/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.base;

import com.blazesoft.repository.base.NdOptimizedRepository;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryAttributeProvider;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryVersionException;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdStrings;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdVersioningSystemEntry;
import com.blazesoft.repository.base.NdVersioningSystemVersionManager;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigException;
import com.blazesoft.repository.config.NdRepositoryEncryptionManagerConfig;
import com.blazesoft.repository.config.NdRepositoryEncryptionManagerFactory;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.file.NdFileCVSServerConnection;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.security.NdAccessController;
import com.blazesoft.security.NdPrivilegedExceptionAction;
import com.blazesoft.util.NdHashMap;
import com.blazesoft.util.NdLocalizedConstants;
import com.blazesoft.util.credentials.NdBaseConnection;
import com.blazesoft.util.credentials.NdBaseUserPasswordCredentials;
import com.blazesoft.util.crypto.NdEncryptionCipherException;
import com.blazesoft.util.crypto.NdEncryptionCipherUtil;
import com.blazesoft.util.crypto.NdEncryptionManager;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class NdRepositorySupport {
    private NdRepositorySupport() {
    }

    public static String getAbsolutePath(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        StringBuffer stringBuffer = new StringBuffer(ndRepositoryEntry.getName());
        NdRepositoryDirectory ndRepositoryDirectory = ndRepositoryEntry.getContainerDirectory();
        while (ndRepositoryDirectory != null) {
            stringBuffer.insert(0, '/');
            if (ndRepositoryDirectory instanceof NdRepository) {
                ndRepositoryDirectory = null;
                continue;
            }
            stringBuffer.insert(0, ndRepositoryDirectory.getName());
            ndRepositoryDirectory = ndRepositoryDirectory.getContainerDirectory();
        }
        return stringBuffer.toString();
    }

    public static NdLocation getParentLocation(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return NdLocationFactory.createLocation(string.substring(0, n));
        }
        return null;
    }

    public static NdRepositoryDirectory lookupParentDirectory(NdRepository ndRepository, String string) throws NdRepositoryException {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            NdRepositoryEntry ndRepositoryEntry = NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndRepository, string2);
            if (ndRepositoryEntry == null) {
                return null;
            }
            if (ndRepositoryEntry instanceof NdRepositoryDirectory) {
                return (NdRepositoryDirectory)ndRepositoryEntry;
            }
            throw new NdRepositoryException(NdStrings.WjHzDfJ("SpecifiedPathIsNotADirectory", string2));
        }
        return ndRepository;
    }

    public static NdRepositoryEntry lookupEntry(NdRepositoryDirectory ndRepositoryDirectory, String string) throws NdRepositoryException {
        if (string.length() == 0 || string.equals("/")) {
            return ndRepositoryDirectory;
        }
        return NdRepositorySupport.lookupEntry(ndRepositoryDirectory, NdLocationFactory.createLocation(string));
    }

    public static String getEntryShortName(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static NdRepositoryEntryAttribute[] getEntryAttributes(NdRepository ndRepository, String string, String[] stringArray) throws NdRepositoryException {
        NdRepositoryEntry ndRepositoryEntry = NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndRepository, string);
        if (ndRepositoryEntry != null) {
            return NdRepositorySupport.getRepositoryEntryAttributes(ndRepositoryEntry, stringArray);
        }
        return null;
    }

    public static NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, String[] stringArray) throws NdRepositoryException {
        if (ndRepositoryEntry instanceof NdRepositoryEntryAttributeProvider) {
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ((NdRepositoryEntryAttributeProvider)((Object)ndRepositoryEntry)).getRepositoryEntryAttributes(stringArray);
            return ndRepositoryEntryAttributeArray != null ? ndRepositoryEntryAttributeArray : new NdRepositoryEntryAttribute[]{};
        }
        NdRepositoryDirectory ndRepositoryDirectory = ndRepositoryEntry.getContainerDirectory();
        if (ndRepositoryDirectory == null) {
            return new NdRepositoryEntryAttribute[0];
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndRepositoryDirectory.getRepositoryEntryAttributes(ndRepositoryEntry);
        if (stringArray == null) {
            return ndRepositoryEntryAttributeArray;
        }
        Hashtable<String, NdRepositoryEntryAttribute> hashtable = new Hashtable<String, NdRepositoryEntryAttribute>(11, 1.0f);
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            hashtable.put(ndRepositoryEntryAttributeArray[i].getAttbId(), ndRepositoryEntryAttributeArray[i]);
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = new NdRepositoryEntryAttribute[stringArray.length];
        for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
            ndRepositoryEntryAttributeArray2[i] = (NdRepositoryEntryAttribute)hashtable.get(stringArray[i]);
            if (ndRepositoryEntryAttributeArray2[i] != null) continue;
            ndRepositoryEntryAttributeArray2[i] = new NdRepositoryEntryAttribute(stringArray[i], null);
        }
        return ndRepositoryEntryAttributeArray2;
    }

    public static String getRepositoryEntryAttributeValue(NdRepositoryEntry ndRepositoryEntry, String string) throws NdRepositoryException {
        String string2 = null;
        String[] stringArray = new String[]{string};
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = NdRepositorySupport.getRepositoryEntryAttributes(ndRepositoryEntry, stringArray);
        if (ndRepositoryEntryAttributeArray.length != 0 && ndRepositoryEntryAttributeArray[0] != null) {
            string2 = ndRepositoryEntryAttributeArray[0].getAttbValue();
        }
        return string2;
    }

    public static NdRepositoryEntry lookupEntry(NdRepositoryDirectory ndRepositoryDirectory, NdLocation ndLocation) throws NdRepositoryException {
        NdRepositoryDirectory ndRepositoryDirectory2 = ndRepositoryDirectory;
        if (ndLocation.isAbsolute()) {
            ndRepositoryDirectory2 = NdRepositorySupport.getRepository(ndRepositoryDirectory);
        }
        NdRepositoryEntry ndRepositoryEntry = ndRepositoryDirectory2;
        int n = ndLocation.getComponentLength();
        for (int i = 0; ndRepositoryDirectory2 != null && i < n; ++i) {
            ndRepositoryEntry = ndRepositoryDirectory2.lookupRepositoryEntry(ndLocation.getComponent(i));
            ndRepositoryDirectory2 = ndRepositoryEntry instanceof NdRepositoryDirectory ? ndRepositoryEntry : null;
        }
        return ndRepositoryEntry;
    }

    public static NdWorkspaceEntry lookupWorkspaceEntry(NdWorkspaceDirectory ndWorkspaceDirectory, NdLocation ndLocation) throws NdRepositoryException {
        return (NdWorkspaceEntry)NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndWorkspaceDirectory, ndLocation);
    }

    public static NdWorkspaceEntry lookupWorkspaceEntry(NdWorkspaceDirectory ndWorkspaceDirectory, String string) throws NdRepositoryException {
        if (string.length() == 0 || string.equals("/")) {
            return ndWorkspaceDirectory;
        }
        return NdRepositorySupport.lookupWorkspaceEntry(ndWorkspaceDirectory, NdLocationFactory.createLocation(string));
    }

    public static NdRepositoryEntry lookupEntryByPhysicalPath(NdRepositoryDirectory ndRepositoryDirectory, String string) throws NdRepositoryException {
        NdLocation ndLocation = NdRepositorySupport.getRepository(ndRepositoryDirectory).getRepositoryEntryLocationManager().translatePhysicalLocation(string);
        return NdRepositorySupport.lookupEntry(ndRepositoryDirectory, ndLocation);
    }

    public static NdRepositoryDirectory createNewRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdLocation ndLocation) throws NdRepositoryException {
        NdRepositoryDirectory ndRepositoryDirectory2 = NdRepositorySupport.WjIejOT(ndRepositoryDirectory, ndLocation);
        String string = ndLocation.getComponent(ndLocation.getComponentLength() - 1);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("innovatorName", string)};
        NdRepositoryDirectory ndRepositoryDirectory3 = ndRepositoryDirectory2.createRepositoryDirectory(string);
        ndRepositoryDirectory2.addRepositoryDirectory(ndRepositoryDirectory3, ndRepositoryEntryAttributeArray);
        return ndRepositoryDirectory3;
    }

    public static NdRepositoryItem createNewRepositoryItem(NdRepositoryDirectory ndRepositoryDirectory, NdLocation ndLocation) throws NdRepositoryException {
        NdRepositoryDirectory ndRepositoryDirectory2 = NdRepositorySupport.WjIejOT(ndRepositoryDirectory, ndLocation);
        String string = ndLocation.getComponent(ndLocation.getComponentLength() - 1);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("innovatorName", string)};
        NdRepositoryItem ndRepositoryItem = ndRepositoryDirectory2.createRepositoryItem(string);
        ndRepositoryDirectory2.addRepositoryItem(ndRepositoryItem, new NdRepositoryItemContent(""), ndRepositoryEntryAttributeArray);
        return ndRepositoryItem;
    }

    private static NdRepositoryDirectory WjIejOT(NdRepositoryDirectory ndRepositoryDirectory, NdLocation ndLocation) throws NdRepositoryException {
        Object object;
        NdRepositoryEntry ndRepositoryEntry;
        Stack<Object> stack = new Stack<Object>();
        NdLocation ndLocation2 = ndLocation;
        do {
            if ((ndLocation2 = ndLocation2.removeLastExternalComponent()).getComponentLength() == 0) {
                ndRepositoryEntry = ndRepositoryDirectory;
                continue;
            }
            object = ndLocation2.getComponent(ndLocation2.getComponentLength() - 1);
            ndRepositoryEntry = NdRepositorySupport.lookupEntry(ndRepositoryDirectory, ndLocation2);
            if (ndRepositoryEntry != null) continue;
            stack.push(object);
        } while (ndRepositoryEntry == null && ndLocation2.getComponentLength() != 0);
        if (ndRepositoryEntry == null || !(ndRepositoryEntry instanceof NdRepositoryDirectory)) {
            throw new NdRepositoryException(NdStrings.WjHzDfJ("RepositoryEntryNotDirectory", ndLocation2));
        }
        object = ndRepositoryEntry;
        while (!stack.empty()) {
            String string = (String)stack.pop();
            NdRepositoryDirectory ndRepositoryDirectory2 = object.createRepositoryDirectory(string);
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("innovatorName", ndRepositoryDirectory2.getName())};
            object.addRepositoryDirectory(ndRepositoryDirectory2, ndRepositoryEntryAttributeArray);
            object = ndRepositoryDirectory2;
        }
        return object;
    }

    public static NdRepositoryDirectory createNewRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, String string) throws NdRepositoryException {
        NdRepository ndRepository = NdRepositorySupport.getRepository(ndRepositoryDirectory);
        NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = ndRepository.getRepositoryEntryLocationManager();
        return NdRepositorySupport.createNewRepositoryDirectory(ndRepositoryDirectory, ndRepositoryEntryLocationManager.translatePhysicalLocation(string));
    }

    public static NdRepositoryItem createNewRepositoryItem(NdRepositoryDirectory ndRepositoryDirectory, String string) throws NdRepositoryException {
        NdRepository ndRepository = NdRepositorySupport.getRepository(ndRepositoryDirectory);
        NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = ndRepository.getRepositoryEntryLocationManager();
        return NdRepositorySupport.createNewRepositoryItem(ndRepositoryDirectory, ndRepositoryEntryLocationManager.translatePhysicalLocation(string));
    }

    public static NdRepository getRepository(NdRepositoryEntry ndRepositoryEntry) {
        NdRepositoryDirectory ndRepositoryDirectory;
        NdRepositoryDirectory ndRepositoryDirectory2;
        NdRepositoryDirectory ndRepositoryDirectory3 = ndRepositoryDirectory2 = ndRepositoryEntry instanceof NdRepositoryDirectory ? (NdRepositoryDirectory)ndRepositoryEntry : ndRepositoryEntry.getContainerDirectory();
        while ((ndRepositoryDirectory = ndRepositoryDirectory2.getContainerDirectory()) != null) {
            ndRepositoryDirectory2 = ndRepositoryDirectory;
        }
        return (NdRepository)ndRepositoryDirectory2;
    }

    public static NdWorkspace getWorkspace(NdWorkspaceEntry ndWorkspaceEntry) {
        return (NdWorkspace)NdRepositorySupport.getRepository(ndWorkspaceEntry);
    }

    public static NdLocation getLocation(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdRepositoryDirectory ndRepositoryDirectory;
        Object object;
        if (ndRepositoryEntry instanceof NdWorkspaceEntry && (object = (NdWorkspaceEntry)ndRepositoryEntry).isVirtual()) {
            return object.getLocation();
        }
        object = new Vector();
        NdRepositoryEntry ndRepositoryEntry2 = ndRepositoryEntry;
        while ((ndRepositoryDirectory = ndRepositoryEntry2.getContainerDirectory()) != null) {
            ((Vector)object).insertElementAt(ndRepositoryEntry2.getName(), 0);
            ndRepositoryEntry2 = ndRepositoryDirectory;
        }
        Object[] objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return NdLocationFactory.createLocation((String[])objectArray, true);
    }

    public static String getEntryType(NdRepository ndRepository, String string) throws NdRepositoryException {
        String[] stringArray = new String[]{"innovatorItemType"};
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = NdRepositorySupport.getEntryAttributes(ndRepository, string, stringArray);
        return ndRepositoryEntryAttributeArray != null ? ndRepositoryEntryAttributeArray[0].getAttbValue() : null;
    }

    public static String getRepositoryUsernameKey(NdRepository ndRepository) {
        return null;
    }

    public static String getRepositoryUsername(NdRepository ndRepository) {
        return ndRepository.getRepositoryConnection().getUser();
    }

    public static String getRepositoryPasswordKey(NdRepository ndRepository) {
        return null;
    }

    public static String getRepositoryPassword(NdRepository ndRepository) {
        return ndRepository.getRepositoryConnection().getPassword();
    }

    public static String processErrorMessageInRepositoryException(NdRepositoryException ndRepositoryException) {
        NdLocation[] ndLocationArray;
        NdLocation[] ndLocationArray2 = ndLocationArray = ndRepositoryException instanceof NdRepositoryVersionException ? ((NdRepositoryVersionException)ndRepositoryException).getLocations() : null;
        if (ndLocationArray != null) {
            Exception[] exceptionArray = ((NdRepositoryVersionException)ndRepositoryException).getExceptions();
            StringBuffer stringBuffer = new StringBuffer();
            if (ndRepositoryException.getMessage() != null) {
                stringBuffer.append(ndRepositoryException.getMessage()).append("\n");
            }
            for (int i = 0; i < ndLocationArray.length; ++i) {
                NdLocation ndLocation = ndLocationArray[i];
                stringBuffer.append(ndLocation);
                stringBuffer.append(NdLocalizedConstants.getColon());
                stringBuffer.append("\n");
                stringBuffer.append(exceptionArray[i].getMessage());
                if (ndLocationArray.length - 1 <= i) continue;
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        return ndRepositoryException.getMessage();
    }

    public static boolean isCheckedOutByAnotherUser(NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo) {
        if (ndRepositoryEntryLockInfo == null) {
            return false;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 4;
    }

    public static boolean isCheckedOutByThisUser(NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo) {
        if (ndRepositoryEntryLockInfo == null) {
            return false;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 2;
    }

    public static boolean isCheckedOutByThisUserInAnotherWorkspace(NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo) {
        if (ndRepositoryEntryLockInfo == null) {
            return false;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 3;
    }

    public static boolean isNotCheckedOut(NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo) {
        if (ndRepositoryEntryLockInfo == null) {
            return true;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 1;
    }

    public static boolean isLocallyCreatedByAnotherUser(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 2;
    }

    public static boolean isLocallyCreatedByThisUser(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 1;
    }

    public static boolean isLocallyModifiedByAnotherUser(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 4;
    }

    public static boolean isLocallyModifiedByThisUser(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 3;
    }

    public static boolean isNotLocal(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 6;
    }

    public static boolean isPreviousVersion(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 9;
    }

    public static boolean isUnresolvedConflict(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 8;
    }

    public static boolean isUpdateNeeded(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 7;
    }

    public static boolean isUpToDate(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.getVersionStatus() == 5;
    }

    public static boolean isLogicallyDeleted(NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        return ndRepositoryVersionResultSet.isLocallyDeleted() || ndRepositoryVersionResultSet.isGloballyDeleted() && !ndRepositoryVersionResultSet.isLocallyRestored();
    }

    public static Hashtable getCVSArgs(NdRepositoryConnection ndRepositoryConnection) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NdFileCVSServerConnection ndFileCVSServerConnection = (NdFileCVSServerConnection)ndRepositoryConnection;
        String string8 = ndFileCVSServerConnection.getType();
        if (string8 != null) {
            hashtable.put("cm.connection.type", string8);
        }
        if ((string7 = ndFileCVSServerConnection.getHost()) != null) {
            hashtable.put("cm.connection.host", string7);
        }
        if ((string6 = ndFileCVSServerConnection.getPort()) != null) {
            hashtable.put("cm.connection.port", string6);
        }
        if ((string5 = ndFileCVSServerConnection.getPath()) != null) {
            hashtable.put("cm.connection.path", string5);
        }
        if ((string4 = ndFileCVSServerConnection.getBranch()) != null) {
            hashtable.put("cm.connection.branch", string4);
        }
        if ((string3 = ndRepositoryConnection.getUser()) != null) {
            hashtable.put("file.repository.user.id", string3);
        }
        if ((string2 = ndRepositoryConnection.getPassword()) != null) {
            hashtable.put("file.repository.user.password", string2);
        }
        if ((string = ndRepositoryConnection.getRepositoryName()) != null) {
            hashtable.put("com.blazesoft.repository.base.repositoryname", string);
        }
        return hashtable;
    }

    public static NdFileCVSServerConnection setCVSArgs(NdFileCVSServerConnection ndFileCVSServerConnection, Hashtable hashtable) {
        if (ndFileCVSServerConnection != null) {
            if (hashtable.get("cm.connection.type") != null) {
                ndFileCVSServerConnection.setType((String)hashtable.get("cm.connection.type"));
            }
            if (hashtable.get("cm.connection.host") != null) {
                ndFileCVSServerConnection.setHost((String)hashtable.get("cm.connection.host"));
            }
            if (hashtable.get("cm.connection.port") != null) {
                ndFileCVSServerConnection.setPort((String)hashtable.get("cm.connection.port"));
            }
            if (hashtable.get("cm.connection.path") != null) {
                ndFileCVSServerConnection.setPath((String)hashtable.get("cm.connection.path"));
            }
            if (hashtable.get("cm.connection.branch") != null) {
                ndFileCVSServerConnection.setBranch((String)hashtable.get("cm.connection.branch"));
            }
            if (hashtable.get("file.repository.user.id") != null) {
                ndFileCVSServerConnection.setUser((String)hashtable.get("file.repository.user.id"));
            }
            if (hashtable.get("file.repository.user.password") != null) {
                ndFileCVSServerConnection.setPassword((String)hashtable.get("file.repository.user.password"));
            }
            if (hashtable.get("com.blazesoft.repository.base.repositoryname") != null) {
                ndFileCVSServerConnection.setRepositoryName((String)hashtable.get("com.blazesoft.repository.base.repositoryname"));
            }
        }
        return ndFileCVSServerConnection;
    }

    public static NdRepositoryEntryAttribute[] parseEntryAttributesFromContents(String string) {
        int n;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        if (string.length() == 0) {
            return new NdRepositoryEntryAttribute[0];
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        int n2 = 0;
        while ((n = string.indexOf(10, n2)) != -1) {
            String string2 = string.substring(n2, n).trim();
            n2 = n + 1;
            int n3 = string2.indexOf(61);
            if (n3 == -1) continue;
            vector.addElement(new NdRepositoryEntryAttribute(string2.substring(0, n3), string2.substring(n3 + 1)));
        }
        Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static NdRepositoryEntryAttribute[] parseEntryAttributesFromArray(String[] stringArray) {
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (!string.endsWith("\n") || (n = (string = string.substring(0, string.length() - 1)).indexOf(61)) == -1) continue;
            vector.addElement(new NdRepositoryEntryAttribute(string.substring(0, n), string.substring(n + 1)));
        }
        Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static NdRepositoryVersionResultSet[] getOutdatedStatusInfos(NdWorkspaceDirectory ndWorkspaceDirectory, boolean bl) throws NdRepositoryException {
        NdRepositoryVersionResultSet[] ndRepositoryVersionResultSetArray;
        NdRepositoryVersionResultSet[] ndRepositoryVersionResultSetArray2;
        Object object;
        NdRepositoryVersionResultSet[] ndRepositoryVersionResultSetArray3 = ndWorkspaceDirectory.getStatusInfos(bl);
        Vector<NdRepositoryVersionResultSet> vector = new Vector<NdRepositoryVersionResultSet>(ndRepositoryVersionResultSetArray3.length);
        for (int i = 0; i < ndRepositoryVersionResultSetArray3.length; ++i) {
            if (ndRepositoryVersionResultSetArray3[i].getVersionStatus() == 5) continue;
            vector.addElement(ndRepositoryVersionResultSetArray3[i]);
        }
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        NdVersioningSystemVersionManager ndVersioningSystemVersionManager = NdRepositorySupport.getWorkspace(ndWorkspaceDirectory).getSystemVersionManager();
        NdRepositorySupport.WjIvgXE(ndWorkspaceDirectory, ndVersioningSystemVersionManager, vector2, vector3, bl);
        if (ndWorkspaceDirectory instanceof NdWorkspace) {
            for (int i = 0; i < vector2.size(); ++i) {
                object = (NdLocation)vector2.elementAt(i);
                if (!object.equals(NdLocationFactory.createLocation(new String[]{"com_blazesoft_rom_config.cfg"}, true)) && !object.equals(NdLocationFactory.createLocation(new String[]{"com_blazesoft_repository_config.cfg"}, true))) continue;
                vector2.removeElementAt(i);
                break;
            }
        }
        Object[] objectArray = new NdRepositoryVersionResultSet[vector.size() + vector2.size()];
        vector.copyInto(objectArray);
        if (vector2.size() != 0) {
            object = new NdLocation[vector2.size()];
            vector2.copyInto((Object[])object);
            ndRepositoryVersionResultSetArray2 = ndVersioningSystemVersionManager.getStatusInfos((NdLocation[])object);
            for (int i = 0; i < ndRepositoryVersionResultSetArray2.length; ++i) {
                ndRepositoryVersionResultSetArray = ndRepositoryVersionResultSetArray2[i];
                ndRepositoryVersionResultSetArray.setVersionStatus(6);
                NdRepositorySupport.WjIvgXD(ndVersioningSystemVersionManager, (NdRepositoryVersionResultSet)ndRepositoryVersionResultSetArray);
            }
            System.arraycopy(ndRepositoryVersionResultSetArray2, 0, objectArray, vector.size(), ndRepositoryVersionResultSetArray2.length);
        }
        object = vector3.elements();
        while (object.hasMoreElements()) {
            ndRepositoryVersionResultSetArray2 = (NdRepositoryVersionResultSet[])object.nextElement();
            NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRepositoryVersionResultSetArray2.getStatusInfo();
            if (ndRepositoryVersionResultSet.getVersionStatus() == 5) continue;
            ndRepositoryVersionResultSetArray = new NdRepositoryVersionResultSet[objectArray.length + 1];
            System.arraycopy(objectArray, 0, ndRepositoryVersionResultSetArray, 0, objectArray.length);
            ndRepositoryVersionResultSetArray[objectArray.length] = ndRepositoryVersionResultSet;
            NdRepositorySupport.WjIvgXD(ndVersioningSystemVersionManager, ndRepositoryVersionResultSet);
            objectArray = ndRepositoryVersionResultSetArray;
        }
        return objectArray;
    }

    private static void WjIvgXD(NdVersioningSystemVersionManager ndVersioningSystemVersionManager, NdRepositoryVersionResultSet ndRepositoryVersionResultSet) throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndVersioningSystemVersionManager.getAttributes(ndRepositoryVersionResultSet.getLocation());
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            String string = ndRepositoryEntryAttributeArray[i].getAttbId();
            if ("innovatorItemCreationId".equals(string)) {
                ndRepositoryVersionResultSet.setCreationUserId(ndRepositoryEntryAttributeArray[i].getAttbValue());
                continue;
            }
            if (!"innovatorDisplayName".equals(string)) continue;
            ndRepositoryVersionResultSet.setDisplayName(ndRepositoryEntryAttributeArray[i].getAttbValue());
        }
    }

    private static void WjIvgXE(NdWorkspaceDirectory ndWorkspaceDirectory, NdVersioningSystemVersionManager ndVersioningSystemVersionManager, Vector vector, Vector vector2, boolean bl) throws NdRepositoryException {
        NdWorkspaceEntry[] ndWorkspaceEntryArray = (NdWorkspaceEntry[])ndWorkspaceDirectory.getRepositoryEntries();
        NdHashMap ndHashMap = new NdHashMap(ndWorkspaceEntryArray.length, 1.0f);
        for (int i = 0; i < ndWorkspaceEntryArray.length; ++i) {
            if (ndWorkspaceEntryArray[i] instanceof NdWorkspaceDirectory) {
                if (bl) {
                    ndHashMap.put((Object)ndWorkspaceEntryArray[i].getLocation(), (Object)Boolean.TRUE);
                    NdRepositorySupport.WjIvgXE((NdWorkspaceDirectory)ndWorkspaceEntryArray[i], ndVersioningSystemVersionManager, vector, vector2, true);
                    continue;
                }
                ndHashMap.put((Object)ndWorkspaceEntryArray[i].getLocation(), (Object)Boolean.TRUE);
                vector2.addElement(ndWorkspaceEntryArray[i]);
                continue;
            }
            ndHashMap.put((Object)ndWorkspaceEntryArray[i].getLocation(), (Object)Boolean.TRUE);
        }
        NdLocation ndLocation = ndWorkspaceDirectory.getLocation();
        NdVersioningSystemEntry[] ndVersioningSystemEntryArray = ndVersioningSystemVersionManager.getServerEntries(ndLocation);
        for (int i = 0; i < ndVersioningSystemEntryArray.length; ++i) {
            NdLocation ndLocation2;
            if (ndVersioningSystemEntryArray[i].isDeleted() || ndHashMap.containsKey((Object)(ndLocation2 = ndLocation.appendExternalComponent(ndVersioningSystemEntryArray[i].getName())))) continue;
            vector.addElement(ndLocation2);
        }
    }

    public static NdRepositoryEntry getStorageEntry(NdRepositoryEntry ndRepositoryEntry) {
        return ndRepositoryEntry instanceof NdWorkspaceEntry ? ((NdWorkspaceEntry)ndRepositoryEntry).getPhysicalRepositoryEntry() : ndRepositoryEntry;
    }

    public static String getCreationUserId(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        return NdRepositorySupport.getAttributeValue(ndRepositoryEntry, "innovatorItemCreationId");
    }

    public static String getCheckedOutUserId(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        return NdRepositorySupport.getAttributeValue(ndRepositoryEntry, "com.blazesoft.repository.local.checkedOut");
    }

    public static String getAttributeValue(NdRepositoryEntry ndRepositoryEntry, String string) throws NdRepositoryException {
        String[] stringArray = new String[]{string};
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = NdRepositorySupport.getRepositoryEntryAttributes(ndRepositoryEntry, stringArray);
        if (ndRepositoryEntryAttributeArray.length != 0) {
            return ndRepositoryEntryAttributeArray[0].getAttbValue();
        }
        return null;
    }

    public static NdRepositoryEntryAttribute[] removeWorkspaceCheckoutAttributes(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>(ndRepositoryEntryAttributeArray.length);
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            String string = ndRepositoryEntryAttributeArray[i].getAttbId();
            if (string.equals("com.blazesoft.repository.local.checkedOut") || string.equals("com.blazesoft.repository.local.locallycreated")) continue;
            vector.addElement(ndRepositoryEntryAttributeArray[i]);
        }
        ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(ndRepositoryEntryAttributeArray);
        return ndRepositoryEntryAttributeArray;
    }

    public static boolean isProtected(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        boolean bl = false;
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            if (!"com.blazesoft.repository.security.protected".equals(ndRepositoryEntryAttributeArray[i].getAttbId())) continue;
            bl = Boolean.valueOf(ndRepositoryEntryAttributeArray[i].getAttbValue());
            break;
        }
        return bl;
    }

    public static String decryptPassword(NdBaseConnection ndBaseConnection, String string) {
        NdEncryptionManager ndEncryptionManager;
        if (!NdRepositorySupport.isPasswordEncrypted(string)) {
            return string;
        }
        String string2 = string;
        if (ndBaseConnection.getCredentials() instanceof NdBaseUserPasswordCredentials && (ndEncryptionManager = ((NdBaseUserPasswordCredentials)ndBaseConnection.getCredentials()).getEncryptionManager()) != null) {
            try {
                string2 = NdEncryptionCipherUtil.WjHGwnM((NdEncryptionManager)ndEncryptionManager, (String)string);
            }
            catch (NdEncryptionCipherException ndEncryptionCipherException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static void transformEncryption(NdBaseConnection ndBaseConnection, NdEncryptionManager ndEncryptionManager) throws NdRepositoryException {
        String string;
        if (ndBaseConnection.getCredentials() instanceof NdBaseUserPasswordCredentials && (string = ((NdBaseUserPasswordCredentials)ndBaseConnection.getCredentials()).getPassword()) != null) {
            try {
                final String string2 = string;
                final NdBaseConnection ndBaseConnection2 = ndBaseConnection;
                string = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return NdRepositorySupport.decryptPassword(ndBaseConnection2, string2);
                    }
                });
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
            if (ndEncryptionManager != null) {
                try {
                    string = NdEncryptionCipherUtil.WjHGwmL((NdEncryptionManager)ndEncryptionManager, (String)string);
                }
                catch (NdEncryptionCipherException ndEncryptionCipherException) {
                    throw new NdRepositoryException(ndEncryptionCipherException);
                }
            }
            ndBaseConnection.setPassword(string);
            ((NdBaseUserPasswordCredentials)ndBaseConnection.getCredentials()).setEncryptionManager(ndEncryptionManager);
        }
    }

    public static NdRepositoryConfig encryptPasswordByConfiguredEncryption(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryConfigException {
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection;
        String string;
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepositoryConfig.getRepositoryVersionManagerConfig();
        NdRepositoryEncryptionManagerConfig ndRepositoryEncryptionManagerConfig = ndRepositoryConfig.getRepositoryEncryptionManagerConfig();
        if (ndRepositoryVersionManagerConfig != null && ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection() != null && (string = (ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection()).getPassword()) != null && string.length() > 0) {
            String string2 = string;
            try {
                string2 = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return NdRepositorySupport.decryptPassword(ndVersioningRepositoryConnection, string);
                    }
                });
            }
            catch (NdEncryptionCipherException ndEncryptionCipherException) {
            }
            catch (Exception exception) {
                throw new NdRepositoryConfigException(exception);
            }
            if (ndRepositoryEncryptionManagerConfig != null) {
                NdRepositoryEncryptionManagerFactory ndRepositoryEncryptionManagerFactory = ndRepositoryEncryptionManagerConfig.getRepositoryEncryptionManagerFactory();
                NdEncryptionManager ndEncryptionManager = null;
                if (ndRepositoryEncryptionManagerFactory != null) {
                    try {
                        ndEncryptionManager = ndRepositoryEncryptionManagerFactory.newRepositoryEncryptionManager(ndRepositoryEncryptionManagerConfig.getEncryptionCipherFactory());
                    }
                    catch (NdRepositoryException ndRepositoryException) {
                        // empty catch block
                    }
                    if (ndEncryptionManager != null) {
                        try {
                            String string3 = NdEncryptionCipherUtil.WjHGwmL((NdEncryptionManager)ndEncryptionManager, (String)string2);
                            ndVersioningRepositoryConnection.setPassword(string3);
                            ((NdBaseUserPasswordCredentials)ndVersioningRepositoryConnection.getCredentials()).setEncryptionManager(ndEncryptionManager);
                            string2 = null;
                        }
                        catch (NdEncryptionCipherException ndEncryptionCipherException) {
                            throw new NdRepositoryConfigException(ndEncryptionCipherException);
                        }
                    }
                }
            }
            if (string2 != null) {
                ndVersioningRepositoryConnection.setPassword(string2);
            }
        }
        return ndRepositoryConfig;
    }

    public static boolean isEmptyFolder(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        if (ndRepositoryDirectory == null) {
            return true;
        }
        NdRepositoryEntry[] ndRepositoryEntryArray = ndRepositoryDirectory.getRepositoryEntries();
        if (ndRepositoryEntryArray.length == 0) {
            return true;
        }
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            if (ndRepositoryEntryArray[i] instanceof NdRepositoryItem) {
                return false;
            }
            if (NdRepositorySupport.isEmptyFolder((NdRepositoryDirectory)ndRepositoryEntryArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isFolderEmptyOrNew(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        if (ndRepositoryDirectory == null) {
            return true;
        }
        NdRepositoryEntry[] ndRepositoryEntryArray = ndRepositoryDirectory.getRepositoryEntries();
        if (ndRepositoryEntryArray.length == 0) {
            return true;
        }
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            if (ndRepositoryEntryArray[i] instanceof NdRepositoryItem && !"true".equals(NdRepositorySupport.getAttributeValue(ndRepositoryEntryArray[i], "com.blazesoft.repository.local.locallycreated"))) {
                return false;
            }
            if (!(ndRepositoryEntryArray[i] instanceof NdRepositoryDirectory) || NdRepositorySupport.isEmptyFolder((NdRepositoryDirectory)ndRepositoryEntryArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasServerItems(NdVersioningSystemVersionManager ndVersioningSystemVersionManager, NdLocation ndLocation) throws NdRepositoryException {
        NdVersioningSystemEntry[] ndVersioningSystemEntryArray = ndVersioningSystemVersionManager.getServerEntries(ndLocation);
        if (ndVersioningSystemEntryArray != null && ndVersioningSystemEntryArray.length > 0) {
            for (int i = 0; i < ndVersioningSystemEntryArray.length; ++i) {
                NdLocation ndLocation2;
                NdVersioningSystemEntry ndVersioningSystemEntry = ndVersioningSystemEntryArray[i];
                if (ndVersioningSystemEntry.isDeleted()) continue;
                if (!ndVersioningSystemEntry.isDirectory()) {
                    return true;
                }
                if (ndVersioningSystemEntry.getName().startsWith("__Items for__") || !NdRepositorySupport.hasServerItems(ndVersioningSystemVersionManager, ndLocation2 = ndLocation.appendExternalComponent(ndVersioningSystemEntry.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    public static NdRepositoryEntryAttribute[] mergeEntryAttributes(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2) {
        if (ndRepositoryEntryAttributeArray2 == null || ndRepositoryEntryAttributeArray2.length == 0) {
            return ndRepositoryEntryAttributeArray;
        }
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < ndRepositoryEntryAttributeArray2.length; ++j) {
                if (!ndRepositoryEntryAttributeArray[i].getAttbId().equals(ndRepositoryEntryAttributeArray2[j].getAttbId())) continue;
                if (ndRepositoryEntryAttributeArray2[j].getAttbValue() != null) {
                    vector.addElement(ndRepositoryEntryAttributeArray2[j]);
                }
                bl = false;
                break;
            }
            if (!bl) continue;
            vector.addElement(ndRepositoryEntryAttributeArray[i]);
        }
        Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean isOptimizedOperationSupported(NdRepositoryEntry ndRepositoryEntry) {
        NdRepository ndRepository = NdRepositorySupport.getRepository(ndRepositoryEntry);
        NdRepository ndRepository2 = (NdRepository)NdRepositorySupport.getStorageEntry(ndRepository);
        return ndRepository2 instanceof NdOptimizedRepository;
    }

    public static void copyEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntry ndRepositoryEntry2, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        int n;
        int n2;
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = ndRepositoryEntry.getContainerDirectory().getRepositoryEntryAttributes(ndRepositoryEntry);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = ndRepositoryEntry2.getContainerDirectory().getRepositoryEntryAttributes(ndRepositoryEntry2);
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        if (ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length > 0) {
            for (n2 = 0; n2 < ndRepositoryEntryAttributeArray.length; ++n2) {
                boolean bl = true;
                for (n = 0; n < ndRepositoryEntryAttributeArray2.length; ++n) {
                    if (!ndRepositoryEntryAttributeArray[n2].getAttbId().equals(ndRepositoryEntryAttributeArray2[n].getAttbId())) continue;
                    ndRepositoryEntryAttributeArray2[n] = ndRepositoryEntryAttributeArray[n2];
                    bl = false;
                    break;
                }
                if (!bl) continue;
                vector.addElement(ndRepositoryEntryAttributeArray[n2]);
            }
            if (vector.size() > 0) {
                Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
                vector.copyInto(objectArray);
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray4 = new NdRepositoryEntryAttribute[ndRepositoryEntryAttributeArray2.length + objectArray.length];
                System.arraycopy(ndRepositoryEntryAttributeArray2, 0, ndRepositoryEntryAttributeArray4, 0, ndRepositoryEntryAttributeArray2.length);
                System.arraycopy(objectArray, 0, ndRepositoryEntryAttributeArray4, ndRepositoryEntryAttributeArray2.length, objectArray.length);
                ndRepositoryEntryAttributeArray2 = ndRepositoryEntryAttributeArray4;
            }
        }
        vector.removeAllElements();
        for (n2 = 0; n2 < ndRepositoryEntryAttributeArray3.length; ++n2) {
            boolean bl = true;
            for (n = 0; n < ndRepositoryEntryAttributeArray2.length; ++n) {
                if (!ndRepositoryEntryAttributeArray2[n].getAttbId().equals(ndRepositoryEntryAttributeArray3[n2].getAttbId())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            vector.addElement(new NdRepositoryEntryAttribute(ndRepositoryEntryAttributeArray3[n2].getAttbId(), null));
        }
        if (vector.size() > 0) {
            Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(objectArray);
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray5 = new NdRepositoryEntryAttribute[ndRepositoryEntryAttributeArray2.length + objectArray.length];
            System.arraycopy(ndRepositoryEntryAttributeArray2, 0, ndRepositoryEntryAttributeArray5, 0, ndRepositoryEntryAttributeArray2.length);
            System.arraycopy(objectArray, 0, ndRepositoryEntryAttributeArray5, ndRepositoryEntryAttributeArray2.length, objectArray.length);
            ndRepositoryEntryAttributeArray2 = ndRepositoryEntryAttributeArray5;
        }
        ndRepositoryEntry2.getContainerDirectory().setRepositoryEntryAttributes(ndRepositoryEntry2, ndRepositoryEntryAttributeArray2);
    }

    public static void copyItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItem ndRepositoryItem2, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        NdRepositorySupport.copyEntryAttributes(ndRepositoryItem, ndRepositoryItem2, ndRepositoryEntryAttributeArray);
        ndRepositoryItem2.setContent(new NdRepositoryItemContent(ndRepositoryItem.getContent().getData()));
    }

    public static boolean isPasswordEncrypted(String string) {
        int n;
        int n2;
        boolean bl = false;
        if (string != null && string.length() > 0 && (n2 = string.indexOf(":")) >= 0 && n2 == (n = string.lastIndexOf(":"))) {
            bl = true;
        }
        return bl;
    }
}

