/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.base.internal;

import com.blazesoft.repository.base.NdInProcessVersionManager;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryAuthorizationException;
import com.blazesoft.repository.base.NdRepositoryAuthorizationManager;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryFactory;
import com.blazesoft.repository.base.NdRepositoryEntryFilter;
import com.blazesoft.repository.base.NdRepositoryEntryLockAuthorizationRequest;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryEntryUnlockAuthorizationRequest;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryVersionAuthorizationException;
import com.blazesoft.repository.base.NdRepositoryVersionException;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdRepositoryVersionLabel;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingStrategy;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingStrategyProvider;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.base.NdWorkspaceVersionManagerListener;
import com.blazesoft.repository.naming.NdLocation;
import java.util.Vector;

public class NdWorkspaceVersionManagerProxy
implements NdWorkspaceItemLoadingStrategyProvider {
    private NdRepository WjISYDM;
    private NdWorkspaceVersionManager WjISYEN;
    private NdRepositoryAuthorizationManager WjISYFO;
    private Vector WjISYGP;

    public NdWorkspaceVersionManagerProxy(NdRepository ndRepository, NdWorkspaceVersionManager ndWorkspaceVersionManager, NdRepositoryAuthorizationManager ndRepositoryAuthorizationManager) {
        this.WjISYDM = ndRepository;
        this.WjISYEN = ndWorkspaceVersionManager;
        this.WjISYFO = ndRepositoryAuthorizationManager;
        this.WjISYGP = new Vector();
    }

    public boolean isDelegateInProcessVersionManager() {
        return this.WjISYEN instanceof NdInProcessVersionManager;
    }

    public NdWorkspaceVersionManager getDelegate() {
        return this.WjISYEN;
    }

    public void cancelCheckOut(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjISYEN.cancelCheckOut(ndRepositoryEntryArray);
    }

    public void checkIn(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            try {
                this.WjISYFO.checkAuthorizationRequest(new NdRepositoryEntryUnlockAuthorizationRequest(this.WjISYDM, ndRepositoryEntryArray[i]));
                continue;
            }
            catch (NdRepositoryAuthorizationException ndRepositoryAuthorizationException) {
                throw new NdRepositoryVersionAuthorizationException((Throwable)((Object)ndRepositoryAuthorizationException));
            }
        }
        this.WjISYEN.checkIn(ndRepositoryEntryArray, string);
    }

    public void checkOut(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            try {
                this.WjISYFO.checkAuthorizationRequest(new NdRepositoryEntryLockAuthorizationRequest(this.WjISYDM, ndRepositoryEntryArray[i]));
                continue;
            }
            catch (NdRepositoryAuthorizationException ndRepositoryAuthorizationException) {
                throw new NdRepositoryVersionAuthorizationException((Throwable)((Object)ndRepositoryAuthorizationException));
            }
        }
        this.WjISYEN.checkOut(ndRepositoryEntryArray);
    }

    public void closeConnection() throws NdRepositoryException {
        this.WjISYEN.closeConnection();
    }

    public void delete(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjISYEN.delete(ndRepositoryEntryArray);
    }

    public void cancelDelete(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjISYEN.cancelDelete(ndRepositoryEntryArray);
    }

    public void deleteLabel(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        this.WjISYEN.deleteLabel(ndRepositoryEntryArray, string);
    }

    public String difference(NdRepositoryItem ndRepositoryItem, String string, String string2) throws NdRepositoryException {
        return this.WjISYEN.difference(ndRepositoryItem, string, string2);
    }

    public NdRepositoryItem getItemByVersion(NdRepositoryItem ndRepositoryItem, String string) throws NdRepositoryException {
        return this.WjISYEN.getItemByVersion(ndRepositoryItem, string);
    }

    public NdRepositoryEntryLockInfo[] getEntryLockInfos(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        return this.WjISYEN.getEntryLockInfos(ndRepositoryEntryArray);
    }

    public NdRepositoryVersionHistory[][] getHistories(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        return this.WjISYEN.getHistories(ndRepositoryEntryArray);
    }

    public NdRepositoryVersionLabel[][] getLabels(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        return this.WjISYEN.getLabels(ndRepositoryEntryArray);
    }

    public NdRepositoryVersionResultSet[] getStatusInfos(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        return this.WjISYEN.getStatusInfos(ndRepositoryEntryArray);
    }

    public boolean isFeatureSupported(int n) {
        return this.WjISYEN.isFeatureSupported(n);
    }

    public boolean isServerConnected() throws NdRepositoryException {
        return this.WjISYEN.isServerConnected();
    }

    public boolean isVersioned(NdLocation ndLocation, boolean bl) throws NdRepositoryException {
        return this.WjISYEN.isVersioned(ndLocation, bl);
    }

    public void openConnection() throws NdRepositoryException {
        this.WjISYEN.openConnection();
    }

    public void setLabel(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        this.WjISYEN.setLabel(ndRepositoryEntryArray, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(NdLocation ndLocation, boolean bl) throws NdRepositoryException {
        this.WjISYHQ();
        try {
            this.WjISYEN.update(ndLocation, bl);
            Object var4_3 = null;
            this.WjISYIR();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WjISYIR();
            throw throwable;
        }
    }

    private void WjISYHQ() {
        int n = this.WjISYGP.size();
        for (int i = 0; i < n; ++i) {
            ((NdWorkspaceVersionManagerListener)this.WjISYGP.elementAt(i)).enableEventBatching();
        }
    }

    private void WjISYIR() throws NdRepositoryVersionException {
        int n = this.WjISYGP.size();
        for (int i = 0; i < n; ++i) {
            ((NdWorkspaceVersionManagerListener)this.WjISYGP.elementAt(i)).disableEventBatching(true);
        }
    }

    public void addWorkspaceVersionManagerListener(NdWorkspaceVersionManagerListener ndWorkspaceVersionManagerListener) {
        this.WjISYGP.addElement(ndWorkspaceVersionManagerListener);
        this.WjISYEN.addWorkspaceVersionManagerListener(ndWorkspaceVersionManagerListener);
    }

    public void removeWorkspaceVersionManagerListener(NdWorkspaceVersionManagerListener ndWorkspaceVersionManagerListener) {
        this.WjISYGP.removeElement(ndWorkspaceVersionManagerListener);
        this.WjISYEN.removeWorkspaceVersionManagerListener(ndWorkspaceVersionManagerListener);
    }

    public void setRepositoryEntryFactory(NdRepositoryEntryFactory ndRepositoryEntryFactory) {
        this.WjISYEN.setRepositoryEntryFactory(ndRepositoryEntryFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjISYHQ();
        try {
            this.WjISYEN.update(ndRepositoryEntryArray);
            Object var3_2 = null;
            this.WjISYIR();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.WjISYIR();
            throw throwable;
        }
    }

    public NdRepositoryEntryFilter getEntryFilter() {
        return this.WjISYEN.getEntryFilter();
    }

    public void enablePersistentConnection(boolean bl) throws NdRepositoryException {
        this.WjISYEN.enablePersistentConnection(bl);
    }

    public boolean isPersistentConnectionEnabled() {
        return this.WjISYEN.isPersistentConnectionEnabled();
    }

    public NdWorkspaceItemLoadingStrategy getLoadingStrategy() {
        return this.WjISYEN instanceof NdWorkspaceItemLoadingStrategyProvider ? ((NdWorkspaceItemLoadingStrategyProvider)this.WjISYEN).getLoadingStrategy() : null;
    }
}

