/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.base.internal;

import com.blazesoft.repository.base.NdDefaultRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryExplicitLockManager;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdRepositoryVersionLabel;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdRepositoryVersionScmConnectionException;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.base.internal.NdInternalWorkspace;
import com.blazesoft.repository.base.internal.NdInternalWorkspaceDirectory;
import com.blazesoft.repository.base.internal.NdInternalWorkspaceEntry;
import com.blazesoft.repository.base.internal.NdStrings;
import com.blazesoft.repository.base.internal.WjISZxK;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.util.NdBase64;
import com.blazesoft.util.NdBaseObject;
import java.util.Vector;

public abstract class WjISWxB {
    private NdInternalWorkspaceEntry WjISVWY;
    private NdInternalWorkspace WjIVfiJ;

    public WjISWxB(NdInternalWorkspaceEntry ndInternalWorkspaceEntry) {
        this.WjISVWY = ndInternalWorkspaceEntry;
    }

    NdInternalWorkspaceEntry WjISVWZ() {
        return this.WjISVWY;
    }

    NdInternalWorkspace WjIVfjK() {
        if (this.WjIVfiJ == null) {
            this.WjIVfiJ = this.WjISVWY.getWorkspace();
        }
        return this.WjIVfiJ;
    }

    public void WjISVXA() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        ((NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory()).cancelCheckOut(new NdWorkspaceEntry[]{this.WjISVWY}, false, false);
    }

    public void WjISVYB(String string) throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        ((NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory()).checkIn(new NdWorkspaceEntry[]{this.WjISVWY}, string, false, false);
    }

    public void WjISVZC() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        ((NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory()).checkOut(new NdWorkspaceEntry[]{this.WjISVWY}, false, false);
    }

    public void WjISWaD() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        ((NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory()).delete(new NdWorkspaceEntry[]{this.WjISVWY});
    }

    public void WjISWbE() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        ((NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory()).cancelDelete(new NdWorkspaceEntry[]{this.WjISVWY});
    }

    public void WjISWcF(String string) throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        if (this.WjISVWY.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjISXLV("OperationNotAllowedOnDeletedItem", "deleteLabel", this.WjISVWY.getLocation()));
        }
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        if (!ndInternalWorkspace.isVersioned()) {
            throw new NdRepositoryException(NdStrings.WjISXKU("VersioningIsNotEnabled", this.WjISVWY.getLocation()));
        }
        NdWorkspaceVersionManager ndWorkspaceVersionManager = ndInternalWorkspace.getWorkspaceVersionManager();
        ndWorkspaceVersionManager.deleteLabel(new NdRepositoryEntry[]{this.WjISVWY}, string);
    }

    public NdRepositoryEntryLockInfo WjISWdG() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndInternalWorkspace.getCachedLockInfo(this.WjISVWY);
        if (ndRepositoryEntryLockInfo == null) {
            try {
                ndInternalWorkspace.executingVersioningCommand();
                ndRepositoryEntryLockInfo = this.WjISWtW();
                if (ndInternalWorkspace.isVersionStatusCached()) {
                    ndInternalWorkspace.setCachedLockInfo(this.WjISVWY, ndRepositoryEntryLockInfo);
                }
            }
            catch (NdRepositoryException ndRepositoryException) {
                if (ndRepositoryException instanceof NdRepositoryVersionScmConnectionException) {
                    ndInternalWorkspace.versioningSystemOffline(true, ndRepositoryException);
                }
                throw ndRepositoryException;
            }
        }
        return ndRepositoryEntryLockInfo;
    }

    public NdRepositoryVersionHistory[] WjISWeH() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray = ndInternalWorkspace.getCachedVersionHistory(this.WjISVWY);
        if (ndRepositoryVersionHistoryArray == null) {
            try {
                ndInternalWorkspace.executingVersioningCommand();
                ndRepositoryVersionHistoryArray = this.WjISWwZ(ndInternalWorkspace);
                if (ndInternalWorkspace.isVersionStatusCached()) {
                    ndInternalWorkspace.setCachedVersionHistory(this.WjISVWY, ndRepositoryVersionHistoryArray);
                }
            }
            catch (NdRepositoryVersionScmConnectionException ndRepositoryVersionScmConnectionException) {
                ndInternalWorkspace.versioningSystemOffline(true, ndRepositoryVersionScmConnectionException);
                throw ndRepositoryVersionScmConnectionException;
            }
        }
        return ndRepositoryVersionHistoryArray;
    }

    public NdRepositoryVersionLabel[] WjISWfI() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        if (ndInternalWorkspace.isVersioned()) {
            try {
                ndInternalWorkspace.executingVersioningCommand();
                NdWorkspaceVersionManager ndWorkspaceVersionManager = ndInternalWorkspace.getWorkspaceVersionManager();
                return ndWorkspaceVersionManager.getLabels(new NdRepositoryEntry[]{this.WjISVWY})[0];
            }
            catch (NdRepositoryVersionScmConnectionException ndRepositoryVersionScmConnectionException) {
                ndInternalWorkspace.versioningSystemOffline(true, ndRepositoryVersionScmConnectionException);
                throw ndRepositoryVersionScmConnectionException;
            }
        }
        return new NdRepositoryVersionLabel[0];
    }

    public NdRepositoryVersionResultSet WjISWgJ() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndInternalWorkspace.getCachedVersionStatus(this.WjISVWY);
        if (ndRepositoryVersionResultSet == null) {
            try {
                ndInternalWorkspace.executingVersioningCommand();
                ndRepositoryVersionResultSet = this.WjISWxA(ndInternalWorkspace);
                if (ndInternalWorkspace.isVersionStatusCached()) {
                    ndInternalWorkspace.setCachedVersionStatus(this.WjISVWY, ndRepositoryVersionResultSet);
                }
            }
            catch (NdRepositoryVersionScmConnectionException ndRepositoryVersionScmConnectionException) {
                ndInternalWorkspace.versioningSystemOffline(true, ndRepositoryVersionScmConnectionException);
                throw ndRepositoryVersionScmConnectionException;
            }
        }
        return ndRepositoryVersionResultSet;
    }

    public void WjISWhK() throws NdRepositoryException {
        NdWorkspaceDirectory ndWorkspaceDirectory = (NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory();
        boolean bl = false;
        if (!(this.WjISVWY instanceof NdWorkspace)) {
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndWorkspaceDirectory.getRepositoryEntryAttributes(this.WjISVWY);
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (!"com.blazesoft.repository.local.locallycreated".equals(ndRepositoryEntryAttributeArray[i].getAttbId())) continue;
                bl = Boolean.valueOf(ndRepositoryEntryAttributeArray[i].getAttbValue());
                break;
            }
        }
        this.WjISVWY.setMarkedForAddition(bl);
    }

    public boolean WjISWiL() throws NdRepositoryException {
        boolean bl = false;
        if (this.WjISVWY.exists()) {
            NdWorkspaceDirectory ndWorkspaceDirectory = (NdWorkspaceDirectory)this.WjISVWY.getContainerDirectory();
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndWorkspaceDirectory.getRepositoryEntryAttributes(this.WjISVWY);
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (!"com.blazesoft.repository.security.protected".equals(ndRepositoryEntryAttributeArray[i].getAttbId())) continue;
                bl = Boolean.valueOf(ndRepositoryEntryAttributeArray[i].getAttbValue());
                break;
            }
        }
        return bl;
    }

    public void WjISWjM() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        if (this.WjISVWY.isMarkedForDeletion()) {
            return;
        }
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        NdRepositoryExplicitLockManager ndRepositoryExplicitLockManager = ndInternalWorkspace.getExplicitLockManager();
        if (ndRepositoryExplicitLockManager == null) {
            throw new NdRepositoryException(NdStrings.WjISXKU("NoLockNullExplicitLockManager", this.WjISVWY.getName()));
        }
        ndRepositoryExplicitLockManager.lockEntry(this.WjISVWY);
    }

    public void WjISWkN(String string) throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        if (this.WjISVWY.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjISXLV("OperationNotAllowedOnDeletedItem", "setLabel", this.WjISVWY.getLocation()));
        }
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        if (!ndInternalWorkspace.isVersioned()) {
            throw new NdRepositoryException(NdStrings.WjISXKU("VersioningIsNotEnabled", this.WjISVWY.getLocation()));
        }
        try {
            ndInternalWorkspace.executingVersioningCommand();
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndInternalWorkspace.getWorkspaceVersionManager();
            ndWorkspaceVersionManager.setLabel(new NdRepositoryEntry[]{this.WjISVWY}, string);
        }
        catch (NdRepositoryVersionScmConnectionException ndRepositoryVersionScmConnectionException) {
            ndInternalWorkspace.versioningSystemOffline(true, ndRepositoryVersionScmConnectionException);
            throw ndRepositoryVersionScmConnectionException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void WjISWlO(boolean bl) throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        if (bl != this.WjISWiL()) {
            NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
            if (ndInternalWorkspace.getSecurityConfig() == null) {
                throw new NdRepositoryException(NdStrings.WjISXKU("NoSecurityConfig", this.WjISVWY.getLocation()));
            }
            NdLocation ndLocation = this.WjISVWY.getLocation();
            ndInternalWorkspace.addChangeProtectionLocation(ndLocation);
            try {
                this.WjISWsV(bl);
            }
            finally {
                ndInternalWorkspace.removeChangeProtectionLocation(ndLocation);
            }
        }
    }

    public void WjISWmP() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        if (this.WjISVWY.isMarkedForDeletion()) {
            return;
        }
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        NdRepositoryExplicitLockManager ndRepositoryExplicitLockManager = ndInternalWorkspace.getExplicitLockManager();
        if (ndRepositoryExplicitLockManager == null) {
            throw new NdRepositoryException(NdStrings.WjISXKU("NoUnlockNullExplicitLockManager", this.WjISVWY.getName()));
        }
        ndRepositoryExplicitLockManager.unlockEntry(this.WjISVWY);
    }

    public void WjISWnQ() throws NdRepositoryException {
        this.WjISVWY.ensureNotDetached();
        if (this.WjISVWY.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjISXLV("OperationNotAllowedOnDeletedItem", "update", this.WjISVWY.getLocation()));
        }
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        if (!ndInternalWorkspace.isVersioned()) {
            throw new NdRepositoryException(NdStrings.WjISXKU("VersioningIsNotEnabled", this.WjISVWY.getLocation()));
        }
        NdWorkspaceVersionManager ndWorkspaceVersionManager = ndInternalWorkspace.getWorkspaceVersionManager();
        try {
            ndInternalWorkspace.executingVersioningCommand();
            ndInternalWorkspace.inUpdateOperation(true);
            ndWorkspaceVersionManager.update(new NdRepositoryEntry[]{this.WjISVWY});
        }
        catch (NdRepositoryVersionScmConnectionException ndRepositoryVersionScmConnectionException) {
            ndInternalWorkspace.versioningSystemOffline(true, ndRepositoryVersionScmConnectionException);
            throw ndRepositoryVersionScmConnectionException;
        }
        finally {
            NdInternalWorkspaceDirectory ndInternalWorkspaceDirectory = (NdInternalWorkspaceDirectory)this.WjISVWY.getContainerDirectory();
            if (ndInternalWorkspaceDirectory != null) {
                ((NdWorkspaceDirectory)ndInternalWorkspaceDirectory.lookupRepositoryEntry("Globally Deleted Items")).resetEntries();
            }
            if (this.WjISVWY instanceof NdWorkspaceDirectory) {
                NdWorkspaceDirectory ndWorkspaceDirectory = (NdWorkspaceDirectory)((Object)this.WjISVWY);
                ((NdWorkspaceDirectory)ndWorkspaceDirectory.lookupRepositoryEntry("Globally Deleted Items")).resetEntries();
            }
            ndInternalWorkspace.resetCachedVersionInfo(this.WjISVWY);
            ndInternalWorkspace.inUpdateOperation(false);
        }
    }

    public NdRepositoryVersionResultSet WjISWoR() throws NdRepositoryException {
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = new NdRepositoryVersionResultSet();
        ndRepositoryVersionResultSet.setLocation(this.WjISVWY.getLocation());
        ndRepositoryVersionResultSet.setSuccessful(true);
        if (NdRepositorySupport.getAttributeValue(this.WjISVWY, "com.blazesoft.repository.local.locallycreated") != null) {
            NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
            if (NdBaseObject.areEqual((Object)WjISWxB.WjISWvY(ndInternalWorkspace), (Object)NdRepositorySupport.getCreationUserId(this.WjISVWY))) {
                ndRepositoryVersionResultSet.setVersionStatus(1);
            } else {
                ndRepositoryVersionResultSet.setVersionStatus(2);
            }
        } else if (NdRepositorySupport.getAttributeValue(this.WjISVWY, "com.blazesoft.repository.local.checkedOut") != null) {
            NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
            if (NdBaseObject.areEqual((Object)WjISWxB.WjISWvY(ndInternalWorkspace), (Object)NdRepositorySupport.getCreationUserId(this.WjISVWY))) {
                ndRepositoryVersionResultSet.setVersionStatus(3);
            } else {
                ndRepositoryVersionResultSet.setVersionStatus(4);
            }
            ndRepositoryVersionResultSet.setLocallyDeleted(this.WjISVWY.isMarkedForDeletion());
        } else {
            ndRepositoryVersionResultSet.setVersionStatus(5);
        }
        WjISZxK.WjISZwZ(this.WjISVWY, ndRepositoryVersionResultSet);
        return ndRepositoryVersionResultSet;
    }

    public NdRepositoryItemContent WjISWpS(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        WjISZKQ wjISZKQ = new WjISZKQ(ndRepositoryItemContent);
        byte[] byArray = wjISZKQ.getRawData();
        byte[] byArray2 = this.WjISWrU(byArray);
        String[] stringArray = NdBase64.encode((byte[])byArray2);
        StringBuffer stringBuffer = new StringBuffer(80 * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append('\n');
        }
        wjISZKQ.setData(stringBuffer.toString());
        return wjISZKQ;
    }

    public NdRepositoryItemContent WjISWqT(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        WjISZKQ wjISZKQ = new WjISZKQ(ndRepositoryItemContent);
        String string = wjISZKQ.getData();
        byte[] byArray = NdBase64.decode((String)string);
        wjISZKQ.setRawData(this.WjIVfjK().getProtectedWorkspaceSupport().decrypt(byArray));
        return wjISZKQ;
    }

    private byte[] WjISWrU(byte[] byArray) throws NdRepositoryException {
        return this.WjIVfjK().getProtectedWorkspaceSupport().encrypt(byArray);
    }

    void WjISWsV(boolean bl) throws NdRepositoryException {
        String string = bl ? "true" : null;
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("com.blazesoft.repository.security.protected", string)};
        NdRepositoryDirectory ndRepositoryDirectory = this.WjISVWY.getContainerDirectory();
        try {
            ndRepositoryDirectory.setRepositoryEntryAttributes(this.WjISVWY, ndRepositoryEntryAttributeArray);
            this.WjISVWY.setCachedProtectedStatus(bl);
        }
        catch (NdRepositoryException ndRepositoryException) {
            this.WjISVWY.resetCachedProtectedStatus();
            throw ndRepositoryException;
        }
    }

    private NdRepositoryEntryLockInfo WjISWtW() throws NdRepositoryException {
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo;
        NdInternalWorkspace ndInternalWorkspace = this.WjIVfjK();
        if (ndInternalWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndInternalWorkspace.getWorkspaceVersionManager();
            if (ndWorkspaceVersionManager.isServerConnected()) {
                ndRepositoryEntryLockInfo = ndWorkspaceVersionManager.getEntryLockInfos(new NdRepositoryEntry[]{this.WjISVWY})[0];
                WjISZxK.WjISZtW(this.WjISVWY, ndRepositoryEntryLockInfo);
            } else {
                ndRepositoryEntryLockInfo = this.WjISWuX();
            }
        } else {
            ndRepositoryEntryLockInfo = new NdDefaultRepositoryEntryLockInfo(1, null, this.WjISVWY.getLocation());
        }
        return ndRepositoryEntryLockInfo;
    }

    public NdRepositoryEntryLockInfo WjISWuX() throws NdRepositoryException {
        NdInternalWorkspace ndInternalWorkspace;
        String string = NdRepositorySupport.getAttributeValue(this.WjISVWY, "com.blazesoft.repository.local.checkedOut");
        int n = string != null ? (NdBaseObject.areEqual((Object)string, (Object)WjISWxB.WjISWvY(ndInternalWorkspace = this.WjIVfjK())) ? 2 : 4) : 1;
        return new NdDefaultRepositoryEntryLockInfo(n, string, this.WjISVWY.getLocation());
    }

    static String WjISWvY(NdInternalWorkspace ndInternalWorkspace) {
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndInternalWorkspace.getRepositoryConfig().getRepositoryVersionManagerConfig();
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        return ndVersioningRepositoryConnection.getUser();
    }

    private NdRepositoryVersionHistory[] WjISWwZ(NdWorkspace ndWorkspace) throws NdRepositoryException {
        if (ndWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
            if (ndWorkspaceVersionManager.isServerConnected()) {
                return ndWorkspaceVersionManager.getHistories(new NdRepositoryEntry[]{this.WjISVWY})[0];
            }
            return new NdRepositoryVersionHistory[0];
        }
        return new NdRepositoryVersionHistory[0];
    }

    private NdRepositoryVersionResultSet WjISWxA(NdWorkspace ndWorkspace) throws NdRepositoryException {
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet;
        if (ndWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
            if (ndWorkspaceVersionManager.isServerConnected()) {
                ndRepositoryVersionResultSet = ndWorkspaceVersionManager.getStatusInfos(new NdWorkspaceEntry[]{this.WjISVWY})[0];
                WjISZxK.WjISZvY(this.WjISVWY, ndRepositoryVersionResultSet);
            } else {
                ndRepositoryVersionResultSet = this.WjISWoR();
            }
        } else {
            NdRepositoryVersionResultSet ndRepositoryVersionResultSet2 = new NdRepositoryVersionResultSet();
            ndRepositoryVersionResultSet2.setLocation(this.WjISVWY.getLocation());
            ndRepositoryVersionResultSet2.setVersionStatus(1);
            ndRepositoryVersionResultSet2.setSuccessful(true);
            ndRepositoryVersionResultSet = ndRepositoryVersionResultSet2;
        }
        return ndRepositoryVersionResultSet;
    }

    public NdRepositoryEntryAttribute[] WjIVfkL(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>(ndRepositoryEntryAttributeArray.length);
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            String string = ndRepositoryEntryAttributeArray[i].getAttbId();
            if (string.equals("com.blazesoft.repository.local.savedversionstatus") || string.equals("com.blazesoft.repository.local.savedworkingversionid")) continue;
            vector.addElement(ndRepositoryEntryAttributeArray[i]);
        }
        Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NdRepositoryEntryAttribute[] WjIVflM(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray, NdRepositoryVersionResultSet ndRepositoryVersionResultSet) {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2;
        boolean bl = false;
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            if (!"com.blazesoft.repository.local.directoryUnmodified".equals(ndRepositoryEntryAttributeArray[i].getAttbId())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ndRepositoryEntryAttributeArray2 = new NdRepositoryEntryAttribute[ndRepositoryEntryAttributeArray.length + 2];
            System.arraycopy(ndRepositoryEntryAttributeArray, 0, ndRepositoryEntryAttributeArray2, 2, ndRepositoryEntryAttributeArray.length);
            ndRepositoryEntryAttributeArray2[0] = new NdRepositoryEntryAttribute("com.blazesoft.repository.local.savedversionstatus", String.valueOf(ndRepositoryVersionResultSet.getVersionStatus()));
            ndRepositoryEntryAttributeArray2[1] = new NdRepositoryEntryAttribute("com.blazesoft.repository.local.savedworkingversionid", ndRepositoryVersionResultSet.getWorkingVersionId());
        } else {
            ndRepositoryEntryAttributeArray2 = new NdRepositoryEntryAttribute[ndRepositoryEntryAttributeArray.length + 1];
            System.arraycopy(ndRepositoryEntryAttributeArray, 0, ndRepositoryEntryAttributeArray2, 1, ndRepositoryEntryAttributeArray.length);
            ndRepositoryEntryAttributeArray2[0] = new NdRepositoryEntryAttribute("com.blazesoft.repository.local.savedworkingversionid", ndRepositoryVersionResultSet.getWorkingVersionId());
        }
        return ndRepositoryEntryAttributeArray2;
    }

    private static class WjISZKQ
    extends NdRepositoryItemContent {
        WjISZKQ(NdRepositoryItemContent ndRepositoryItemContent) {
            super(ndRepositoryItemContent);
        }

        protected void setData(String string) {
            super.setData(string);
        }

        protected void setRawData(byte[] byArray) {
            super.setRawData(byArray);
        }
    }
}

