/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.file;

import com.blazesoft.repository.base.NdFileBasedRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryEntryNotFoundException;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItemContentConverter;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigLoader;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.NdRepositoryItemContentConverterFactory;
import com.blazesoft.repository.file.NdFileEntryNotDirRepositoryException;
import com.blazesoft.repository.file.NdFileEntryRepositoryException;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.file.NdFileRepositoryDefEntryFactory;
import com.blazesoft.repository.file.NdFileRepositoryDirectory;
import com.blazesoft.repository.file.NdFileRepositoryEntryFactory;
import com.blazesoft.repository.file.NdFileRepositoryEntryLocationManager;
import com.blazesoft.repository.file.NdStrings;
import java.io.File;
import java.io.IOException;

public class NdFileRepository
extends NdFileRepositoryDirectory
implements NdFileBasedRepository {
    public static final String REPOSITORY_BASE_LOCATION_TAG = "com.blazesoft.repository.file.baselocation";
    public static final String POPULATE_REPOSITORY_TAG = "com.blazesoft.repository.file.populate";
    public static final String FILE_REPOSITORY_USER_ID = "file.repository.user.id";
    public static final String FILE_REPOSITORY_USER_PASSWORD = "file.repository.user.password";
    public static final String WORK_ONLINE_TAG = "com.blazesoft.repository.file.work.online";
    private NdFileRepositoryEntryFactory WjHzEyR;
    private int WjHzEzS;
    private NdFileRepositoryEntryLocationManager WjHYTmC;
    private NdRepositoryConfig WjIehfW = null;
    private NdFileRepositoryConnection WjHIzVF = null;
    private boolean WjHDJZS;
    private String WjHEycE = "";
    private NdRepositoryItemContentConverter WjHIGGY;

    public NdFileRepository(NdRepositoryConnection ndRepositoryConnection) throws NdRepositoryException {
        String string;
        this.WjHIzVF = (NdFileRepositoryConnection)ndRepositoryConnection;
        if (this.WjHIzVF.getRepositoryFolder() == null || this.WjHIzVF.getRepositoryFolder().length() <= 0) {
            throw new NdRepositoryException(NdStrings.WjHzCYA("FoundInvalidRepositoryFolder", this.WjHIzVF.getRepositoryFolder()));
        }
        this.WjIejoZ(this.WjHIzVF.getRepositoryName());
        String string2 = this.WjHIzVF.getRepositoryFolder();
        if (!new File(string2).isAbsolute() && this.WjHIzVF.obtainBaseFilePath() != null && !new File(string2 = (string = this.WjHIzVF.obtainBaseFilePath()) + string2).exists()) {
            String string3 = string + ".." + File.separator + this.WjHIzVF.getRepositoryFolder();
            if (!new File(string3).exists()) {
                throw new NdRepositoryException(NdStrings.WjHzCYA("CouldNotFindRepositoryFolder", string2));
            }
            string2 = string3;
        }
        try {
            if (!new File(string2).exists()) {
                throw new NdRepositoryException(NdStrings.WjHzCYA("CouldNotFindRepositoryFolder", string2));
            }
            this.WjIahLZ(new File(new File(string2).getCanonicalPath()));
        }
        catch (IOException iOException) {
            this.WjIahLZ(new File(string2));
        }
        this.WjHEycE = ndRepositoryConnection.getUser();
        this.WjHDJZS = false;
    }

    public File getRepositoryRoot() {
        return (File)this.getPhysicalDescription();
    }

    private void WjHAtwZ() throws NdRepositoryException {
        String string = null;
        if (this.WjIehfW != null) {
            string = this.WjIehfW.getEntryFactoryClassName();
        }
        Class<?> clazz = null;
        if (string != null) {
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotFindClass", string), this, exception);
            }
        }
        if (clazz != null) {
            try {
                this.WjHzEyR = (NdFileRepositoryEntryFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotInstantiateClass", string), this, exception);
            }
        } else {
            this.WjHzEyR = new NdFileRepositoryDefEntryFactory();
        }
    }

    private void WjIvckZ() throws NdRepositoryException {
        try {
            File file = this.getFile();
            if (!file.exists()) {
                throw new NdRepositoryEntryNotFoundException(NdRepositorySupport.getLocation(this), file.getCanonicalPath());
            }
            File file2 = new File(file, "com_blazesoft_repository_config.cfg");
            if (file2.exists()) {
                this.WjIehfW = NdRepositoryConfigLoader.getDefaultRepositoryConfigLoader(this.WjHIzVF.getClassLoadingContext()).load(file2.getCanonicalPath(), (NdRepositoryConnection)this.WjHIzVF);
            }
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    private void WjHIGHZ() throws NdRepositoryException {
        NdRepositoryItemContentConverterFactory ndRepositoryItemContentConverterFactory = null;
        if (this.WjIehfW != null) {
            ndRepositoryItemContentConverterFactory = this.WjIehfW.getRepositoryItemContentConverterFactory();
        }
        this.WjHIGGY = ndRepositoryItemContentConverterFactory != null ? (NdRepositoryItemContentConverter)ndRepositoryItemContentConverterFactory.newRepositoryItemContentConverter() : null;
        if (this.WjHIGGY != null) {
            this.WjHIGGY.openConnection(this);
        }
    }

    String WjHOqRO() {
        return this.WjHEycE;
    }

    NdFileRepository WjIahJX() {
        return this;
    }

    public NdFileRepositoryEntryFactory getRepositoryEntryFactory() throws NdRepositoryException {
        if (this.WjHzEyR == null) {
            this.WjHAtwZ();
        }
        return this.WjHzEyR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection(int n) throws NdRepositoryException {
        Object object;
        this.WjHzEzS = n;
        if (!(this.WjHDJZS || ((File)(object = this.getFile())).exists() && ((File)object).isDirectory() && ((File)object).canRead())) {
            String string = ((File)object).getAbsolutePath();
            try {
                string = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!((File)object).exists()) {
                throw new NdRepositoryEntryNotFoundException(NdRepositorySupport.getLocation(this), string);
            }
            if (!((File)object).isDirectory()) {
                throw new NdFileEntryNotDirRepositoryException(string, this);
            }
            if (!((File)object).canRead()) {
                throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotRead", string), this);
            }
        }
        object = this;
        synchronized (object) {
            if (this.WjHzEyR == null) {
                this.WjHAtwZ();
            }
            if (this.WjHIGGY == null) {
                this.WjHIGHZ();
            }
            this.WjHDJZS = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws NdRepositoryException {
        NdFileRepository ndFileRepository = this;
        synchronized (ndFileRepository) {
            this.WjHDJZS = false;
        }
    }

    public int getRepositoryMode() {
        return this.WjHzEzS;
    }

    public synchronized NdRepositoryEntryLocationManager getRepositoryEntryLocationManager() {
        if (this.WjHYTmC == null) {
            String string = this.WjHIzVF.getRepositoryFolder();
            this.WjHYTmC = new NdFileRepositoryEntryLocationManager(string);
        }
        return this.WjHYTmC;
    }

    public NdRepositoryItemContentConverter getRepositoryItemContentConverter() {
        return this.WjHIGGY;
    }

    public void setRepositoryItemContentConverter(NdRepositoryItemContentConverter ndRepositoryItemContentConverter) {
        this.WjHIGGY = ndRepositoryItemContentConverter;
    }

    public NdRepositoryConnection getRepositoryConnection() {
        return this.WjHIzVF;
    }

    public NdRepositoryConfig getRepositoryConfig() {
        if (this.WjIehfW == null) {
            try {
                this.WjIvckZ();
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRepositoryRuntimeException((Throwable)((Object)ndRepositoryException));
            }
        }
        return this.WjIehfW;
    }

    public void setRepositoryConfig(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        try {
            String string = this.getFile().getCanonicalPath() + File.separator + "com_blazesoft_repository_config.cfg";
            NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(string, ndRepositoryConfig);
        }
        catch (Exception exception) {
            throw new NdRepositoryException(exception);
        }
    }
}

