/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.file;

import com.blazesoft.dynobj.NdDynObjFilePathConsumer;
import com.blazesoft.repository.base.NdAbstractWorkspaceConnection;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.file.NdStrings;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class NdFileRepositoryConnection
extends NdAbstractWorkspaceConnection
implements NdWorkspaceConnection,
NdDynObjFilePathConsumer {
    public static final String REPOSITORY_CONNECTION_FOLDER_TAG = "com_blazesoft_repository_repositoryfolder";
    public static final String WORKSPACE_CONNECTION_FOLDER_TAG = "com_blazesoft_repository_workspacefolder";
    public static final String WORKSPACE_CONNECTION_USER_TAG = "com_blazesoft_repository_workspaceuser";
    public static final String WORKSPACE_CONNECTION_PASSWORD_TAG = "com_blazesoft_repository_workspacepassword";
    public static final String WORKSPACE_CONNECTION_PERSIST_CREDENTIALS_TAG = "com_blazesoft_repository_persist_workspacecredentials";
    private String WjIacfL;
    private Hashtable WjIaciO;
    private static NdRepositoryAdminFactory WjIljoR = new NdRepositoryAdminFactory("com.blazesoft.repository.file.NdFileRepositoryAdmin");
    private String WjIuiLR;
    private String WjIyoDK;

    public NdFileRepositoryConnection() {
    }

    public NdFileRepositoryConnection(Hashtable hashtable) {
        this.setUser((String)hashtable.get("com_blazesoft_repository_username"));
        this.setPassword((String)hashtable.get("com_blazesoft_repository_password"));
        String string = (String)hashtable.get(REPOSITORY_CONNECTION_FOLDER_TAG);
        if (string == null) {
            Object v = hashtable.get("com_blazesoft_repository_isForWorkspace");
            boolean bl = v != null ? (v instanceof Boolean ? ((Boolean)v).booleanValue() : Boolean.valueOf(String.valueOf(v)).booleanValue()) : false;
            if (bl) {
                string = (String)hashtable.get(WORKSPACE_CONNECTION_FOLDER_TAG);
            }
        }
        this.WjIacfL = string;
        this.setRepositoryName(this.WjIaclR(this.WjIacfL));
        this.WjIaciO = hashtable;
    }

    private String WjIaclR(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException((Throwable)iOException);
        }
        if (string2.lastIndexOf(File.separator) != -1) {
            string2 = string2.substring(string2.lastIndexOf(File.separator) + 1);
        }
        return string2;
    }

    public String getSystemDescription() {
        if (this.WjIyoDK == null) {
            this.WjIyoDK = NdStrings.WjHzCYA("FileRepository", this.getRepositoryName());
            String string = this.getRepositoryFolder();
            if (string != null) {
                this.WjIyoDK = NdStrings.WjHzCZB("FileRepositoryAt", this.WjIyoDK, string);
            }
        }
        return this.WjIyoDK;
    }

    public void setSystemDescription(String string) {
        this.WjIyoDK = string;
    }

    public String getRawRepositoryFolder() {
        return this.WjIacfL;
    }

    public String getRepositoryFolder() {
        return this.getInterpolatedPath(this.WjIacfL);
    }

    public void setRepositoryFolder(String string) {
        this.WjIacfL = string;
        if (this.getRepositoryName() == null) {
            this.setRepositoryName(this.WjIaclR(string));
        }
        if (this.WjIaciO != null) {
            this.WjIaciO.put(REPOSITORY_CONNECTION_FOLDER_TAG, string);
        }
    }

    public void setUser(String string) {
        super.setUser(string);
        if (this.WjIaciO != null) {
            if (string != null) {
                this.WjIaciO.put("com_blazesoft_repository_username", string);
            } else {
                this.WjIaciO.remove("com_blazesoft_repository_username");
            }
        }
    }

    public void setPassword(String string) {
        super.setPassword(string);
        if (this.WjIaciO != null) {
            if (string != null) {
                this.WjIaciO.put("com_blazesoft_repository_password", string);
            } else {
                this.WjIaciO.remove("com_blazesoft_repository_password");
            }
        }
    }

    public String getRepositoryClassName() {
        return "com.blazesoft.repository.file.NdFileRepository";
    }

    public Hashtable getConnectionArgs() {
        if (this.WjIaciO == null) {
            this.WjIaciO = new Hashtable();
            if (this.getUser() != null) {
                this.WjIaciO.put("com_blazesoft_repository_username", this.getUser());
            }
            if (this.getPassword() != null) {
                this.WjIaciO.put("com_blazesoft_repository_password", this.getPassword());
            }
            if (this.getRawRepositoryFolder() != null) {
                this.WjIaciO.put(REPOSITORY_CONNECTION_FOLDER_TAG, this.getRawRepositoryFolder());
            }
            this.WjIaciO.put("com_blazesoft_repository_connectionclass", this.getClass().getName());
        }
        return this.WjIaciO;
    }

    public NdRepositoryAdminFactory getRepositoryAdminFactory() {
        return WjIljoR;
    }

    private String WjIUxVI(String string) {
        String string2;
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException((Throwable)iOException);
        }
        string2 = string2.trim();
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private boolean WjIUxWJ(NdFileRepositoryConnection ndFileRepositoryConnection) {
        String string = this.getRepositoryFolder();
        if (string != null) {
            String string2 = ndFileRepositoryConnection.getRepositoryFolder();
            if (string2 == null) {
                return false;
            }
            boolean bl = this.WjIUxVI(string).equals(this.WjIUxVI(string2));
            return bl;
        }
        return this.getRawRepositoryFolder() == ndFileRepositoryConnection.getRawRepositoryFolder();
    }

    public boolean isSameWorkspace(NdWorkspaceConnection ndWorkspaceConnection) {
        boolean bl = super.isSameWorkspace(ndWorkspaceConnection);
        if (!bl && ndWorkspaceConnection instanceof NdFileRepositoryConnection) {
            NdFileRepositoryConnection ndFileRepositoryConnection = (NdFileRepositoryConnection)ndWorkspaceConnection;
            bl = this.WjIUxWJ(ndFileRepositoryConnection);
        }
        return bl;
    }

    public boolean equals(NdRepositoryConnection ndRepositoryConnection) {
        if (!(ndRepositoryConnection instanceof NdFileRepositoryConnection)) {
            return false;
        }
        if (!super.equals(ndRepositoryConnection)) {
            return false;
        }
        NdFileRepositoryConnection ndFileRepositoryConnection = (NdFileRepositoryConnection)ndRepositoryConnection;
        return this.WjIUxWJ(ndFileRepositoryConnection);
    }

    public void updateBaseFilePath(String string) throws IOException {
        this.WjIuiLR = string;
    }

    public String obtainBaseFilePath() {
        return this.WjIuiLR;
    }
}

