/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.file;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.dotnet.NdFile;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentDefConverterContext;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.file.NdFileEntryRepositoryException;
import com.blazesoft.repository.file.NdFileRepository;
import com.blazesoft.repository.file.NdFileRepositoryDirectory;
import com.blazesoft.repository.file.NdFileRepositoryEntry;
import com.blazesoft.repository.file.NdStrings;
import com.blazesoft.util.NdIOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class NdFileRepositoryItem
extends NdFileRepositoryEntry
implements NdRepositoryItem {
    NdFileRepositoryItem(NdFileRepositoryDirectory ndFileRepositoryDirectory, String string, File file) {
        super(ndFileRepositoryDirectory, string, file);
    }

    public NdRepositoryItemContent getContent() throws NdRepositoryException {
        byte[] byArray;
        Serializable serializable;
        NdRepository ndRepository = NdRepositorySupport.getRepository(this);
        try {
            serializable = this.getFile();
            byArray = NdIOUtil.readAllBytes((File)serializable);
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotReadContent", this.getName()), this, exception);
        }
        serializable = new NdRepositoryItemContent(byArray);
        ((NdRepositoryItemContent)serializable).setItemContentConverter(ndRepository.getRepositoryItemContentConverter());
        ((NdRepositoryItemContent)serializable).setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(ndRepository, this));
        return serializable;
    }

    public void setContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        NdFileRepository ndFileRepository = (NdFileRepository)NdRepositorySupport.getRepository(this);
        try {
            this.checkWriteMode();
            ndRepositoryItemContent.setItemContentConverter(ndFileRepository.getRepositoryItemContentConverter());
            ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(ndFileRepository, this));
            File file = this.getFile();
            if (file.exists() && !file.canWrite()) {
                throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("ReadOnlyFileError", this.getName()), this);
            }
            byte[] byArray = ndRepositoryItemContent.getRawData();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            String string = ndFileRepository.WjHOqRO();
            if (string != null && string.length() > 0) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute("innovatorLastModifiedUser", string);
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{ndRepositoryEntryAttribute};
                this.getContainerDirectory().setRepositoryEntryAttributes(this, ndRepositoryEntryAttributeArray);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotWriteContent", this.getName()), this, exception);
        }
    }

    public Date getLastModified() throws NdRepositoryException {
        long l = this.getFile().lastModified();
        return new Date(l);
    }

    public void setLastModified(Date date) throws NdRepositoryException {
        try {
            NdFile ndFile = NdDotNETLib.getFileSupport().getFile(this.getFile().getCanonicalPath());
            ndFile.setLastModified(date.getTime());
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    public boolean isReadable() throws NdRepositoryException {
        return this.getFile().canRead();
    }

    public boolean isWritable() throws NdRepositoryException {
        return this.getFile().canWrite();
    }
}

