/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jdbc;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.java6.WjHDSZL;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryAlreadyExistsException;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigLoader;
import com.blazesoft.repository.jdbc.NdJdbcEntryRepositoryException;
import com.blazesoft.repository.jdbc.NdJdbcRepository;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryAccessor;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryDirectory;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryEntry;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryItem;
import com.blazesoft.repository.jdbc.NdStrings;
import com.blazesoft.security.NdAccessController;
import com.blazesoft.security.NdPrivilegedExceptionAction;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.WjHzAhT;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NdDefaultJdbcRepositoryAccessor
implements NdJdbcRepositoryAccessor {
    private static final String WjHBasO = "innovator";
    private static final String WjHKesQ = "attribute";
    private static final String WjIJkKI = "Oversized_Binary_Attribute_Value";
    private static final int WjHBasP = "innovator".length();
    private NdJdbcRepository WjHBasQ;
    private String WjHBasR;
    private String WjHBasS;
    private String WjHBasT;
    private String WjHBasU;
    private Connection WjHBasV;
    private String WjHBasW;
    private String WjHBasX;
    private Hashtable WjHBasY;
    private NdJdbcRepositoryConnection WjHIPlT;
    private boolean WjItmcO;
    private static final Hashtable WjHKetR = new Hashtable();
    private String WjJqeUO = null;

    protected static String getFieldName(String string) {
        if (string.startsWith(WjHBasO)) {
            String string2 = string.substring(WjHBasP, WjHBasP + 1).toLowerCase();
            String string3 = string.substring(WjHBasP + 1);
            return string2 + string3;
        }
        return string;
    }

    protected static String getAttrName(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1);
        return WjHBasO + string2 + string3;
    }

    public NdDefaultJdbcRepositoryAccessor(NdJdbcRepository ndJdbcRepository) {
        this.WjHBasQ = ndJdbcRepository;
    }

    private boolean WjHBasZ(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory, NdJdbcRepositoryEntry ndJdbcRepositoryEntry) throws SQLException, NdRepositoryException {
        String string = "SELECT id FROM " + this.WjHBasW + " WHERE dirId=? and name=?";
        boolean bl = false;
        PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
        preparedStatement.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
        preparedStatement.setString(2, ndJdbcRepositoryEntry.getName());
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    private void WjHKeAY(Object object, String string, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return;
        }
        String string2 = "INSERT INTO " + this.WjHBasW + " (ID, DIRID, NAME, SHORTDESC, ITEMTYPE, ITEMCONTENT) VALUES (?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string2);
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                String string3 = null;
                WjHzAhT wjHzAhT = new WjHzAhT(null);
                String string4 = wjHzAhT.WjHzAhS(WjHzAhT.WjHzAhP);
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
                preparedStatement.setString(1, string4);
                preparedStatement.setString(2, (String)object);
                preparedStatement.setString(3, ndRepositoryEntryAttribute.getAttbId());
                if (ndRepositoryEntryAttribute.getAttbValue() != null && ndRepositoryEntryAttribute.getAttbValue().length() > 255) {
                    string3 = ndRepositoryEntryAttribute.getAttbValue();
                    preparedStatement.setString(4, WjIJkKI);
                } else {
                    preparedStatement.setString(4, ndRepositoryEntryAttribute.getAttbValue());
                }
                preparedStatement.setString(5, WjHKesQ);
                if (string3 != null) {
                    preparedStatement.setBytes(6, string3.getBytes("UTF8"));
                } else {
                    preparedStatement.setBytes(6, new byte[0]);
                }
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdRepositoryException(NdStrings.WjHBadS("CouldNotSetEntryAttributes", string), sQLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                unsupportedEncodingException.printStackTrace();
            }
            throw new NdRepositoryException(NdStrings.WjHBadS("CouldNotSetEntryAttributes", string), unsupportedEncodingException);
        }
    }

    private void WjHKeBZ(NdJdbcRepositoryEntry ndJdbcRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        Object[] objectArray;
        int n;
        int n2;
        int n3;
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return;
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjHKewU(ndJdbcRepositoryEntry);
        if (ndRepositoryEntryAttributeArray2 == null || ndRepositoryEntryAttributeArray2.length == 0) {
            this.WjHKeAY(ndJdbcRepositoryEntry.getKey(), ndJdbcRepositoryEntry.getName(), ndRepositoryEntryAttributeArray);
            return;
        }
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        for (n3 = 0; n3 < ndRepositoryEntryAttributeArray2.length; ++n3) {
            boolean bl = false;
            for (n2 = 0; n2 < ndRepositoryEntryAttributeArray.length; ++n2) {
                if (!ndRepositoryEntryAttributeArray2[n3].getAttbId().equals(ndRepositoryEntryAttributeArray[n2].getAttbId())) continue;
                bl = true;
                if (ndRepositoryEntryAttributeArray[n2].getAttbValue() == null) break;
                vector.addElement(ndRepositoryEntryAttributeArray[n2]);
                break;
            }
            if (bl) continue;
            vector.addElement(ndRepositoryEntryAttributeArray2[n3]);
        }
        for (n3 = 0; n3 < ndRepositoryEntryAttributeArray.length; ++n3) {
            n2 = 1;
            for (n = 0; n < ndRepositoryEntryAttributeArray2.length; ++n) {
                if (!ndRepositoryEntryAttributeArray[n3].getAttbId().equals(ndRepositoryEntryAttributeArray2[n].getAttbId())) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            vector.addElement(ndRepositoryEntryAttributeArray[n3]);
        }
        String string = "DELETE FROM " + this.WjHBasW + " WHERE dirid=? AND NAME=? AND ITEMTYPE=? ";
        try {
            objectArray = this.WjHBasV.prepareStatement(string);
            for (n = 0; n < ndRepositoryEntryAttributeArray2.length; ++n) {
                objectArray.setString(1, (String)ndJdbcRepositoryEntry.getKey());
                objectArray.setString(2, ndRepositoryEntryAttributeArray2[n].getAttbId());
                objectArray.setString(3, WjHKesQ);
                objectArray.executeUpdate();
            }
            objectArray.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdRepositoryException(NdStrings.WjHBadS("CouldNotUpdateEntryAttributes", ndJdbcRepositoryEntry.getName()), sQLException);
        }
        if (vector.size() == 0) {
            return;
        }
        objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        this.WjHKeAY(ndJdbcRepositoryEntry.getKey(), ndJdbcRepositoryEntry.getName(), (NdRepositoryEntryAttribute[])objectArray);
    }

    private NdRepositoryEntryAttribute[] WjHKewU(NdJdbcRepositoryEntry ndJdbcRepositoryEntry) throws NdRepositoryException {
        Object[] objectArray;
        String string = "SELECT * FROM " + this.WjHBasW + " WHERE DIRID=? AND ITEMTYPE=?";
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        this.open();
        try {
            objectArray = this.WjHBasV.prepareStatement(string);
            objectArray.setString(1, (String)ndJdbcRepositoryEntry.getKey());
            objectArray.setString(2, WjHKesQ);
            ResultSet resultSet = objectArray.executeQuery();
            while (resultSet.next()) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute(resultSet.getString("NAME"), resultSet.getString("SHORTDESC"));
                if (WjIJkKI.equals(ndRepositoryEntryAttribute.getAttbValue())) {
                    String string2 = resultSet.getString("id");
                    byte[] byArray = resultSet.getBytes("itemContent");
                    ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute(resultSet.getString("NAME"), new String(byArray, "UTF8"));
                }
                vector.addElement(ndRepositoryEntryAttribute);
            }
            resultSet.close();
            objectArray.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotSetEntryAttributes", ndJdbcRepositoryEntry.getName()), ndJdbcRepositoryEntry, sQLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                unsupportedEncodingException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetEntryAttributes", ndJdbcRepositoryEntry.getName()), ndJdbcRepositoryEntry, unsupportedEncodingException);
        }
        objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private NdRepositoryEntryAttribute[] WjHKeyW(NdJdbcRepositoryEntry ndJdbcRepositoryEntry, String[] stringArray) throws NdRepositoryException {
        if (stringArray == null || stringArray.length == 0) {
            return new NdRepositoryEntryAttribute[0];
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[stringArray.length];
        String string = "SELECT id, SHORTDESC, ITEMCONTENT FROM " + this.WjHBasW + " WHERE DIRID=? AND NAME=? AND ITEMTYPE=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = null;
                preparedStatement.setString(1, (String)ndJdbcRepositoryEntry.getKey());
                preparedStatement.setString(2, stringArray[i]);
                preparedStatement.setString(3, WjHKesQ);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    if (WjIJkKI.equals(ndRepositoryEntryAttributeArray[i].getAttbValue())) {
                        byte[] byArray = resultSet.getBytes("ItemContent");
                        ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute(stringArray[i], new String(byArray, "UTF8"));
                    } else {
                        ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute(stringArray[i], resultSet.getString(2));
                    }
                } else {
                    ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute(stringArray[i], null);
                }
                resultSet.close();
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetEntryAttributes", ndJdbcRepositoryEntry.getName()), ndJdbcRepositoryEntry, sQLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                unsupportedEncodingException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetEntryAttributes", ndJdbcRepositoryEntry.getName()), ndJdbcRepositoryEntry, unsupportedEncodingException);
        }
        return ndRepositoryEntryAttributeArray;
    }

    private NdRepositoryEntryAttribute[] WjHKevT(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return null;
        }
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
            if (WjHKetR.get(ndRepositoryEntryAttribute.getAttbId()) == null) continue;
            vector.addElement(ndRepositoryEntryAttribute);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private String[] WjHKezX(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (WjHKetR.get(stringArray[i]) == null) continue;
            vector.addElement(stringArray[i]);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private NdRepositoryEntryAttribute[] WjHKeuS(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return null;
        }
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
            if (WjHKetR.get(ndRepositoryEntryAttribute.getAttbId()) != null) continue;
            vector.addElement(ndRepositoryEntryAttribute);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private String[] WjHKexV(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (WjHKetR.get(stringArray[i]) != null) continue;
            vector.addElement(stringArray[i]);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public void openConnection(NdJdbcRepositoryConnection ndJdbcRepositoryConnection) throws NdRepositoryException {
        this.WjHIPlT = ndJdbcRepositoryConnection;
        if (ndJdbcRepositoryConnection.getNativeConnection() != null) {
            this.WjHBasV = ndJdbcRepositoryConnection.getNativeConnection();
            this.WjItmcO = true;
        } else {
            this.WjHBasR = ndJdbcRepositoryConnection.getJdbcDriver();
            this.WjHBasS = ndJdbcRepositoryConnection.getJdbcUrl();
            this.WjHBasT = ndJdbcRepositoryConnection.getUser();
            this.WjHBasU = ndJdbcRepositoryConnection.getPassword();
            if ((this.WjHBasR == null || this.WjHBasR.length() == 0) && this.WjHBasS != null && this.WjHBasS.startsWith("jdbc:odbc")) {
                this.WjHBasR = NdSystemProperties.getJavaVendorType() == 1 ? "com.ms.jdbc.odbc.JdbcOdbcDriver" : "sun.jdbc.odbc.JdbcOdbcDriver";
            }
            this.open();
        }
    }

    public void openConnection(Hashtable hashtable) throws NdRepositoryException {
        this.WjHBasY = hashtable;
        this.WjHBasR = (String)hashtable.get("JDBC.driver");
        this.WjHBasS = (String)hashtable.get("JDBC.database.url");
        this.WjHBasT = (String)hashtable.get("JDBC.username");
        this.WjHBasU = (String)hashtable.get("JDBC.password");
        if ((this.WjHBasR == null || this.WjHBasR.length() == 0) && this.WjHBasS != null && this.WjHBasS.startsWith("jdbc:odbc")) {
            this.WjHBasR = NdSystemProperties.getJavaVendorType() == 1 ? "com.ms.jdbc.odbc.JdbcOdbcDriver" : "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        this.open();
    }

    protected void open() throws NdRepositoryException {
        if (!this.WjItmcO) {
            try {
                if (this.WjHBasV == null || this.WjHBasV.isClosed()) {
                    NdClassLoadingContext ndClassLoadingContext = this.WjHIPlT.getClassLoadingContext();
                    WjHDSZL.WjHGAFQ((NdClassLoadingContext)ndClassLoadingContext, (String)this.WjHBasR);
                    String string = this.WjHBasU;
                    if (this.WjHBasU != null && this.WjHBasU.length() > 0) {
                        try {
                            final String string2 = string;
                            string = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return NdRepositorySupport.decryptPassword(NdDefaultJdbcRepositoryAccessor.this.WjHIPlT, string2);
                                }
                            });
                        }
                        catch (Exception exception) {
                            throw new NdRepositoryException(exception);
                        }
                    }
                    this.WjHBasV = DriverManager.getConnection(this.WjHBasS, this.WjHBasT, string);
                }
                if (!this.WjHBasV.getAutoCommit()) {
                    this.WjHBasV.setAutoCommit(true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    classNotFoundException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotFindClass", this.WjHBasR), this.WjHBasQ, classNotFoundException);
            }
            catch (SQLException sQLException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    sQLException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBafU("CouldNotConnectDB", this.WjHBasR, this.WjHBasS, this.WjHBasT), this.WjHBasQ, sQLException);
            }
            catch (InstantiationException instantiationException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    instantiationException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBafU("CouldNotConnectDB", this.WjHBasR, this.WjHBasS, this.WjHBasT), this.WjHBasQ, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    illegalAccessException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBafU("CouldNotConnectDB", this.WjHBasR, this.WjHBasS, this.WjHBasT), this.WjHBasQ, illegalAccessException);
            }
            catch (Exception exception) {
                if (exception instanceof NdRepositoryException) {
                    throw (NdRepositoryException)((Object)exception);
                }
                if (NdSystemProperties.isDebugModeEnabled()) {
                    exception.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(exception);
            }
        }
    }

    public void closeConnection() throws NdRepositoryException {
        if (!this.WjItmcO) {
            try {
                this.WjHBasV.close();
            }
            catch (SQLException sQLException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    sQLException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBabQ("CouldNotCloseDB"), this.WjHBasQ, sQLException);
            }
        }
    }

    public Object getRepositoryKey() throws NdRepositoryException {
        if (this.WjHIPlT != null) {
            this.WjJhIKG(this.WjHIPlT.getJdbcTable());
            this.WjHBasX = this.WjHIPlT.getRepositoryName();
        } else {
            this.WjJhIKG((String)this.WjHBasY.get("JDBC.repository.table"));
            this.WjHBasX = (String)this.WjHBasY.get("com.blazesoft.repository.base.repositoryname");
        }
        String string = "SELECT id FROM " + this.WjHBasW + " WHERE name=? AND dirId=?";
        this.open();
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, this.WjHBasX);
            preparedStatement.setString(2, "no parent");
            ResultSet resultSet = preparedStatement.executeQuery();
            String string2 = null;
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (string2 == null) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotLocateRepository", this.WjHBasX, this.WjHBasW), this.WjHBasQ);
            }
            return string2;
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotLocateRepository", this.WjHBasX, this.WjHBasW), this.WjHBasQ, sQLException);
        }
    }

    public NdJdbcRepositoryEntry[] getEntries(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory) throws NdRepositoryException {
        this.open();
        String string = "SELECT id, isItem, name, ITEMTYPE FROM " + this.WjHBasW + " WHERE dirId=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<NdJdbcRepositoryItem> vector = new Vector<NdJdbcRepositoryItem>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                boolean bl = resultSet.getBoolean(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                if (string3.equals("_com_blazesoft_repository_config_object") || string3.startsWith("_ext_config_obj_") || WjHKesQ.equalsIgnoreCase(string4)) continue;
                NdJdbcRepositoryEntry ndJdbcRepositoryEntry = bl ? new NdJdbcRepositoryItem(ndJdbcRepositoryDirectory, string3, string2) : new NdJdbcRepositoryDirectory(ndJdbcRepositoryDirectory, string3, string2);
                vector.addElement((NdJdbcRepositoryItem)ndJdbcRepositoryEntry);
            }
            Object[] objectArray = new NdJdbcRepositoryEntry[vector.size()];
            if (vector.size() > 0) {
                vector.copyInto(objectArray);
            }
            resultSet.close();
            preparedStatement.close();
            return objectArray;
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetEntries", ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
    }

    public Object addDirectory(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory, NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory2, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        Object object;
        this.open();
        try {
            if (this.WjHBasZ(ndJdbcRepositoryDirectory, ndJdbcRepositoryDirectory2)) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjHBaeT("EntryAlreadyExist", ndJdbcRepositoryDirectory2.getName(), ndJdbcRepositoryDirectory.getName()));
            }
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotCreateDirectoryWith", ndJdbcRepositoryDirectory2.getName(), ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjHKevT(ndRepositoryEntryAttributeArray);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = this.WjHKeuS(ndRepositoryEntryAttributeArray);
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.WjHBasW);
        stringBuffer.append(" (");
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        if (ndRepositoryEntryAttributeArray2 != null) {
            for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                object = ndRepositoryEntryAttributeArray2[i];
                String string = NdDefaultJdbcRepositoryAccessor.getFieldName(((NdRepositoryEntryAttribute)object).getAttbId());
                if (string.equals("name")) {
                    bl = true;
                }
                stringBuffer.append(string);
                stringBuffer.append(", ");
                stringBuffer2.append("?, ");
            }
        }
        stringBuffer.append("id, dirId, isItem");
        if (!bl) {
            stringBuffer.append(", name");
        }
        stringBuffer.append(") VALUES (");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("?, ?, ?");
        if (!bl) {
            stringBuffer.append(", ?");
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        try {
            Object object2;
            object = this.WjHBasV.prepareStatement(string);
            int n = 0;
            if (ndRepositoryEntryAttributeArray2 != null) {
                n = ndRepositoryEntryAttributeArray2.length;
                for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                    object2 = ndRepositoryEntryAttributeArray2[i];
                    object.setString(i + 1, ((NdRepositoryEntryAttribute)object2).getAttbValue());
                }
            }
            WjHzAhT wjHzAhT = new WjHzAhT(null);
            object2 = wjHzAhT.WjHzAhS(WjHzAhT.WjHzAhP);
            object.setString(n + 1, (String)object2);
            object.setString(n + 2, (String)ndJdbcRepositoryDirectory.getKey());
            object.setBoolean(n + 3, false);
            if (!bl) {
                object.setString(n + 4, ndJdbcRepositoryDirectory2.getName());
            }
            object.executeUpdate();
            object.close();
            if (ndRepositoryEntryAttributeArray3 != null && ndRepositoryEntryAttributeArray3.length > 0) {
                this.WjHKeAY(object2, ndJdbcRepositoryDirectory2.getName(), ndRepositoryEntryAttributeArray3);
            }
            return object2;
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotCreateDirectoryWith", ndJdbcRepositoryDirectory2.getName(), ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
    }

    public void removeDirectory(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory) throws NdRepositoryException {
        PreparedStatement preparedStatement;
        this.open();
        String string = "DELETE FROM " + this.WjHBasW + " WHERE dirid=? AND ITEMTYPE=?";
        try {
            PreparedStatement preparedStatement2 = this.WjHBasV.prepareStatement(string);
            preparedStatement2.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
            preparedStatement2.setString(2, WjHKesQ);
            preparedStatement2.executeUpdate();
            preparedStatement2.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotRemoveDirectory", ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
        boolean bl = false;
        String string2 = "SELECT id FROM " + this.WjHBasW + " WHERE dirId=?";
        try {
            preparedStatement = this.WjHBasV.prepareStatement(string2);
            preparedStatement.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotRemoveDirectory", ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
        if (bl) {
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotRemoveDirectoryWith", ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory);
        }
        string2 = "DELETE FROM " + this.WjHBasW + " WHERE id=?";
        try {
            preparedStatement = this.WjHBasV.prepareStatement(string2);
            preparedStatement.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
            preparedStatement.executeUpdate();
            preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
            preparedStatement.setString(2, WjHKesQ);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotRemoveDirectory", ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
    }

    public Object addItem(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory, NdJdbcRepositoryItem ndJdbcRepositoryItem, byte[] byArray, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        Object object;
        this.open();
        try {
            if (this.WjHBasZ(ndJdbcRepositoryDirectory, ndJdbcRepositoryItem)) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjHBaeT("EntryAlreadyExist", ndJdbcRepositoryItem.getName(), ndJdbcRepositoryDirectory.getName()));
            }
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotCreateItemWith", ndJdbcRepositoryItem.getName(), ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjHKevT(ndRepositoryEntryAttributeArray);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = this.WjHKeuS(ndRepositoryEntryAttributeArray);
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.WjHBasW);
        stringBuffer.append(" (");
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        if (ndRepositoryEntryAttributeArray2 != null) {
            for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                object = ndRepositoryEntryAttributeArray2[i];
                String string = NdDefaultJdbcRepositoryAccessor.getFieldName(((NdRepositoryEntryAttribute)object).getAttbId());
                if (string.equals("name")) {
                    bl = true;
                }
                stringBuffer.append(string);
                stringBuffer.append(", ");
                stringBuffer2.append("?, ");
            }
        }
        stringBuffer.append("id, dirId, isItem, lastModified");
        if (!bl) {
            stringBuffer.append(", name");
        }
        stringBuffer.append(") VALUES (");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("?, ?, ?, ?");
        if (!bl) {
            stringBuffer.append(", ?");
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        try {
            Object object2;
            object = this.WjHBasV.prepareStatement(string);
            int n = 0;
            if (ndRepositoryEntryAttributeArray2 != null) {
                n = ndRepositoryEntryAttributeArray2.length;
                for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                    object2 = ndRepositoryEntryAttributeArray2[i];
                    object.setString(i + 1, ((NdRepositoryEntryAttribute)object2).getAttbValue());
                }
            }
            WjHzAhT wjHzAhT = new WjHzAhT(null);
            object2 = wjHzAhT.WjHzAhS(WjHzAhT.WjHzAhP);
            object.setString(n + 1, (String)object2);
            object.setString(n + 2, (String)ndJdbcRepositoryDirectory.getKey());
            object.setBoolean(n + 3, true);
            Timestamp timestamp = new Timestamp(new Date().getTime());
            object.setTimestamp(n + 4, timestamp);
            n += 5;
            if (!bl) {
                object.setString(n, ndJdbcRepositoryItem.getName());
            }
            object.executeUpdate();
            object.close();
            try {
                this.setKeyItemContent(object2, byArray);
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotSetItemContent", ndJdbcRepositoryItem.getName()), ndJdbcRepositoryItem, (Throwable)((Object)ndRepositoryException));
            }
            if (ndRepositoryEntryAttributeArray3 != null && ndRepositoryEntryAttributeArray3.length > 0) {
                this.WjHKeAY(object2, ndJdbcRepositoryItem.getName(), ndRepositoryEntryAttributeArray3);
            }
            return object2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotCreateItemWith", ndJdbcRepositoryItem.getName(), ndJdbcRepositoryDirectory.getName()), ndJdbcRepositoryDirectory, sQLException);
        }
    }

    public void removeItem(NdJdbcRepositoryItem ndJdbcRepositoryItem) throws NdRepositoryException {
        this.open();
        String string = "DELETE FROM " + this.WjHBasW + " WHERE id=?";
        String string2 = "DELETE FROM " + this.WjHBasW + " WHERE dirid=? AND ITEMTYPE=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, (String)ndJdbcRepositoryItem.getKey());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = this.WjHBasV.prepareStatement(string2);
            preparedStatement.setString(1, (String)ndJdbcRepositoryItem.getKey());
            preparedStatement.setString(2, WjHKesQ);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotRemoveItem", ndJdbcRepositoryItem.getName()), ndJdbcRepositoryItem, sQLException);
        }
    }

    public NdRepositoryEntryAttribute[] getEntryAttributes(NdJdbcRepositoryEntry ndJdbcRepositoryEntry) throws NdRepositoryException {
        int n;
        String[] stringArray = new String[WjHKetR.size()];
        int n2 = 0;
        Enumeration enumeration = WjHKetR.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = this.getEntryAttributes(ndJdbcRepositoryEntry, stringArray);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjHKewU(ndJdbcRepositoryEntry);
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        if (ndRepositoryEntryAttributeArray2 != null && ndRepositoryEntryAttributeArray2.length > 0) {
            for (n = 0; n < ndRepositoryEntryAttributeArray2.length; ++n) {
                vector.addElement(ndRepositoryEntryAttributeArray2[n]);
            }
        }
        for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
            if (ndRepositoryEntryAttributeArray[n].getAttbValue() == null) continue;
            vector.addElement(ndRepositoryEntryAttributeArray[n]);
        }
        Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NdRepositoryEntryAttribute[] getEntryAttributes(NdJdbcRepositoryEntry ndJdbcRepositoryEntry, String[] stringArray) throws NdRepositoryException {
        this.open();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Object[] objectArray = new NdRepositoryEntryAttribute[]{};
        String[] stringArray2 = this.WjHKexV(stringArray);
        String[] stringArray3 = this.WjHKezX(stringArray);
        if (stringArray2 != null) {
            objectArray = this.WjHKeyW(ndJdbcRepositoryEntry, stringArray2);
        }
        if (stringArray3 == null) {
            return objectArray;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        for (int i = 0; i < stringArray3.length; ++i) {
            stringBuffer.append(NdDefaultJdbcRepositoryAccessor.getFieldName(stringArray3[i]));
            if (i == stringArray3.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.WjHBasW);
        stringBuffer.append(" WHERE id=?");
        String string = stringBuffer.toString();
        try {
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray;
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, (String)ndJdbcRepositoryEntry.getKey());
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<NdRepositoryEntryAttribute[]> vector = new Vector<NdRepositoryEntryAttribute[]>();
            if (resultSet.next()) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute(stringArray3[i], resultSet.getString(i + 1));
                    vector.addElement(ndRepositoryEntryAttributeArray);
                }
            }
            resultSet.close();
            preparedStatement.close();
            Object[] objectArray2 = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(objectArray2);
            if (vector.size() > 0) {
                if (objectArray.length > 0) {
                    ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[objectArray.length + objectArray2.length];
                    System.arraycopy(objectArray, 0, ndRepositoryEntryAttributeArray, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, ndRepositoryEntryAttributeArray, objectArray.length, objectArray2.length);
                    objectArray = ndRepositoryEntryAttributeArray;
                } else {
                    objectArray = objectArray2;
                }
            }
            return objectArray;
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetEntryAttributes", ndJdbcRepositoryEntry.getName()), ndJdbcRepositoryEntry, sQLException);
        }
    }

    public void setEntryAttributes(NdJdbcRepositoryEntry ndJdbcRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return;
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjHKeuS(ndRepositoryEntryAttributeArray);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = this.WjHKevT(ndRepositoryEntryAttributeArray);
        this.open();
        if (ndRepositoryEntryAttributeArray2 != null && ndRepositoryEntryAttributeArray2.length > 0) {
            this.WjHKeBZ(ndJdbcRepositoryEntry, ndRepositoryEntryAttributeArray2);
        }
        if (ndRepositoryEntryAttributeArray3 != null && ndRepositoryEntryAttributeArray3.length > 0) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(this.WjHBasW);
            stringBuffer.append(" SET ");
            for (int i = 0; i < ndRepositoryEntryAttributeArray3.length; ++i) {
                object = ndRepositoryEntryAttributeArray3[i];
                stringBuffer.append(NdDefaultJdbcRepositoryAccessor.getFieldName(((NdRepositoryEntryAttribute)object).getAttbId()));
                stringBuffer.append("=?");
                if (i == ndRepositoryEntryAttributeArray3.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" WHERE id=?");
            String string = stringBuffer.toString();
            try {
                object = this.WjHBasV.prepareStatement(string);
                for (int i = 0; i < ndRepositoryEntryAttributeArray3.length; ++i) {
                    NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray3[i];
                    object.setString(i + 1, ndRepositoryEntryAttribute.getAttbValue());
                }
                object.setString(ndRepositoryEntryAttributeArray3.length + 1, (String)ndJdbcRepositoryEntry.getKey());
                object.executeUpdate();
                object.close();
            }
            catch (SQLException sQLException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    sQLException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotSetEntryAttributes", ndJdbcRepositoryEntry.getName()), ndJdbcRepositoryEntry, sQLException);
            }
        }
    }

    public NdJdbcRepositoryEntry lookupEntry(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory, String string) throws NdRepositoryException {
        String string2 = "SELECT id, isItem FROM " + this.WjHBasW + " WHERE dirId=? and name=?";
        this.open();
        try {
            NdJdbcRepositoryEntry ndJdbcRepositoryEntry;
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string2);
            preparedStatement.setString(1, (String)ndJdbcRepositoryDirectory.getKey());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string3 = resultSet.getString(1);
                boolean bl = resultSet.getBoolean(2);
                resultSet.close();
                ndJdbcRepositoryEntry = bl ? new NdJdbcRepositoryItem(ndJdbcRepositoryDirectory, string, string3) : new NdJdbcRepositoryDirectory(ndJdbcRepositoryDirectory, string, string3);
            } else {
                resultSet.close();
                ndJdbcRepositoryEntry = null;
            }
            preparedStatement.close();
            return ndJdbcRepositoryEntry;
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBaeT("CouldNotFindEntry", string, ndJdbcRepositoryDirectory.getName()), sQLException);
        }
    }

    public byte[] getKeyItemContent(Object object) throws NdRepositoryException {
        this.open();
        String string = "SELECT contentLength, itemContent FROM " + this.WjHBasW + " WHERE id=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, (String)object);
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] byArray = null;
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                InputStream inputStream = null;
                try {
                    if (!NdDotNETLib.isDotNETSupportEnabled()) {
                        inputStream = resultSet.getBinaryStream(2);
                    } else {
                        byArray = resultSet.getBytes("itemContent");
                    }
                }
                catch (SQLException sQLException) {
                    throw new NdJdbcEntryRepositoryException(sQLException);
                }
                if (inputStream != null) {
                    int n2;
                    byte[] byArray2 = new byte[n];
                    while ((n2 = inputStream.read(byArray2)) != -1) {
                        if (byArray == null) {
                            byArray = new byte[n2];
                            System.arraycopy(byArray2, 0, byArray, 0, n2);
                            continue;
                        }
                        byte[] byArray3 = new byte[byArray.length + n2];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                        System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
                        byArray = byArray3;
                    }
                    inputStream.close();
                }
            }
            resultSet.close();
            preparedStatement.close();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            return byArray;
        }
        catch (Exception exception) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                exception.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(exception);
        }
    }

    public void setKeyItemContent(Object object, byte[] byArray) throws NdRepositoryException {
        this.open();
        String string = "UPDATE " + this.WjHBasW + " SET contentLength=?, itemContent=?, lastModified=? WHERE id=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            Timestamp timestamp = new Timestamp(new Date().getTime());
            if (byArray != null && byArray.length > 0) {
                preparedStatement.setInt(1, byArray.length);
                preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setInt(1, 0);
                if (!NdDotNETLib.isDotNETSupportEnabled()) {
                    preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
                }
                preparedStatement.setNull(2, -4);
            }
            preparedStatement.setTimestamp(3, timestamp);
            preparedStatement.setString(4, (String)object);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(sQLException);
        }
    }

    public Date getLastModified(NdJdbcRepositoryItem ndJdbcRepositoryItem) throws NdRepositoryException {
        this.open();
        String string = "SELECT lastModified FROM " + this.WjHBasW + " WHERE id=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            preparedStatement.setString(1, (String)ndJdbcRepositoryItem.getKey());
            ResultSet resultSet = preparedStatement.executeQuery();
            Timestamp timestamp = null;
            if (resultSet.next()) {
                timestamp = resultSet.getTimestamp(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (timestamp == null) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetLastModified", ndJdbcRepositoryItem.getName()), ndJdbcRepositoryItem);
            }
            return timestamp;
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetLastModified", ndJdbcRepositoryItem.getName()), ndJdbcRepositoryItem, sQLException);
        }
    }

    public void setLastModified(Date date, NdJdbcRepositoryItem ndJdbcRepositoryItem) throws NdRepositoryException {
        this.open();
        String string = "UPDATE " + this.WjHBasW + " SET lastModified=? WHERE id=?";
        try {
            PreparedStatement preparedStatement = this.WjHBasV.prepareStatement(string);
            Timestamp timestamp = new Timestamp(date.getTime());
            preparedStatement.setTimestamp(1, timestamp);
            preparedStatement.setString(2, (String)ndJdbcRepositoryItem.getKey());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                sQLException.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotSetLastModified", ndJdbcRepositoryItem.getName()), sQLException);
        }
    }

    public NdRepositoryConfig loadRepositoryConfig(NdJdbcRepositoryConnection ndJdbcRepositoryConnection) throws NdRepositoryException {
        byte[] byArray;
        this.openConnection(ndJdbcRepositoryConnection);
        Object object = this.getRepositoryKey();
        try {
            byArray = this.getKeyItemContent(object);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotGetItemContent", this.WjHBasX), (Throwable)((Object)ndRepositoryException));
        }
        String string = null;
        if (byArray.length > 0) {
            try {
                string = new String(byArray, "UTF8");
            }
            catch (IOException iOException) {
                throw new NdRepositoryException(iOException);
            }
        }
        if (string != null && string.length() > 0) {
            return NdRepositoryConfigLoader.getDefaultRepositoryConfigLoader(this.WjHIPlT.getClassLoadingContext()).load(new StringBuffer(string), (NdRepositoryConnection)ndJdbcRepositoryConnection);
        }
        return null;
    }

    protected NdJdbcRepository getJdbcRepository() {
        return this.WjHBasQ;
    }

    protected Connection getConnection() {
        return this.WjHBasV;
    }

    protected void setConnection(Connection connection) {
        this.WjHBasV = connection;
    }

    protected String getRepositoryTable() {
        return this.WjHBasW;
    }

    protected boolean isNativeConnection() {
        return this.WjItmcO;
    }

    private void WjJhIKG(String string) throws NdRepositoryException {
        this.WjJhIKH(this.WjHBasV, string);
        this.WjHBasW = string;
    }

    private void WjJhIKH(Connection connection, String string) throws NdRepositoryException {
        boolean bl = false;
        ResultSet resultSet = null;
        if (!string.equals(this.WjJqeUO)) {
            try {
                resultSet = connection.getMetaData().getTables(null, null, string.toUpperCase(), new String[]{"TABLE"});
                while (resultSet.next()) {
                    String string2 = resultSet.getString(3);
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("InvalidTableName", string));
                }
                this.WjJqeUO = string;
            }
            catch (Exception exception) {
                throw new NdJdbcEntryRepositoryException(exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        throw new NdJdbcEntryRepositoryException(sQLException);
                    }
                }
            }
        }
    }

    static {
        WjHKetR.put("innovatorName", "innovatorName");
        WjHKetR.put("innovatorShortDesc", "innovatorShortDesc");
        WjHKetR.put("innovatorItemType", "innovatorItemType");
        WjHKetR.put("innovatorTemplateRef", "innovatorTemplateRef");
        WjHKetR.put("innovatorItemDeletedFlag", "innovatorItemDeletedFlag");
        WjHKetR.put("innovatorItemCreationId", "innovatorItemCreationId");
    }
}

