/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jdbc;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.repository.base.NdCredentialsProvider;
import com.blazesoft.repository.base.NdDefaultRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdOptimizedRepositoryConnectionTester;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItemContentConverter;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.NdRepositoryItemContentConverterFactory;
import com.blazesoft.repository.jdbc.NdDefaultJdbcRepositoryAccessor;
import com.blazesoft.repository.jdbc.NdJdbcEntryRepositoryException;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryAccessor;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryDirectory;
import com.blazesoft.repository.jdbc.NdStrings;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.credentials.NdBaseConnection;
import com.blazesoft.util.credentials.NdBaseCredentialsProvider;
import com.blazesoft.util.credentials.NdBaseCredentialsProviderUtil;
import com.blazesoft.util.credentials.NdCredentialsException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;

public class NdJdbcRepository
extends NdJdbcRepositoryDirectory
implements NdRepository,
NdOptimizedRepositoryConnectionTester {
    public static final String JDBC_DRIVER = "JDBC.driver";
    public static final String JDBC_DATABASE_URL = "JDBC.database.url";
    public static final String JDBC_USERNAME = "JDBC.username";
    public static final String JDBC_PASSWORD = "JDBC.password";
    public static final String JDBC_REPOSITORY_TABLE = "JDBC.repository.table";
    public static final String JDBC_ACCESSOR_CLASS = "JDBC.accessor.class";
    private static final String WjHDJIN = "com.blazesoft.repository.jdbc.NdOracleJdbcRepositoryAccessor";
    private NdJdbcRepositoryAccessor WjHBahS = null;
    private int WjHBahT;
    private NdRepositoryEntryLocationManager WjHKARK;
    private NdRepositoryConfig WjIejBF = null;
    private NdJdbcRepositoryConnection WjHIPVG = null;
    private boolean WjHDJNS;
    private NdRepositoryItemContentConverter WjHIHVK;
    private String WjHOsIQ = "";
    private NdCredentialsProvider WjIZsAD;
    static /* synthetic */ Class class$com$blazesoft$repository$jdbc$NdJdbcRepository;

    public NdJdbcRepository(NdRepositoryConnection ndRepositoryConnection) throws NdRepositoryException {
        this(ndRepositoryConnection, null);
    }

    public NdJdbcRepository(NdRepositoryConnection ndRepositoryConnection, NdCredentialsProvider ndCredentialsProvider) throws NdRepositoryException {
        NdBaseObject.advAssertNonNull((Object)ndRepositoryConnection);
        this.WjHIPVG = (NdJdbcRepositoryConnection)ndRepositoryConnection;
        this.WjIejGF(this.WjHIPVG.getRepositoryName());
        this.WjHBahW();
        this.WjIZsAD = ndCredentialsProvider;
        this.WjHOsIQ = ndRepositoryConnection.getUser();
        this.WjHDJNS = false;
    }

    private static Constructor WjHBahV(Class clazz) {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || !NdBaseObject.isAssignableFrom(classArray[0], (Class)(class$com$blazesoft$repository$jdbc$NdJdbcRepository == null ? NdJdbcRepository.class$("com.blazesoft.repository.jdbc.NdJdbcRepository") : class$com$blazesoft$repository$jdbc$NdJdbcRepository))) continue;
            constructor = constructorArray[i];
            break;
        }
        return constructor;
    }

    private void WjHBahW() throws NdRepositoryException {
        Class<?> clazz;
        String string;
        block22: {
            string = this.WjHIPVG.getJdbcAccessor();
            clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string.indexOf(46) == -1) {
                    try {
                        clazz = Class.forName("com.blazesoft.repository.jdbc." + string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
                if (clazz != null) break block22;
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotFindClass", string), this, classNotFoundException);
            }
        }
        if (clazz != null) {
            Constructor constructor = NdJdbcRepository.WjHBahV(clazz);
            if (constructor == null) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotFindConstructor", string));
            }
            try {
                Object[] objectArray = new Object[]{this};
                this.WjHBahS = (NdJdbcRepositoryAccessor)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotInstantiateClass", string), this, exception);
            }
        }
        String string2 = this.WjHIPVG.getJdbcDriver();
        if (string2 == null) {
            if (this.WjHIPVG.getNativeConnection() != null) {
                try {
                    string2 = this.WjHIPVG.getNativeConnection().getMetaData().getDriverName();
                }
                catch (SQLException sQLException) {
                    throw new NdJdbcEntryRepositoryException(sQLException);
                }
            } else {
                throw new NdRepositoryException(NdStrings.WjHBabQ("DriverNotSpecified"));
            }
        }
        if (string2.startsWith("oracle") && !NdDotNETLib.isDotNETSupportEnabled()) {
            Constructor<?> constructor;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName(WjHDJIN);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotFindClass", WjHDJIN), this, classNotFoundException);
            }
            try {
                constructor = clazz2.getConstructor(class$com$blazesoft$repository$jdbc$NdJdbcRepository == null ? (class$com$blazesoft$repository$jdbc$NdJdbcRepository = NdJdbcRepository.class$("com.blazesoft.repository.jdbc.NdJdbcRepository")) : class$com$blazesoft$repository$jdbc$NdJdbcRepository);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotFindConstructor", WjHDJIN), noSuchMethodException);
            }
            catch (SecurityException securityException) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotFindConstructor", WjHDJIN), securityException);
            }
            try {
                this.WjHBahS = (NdJdbcRepositoryAccessor)constructor.newInstance(this);
            }
            catch (Exception exception) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotInstantiateClass", WjHDJIN), this, exception);
            }
        }
        this.WjHBahS = new NdDefaultJdbcRepositoryAccessor(this);
    }

    private void WjHIPVJ() throws NdRepositoryException {
        if (!this.WjHDJNS) {
            this.openConnection(0);
        }
        this.WjIejBF = this.WjHBahS.loadRepositoryConfig(this.WjHIPVG);
    }

    boolean WjHNnNG() {
        return this.WjHDJNS;
    }

    private void WjHIHVL() throws NdRepositoryException {
        NdRepositoryItemContentConverterFactory ndRepositoryItemContentConverterFactory = null;
        if (this.WjIejBF != null) {
            ndRepositoryItemContentConverterFactory = this.WjIejBF.getRepositoryItemContentConverterFactory();
        }
        this.WjHIHVK = ndRepositoryItemContentConverterFactory != null ? (NdRepositoryItemContentConverter)ndRepositoryItemContentConverterFactory.newRepositoryItemContentConverter() : null;
        if (this.WjHIHVK != null) {
            this.WjHIHVK.openConnection(this);
        }
    }

    NdJdbcRepository WjIairN() {
        return this;
    }

    String WjHOsIR() {
        return this.WjHOsIQ;
    }

    public NdJdbcRepositoryAccessor getJdbcRepositoryAccessor() throws NdRepositoryException {
        NdJdbcRepository ndJdbcRepository = this;
        synchronized (ndJdbcRepository) {
            if (this.WjHDJNS) {
                if (this.WjHBahS == null) {
                    this.WjHBahW();
                }
                return this.WjHBahS;
            }
            throw new NdRepositoryException(NdStrings.WjHBabQ("JDBCRepositoryConnectionIsNotOpened"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection(int n) throws NdRepositoryException {
        NdJdbcRepository ndJdbcRepository = this;
        synchronized (ndJdbcRepository) {
            this.WjHBahT = n;
            if ((this.WjHIPVG.getUser() == null || this.WjHIPVG.getUser().length() == 0) && this.WjIZsAD != null) {
                try {
                    NdBaseCredentialsProviderUtil.performCredentialsCompletion((NdBaseConnection)this.WjHIPVG, (NdBaseCredentialsProvider)this.WjIZsAD);
                }
                catch (NdCredentialsException ndCredentialsException) {
                    throw new NdRepositoryException(ndCredentialsException);
                }
            }
            if (this.WjHBahS == null) {
                this.WjHBahW();
            }
            String string = this.WjHIPVG.getJdbcTable();
            this.WjHOsIQ = this.WjHIPVG.getUser();
            this.WjHBahS.openConnection(this.WjHIPVG);
            if (string == null) {
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("ParameterNotSet", "JDBC_REPOSITORY_TABLE"), this);
            }
            this.setKey(this.WjHBahS.getRepositoryKey());
            if (this.WjHIHVK == null) {
                this.WjHIHVL();
            }
            this.WjHDJNS = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws NdRepositoryException {
        NdJdbcRepository ndJdbcRepository = this;
        synchronized (ndJdbcRepository) {
            if (this.WjHDJNS) {
                this.WjHBahS.closeConnection();
                this.WjHBahS = null;
                this.WjHDJNS = false;
            }
        }
    }

    public int getRepositoryMode() {
        return this.WjHBahT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdRepositoryEntryLocationManager getRepositoryEntryLocationManager() {
        NdJdbcRepository ndJdbcRepository = this;
        synchronized (ndJdbcRepository) {
            if (this.WjHKARK == null) {
                this.WjHKARK = new NdDefaultRepositoryEntryLocationManager();
            }
        }
        return this.WjHKARK;
    }

    public NdRepositoryItemContentConverter getRepositoryItemContentConverter() {
        return this.WjHIHVK;
    }

    public void setRepositoryItemContentConverter(NdRepositoryItemContentConverter ndRepositoryItemContentConverter) {
        this.WjHIHVK = ndRepositoryItemContentConverter;
    }

    public NdRepositoryConnection getRepositoryConnection() {
        return this.WjHIPVG;
    }

    public NdRepositoryConfig getRepositoryConfig() {
        if (this.WjIejBF == null) {
            try {
                this.WjHIPVJ();
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRepositoryRuntimeException((Throwable)((Object)ndRepositoryException));
            }
        }
        return this.WjIejBF;
    }

    public void setRepositoryConfig(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        try {
            String string = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
            byte[] byArray = string.getBytes("UTF8");
            if (this.WjHBahS == null) {
                this.getJdbcRepositoryAccessor();
            }
            if (this.WjHIPVG != null) {
                this.WjHBahS.openConnection(this.WjHIPVG);
            }
            this.WjHBahS.setKeyItemContent(this.WjHBahS.getRepositoryKey(), byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NdRepositoryException(unsupportedEncodingException);
        }
    }

    public void testConnection() throws NdRepositoryException {
        this.lookupRepositoryEntry("com_blazesoft_repository_config.cfg");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

