/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jdbc;

import com.blazesoft.repository.base.NdAbstractWorkspaceConnection;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.jdbc.NdStrings;
import java.sql.Connection;
import java.util.Hashtable;

public class NdJdbcRepositoryConnection
extends NdAbstractWorkspaceConnection
implements NdWorkspaceConnection {
    public static final String REPOSITORY_JDBC_CONNECTION_DRIVER_TAG = "com_blazesoft_repository_jdbc_driver";
    public static final String REPOSITORY_JDBC_CONNECTION_TABLE_TAG = "com_blazesoft_repository_jdbc_table";
    public static final String REPOSITORY_CONNECTION_JDBC_URL_TAG = "com_blazesoft_repository_jdbc_url";
    public static final String REPOSITORY_JDBC_CONNECTION_ACCESSOR_TAG = "com_blazesoft_repository_jdbc_accessor";
    public static final String REPOSITORY_JDBC_NATIVE_CONNECTION_TAG = "com_blazesoft_repository_jdbc_native_connection";
    private String WjHIBZB;
    private String WjHICaC;
    private String WjHICbD = "com.blazesoft.repository.jdbc.NdDefaultJdbcRepositoryAccessor";
    private String WjHIPDE;
    private String WjIyqTT;
    private Hashtable WjHIPFG;
    private Hashtable WjHJXvG;
    private Connection WjItmIR;
    private static NdRepositoryAdminFactory WjIllUL = new NdRepositoryAdminFactory("com.blazesoft.repository.jdbc.NdJdbcRepositoryAdmin");

    public NdJdbcRepositoryConnection() {
    }

    public NdJdbcRepositoryConnection(Hashtable hashtable) {
        this.WjHJXvG = hashtable;
        this.setUser((String)hashtable.get("com_blazesoft_repository_username"));
        this.setPassword((String)hashtable.get("com_blazesoft_repository_password"));
        this.setRepositoryName((String)hashtable.get("com_blazesoft_repository_repositoryname"));
        this.WjHIPDE = (String)hashtable.get(REPOSITORY_CONNECTION_JDBC_URL_TAG);
        this.WjHIBZB = (String)hashtable.get(REPOSITORY_JDBC_CONNECTION_DRIVER_TAG);
        this.WjHICaC = (String)hashtable.get(REPOSITORY_JDBC_CONNECTION_TABLE_TAG);
        this.WjHICbD = (String)hashtable.get(REPOSITORY_JDBC_CONNECTION_ACCESSOR_TAG);
        this.WjItmIR = (Connection)hashtable.get(REPOSITORY_JDBC_NATIVE_CONNECTION_TAG);
    }

    Hashtable WjIeiUQ() {
        if (this.WjHIPFG == null) {
            this.WjHIPFG = new Hashtable();
            if (this.WjHIBZB != null) {
                this.WjHIPFG.put("JDBC.driver", this.WjHIBZB);
            }
            if (this.WjHIPDE != null) {
                this.WjHIPFG.put("JDBC.database.url", this.WjHIPDE);
            }
            if (this.WjHICaC != null) {
                this.WjHIPFG.put("JDBC.repository.table", this.WjHICaC);
            }
            if (this.WjHICbD != null) {
                this.WjHIPFG.put("JDBC.accessor.class", this.WjHICbD);
            }
            if (this.getRepositoryName() != null) {
                this.WjHIPFG.put("com.blazesoft.repository.base.repositoryname", this.getRepositoryName());
            }
            if (this.getUser() != null) {
                this.WjHIPFG.put("JDBC.username", this.getUser());
            }
            if (this.getPassword() != null) {
                this.WjHIPFG.put("JDBC.password", this.getPassword());
            }
            this.WjHIPFG.put("com.blazesoft.repository.base.repositoryclass", this.getRepositoryClassName());
        }
        return this.WjHIPFG;
    }

    public String getSystemDescription() {
        if (this.WjIyqTT == null) {
            this.WjIyqTT = NdStrings.WjHBadS("JdbcRepository", this.getRepositoryName());
            if (this.WjHIPDE != null) {
                this.WjIyqTT = NdStrings.WjHBaeT("At", this.WjIyqTT, this.WjHIPDE);
            }
        }
        return this.WjIyqTT;
    }

    public void setSystemDescription(String string) {
        this.WjIyqTT = string;
    }

    public String getJdbcDriver() {
        return this.WjHIBZB;
    }

    public void setJdbcDriver(String string) {
        this.WjHIBZB = string;
    }

    public String getJdbcTable() {
        return this.WjHICaC;
    }

    public void setJdbcTable(String string) {
        this.WjHICaC = string;
    }

    public String getJdbcUrl() {
        return this.WjHIPDE;
    }

    public void setJdbcUrl(String string) {
        this.WjHIPDE = string;
    }

    public String getJdbcAccessor() {
        return this.WjHICbD;
    }

    public void setJdbcAccessor(String string) {
        this.WjHICbD = string;
    }

    public Hashtable getConnectionArgs() {
        if (this.WjHJXvG == null) {
            this.WjHJXvG = new Hashtable();
            if (this.getUser() != null) {
                this.WjHJXvG.put("com_blazesoft_repository_username", this.getUser());
            }
            if (this.getPassword() != null) {
                this.WjHJXvG.put("com_blazesoft_repository_password", this.getPassword());
            }
            if (this.getRepositoryName() != null) {
                this.WjHJXvG.put("com_blazesoft_repository_repositoryname", this.getRepositoryName());
            }
            if (this.WjHIBZB != null) {
                this.WjHJXvG.put(REPOSITORY_JDBC_CONNECTION_DRIVER_TAG, this.WjHIBZB);
            }
            if (this.WjHICaC != null) {
                this.WjHJXvG.put(REPOSITORY_JDBC_CONNECTION_TABLE_TAG, this.WjHICaC);
            }
            if (this.WjHIPDE != null) {
                this.WjHJXvG.put(REPOSITORY_CONNECTION_JDBC_URL_TAG, this.WjHIPDE);
            }
            if (this.WjHICbD != null) {
                this.WjHJXvG.put(REPOSITORY_JDBC_CONNECTION_ACCESSOR_TAG, this.WjHICbD);
            }
            this.WjHJXvG.put("com_blazesoft_repository_connectionclass", this.getClass().getName());
        }
        return this.WjHJXvG;
    }

    public NdRepositoryAdminFactory getRepositoryAdminFactory() {
        return WjIllUL;
    }

    public String getRepositoryClassName() {
        return "com.blazesoft.repository.jdbc.NdJdbcRepository";
    }

    public Connection getNativeConnection() {
        return this.WjItmIR;
    }

    public void setNativeConnection(Connection connection) {
        this.WjItmIR = connection;
    }

    public boolean isSameWorkspace(NdWorkspaceConnection ndWorkspaceConnection) {
        boolean bl = super.isSameWorkspace(ndWorkspaceConnection);
        if (!bl && ndWorkspaceConnection instanceof NdJdbcRepositoryConnection) {
            NdJdbcRepositoryConnection ndJdbcRepositoryConnection = (NdJdbcRepositoryConnection)ndWorkspaceConnection;
            bl = this.WjHIPDE.equals(ndJdbcRepositoryConnection.getJdbcUrl()) && this.WjHICaC.equals(ndJdbcRepositoryConnection.getJdbcTable()) && this.getRepositoryName().equals(ndJdbcRepositoryConnection.getRepositoryName());
        }
        return bl;
    }

    public boolean equals(NdRepositoryConnection ndRepositoryConnection) {
        if (!(ndRepositoryConnection instanceof NdJdbcRepositoryConnection)) {
            return false;
        }
        if (!super.equals(ndRepositoryConnection)) {
            return false;
        }
        NdJdbcRepositoryConnection ndJdbcRepositoryConnection = (NdJdbcRepositoryConnection)ndRepositoryConnection;
        if (this.WjHIBZB != null ? !this.WjHIBZB.equals(ndJdbcRepositoryConnection.getJdbcDriver()) : ndJdbcRepositoryConnection.getJdbcDriver() != null) {
            return false;
        }
        if (this.WjHICaC != null ? !this.WjHICaC.equals(ndJdbcRepositoryConnection.getJdbcTable()) : ndJdbcRepositoryConnection.getJdbcTable() != null) {
            return false;
        }
        if (this.WjHIPDE != null ? !this.WjHIPDE.equals(ndJdbcRepositoryConnection.getJdbcUrl()) : ndJdbcRepositoryConnection.getJdbcUrl() != null) {
            return false;
        }
        return this.getRepositoryName() == null || this.getRepositoryName().equals(ndJdbcRepositoryConnection.getRepositoryName());
    }
}

