/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.local;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAlreadyExistsException;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryFilter;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryImplicitLock;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.base.internal.NdDeletedItemsDirectory;
import com.blazesoft.repository.base.internal.NdInternalWorkspace;
import com.blazesoft.repository.base.internal.NdInternalWorkspaceDirectory;
import com.blazesoft.repository.base.internal.NdInternalWorkspaceEntry;
import com.blazesoft.repository.base.internal.NdInternalWorkspaceItem;
import com.blazesoft.repository.base.internal.WjISYwX;
import com.blazesoft.repository.local.NdAbstractWorkspaceDirectory;
import com.blazesoft.repository.local.NdAbstractWorkspaceEntry;
import com.blazesoft.repository.local.NdAbstractWorkspaceItem;
import com.blazesoft.repository.local.NdLocalRepositoryDirectory;
import com.blazesoft.repository.local.NdLocalRepositoryItem;
import com.blazesoft.repository.local.NdNonCachingWorkspaceItem;
import com.blazesoft.repository.local.NdStrings;
import java.util.Vector;

public class NdNonCachingWorkspaceDirectory
extends NdAbstractWorkspaceDirectory {
    NdNonCachingWorkspaceDirectory(NdRepositoryDirectory ndRepositoryDirectory) {
        super(ndRepositoryDirectory);
    }

    NdNonCachingWorkspaceDirectory(NdRepositoryDirectory ndRepositoryDirectory, boolean bl) {
        super(ndRepositoryDirectory, bl);
    }

    public String getName() throws NdRepositoryException {
        return this.getPhysicalRepositoryEntry().getName();
    }

    public void resetEntries() {
    }

    void WjIvyhU(boolean bl, boolean bl2) {
    }

    public void resetVersionInfoForUpdate(boolean bl) throws NdRepositoryException {
        NdInternalWorkspace ndInternalWorkspace = this.getWorkspace();
        ndInternalWorkspace.versionStatusChanged(this);
        NdWorkspaceEntry[] ndWorkspaceEntryArray = this.WjIufQD(false);
        for (int i = 0; i < ndWorkspaceEntryArray.length; ++i) {
            if (ndWorkspaceEntryArray[i] instanceof NdAbstractWorkspaceDirectory) {
                if (!bl) continue;
                ((NdAbstractWorkspaceDirectory)ndWorkspaceEntryArray[i]).resetVersionInfoForUpdate(true);
                continue;
            }
            if (!(ndWorkspaceEntryArray[i] instanceof NdAbstractWorkspaceItem)) continue;
            ndInternalWorkspace.versionStatusChanged((NdAbstractWorkspaceItem)ndWorkspaceEntryArray[i]);
        }
    }

    public void uncacheAllEntries() {
    }

    void WjIzZER(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray, boolean bl) throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "addRepositoryDirectoryWithLocking", this.getLocation()));
        }
        if (((NdWorkspaceDirectory)ndRepositoryDirectory).isVirtual()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnVirtualEntry", "addRepositoryDirectoryWithLocking", ((NdWorkspaceDirectory)ndRepositoryDirectory).getLocation()));
        }
        this.WjIqhvE((NdWorkspaceEntry)((Object)ndRepositoryDirectory), ndRepositoryEntryAttributeArray);
        ndRepositoryEntryAttributeArray = this.WjIzZES(ndRepositoryDirectory, ndRepositoryEntryAttributeArray);
        if (bl) {
            this.WjIvciS((NdWorkspaceEntry)((Object)ndRepositoryDirectory), ndRepositoryEntryAttributeArray, 2);
        }
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "addRepositoryItemWithLocking", this.getLocation()));
        }
        if (((NdWorkspaceItem)ndRepositoryItem).isVirtual()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnVirtualEntry", "addRepositoryItemWithLocking", ((NdWorkspaceItem)ndRepositoryItem).getLocation()));
        }
        this.WjIqhvE((NdWorkspaceEntry)((Object)ndRepositoryItem), ndRepositoryEntryAttributeArray);
        this.WjIQaVJ(ndRepositoryItem, ndRepositoryItemContent, ndRepositoryEntryAttributeArray);
        if (NdRepositorySupport.getWorkspace(this).isEventSendingEnabled()) {
            this.WjIvciS((NdWorkspaceEntry)((Object)ndRepositoryItem), ndRepositoryEntryAttributeArray, 2);
        }
    }

    public NdWorkspaceDirectory createWorkspaceDirectory(String string, boolean bl) throws NdRepositoryException {
        this.ensureNotDetached();
        if (bl && this.WjIuaJK(string)) {
            throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjIejYS("EntryAlreadyExists", string, this.getName()));
        }
        NdRepositoryDirectory ndRepositoryDirectory = (NdRepositoryDirectory)this.getPhysicalRepositoryEntry();
        return new NdNonCachingWorkspaceDirectory(ndRepositoryDirectory.createRepositoryDirectory(string), this.isMarkedForDeletion());
    }

    public NdWorkspaceItem createWorkspaceItem(String string, boolean bl) throws NdRepositoryException {
        this.ensureNotDetached();
        if (bl && this.WjIuaJK(string)) {
            throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjIejYS("EntryAlreadyExists", string, this.getName()));
        }
        if ("Globally Deleted Items".equals(string)) {
            throw new NdRepositoryException(NdStrings.WjIejXR("ReservedName", "Globally Deleted Items"));
        }
        NdRepositoryDirectory ndRepositoryDirectory = (NdRepositoryDirectory)this.getPhysicalRepositoryEntry();
        return new NdNonCachingWorkspaceItem(ndRepositoryDirectory.createRepositoryItem(string), this.isMarkedForDeletion());
    }

    NdAbstractWorkspaceItem WjIQaVK(NdRepositoryItem ndRepositoryItem) {
        return new NdNonCachingWorkspaceItem(ndRepositoryItem);
    }

    public NdWorkspaceEntry[] getAllWorkspaceEntries() throws NdRepositoryException {
        return this.WjIufQD(true);
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        return this.WjIufQD(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NdWorkspaceEntry[] WjIufQD(boolean bl) throws NdRepositoryException {
        Object object;
        this.ensureNotDetached();
        this.WjImwLW();
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            NdRepositoryEntry ndRepositoryEntry;
            NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
            NdRepositoryEntryFilter[] ndRepositoryEntryFilterArray = ndWorkspace.getEntryFilters();
            NdRepositoryDirectory ndRepositoryDirectory = (NdRepositoryDirectory)this.getPhysicalRepositoryEntry();
            NdRepositoryEntry[] ndRepositoryEntryArray = ndRepositoryDirectory.getRepositoryEntries();
            Vector<Object> vector = new Vector<Object>(ndRepositoryEntryArray.length);
            block2: for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
                NdRepositoryEntry ndRepositoryEntry2 = ndRepositoryEntryArray[i];
                for (int j = 0; j < ndRepositoryEntryFilterArray.length; ++j) {
                    if (!ndRepositoryEntryFilterArray[j].accepts(ndRepositoryEntry2)) continue block2;
                }
                object = ndRepositoryEntry2 instanceof NdRepositoryItem ? new NdNonCachingWorkspaceItem((NdRepositoryItem)ndRepositoryEntry2) : new NdNonCachingWorkspaceDirectory((NdRepositoryDirectory)ndRepositoryEntry2);
                ((NdAbstractWorkspaceEntry)object).WjIQeQA(this);
                vector.addElement(object);
            }
            if (!this.isMarkedForDeletion() && ndWorkspace.isVersioned() && (ndRepositoryEntry = ndRepositoryDirectory.lookupRepositoryEntry("com_blazesoft_deleted_folder")) instanceof NdRepositoryDirectory) {
                object = ((NdRepositoryDirectory)ndRepositoryEntry).getRepositoryEntries();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object2 = object[i];
                    NdAbstractWorkspaceEntry ndAbstractWorkspaceEntry = object2 instanceof NdRepositoryItem ? new NdLocalRepositoryItem((NdRepositoryItem)object2, true) : new NdLocalRepositoryDirectory((NdRepositoryDirectory)object2, true);
                    ndAbstractWorkspaceEntry.WjIQeQA(this);
                    vector.addElement(ndAbstractWorkspaceEntry);
                }
            }
            if (bl) {
                NdDeletedItemsDirectory ndDeletedItemsDirectory = new NdDeletedItemsDirectory("Globally Deleted Items", this);
                vector.addElement(ndDeletedItemsDirectory);
            }
            Object[] objectArray = new NdWorkspaceEntry[vector.size()];
            vector.copyInto(objectArray);
            object = objectArray;
            Object var14_19 = null;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            this.WjImvQN(ndRepositoryImplicitLock);
            throw throwable;
        }
        this.WjImvQN(ndRepositoryImplicitLock);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NdRepositoryEntryAttribute[] WjIrVVR(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray;
        this.WjIqhvG((NdWorkspaceEntry)ndRepositoryEntry);
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            ndRepositoryEntryAttributeArray = super.WjIzZEU((NdWorkspaceEntry)ndRepositoryEntry);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.WjImvQN(ndRepositoryImplicitLock);
            throw throwable;
        }
        this.WjImvQN(ndRepositoryImplicitLock);
        return ndRepositoryEntryAttributeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdRepositoryEntryAttribute[] setAttributes(NdInternalWorkspaceEntry ndInternalWorkspaceEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        ndRepositoryEntryAttributeArray = ((WjISYwX)this.createWorkspaceEntryHelper()).WjISYhL(ndInternalWorkspaceEntry, ndRepositoryEntryAttributeArray);
        ndInternalWorkspaceEntry.resetCachedProtectedStatus();
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            this.WjISVPK(ndInternalWorkspaceEntry, ndRepositoryEntryAttributeArray);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.WjImvQN(ndRepositoryImplicitLock);
            throw throwable;
        }
        this.WjImvQN(ndRepositoryImplicitLock);
        return ndRepositoryEntryAttributeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        NdRepositoryEntry ndRepositoryEntry;
        this.ensureNotDetached();
        this.WjImwPB(string);
        if ("Globally Deleted Items".equals(string)) {
            return new NdDeletedItemsDirectory("Globally Deleted Items", this);
        }
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            NdRepositoryDirectory ndRepositoryDirectory = (NdRepositoryDirectory)this.getPhysicalRepositoryEntry();
            NdRepositoryEntry ndRepositoryEntry2 = ndRepositoryDirectory.lookupRepositoryEntry(string);
            if (ndRepositoryEntry2 == null && (ndRepositoryEntry = ndRepositoryDirectory.lookupRepositoryEntry("com_blazesoft_deleted_folder")) instanceof NdRepositoryDirectory) {
                ndRepositoryEntry2 = ((NdRepositoryDirectory)ndRepositoryEntry).lookupRepositoryEntry(string);
            }
            if (ndRepositoryEntry2 instanceof NdRepositoryDirectory) {
                ndRepositoryEntry2 = new NdNonCachingWorkspaceDirectory((NdRepositoryDirectory)ndRepositoryEntry2);
                ((NdNonCachingWorkspaceDirectory)ndRepositoryEntry2).WjIQeQA(this);
            } else if (ndRepositoryEntry2 instanceof NdRepositoryItem) {
                ndRepositoryEntry2 = new NdNonCachingWorkspaceItem((NdRepositoryItem)ndRepositoryEntry2);
                ((NdNonCachingWorkspaceItem)ndRepositoryEntry2).WjIQeQA(this);
            }
            ndRepositoryEntry = ndRepositoryEntry2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.WjImvQN(ndRepositoryImplicitLock);
            throw throwable;
        }
        this.WjImvQN(ndRepositoryImplicitLock);
        return ndRepositoryEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectory(NdInternalWorkspaceDirectory ndInternalWorkspaceDirectory) throws NdRepositoryException {
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            this.WjISVQL(ndInternalWorkspaceDirectory);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WjImvQN(ndRepositoryImplicitLock);
            throw throwable;
        }
        this.WjImvQN(ndRepositoryImplicitLock);
        ((NdAbstractWorkspaceEntry)((Object)ndInternalWorkspaceDirectory)).WjIvbWG(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(NdInternalWorkspaceItem ndInternalWorkspaceItem) throws NdRepositoryException {
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            this.WjISVRM(ndInternalWorkspaceItem);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WjImvQN(ndRepositoryImplicitLock);
            throw throwable;
        }
        this.WjImvQN(ndRepositoryImplicitLock);
        ((NdAbstractWorkspaceEntry)((Object)ndInternalWorkspaceItem)).WjIvbWG(true);
    }

    public void ensureEntryIsCached(NdInternalWorkspaceEntry ndInternalWorkspaceEntry) {
    }

    public void resetCachedEntryAttributes(String string) {
    }

    public NdInternalWorkspaceEntry[] getCachedEntries() {
        return new NdInternalWorkspaceEntry[0];
    }

    boolean WjIuaJK(String string) throws NdRepositoryException {
        boolean bl = false;
        NdWorkspaceEntry[] ndWorkspaceEntryArray = this.WjIufQD(false);
        for (int i = 0; i < ndWorkspaceEntryArray.length; ++i) {
            NdWorkspaceEntry ndWorkspaceEntry = ndWorkspaceEntryArray[i];
            if (!string.equals(ndWorkspaceEntry.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

