/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.local;

import com.blazesoft.repository.base.NdRepositoryAuthorizationException;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryImplicitLock;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.local.NdAbstractWorkspaceItem;
import com.blazesoft.repository.local.NdStrings;
import java.util.Date;

public class NdNonCachingWorkspaceItem
extends NdAbstractWorkspaceItem {
    NdNonCachingWorkspaceItem(NdRepositoryItem ndRepositoryItem) {
        super(ndRepositoryItem);
    }

    NdNonCachingWorkspaceItem(NdRepositoryItem ndRepositoryItem, boolean bl) {
        super(ndRepositoryItem, bl);
    }

    public String getName() throws NdRepositoryException {
        return this.getPhysicalRepositoryEntry().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdRepositoryItemContent getContent() throws NdRepositoryException {
        this.ensureNotDetached();
        this.WjImvRO();
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)this.getPhysicalRepositoryEntry();
            NdRepositoryItemContent ndRepositoryItemContent = ndRepositoryItem.getContent();
            if (this.isProtected() && this.isEncryptionEnabled()) {
                ndRepositoryItemContent = this.createWorkspaceEntryHelper().WjISWqT(ndRepositoryItemContent);
            }
            NdRepositoryItemContent ndRepositoryItemContent2 = ndRepositoryItemContent;
            return ndRepositoryItemContent2;
        }
        finally {
            this.WjImvQN(ndRepositoryImplicitLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdRepositoryItemContent getRawContent() throws NdRepositoryException {
        this.ensureNotDetached();
        this.WjImvRO();
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            NdRepositoryItemContent ndRepositoryItemContent = ((NdRepositoryItem)this.getPhysicalRepositoryEntry()).getContent();
            return ndRepositoryItemContent;
        }
        finally {
            this.WjImvQN(ndRepositoryImplicitLock);
        }
    }

    public Date getLastModified() throws NdRepositoryException {
        this.ensureNotDetached();
        NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)this.getPhysicalRepositoryEntry();
        return ndRepositoryItem.getLastModified();
    }

    public boolean isReadable() throws NdRepositoryException {
        this.ensureNotDetached();
        try {
            this.WjImvRO();
        }
        catch (NdRepositoryAuthorizationException ndRepositoryAuthorizationException) {
            return false;
        }
        NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)this.getPhysicalRepositoryEntry();
        return ndRepositoryItem.isReadable();
    }

    public boolean isWritable() throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            return false;
        }
        try {
            this.WjImvSP(WjIvbTD);
        }
        catch (NdRepositoryAuthorizationException ndRepositoryAuthorizationException) {
            return false;
        }
        NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)this.getPhysicalRepositoryEntry();
        return ndRepositoryItem.isWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "setContent", this.getLocation()));
        }
        this.WjImvSP(ndRepositoryItemContent);
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)this.getPhysicalRepositoryEntry();
            if (this.isProtected() && this.isEncryptionEnabled()) {
                ndRepositoryItem.setContent(this.createWorkspaceEntryHelper().WjISWpS(ndRepositoryItemContent));
            } else {
                ndRepositoryItem.setContent(ndRepositoryItemContent);
            }
        }
        finally {
            this.WjImvQN(ndRepositoryImplicitLock);
            this.WjIvchR(this.getLocation(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            ((NdRepositoryItem)this.getPhysicalRepositoryEntry()).setContent(ndRepositoryItemContent);
        }
        finally {
            this.WjImvQN(ndRepositoryImplicitLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastModified(Date date) throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "setLastModified", this.getLocation()));
        }
        NdRepositoryImplicitLock ndRepositoryImplicitLock = this.WjImvPM(this);
        try {
            NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)this.getPhysicalRepositoryEntry();
            ndRepositoryItem.setLastModified(date);
        }
        finally {
            this.WjImvQN(ndRepositoryImplicitLock);
        }
    }
}

