/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.mongodb;

import com.blazesoft.repository.base.NdCredentialsProvider;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdUserCredentials;
import com.blazesoft.repository.base.NdUserPasswordCredentials;
import com.blazesoft.repository.mongodb.NdAbstractMongoRepositoryAccessor;
import com.blazesoft.repository.mongodb.NdMongoRepository;
import com.blazesoft.repository.mongodb.NdMongoRepositoryConnection;
import com.blazesoft.repository.mongodb.NdMongoRepositoryEntryException;
import com.blazesoft.repository.mongodb.NdStrings;
import com.blazesoft.security.NdAccessController;
import com.blazesoft.security.NdPrivilegedExceptionAction;
import com.blazesoft.util.NdWrappedException;
import com.blazesoft.util.credentials.NdAdminCredentialsProvider;
import com.blazesoft.util.credentials.NdBaseConnection;
import com.blazesoft.util.credentials.NdBaseCredentialsProvider;
import com.blazesoft.util.credentials.NdBaseCredentialsProviderUtil;
import com.blazesoft.util.credentials.NdCredentialsException;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class NdJavaMongoRepositoryAccessor
extends NdAbstractMongoRepositoryAccessor {
    private MongoClient WjJBAdK;
    private DB WjJBAdL;
    private DBCollection WjJBAdM;
    private NdRepositoryException WjJBAdN;
    private static final BasicDBObject WjJBAdO = new BasicDBObject();

    Object WjJBCwI() {
        return WjJBAdO;
    }

    final Object WjJBCxJ() throws NdRepositoryException {
        if (this.WjJBAdN != null) {
            throw this.WjJBAdN;
        }
        if (this.WjJBAdM == null) {
            throw new NdRepositoryException(NdStrings.WjJBxPP("UnableToObtainRepositoryRootCollection"));
        }
        return this.WjJBAdM;
    }

    Object WjJBCyK() {
        return new ObjectId();
    }

    Object WjJBCzL(int n) {
        return new BasicDBObject();
    }

    Object WjJBCAM(String string, Object object, int n) {
        return new BasicDBObject(string, object);
    }

    Object WjJBCBN(String string, int n, int n2) {
        return new BasicDBObject(string, (Object)n);
    }

    Object WjJBCCO(String string, byte[] byArray, int n) {
        return new BasicDBObject(string, (Object)new Binary(byArray));
    }

    Object WjJBCDP(Object object, String string) {
        return ((BSONObject)object).get(string);
    }

    int WjJBCFR(Object object, String string) {
        return ((BasicBSONObject)object).getInt(string);
    }

    String WjJBCGS(Object object, String string) {
        return ((BasicBSONObject)object).getString(string);
    }

    byte[] WjJBCHT(Object object, String string) {
        return (byte[])((BSONObject)object).get(string);
    }

    void WjJBCEQ(Object object, String string, Object object2) {
        ((BSONObject)object).put(string, object2);
    }

    Set WjJBCIU(Object object) {
        return ((BSONObject)object).keySet();
    }

    int WjJBCJV(Object object) {
        return ((BasicBSONObject)object).size();
    }

    void WjJBCKW(Object object, String string, Object object2) {
        ((BasicBSONObject)object).append(string, object2);
    }

    void WjJBCLX(Object object, String string, int n) {
        ((BasicBSONObject)object).append(string, (Object)n);
    }

    void WjJBCMY(Object object, String string, byte[] byArray) {
        ((BasicBSONObject)object).append(string, (Object)new Binary(byArray));
    }

    private void WjJBAdP(WriteResult writeResult) throws NdRepositoryException {
        this.WjJBAdQ(writeResult, null);
    }

    private void WjJBAdQ(WriteResult writeResult, String string) throws NdRepositoryException {
        CommandResult commandResult = writeResult.getLastError();
        MongoException mongoException = commandResult.getException();
        if (mongoException != null) {
            if (string == null) {
                throw new NdRepositoryException(mongoException);
            }
            throw new NdRepositoryException(string, mongoException);
        }
    }

    void WjJBCNZ(Object object, Object object2, Object object3, boolean bl, boolean bl2) throws NdRepositoryException {
        try {
            this.WjJBAdP(((DBCollection)object).update((DBObject)object2, (DBObject)object3, bl, bl2));
        }
        catch (MongoException mongoException) {
            throw new NdRepositoryException(mongoException);
        }
    }

    Object WjJBCOA(Object object, Object object2, Object object3) throws NdRepositoryException {
        DBObject dBObject;
        try {
            dBObject = ((DBCollection)object).findOne((DBObject)object2, (DBObject)object3);
        }
        catch (MongoException mongoException) {
            throw new NdRepositoryException(mongoException);
        }
        return dBObject;
    }

    Object WjJBCOB(Object object, Object object2, Object object3) throws NdRepositoryException {
        DBCursor dBCursor;
        try {
            dBCursor = ((DBCollection)object).find((DBObject)object2, (DBObject)object3);
        }
        catch (MongoException mongoException) {
            throw new NdRepositoryException(mongoException);
        }
        return dBCursor;
    }

    Iterator WjJBCOC(Object object) {
        return (DBCursor)object;
    }

    int WjJBCOD(Object object) {
        return ((DBCursor)object).size();
    }

    void WjJBCOE(Object object) {
        ((DBCursor)object).close();
    }

    void WjJBCOF(Object object, Object object2) throws NdRepositoryException {
        try {
            this.WjJBAdP(((DBCollection)object).remove((DBObject)object2));
        }
        catch (MongoException mongoException) {
            throw new NdRepositoryException(mongoException);
        }
    }

    public NdJavaMongoRepositoryAccessor(NdMongoRepository ndMongoRepository) {
        super(ndMongoRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WjJBAdR() throws NdRepositoryException {
        if (this.WjJBAdK != null) {
            return;
        }
        String string = this.WjJBCsE().getName();
        NdJavaMongoRepositoryAccessor ndJavaMongoRepositoryAccessor = this;
        synchronized (ndJavaMongoRepositoryAccessor) {
            if (this.WjJBAdK != null) {
                return;
            }
            final NdMongoRepositoryConnection ndMongoRepositoryConnection = (NdMongoRepositoryConnection)this.WjJBCsE().getRepositoryConnection();
            String string2 = NdJavaMongoRepositoryAccessor.WjJBCrD(ndMongoRepositoryConnection.getMongoDBUrl());
            try {
                int n = ndMongoRepositoryConnection.getMongoDBAuthenticationType();
                NdMongoRepositoryConnection.WjJBxWN(n);
                MongoClientOptions.Builder builder = ndMongoRepositoryConnection.isUseSSLEnabled() ? new MongoClientOptions.Builder().socketFactory(SSLSocketFactory.getDefault()) : new MongoClientOptions.Builder();
                MongoClientURI mongoClientURI = new MongoClientURI(string2, builder);
                this.WjJBAdK = new MongoClient(mongoClientURI);
                this.WjJBAdL = this.WjJBAdK.getDB(string);
                if (n == 1) {
                    boolean bl;
                    Object object;
                    String string3;
                    NdCredentialsProvider ndCredentialsProvider = this.WjJBCsE().WjJBErR();
                    if (ndCredentialsProvider != null) {
                        try {
                            NdBaseCredentialsProviderUtil.performCredentialsCompletion((NdBaseConnection)ndMongoRepositoryConnection, (NdBaseCredentialsProvider)ndCredentialsProvider);
                        }
                        catch (NdCredentialsException ndCredentialsException) {
                            throw new NdRepositoryException(ndCredentialsException);
                        }
                    }
                    if ((string3 = ndMongoRepositoryConnection.getUser()) == null || string3.length() < 1) {
                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPS("CouldNotConnectDBNullOrEmptyUser", string, string2), this.WjJBCsE());
                    }
                    String string4 = ndMongoRepositoryConnection.getPassword();
                    if (string4 == null) {
                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBNullPassword", string3, string, string2), this.WjJBCsE());
                    }
                    if (string4 != null && string4.length() > 0) {
                        try {
                            object = string4;
                            string4 = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction((String)object){
                                final /* synthetic */ String val$encryptedPassword;
                                {
                                    this.val$encryptedPassword = string;
                                }

                                public Object run() throws Exception {
                                    return NdRepositorySupport.decryptPassword(ndMongoRepositoryConnection, this.val$encryptedPassword);
                                }
                            });
                        }
                        catch (Exception exception) {
                            this.WjJBAdT();
                            throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPS("CouldNotConnectDB", string, string2), this.WjJBCsE(), exception);
                        }
                    }
                    object = string4 != null ? string4.toCharArray() : null;
                    try {
                        bl = this.WjJBAdL.authenticate(string3, object);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.WjJBAdT();
                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBErrorDuringAuthorization", string3, string, string2), this.WjJBCsE(), illegalStateException);
                    }
                    catch (MongoException mongoException) {
                        this.WjJBAdT();
                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBErrorDuringAuthorization", string3, string, string2), this.WjJBCsE(), mongoException);
                    }
                    if (!bl) {
                        Object object2;
                        boolean bl2 = false;
                        List list = mongoClientURI.getHosts();
                        if (list.size() == 1 && ("localhost".equalsIgnoreCase((String)list.get(0)) || "127.0.0.1".equals(list.get(0)))) {
                            boolean bl3;
                            DBObject dBObject;
                            try {
                                object2 = this.WjJBAdL.getCollection("system.users");
                                dBObject = object2.findOne((DBObject)new BasicDBObject("user", (Object)string3));
                                bl3 = true;
                            }
                            catch (MongoException mongoException) {
                                bl3 = false;
                                bl2 = true;
                                dBObject = null;
                            }
                            if (bl3 && dBObject == null) {
                                try {
                                    this.WjJBAdQ(this.WjJBAdL.addUser(string3, object), NdStrings.WjJBxPS("CouldNotConnectDB", string, string2));
                                }
                                catch (NdRepositoryException ndRepositoryException) {
                                    bl2 = true;
                                }
                                try {
                                    bl = this.WjJBAdL.authenticate(string3, object);
                                    if (!bl) {
                                        this.WjJBAdT();
                                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBNotAuthorized", string3, string, string2), this.WjJBCsE());
                                    }
                                }
                                catch (IllegalStateException illegalStateException) {
                                    this.WjJBAdT();
                                    throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBErrorDuringAuthorization", string3, string, string2), this.WjJBCsE(), illegalStateException);
                                }
                                catch (MongoException mongoException) {
                                    this.WjJBAdT();
                                    throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBErrorDuringAuthorization", string3, string, string2), this.WjJBCsE(), mongoException);
                                }
                            }
                        } else {
                            bl2 = true;
                        }
                        if (bl2) {
                            boolean bl4;
                            Object object3;
                            if (ndCredentialsProvider instanceof NdAdminCredentialsProvider) {
                                try {
                                    object2 = (NdUserPasswordCredentials)ndCredentialsProvider.getCredentials((NdBaseConnection)new NdAbstractMongoRepositoryAccessor.WjJCVIX(ndMongoRepositoryConnection));
                                    object3 = ((NdUserCredentials)object2).getUser();
                                    String string5 = ((NdUserPasswordCredentials)object2).getPassword();
                                    if (object3 != null && ((String)object3).length() > 0 && string5 != null) {
                                        char[] cArray = string5 != null ? string5.toCharArray() : null;
                                        DB dB = this.WjJBAdK.getDB("admin");
                                        bl4 = dB.authenticate((String)object3, cArray);
                                    }
                                    bl4 = false;
                                }
                                catch (MongoException mongoException) {
                                    this.WjJBAdT();
                                    throw new NdRepositoryException(NdStrings.WjJBxPS("CouldNotConnectDB", "admin", string2), mongoException);
                                }
                                catch (NdWrappedException ndWrappedException) {
                                    this.WjJBAdT();
                                    throw new NdRepositoryException(NdStrings.WjJBxPS("CouldNotConnectDB", "admin", string2), ndWrappedException);
                                }
                                catch (RuntimeException runtimeException) {
                                    this.WjJBAdT();
                                    throw new NdRepositoryException(NdStrings.WjJBxPS("CouldNotConnectDB", "admin", string2), runtimeException);
                                }
                            } else {
                                bl4 = false;
                            }
                            if (bl4) {
                                boolean bl5;
                                DBObject dBObject;
                                try {
                                    object3 = this.WjJBAdL.getCollection("system.users");
                                    dBObject = object3.findOne((DBObject)new BasicDBObject("user", (Object)string3));
                                    bl5 = true;
                                }
                                catch (MongoException mongoException) {
                                    bl5 = false;
                                    dBObject = null;
                                }
                                if (bl5 && dBObject == null) {
                                    try {
                                        this.WjJBAdQ(this.WjJBAdL.addUser(string3, object), NdStrings.WjJBxPS("CouldNotConnectDB", string, string2));
                                    }
                                    catch (NdRepositoryException ndRepositoryException) {
                                        this.WjJBAdT();
                                        throw ndRepositoryException;
                                    }
                                    try {
                                        bl = this.WjJBAdL.authenticate(string3, object);
                                        if (!bl) {
                                            this.WjJBAdT();
                                            throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBNotAuthorized", string3, string, string2), this.WjJBCsE());
                                        }
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        this.WjJBAdT();
                                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBErrorDuringAuthorization", string3, string, string2), this.WjJBCsE(), illegalStateException);
                                    }
                                    catch (MongoException mongoException) {
                                        this.WjJBAdT();
                                        throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBErrorDuringAuthorization", string3, string, string2), this.WjJBCsE(), mongoException);
                                    }
                                }
                            }
                        }
                        if (!bl) {
                            this.WjJBAdT();
                            throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBNotAuthorized", string3, string, string2), this.WjJBCsE());
                        }
                    }
                }
                this.WjJBAdM = this.WjJBAdL.getCollection("repositoryRoot");
                this.WjJBAdM.ensureIndex("parentId");
            }
            catch (NdMongoRepositoryEntryException ndMongoRepositoryEntryException) {
                throw ndMongoRepositoryEntryException;
            }
            catch (MongoException mongoException) {
                this.WjJBAdT();
                if (mongoException.getMessage().startsWith("unauthorized db:")) {
                    String string6 = ndMongoRepositoryConnection.getUser();
                    throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPT("CouldNotConnectDBNotAuthorized", string6, string, string2), this.WjJBCsE());
                }
                throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPS("CouldNotConnectDB", string, string2), this.WjJBCsE(), mongoException);
            }
            catch (Exception exception) {
                this.WjJBAdT();
                throw new NdMongoRepositoryEntryException(NdStrings.WjJBxPS("CouldNotConnectDB", string, string2), this.WjJBCsE(), exception);
            }
        }
    }

    private void WjJBAdS() throws NdRepositoryException {
        if (this.WjJBAdN != null) {
            throw this.WjJBAdN;
        }
        try {
            this.WjJBAdR();
        }
        catch (NdRepositoryException ndRepositoryException) {
            this.WjJBAdN = ndRepositoryException;
            throw ndRepositoryException;
        }
    }

    public void WjJBCtF() throws NdRepositoryException {
        this.WjJBAdS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WjJBAdT() {
        NdJavaMongoRepositoryAccessor ndJavaMongoRepositoryAccessor = this;
        synchronized (ndJavaMongoRepositoryAccessor) {
            if (this.WjJBAdK != null) {
                this.WjJBAdK.close();
                this.WjJBAdK = null;
                this.WjJBAdL = null;
                this.WjJBAdM = null;
                this.WjJBCsE().WjJBDlU(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void WjJBCuG() throws NdRepositoryException {
        NdJavaMongoRepositoryAccessor ndJavaMongoRepositoryAccessor = this;
        synchronized (ndJavaMongoRepositoryAccessor) {
            this.WjJBAdT();
        }
    }

    public void WjJBCvH() throws NdRepositoryException {
        this.WjJBAdS();
        try {
            this.WjJBAdL.dropDatabase();
        }
        catch (MongoException mongoException) {
            throw new NdRepositoryException(NdStrings.WjJBxPP("CouldNotDeleteDatabase"), mongoException);
        }
        this.WjJBAdT();
    }

    void WjJJsRO() throws NdRepositoryException {
        if (this.WjJBAdM == null) {
            throw new IllegalStateException(NdStrings.WjJBxPP("NoConnection"));
        }
        try {
            this.WjJBAdM.findOne();
        }
        catch (MongoException mongoException) {
            throw new NdRepositoryException(mongoException);
        }
    }

    static {
        WjJBAdO.put("name", (Object)1);
        WjJBAdO.put("parentId", (Object)1);
        WjJBAdO.put("entryType", (Object)1);
    }
}

