/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.mongodb;

import com.blazesoft.repository.base.NdAbstractWorkspaceConnection;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdSharedRepositoryWorkspaceConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdCredentialsFactory;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.mongodb.NdStrings;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.credentials.NdBaseCredentialsFactory;
import java.util.Hashtable;

public class NdMongoRepositoryConnection
extends NdAbstractWorkspaceConnection
implements NdWorkspaceConnection,
NdSharedRepositoryWorkspaceConnection {
    public static final String REPOSITORY_CONNECTION_MONGODB_URL_TAG = "com_blazesoft_repository_mongodb_url";
    public static final String REPOSITORY_CONNECTION_MONGODB_AUTHENTICATION_TYPE_TAG = "com_blazesoft_repository_mongodb_authentication_type";
    public static final String REPOSITORY_CONNECTION_MONGODB_USE_SSL_TAG = "com_blazesoft_repository_mongodb_use_ssl";
    public static final int MONGODB_AUTHENTICATION_TYPE_NONE = 0;
    public static final int MONGODB_AUTHENTICATION_TYPE_MONGODB = 1;
    public static final int MAX_REPOSITORY_NAME_LENGTH_CHARS = 62;
    private static final NdRepositoryAdminFactory WjJBxWG = new NdRepositoryAdminFactory("com.blazesoft.repository.mongodb.NdMongoRepositoryAdmin");
    private Hashtable WjJBRSE;
    private String WjJBxWH;
    private String WjJBxWI;
    private int WjJBxWJ;
    private boolean WjJBxWK;
    private boolean WjJBxWL;
    private boolean WjJBFzO;
    private String WjJBxWM;

    static void WjJBxWN(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(NdStrings.WjJBxPR("UnsupportedMongoDBAuthenticationType", Integer.toString(n)));
            }
        }
    }

    public NdMongoRepositoryConnection() {
    }

    public NdMongoRepositoryConnection(Hashtable hashtable) {
        String string = null;
        if (hashtable != null) {
            this.WjJBRSE = hashtable;
            Object v = hashtable.get("com_blazesoft_repository_isForWorkspace");
            this.WjJBxWL = v != null ? (v instanceof Boolean ? ((Boolean)v).booleanValue() : Boolean.valueOf(String.valueOf(v)).booleanValue()) : false;
            if (this.WjJBxWL) {
                string = (String)hashtable.get("com_blazesoft_repository_workspacename");
                if (string == null || string.trim().length() < 1) {
                    this.WjJBFzO = true;
                    string = (String)hashtable.get("com_blazesoft_repository_repositoryname");
                    this.setUser((String)hashtable.get("com_blazesoft_repository_username"));
                    this.setPassword((String)hashtable.get("com_blazesoft_repository_password"));
                } else {
                    this.setUser((String)hashtable.get("com_blazesoft_repository_workspaceuser"));
                    this.setPassword((String)hashtable.get("com_blazesoft_repository_workspacepassword"));
                }
            } else {
                string = (String)hashtable.get("com_blazesoft_repository_repositoryname");
                this.setUser((String)hashtable.get("com_blazesoft_repository_username"));
                this.setPassword((String)hashtable.get("com_blazesoft_repository_password"));
            }
            this.WjJBxWH = (String)hashtable.get("com_blazesoft_repository_credentials_class");
            if ("com.blazesoft.repository.base.NO_CREDENTIALS".equals(this.WjJBxWH)) {
                this.WjJBxWH = null;
            }
            this.WjJBxWI = (String)hashtable.get(REPOSITORY_CONNECTION_MONGODB_URL_TAG);
            String string2 = (String)hashtable.get(REPOSITORY_CONNECTION_MONGODB_AUTHENTICATION_TYPE_TAG);
            if (string2 != null && string2.length() > 0) {
                int n = Integer.valueOf(string2);
                NdMongoRepositoryConnection.WjJBxWN(n);
                this.WjJBxWJ = n;
            } else {
                this.WjJBxWJ = 0;
            }
            String string3 = (String)hashtable.get(REPOSITORY_CONNECTION_MONGODB_USE_SSL_TAG);
            this.WjJBxWK = string3 != null && string3.length() > 0 ? Boolean.valueOf(string3) : false;
        }
        this.setRepositoryName(string);
    }

    public static void validateDatabaseName(String string) throws IllegalArgumentException {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(NdStrings.WjJBxPP("InvalidRepositoryNameNullOrZeroLength"));
        }
        if (string.length() > 62) {
            throw new IllegalArgumentException(NdStrings.WjJBxPS("InvalidRepositoryNameTooLong", string, Integer.toString(62)));
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '/' && c != '\\' && c != '.' && c != ' ' && c != '\"' && c != '*' && c != '<' && c != '>' && c != ':' && c != '|' && c != '?') continue;
            throw new IllegalArgumentException(NdStrings.WjJBxPR("InvalidRepositoryNameContainsIllegalChar", string));
        }
    }

    public void setRepositoryName(String string) {
        super.setRepositoryName(string);
        NdMongoRepositoryConnection.validateDatabaseName(string);
    }

    public String getSystemDescription() {
        if (this.WjJBxWM == null) {
            this.WjJBxWM = NdStrings.WjJBxPR("MongoDBRepository", this.getRepositoryName());
        }
        return this.WjJBxWM;
    }

    public void setSystemDescription(String string) {
        this.WjJBxWM = string;
    }

    public NdBaseCredentialsFactory getCredentialsFactory() {
        if (this.WjJBxWH == null && this.getCredentials() != null) {
            this.WjJBxWH = this.getCredentials().getClass().getName();
        }
        if (this.WjJBxWH != null && this.WjJBxWH.length() > 0 && !"com.blazesoft.repository.base.NO_CREDENTIALS".equals(this.WjJBxWH)) {
            NdCredentialsFactory ndCredentialsFactory = new NdCredentialsFactory(this.WjJBxWH);
            return ndCredentialsFactory;
        }
        return null;
    }

    public String getCredentialsClassName() {
        return this.WjJBxWH;
    }

    public void setCredentialsClassName(String string) {
        this.WjJBxWH = string;
    }

    public boolean isWorkspaceConnection() {
        return this.WjJBxWL;
    }

    public void setWorkspaceConnection(boolean bl) {
        this.WjJBxWL = bl;
    }

    public boolean isSharedWorkspace() {
        return this.WjJBxWL && this.WjJBFzO;
    }

    public void setSharedWorkspace(boolean bl) {
        this.WjJBFzO = bl;
    }

    public String getMongoDBUrl() {
        return this.WjJBxWI;
    }

    public void setMongoDBUrl(String string) {
        this.WjJBxWI = string;
    }

    public int getMongoDBAuthenticationType() {
        return this.WjJBxWJ;
    }

    public void setMongoDBAuthenticationType(int n) {
        this.WjJBxWJ = n;
    }

    public boolean isUseSSLEnabled() {
        return this.WjJBxWK;
    }

    public void setUseSSLEnabled(boolean bl) {
        this.WjJBxWK = bl;
    }

    public Hashtable getConnectionArgs() {
        Hashtable<String, Object> hashtable = this.WjJBRSE;
        if (hashtable == null) {
            this.WjJBRSE = hashtable = new Hashtable<String, Object>();
        }
        if (this.getUser() != null) {
            if (this.WjJBxWL) {
                if (this.WjJBFzO) {
                    hashtable.put("com_blazesoft_repository_username", this.getUser());
                } else {
                    hashtable.put("com_blazesoft_repository_workspaceuser", this.getUser());
                }
            } else {
                hashtable.put("com_blazesoft_repository_username", this.getUser());
            }
        }
        if (this.getPassword() != null) {
            if (this.WjJBxWL) {
                if (this.WjJBFzO) {
                    hashtable.put("com_blazesoft_repository_password", this.getPassword());
                } else {
                    hashtable.put("com_blazesoft_repository_workspacepassword", this.getPassword());
                }
            } else {
                hashtable.put("com_blazesoft_repository_password", this.getPassword());
            }
        }
        hashtable.put("com_blazesoft_repository_connectionclass", this.getClass().getName());
        if (this.WjJBxWH != null) {
            hashtable.put("com_blazesoft_repository_credentials_class", this.WjJBxWH);
        } else {
            hashtable.put("com_blazesoft_repository_credentials_class", "com.blazesoft.repository.base.NO_CREDENTIALS");
        }
        if (this.WjJBxWI != null) {
            hashtable.put(REPOSITORY_CONNECTION_MONGODB_URL_TAG, this.WjJBxWI);
        }
        hashtable.put(REPOSITORY_CONNECTION_MONGODB_AUTHENTICATION_TYPE_TAG, Integer.toString(this.WjJBxWJ));
        hashtable.put(REPOSITORY_CONNECTION_MONGODB_USE_SSL_TAG, new Boolean(this.WjJBxWK).toString());
        String string = this.getRepositoryName();
        if (string != null) {
            if (this.WjJBxWL) {
                hashtable.put("com_blazesoft_repository_isForWorkspace", Boolean.TRUE);
                if (this.WjJBFzO) {
                    hashtable.put("com_blazesoft_repository_repositoryname", string);
                } else {
                    hashtable.put("com_blazesoft_repository_workspacename", string);
                }
            } else {
                hashtable.put("com_blazesoft_repository_repositoryname", string);
            }
        }
        return hashtable;
    }

    public boolean copySharedConnectionInfoTo(NdSharedRepositoryWorkspaceConnection ndSharedRepositoryWorkspaceConnection) {
        boolean bl = false;
        if (ndSharedRepositoryWorkspaceConnection instanceof NdMongoRepositoryConnection) {
            NdMongoRepositoryConnection ndMongoRepositoryConnection = (NdMongoRepositoryConnection)ndSharedRepositoryWorkspaceConnection;
            ndMongoRepositoryConnection.setMongoDBUrl(this.WjJBxWI);
            ndMongoRepositoryConnection.setMongoDBAuthenticationType(this.WjJBxWJ);
            ndMongoRepositoryConnection.setUseSSLEnabled(this.WjJBxWK);
            bl = true;
        }
        return bl;
    }

    private static String WjJBxWP(String string) {
        int n;
        String string2 = string.trim().toLowerCase();
        if (string2.startsWith("mongodb://")) {
            string2 = string2.substring(10);
        }
        if ((n = string2.indexOf(63)) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public boolean isSameWorkspace(NdWorkspaceConnection ndWorkspaceConnection) {
        boolean bl = super.isSameWorkspace(ndWorkspaceConnection);
        if (!bl && (bl = NdBaseObject.areIdentical((Object)this.getRepositoryName(), (Object)ndWorkspaceConnection.getRepositoryName()))) {
            NdMongoRepositoryConnection ndMongoRepositoryConnection = (NdMongoRepositoryConnection)ndWorkspaceConnection;
            bl = this.WjJBxWL == ndMongoRepositoryConnection.WjJBxWL && this.WjJBFzO == ndMongoRepositoryConnection.WjJBFzO && NdBaseObject.areIdentical((Object)NdMongoRepositoryConnection.WjJBxWP(this.WjJBxWI), (Object)NdMongoRepositoryConnection.WjJBxWP(ndMongoRepositoryConnection.WjJBxWI));
        }
        return bl;
    }

    private boolean WjJBxWQ(NdRepositoryConnection ndRepositoryConnection) {
        boolean bl = ndRepositoryConnection instanceof NdMongoRepositoryConnection;
        if (bl) {
            NdMongoRepositoryConnection ndMongoRepositoryConnection = (NdMongoRepositoryConnection)ndRepositoryConnection;
            bl = this.WjJBxWL == ndMongoRepositoryConnection.WjJBxWL && this.WjJBFzO == ndMongoRepositoryConnection.WjJBFzO && NdBaseObject.areIdentical((Object)this.WjJBxWI, (Object)ndMongoRepositoryConnection.WjJBxWI) && this.WjJBxWJ == ndMongoRepositoryConnection.WjJBxWJ && this.WjJBxWK == ndMongoRepositoryConnection.WjJBxWK && NdBaseObject.areIdentical((Object)this.WjJBxWH, (Object)ndMongoRepositoryConnection.WjJBxWH);
        }
        return bl;
    }

    public boolean equals(NdRepositoryConnection ndRepositoryConnection) {
        boolean bl = ndRepositoryConnection instanceof NdMongoRepositoryConnection;
        if (bl && (bl = super.equals(ndRepositoryConnection)) && bl) {
            bl = this.WjJBxWQ(ndRepositoryConnection);
        }
        return bl;
    }

    public NdRepositoryAdminFactory getRepositoryAdminFactory() {
        return WjJBxWG;
    }

    public String getRepositoryClassName() {
        return "com.blazesoft.repository.mongodb.NdMongoRepository";
    }
}

