/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.scm.NdDefScmCommandClient;
import com.blazesoft.repository.scm.NdFileScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.NdScmCommand;
import com.blazesoft.repository.scm.NdScmCommandClient;
import com.blazesoft.repository.scm.NdScmCommandClientFactory;
import com.blazesoft.repository.scm.NdScmCommandExecutor;
import com.blazesoft.repository.scm.NdScmExecutionUnit;
import com.blazesoft.repository.scm.NdScmLocalCommand;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdStrings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class NdCmdScmWorkspaceVersionManager
extends NdFileScmWorkspaceVersionManager {
    private NdScmCommandExecutor WjIBssX;
    private NdScmCommandClient WjIBstY;

    public NdCmdScmWorkspaceVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        super(ndRepository);
    }

    public boolean hasVersionedFolderSupport() {
        if (this.WjIBstY != null) {
            return this.WjIBstY.hasVersionedFolderSupport();
        }
        return super.hasVersionedFolderSupport();
    }

    public boolean hasBaselineFolderSupport() {
        if (this.WjIBstY != null) {
            return this.WjIBstY.hasBaselineFolderSupport();
        }
        return super.hasBaselineFolderSupport();
    }

    public boolean hasAutoCheckoutParent() {
        if (this.WjIBstY != null) {
            return this.WjIBstY.hasAutoCheckoutParent();
        }
        return super.hasAutoCheckoutParent();
    }

    public void openConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIBstY = new NdScmCommandClientFactory(ndScmServerConnection.getScmProvider()).newScmCommandClient();
        this.WjIBstY.initialize(this.getWorkspacePathFile(), ndScmServerConnection);
        if (this.WjIBstY instanceof NdDefScmCommandClient) {
            ((NdDefScmCommandClient)this.WjIBstY).setWorkspaceVersionManager(this);
        }
        try {
            this.WjIBssX = new NdScmCommandExecutor(this.WjIBstY.getCommandTool(), this.getWorkspacePath());
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    public void closeConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIBstY.dispose();
    }

    public void cancelCheckOut(File[] fileArray) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getCancelCheckOutCommand(fileArray));
    }

    public void checkIn(File[] fileArray, String string) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getCheckInCommand(fileArray, string));
    }

    public List doVersionControl(File[] fileArray, String string) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getVersionControlCommand(fileArray, string));
        return null;
    }

    public boolean isVersioned(File file) throws NdRepositoryException {
        Object object = this.executeCommand(this.WjIBstY.getIsVersionedCommand(file));
        this.trace("isControlled: " + file + " " + object);
        return (Boolean)object;
    }

    public boolean isCheckedOut(File file) throws NdRepositoryException {
        Object object = this.executeCommand(this.WjIBstY.getIsCheckedOutCommand(file));
        this.trace("isCheckedOut: " + file + " " + object);
        return (Boolean)object;
    }

    public void checkOut(File[] fileArray) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getCheckOutCommand(fileArray));
    }

    public void delete(File[] fileArray) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getDeleteCommand(fileArray));
    }

    public void cancelDelete(File[] fileArray) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getCancelDeleteCommand(fileArray));
    }

    public void getEntryLockInfos(File[] fileArray, Map map) throws NdRepositoryException {
        if (fileArray.length != 0) {
            this.executeCommand(this.WjIBstY.getEntryLockInfosCommand(fileArray, map));
        }
    }

    public void getHistories(File[] fileArray, Map map) throws NdRepositoryException {
        if (fileArray.length != 0) {
            this.executeCommand(this.WjIBstY.getHistoriesCommand(fileArray, map));
        }
    }

    public void getStatusInfos(File[] fileArray, Map map) throws NdRepositoryException {
        if (fileArray.length != 0) {
            this.executeCommand(this.WjIBstY.getStatusInfosCommand(fileArray, map));
        }
    }

    public void update(File[] fileArray) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getUpdateCommand(fileArray));
    }

    public void updateLocation(File file, boolean bl) throws NdRepositoryException {
        this.executeCommand(this.WjIBstY.getUpdateLocationCommand(file, bl));
    }

    public String getContentByVersion(File file, String string) throws NdRepositoryException, IOException {
        Object object = this.executeCommand(this.WjIBstY.getContentByVersionCommand(file, string));
        return (String)object;
    }

    protected Object executeCommand(NdScmCommand ndScmCommand) throws NdRepositoryException {
        int n = 0;
        try {
            Object object;
            if (ndScmCommand instanceof NdScmExecutionUnit) {
                object = ((NdScmExecutionUnit)ndScmCommand).getScmCommands();
                for (int i = 0; i < ((NdScmCommand[])object).length; ++i) {
                    this.executeCommand(object[i]);
                }
            } else {
                n = ndScmCommand instanceof NdScmLocalCommand ? ((NdScmLocalCommand)ndScmCommand).execute() : this.WjIBssX.execute(ndScmCommand);
            }
            if (ndScmCommand.hasFailed()) {
                object = ndScmCommand.getException();
                String string = null;
                if (object != null) {
                    if (object instanceof NdRepositoryException) {
                        throw (NdRepositoryException)((Object)object);
                    }
                    string = ((Throwable)object).getMessage();
                }
                throw new NdRepositoryException(NdStrings.WjIAZxO("ScmCommandFailed", ndScmCommand.toString(), new Integer(n), string), (Throwable)object);
            }
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        return ndScmCommand.getResults();
    }
}

