/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.config.NdRepositoryVersionManagerFactory;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmVersionSystemAdmin;
import com.blazesoft.repository.scm.NdScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.NdStrings;
import com.blazesoft.repository.scm.WjIAZHL;
import com.blazesoft.util.WjHzAhT;
import java.io.File;
import java.io.IOException;

public class NdFileScmVersionSystemAdmin
extends NdScmVersionSystemAdmin {
    protected String createTemporaryWorkspaceLocation(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        try {
            File file = File.createTempFile(new WjHzAhT().toString(), null);
            File file2 = new File(file.getParentFile(), new WjHzAhT().toString());
            file.delete();
            if (!file2.mkdir()) {
                throw new NdRepositoryException(NdStrings.WjIAZvM("UnableToCreateTemporaryDirectory", file2.getCanonicalPath()));
            }
            File file3 = new File(file2, ndScmServerConnection.getRepositoryName());
            return file3.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    protected void cleanUpTemporaryWorkspace(String string) throws NdRepositoryException {
        File file;
        this.trace("Cleanup: " + string);
        File file2 = new File(string);
        if (file2.exists()) {
            this.trace("Cleanup: delete " + file2.getPath());
            this.WjIBcuR(file2);
            file2.delete();
        }
        if ((file = file2.getParentFile()).exists()) {
            this.trace("Cleanup: delete temDir" + file.getPath());
            file.delete();
        }
    }

    protected NdWorkspaceConnection createWorkspaceConnection(String string, String string2, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        File file = new File(string);
        if (string2 != null && string2.length() != 0) {
            file = new File(string, string2);
        }
        return this.createFileWorkspaceConnection(file, ndVersioningRepositoryConnection);
    }

    protected NdWorkspaceConnection createWorkspaceConnection(NdWorkspaceConnection ndWorkspaceConnection, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        String string2 = ((NdFileRepositoryConnection)ndWorkspaceConnection).getRepositoryFolder();
        return this.createWorkspaceConnection(string2, string, ndVersioningRepositoryConnection);
    }

    protected NdWorkspaceConnection createFileWorkspaceConnection(File file, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        try {
            NdFileRepositoryConnection ndFileRepositoryConnection = new NdFileRepositoryConnection();
            ndFileRepositoryConnection.setRepositoryFolder(file.getCanonicalPath());
            ndFileRepositoryConnection.setUser(ndVersioningRepositoryConnection.getUser());
            ndFileRepositoryConnection.setPassword(ndVersioningRepositoryConnection.getPassword());
            return ndFileRepositoryConnection;
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    protected NdScmWorkspaceVersionManager createWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        Object object;
        File file;
        NdScmServerConnection ndScmServerConnection;
        block15: {
            ndScmServerConnection = null;
            try {
                ndScmServerConnection = (NdScmServerConnection)ndVersioningRepositoryConnection;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (ndScmServerConnection == null) {
                throw new NdRepositoryException(NdStrings.WjIAZtK("InvalidRepositoryConnection"));
            }
            String string = ndScmServerConnection.getRepositoryHomeFolder();
            String string2 = ndScmServerConnection.getRepositoryName();
            if (string2 == null || string2.length() == 0) {
                throw new NdRepositoryException(NdStrings.WjIAZtK("NoRepositoryNameSpecified"));
            }
            file = null;
            if (ndScmServerConnection.getWorkspaceFolder() != null && ndScmServerConnection.getWorkspaceFolder().length() > 0) {
                try {
                    file = new File(((NdFileRepositoryConnection)ndWorkspaceConnection).getRepositoryFolder()).getCanonicalFile();
                    if (!file.exists()) {
                        throw new NdRepositoryException(NdStrings.WjIAZvM("NoWorkspaceDirectory", file.getCanonicalPath()));
                    }
                    break block15;
                }
                catch (IOException iOException) {
                    throw new NdRepositoryException(iOException);
                }
            }
            object = ((NdFileRepositoryConnection)ndWorkspaceConnection).getRepositoryFolder();
            file = new File((String)object);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new NdRepositoryException(NdStrings.WjIAZvM("FailedToCreateWorkspaceBecauseFileAlreadyExists", file.getAbsolutePath()));
                }
                String[] stringArray = file.list();
                if (stringArray != null && stringArray.length > 0) {
                    throw new NdRepositoryException(NdStrings.WjIAZvM("FailedToCreateWorkspaceBecauseIsNotEmpty", file.getAbsolutePath()));
                }
            }
            int n = ((String)object).lastIndexOf(File.separator);
            String string3 = ((String)object).substring(n + 1);
            file = new File(((String)object).substring(0, n));
            this.createFileWorkspace(file, string, ndScmServerConnection, string3);
            if (!string3.equals(ndScmServerConnection.getRepositoryName())) {
                file = new File(file, string3);
            }
        }
        if (!file.exists()) {
            throw new NdRepositoryException(NdStrings.WjIAZwN("NoRepositoryHomeFolder", ndScmServerConnection.getRepositoryHomeFolder(), ndScmServerConnection.getWorkspaceFolder()));
        }
        object = null;
        if (this.getWorkspaceVersionManagerClassName() != null) {
            ndScmServerConnection.setVersionManagerClass(this.getWorkspaceVersionManagerClassName());
        }
        if (ndScmServerConnection.getVersionManagerClass() != null) {
            object = this.createFileVersionManager(ndWorkspaceConnection, file, this.createVersionManagerConfig(ndScmServerConnection), ndScmServerConnection);
        }
        return object;
    }

    public File createFileWorkspace(File file, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection, String string2) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "createFileWorkspace");
    }

    protected NdWorkspace createFileWorkspaceProxy(NdWorkspaceConnection ndWorkspaceConnection, File file, NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdFileRepositoryConnection ndFileRepositoryConnection = (NdFileRepositoryConnection)this.createFileWorkspaceConnection(file, ndVersioningRepositoryConnection);
        return new WjIAZHL(ndFileRepositoryConnection, ndRepositoryVersionManagerConfig);
    }

    protected NdScmWorkspaceVersionManager createFileVersionManager(NdWorkspaceConnection ndWorkspaceConnection, File file, NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdWorkspace ndWorkspace = this.createFileWorkspaceProxy(ndWorkspaceConnection, file, ndRepositoryVersionManagerConfig, ndVersioningRepositoryConnection);
        NdRepositoryVersionManagerFactory ndRepositoryVersionManagerFactory = ndRepositoryVersionManagerConfig.getRepositoryVersionManagerFactory();
        if (ndRepositoryVersionManagerFactory == null) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("NoVersionManagerFactoryFound"));
        }
        this.trace("Init: " + ndRepositoryVersionManagerFactory.getJavaName());
        NdWorkspaceVersionManager ndWorkspaceVersionManager = (NdWorkspaceVersionManager)ndRepositoryVersionManagerFactory.newWorkspaceVersionManager(ndWorkspace);
        if (!(ndWorkspaceVersionManager instanceof NdScmWorkspaceVersionManager)) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("NotScmVersionManager"));
        }
        return (NdScmWorkspaceVersionManager)ndWorkspaceVersionManager;
    }

    protected NdFileRepositoryConnection getFileConnection(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        NdFileRepositoryConnection ndFileRepositoryConnection;
        try {
            ndFileRepositoryConnection = (NdFileRepositoryConnection)ndWorkspaceConnection;
        }
        catch (ClassCastException classCastException) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("InvalidWorkspaceConnection"));
        }
        return ndFileRepositoryConnection;
    }

    public File writeConfigurationFile(NdRepositoryConfig ndRepositoryConfig, File file) throws NdRepositoryException {
        NdRepositoryConfigWriter ndRepositoryConfigWriter = new NdRepositoryConfigWriter();
        File file2 = new File(file, "com_blazesoft_repository_config.cfg");
        try {
            ndRepositoryConfigWriter.save(file2.getCanonicalPath(), ndRepositoryConfig);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        return file2;
    }

    private void WjIBcuR(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.WjIBcuR(fileArray[i]);
            }
            fileArray[i].delete();
        }
    }

    protected String getWorkspaceVersionManagerClassName() {
        return null;
    }
}

