/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.repository.base.NdFileBasedRepository;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionException;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.scm.NdScmSupport;
import com.blazesoft.repository.scm.NdScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.NdStrings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class NdFileScmWorkspaceVersionManager
extends NdScmWorkspaceVersionManager {
    protected NdFileScmWorkspaceVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        this.initializeRepository(ndRepository);
    }

    protected String initializeRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        NdRepository ndRepository2 = ndRepository;
        if (ndRepository instanceof NdWorkspace) {
            ndRepository2 = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
        }
        return ndRepository2 instanceof NdFileBasedRepository ? ((NdFileBasedRepository)ndRepository2).getRepositoryRoot().getPath() : super.initializeRepositoryPath(ndRepository);
    }

    protected void cancelCheckOutInternal(List list) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.cancelCheckOut(fileArray);
    }

    public abstract void cancelCheckOut(File[] var1) throws NdRepositoryException;

    protected void checkInInternal(List list, String string) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.checkIn(fileArray, string);
    }

    protected boolean isVersionedInternal(Object object) throws NdRepositoryException {
        return ((File)object).exists() ? this.isVersioned((File)object) : false;
    }

    protected boolean isCheckedOutInternal(Object object) throws NdRepositoryException {
        return this.isCheckedOut((File)object);
    }

    protected List doVersionControlInternal(List list, String string) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        ArrayList<File> arrayList = this.doVersionControl(fileArray, string);
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
            boolean bl = this.hasVersionedFolderSupport();
            boolean bl2 = this.hasBaselineFolderSupport();
            HashSet<File> hashSet = new HashSet<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                if (bl || bl2) {
                    if (bl2) {
                        File file = fileArray[i].getParentFile();
                        if (hashSet.contains(file)) continue;
                        arrayList.add(file);
                        hashSet.add(file);
                        continue;
                    }
                    arrayList.add(fileArray[i]);
                    continue;
                }
                if (fileArray[i].isDirectory()) continue;
                arrayList.add(fileArray[i]);
            }
        }
        return arrayList;
    }

    public abstract void checkIn(File[] var1, String var2) throws NdRepositoryException;

    public abstract List doVersionControl(File[] var1, String var2) throws NdRepositoryException;

    public abstract boolean isVersioned(File var1) throws NdRepositoryException;

    public abstract boolean isCheckedOut(File var1) throws NdRepositoryException;

    protected void checkOutInternal(List list) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.checkOut(fileArray);
        Vector<File> vector = new Vector<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                NdScmSupport.makeFileWritable(fileArray[i]);
                continue;
            }
            catch (IOException iOException) {
                vector.addElement(fileArray[i]);
            }
        }
        if (vector.size() != 0) {
            Object[] objectArray = new File[vector.size()];
            vector.copyInto(objectArray);
            NdLocation[] ndLocationArray = new NdLocation[objectArray.length];
            NdRepositoryException[] ndRepositoryExceptionArray = new NdRepositoryException[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                ndLocationArray[i] = this.convertFileToLocation((File)objectArray[i]);
                ndRepositoryExceptionArray[i] = new NdRepositoryException(NdStrings.WjIAZvM("UnableToSetFileWritable", ndLocationArray[i]));
            }
            throw new NdRepositoryVersionException((Exception[])ndRepositoryExceptionArray, ndLocationArray);
        }
    }

    public abstract void checkOut(File[] var1) throws NdRepositoryException;

    protected void deleteInternal(List list) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[list.size()]);
        this.delete(fileArray);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].exists()) continue;
            fileArray[i].delete();
        }
    }

    public abstract void delete(File[] var1) throws NdRepositoryException;

    protected void cancelDeleteInternal(List list) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[list.size()]);
        this.cancelDelete(fileArray);
    }

    public abstract void cancelDelete(File[] var1) throws NdRepositoryException;

    protected void getEntryLockInfosInternal(List list, Map map) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.getEntryLockInfos(fileArray, map);
    }

    public abstract void getEntryLockInfos(File[] var1, Map var2) throws NdRepositoryException;

    protected void getHistoriesInternal(List list, Map map) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.getHistories(fileArray, map);
    }

    public abstract void getHistories(File[] var1, Map var2) throws NdRepositoryException;

    protected void getStatusInfosInternal(List list, Map map) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.getStatusInfos(fileArray, map);
    }

    public abstract void getStatusInfos(File[] var1, Map var2) throws NdRepositoryException;

    protected void updateLocationInternal(Object object, boolean bl) throws NdRepositoryException {
        this.updateLocation((File)object, bl);
    }

    protected void updateInternal(List list) throws NdRepositoryException {
        File[] fileArray = list.toArray(new File[0]);
        this.update(fileArray);
    }

    public abstract void update(File[] var1) throws NdRepositoryException;

    public abstract void updateLocation(File var1, boolean var2) throws NdRepositoryException;

    protected String getContentByVersionInternal(Object object, String string) throws NdRepositoryException {
        try {
            return this.getContentByVersion((File)object, string);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    public String getContentByVersion(File file, String string) throws NdRepositoryException, IOException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "getFileContentByVersion");
    }

    public Object convertEntryToPhysicalResource(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        return this.convertLocationToFile(NdRepositorySupport.getLocation(ndRepositoryEntry));
    }

    public Object convertAttributesToPhysicalResource(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        File file = this.convertLocationToFile(NdRepositorySupport.getLocation(ndRepositoryEntry));
        return new File(file.getParentFile(), ndRepositoryEntry.getName() + ".innovator_attbs");
    }

    public Object convertLocationToPhysicalResource(NdLocation ndLocation) throws NdRepositoryException {
        return this.convertLocationToFile(ndLocation);
    }

    public File[] filterDirectories(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) continue;
            arrayList.add(fileArray[i]);
        }
        return arrayList.toArray(new File[0]);
    }

    public String[] getRepositoryPaths(File[] fileArray) {
        String string = this.getRepositoryPath();
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getPath();
            arrayList.add(string2.substring(n).replace(File.separatorChar, '/'));
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getWorkspacePaths(File[] fileArray) {
        String string = this.getWorkspacePath();
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getPath();
            arrayList.add(string2.substring(n).replace(File.separatorChar, '/'));
        }
        return arrayList.toArray(new String[0]);
    }
}

