/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.dotnet.NdFile;
import com.blazesoft.repository.base.NdFileBasedRepository;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdStrings;
import com.blazesoft.util.NdProperties;
import com.blazesoft.util.WjHzAhT;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class NdScmSupport {
    public static String getWorkspacePath(NdRepository ndRepository) throws NdRepositoryException {
        try {
            String string;
            if (ndRepository instanceof NdWorkspace) {
                ndRepository = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
            }
            if ((string = ((NdFileBasedRepository)ndRepository).getRepositoryRoot().getCanonicalPath()).endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    public static String getPhysicalWorkspacePath(NdRepository ndRepository) throws NdRepositoryException {
        int n;
        String string = NdScmSupport.getWorkspacePath(ndRepository);
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepository.getRepositoryConfig().getRepositoryVersionManagerConfig();
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        String string2 = null;
        String string3 = null;
        if (ndVersioningRepositoryConnection instanceof NdScmServerConnection) {
            string2 = ((NdScmServerConnection)ndVersioningRepositoryConnection).getRepositoryHomeFolder();
            string3 = ((NdScmServerConnection)ndVersioningRepositoryConnection).getRepositoryName();
        }
        if (string2 != null) {
            int n2 = string.lastIndexOf(string2 = string2.replace('/', File.separatorChar));
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
        } else if (string3 != null && (n = string.lastIndexOf(string3)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        String string = NdScmSupport.getWorkspacePath(ndRepository);
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepository.getRepositoryConfig().getRepositoryVersionManagerConfig();
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        String string2 = ndVersioningRepositoryConnection.getRepositoryName();
        String string3 = null;
        if (ndVersioningRepositoryConnection instanceof NdScmServerConnection) {
            string3 = ((NdScmServerConnection)ndVersioningRepositoryConnection).getRepositoryHomeFolder();
        }
        if (string3 == null) {
            string3 = string;
        } else {
            int n = string.lastIndexOf(string3 = string3.replace('/', File.separatorChar));
            if (n != -1) {
                string = string.substring(0, n);
                string3 = string + string3;
            } else {
                string3 = string + string3;
            }
        }
        if (!string3.endsWith(string2) && !new File(string3, "com_blazesoft_repository_config.cfg").exists()) {
            string3 = string3 + File.separator + string2;
        }
        return string3;
    }

    public static File convertLocationToFile(String string, NdLocation ndLocation) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(((Object)ndLocation).toString());
        return new File(stringBuffer.toString());
    }

    public static File[] convertLocationsToFiles(String string, NdLocation[] ndLocationArray) {
        File[] fileArray = new File[ndLocationArray.length];
        for (int i = 0; i < ndLocationArray.length; ++i) {
            fileArray[i] = NdScmSupport.convertLocationToFile(string, ndLocationArray[i]);
        }
        return fileArray;
    }

    public static NdLocation convertFileToLocation(String string, File file) {
        File file2 = new File(string);
        Vector<String> vector = new Vector<String>();
        while (!file2.equals(file)) {
            vector.insertElementAt(file.getName(), 0);
            file = file.getParentFile();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length != 0 && ((String)objectArray[objectArray.length - 1]).endsWith(".innovator_attbs")) {
            Object object = objectArray[objectArray.length - 1];
            int n = ".innovator_attbs".length();
            objectArray[objectArray.length - 1] = object = ((String)object).substring(0, ((String)object).length() - n);
        }
        return NdLocationFactory.createLocation((String[])objectArray, true);
    }

    public static void makeFileWritable(File file) throws IOException {
        if (file.exists() && !file.canWrite()) {
            int n;
            File file2 = file.getParentFile();
            File file3 = File.createTempFile("blaze_scm", null, file2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[16384];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            NdFile ndFile = NdDotNETLib.getFileSupport().getFile(file.getAbsolutePath());
            if (!ndFile.delete()) {
                throw new IOException(NdStrings.WjIAZvM("UnableToDeleteFile", file.getCanonicalPath()));
            }
            file3.renameTo(file);
        }
    }

    public static NdRepositoryEntryAttribute[] _resetGuidAttribute(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        Object[] objectArray;
        int n;
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
            objectArray = ndRepositoryEntryAttributeArray[n];
            if (objectArray.getAttbId().equals("guid")) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute("guid", new WjHzAhT().toString());
                vector.addElement(ndRepositoryEntryAttribute);
                continue;
            }
            vector.addElement(objectArray);
        }
        n = vector.size();
        objectArray = new NdRepositoryEntryAttribute[n];
        if (n > 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static void createNewDirectoryAttributeFile(NdRepository ndRepository, String string, String string2) throws NdRepositoryException {
        String string3 = string.substring(string.lastIndexOf(File.separator) + 1);
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute("com.blazesoft.repository.local.locallycreated", "true");
        NdRepositoryEntryAttribute ndRepositoryEntryAttribute2 = new NdRepositoryEntryAttribute("guid", new WjHzAhT().toString());
        NdRepositoryEntryAttribute ndRepositoryEntryAttribute3 = new NdRepositoryEntryAttribute("innovatorDisplayName", string3);
        NdRepositoryEntryAttribute ndRepositoryEntryAttribute4 = new NdRepositoryEntryAttribute("innovatorItemCreationId", string2);
        vector.addElement(ndRepositoryEntryAttribute);
        vector.addElement(ndRepositoryEntryAttribute2);
        vector.addElement(ndRepositoryEntryAttribute3);
        vector.addElement(ndRepositoryEntryAttribute4);
        Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        NdScmSupport.saveEntryAttributes(string, (NdRepositoryEntryAttribute[])objectArray);
    }

    public static NdRepositoryEntry lookupEntry(NdRepository ndRepository, NdLocation ndLocation) {
        NdRepositoryEntry ndRepositoryEntry = null;
        try {
            ndRepositoryEntry = NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndRepository, ndLocation);
        }
        catch (NdRepositoryException ndRepositoryException) {
            // empty catch block
        }
        return ndRepositoryEntry;
    }

    public static void saveEntryAttributes(String string, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1);
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return;
        }
        OutputStream outputStream = null;
        try {
            String string3;
            int n;
            File file;
            NdProperties ndProperties = new NdProperties();
            String string4 = string + ".innovator_attbs";
            try {
                file = new File(string4);
            }
            catch (Error error) {
                throw new NdRepositoryException(NdStrings.WjIAZwN("InvalidFileName", string, string4) + "\n" + NdStrings.WjIAZwN("CouldNotSaveEntryAttbsInAttbsFile", string4, string), error);
            }
            for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
                if (ndRepositoryEntryAttributeArray[n] == null || (string3 = ndRepositoryEntryAttributeArray[n].getAttbValue()) != null) continue;
                ndProperties.remove((Object)ndRepositoryEntryAttributeArray[n].getAttbId());
            }
            for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
                if (ndRepositoryEntryAttributeArray[n] == null) continue;
                string3 = ndRepositoryEntryAttributeArray[n].getAttbId();
                String string5 = ndRepositoryEntryAttributeArray[n].getAttbValue();
                if (string5 == null || string3.equals("innovatorLastModified")) continue;
                ndProperties.put((Object)ndRepositoryEntryAttributeArray[n].getAttbId(), (Object)string5);
            }
            outputStream = new FileOutputStream(file);
            ndProperties.save(outputStream, NdStrings.WjIAZvM("AttbsFileHeader", string2));
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(NdStrings.WjIAZwN("CouldNotSaveEntryAttbsInAttbsFile", string2, string), iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new NdRepositoryException(NdStrings.WjIAZwN("CouldNotSaveEntryAttbsInAttbsFile", string2, string), iOException);
                }
            }
        }
    }
}

