/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionSystemAdmin;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.config.NdRepositoryVersionManagerFactory;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.NdStrings;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.logging.NdConsoleLogHandler;
import com.blazesoft.util.logging.NdLogLevel;
import com.blazesoft.util.logging.NdLogger;
import com.blazesoft.util.logging.NdNamedLogManager;
import java.util.ArrayList;
import java.util.List;

public abstract class NdScmVersionSystemAdmin
implements NdRepositoryVersionSystemAdmin {
    private static NdLogger WjIAXGI = NdNamedLogManager.getInstance().getLogger("SCMVersionSystemAdmin");
    private static boolean WjIAXGJ = false;
    private static final String WjIBBbY = "Update Configuration";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createVersioningRepository(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        Object object;
        NdScmServerConnection ndScmServerConnection = null;
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepositoryConfig.getRepositoryVersionManagerConfig();
        if (ndRepositoryVersionManagerConfig == null) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("CouldNotFindVersionManagerConfiguration"));
        }
        try {
            ndScmServerConnection = (NdScmServerConnection)ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (ndScmServerConnection == null) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("CouldNotFindVersioningConnectionFromConfig"));
        }
        String string = ndScmServerConnection.getRepositoryHomeFolder();
        String string2 = ndScmServerConnection.getRepositoryName();
        if (ndScmServerConnection.getVersionManagerClass() == null) {
            object = ndRepositoryVersionManagerConfig.getRepositoryVersionManagerFactory();
            ndScmServerConnection.setVersionManagerClass(object.getJavaName());
        }
        object = null;
        String string3 = null;
        String string4 = ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().getUser();
        String string5 = ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().getPassword();
        try {
            Object object2;
            Object object3;
            NdWorkspaceConnection ndWorkspaceConnection;
            if (ndScmServerConnection.getWorkspaceFolder() != null && ndScmServerConnection.getWorkspaceFolder().length() > 0) {
                string3 = ndScmServerConnection.getWorkspaceFolder();
                if (string != null && string.length() != 0) {
                    // empty if block
                }
            } else {
                string3 = this.createTemporaryWorkspaceLocation(ndScmServerConnection);
            }
            if ((object = this.createWorkspace(ndWorkspaceConnection = this.createWorkspaceConnection(string3, string, (NdVersioningRepositoryConnection)ndScmServerConnection), ndScmServerConnection)) == null) {
                throw new NdRepositoryException(NdStrings.WjIAZtK("FailedToCreateRepositoryVersionManager"));
            }
            ((NdScmWorkspaceVersionManager)object).openConnection();
            if (string != null && string.length() != 0) {
                object3 = NdLocationFactory.createLocation(string);
                this.updateRepositoryHomeFolder((NdScmWorkspaceVersionManager)object, ((NdScmWorkspaceVersionManager)object).getRepository(), (NdLocation)object3);
            }
            object3 = ((NdScmWorkspaceVersionManager)object).getRepository();
            object3.openConnection(1);
            Object object4 = object3;
            NdRepositoryEntry ndRepositoryEntry = object4.lookupRepositoryEntry(string2);
            if (ndRepositoryEntry != null) {
                if (!(ndRepositoryEntry instanceof NdRepositoryDirectory)) throw new NdRepositoryException(NdStrings.WjIAZvM("FailedToCreateRepositoryBecauseExist", string2));
                object2 = ((NdRepositoryDirectory)ndRepositoryEntry).getRepositoryEntries();
                if (object2 != null && ((NdRepositoryEntry[])object2).length > 0) {
                    throw new NdRepositoryException(NdStrings.WjIAZvM("FailedToCreateRepositoryBecauseExist", string2));
                }
            } else {
                ndRepositoryEntry = object4.createRepositoryDirectory(string2);
                object4.addRepositoryDirectory((NdRepositoryDirectory)ndRepositoryEntry, new NdRepositoryEntryAttribute[0]);
            }
            object2 = (NdRepositoryDirectory)ndRepositoryEntry;
            Object object5 = ((NdScmWorkspaceVersionManager)object).convertEntryToPhysicalResource((NdRepositoryEntry)object2);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object5);
            if (((NdScmWorkspaceVersionManager)object).hasBaselineFolderSupport() && !((NdScmWorkspaceVersionManager)object).hasAutoCheckoutParent()) {
                ((NdScmWorkspaceVersionManager)object).ensureBaselineFolderIsCheckedOut((NdWorkspaceDirectory)object4);
            }
            List list = ((NdScmWorkspaceVersionManager)object).doVersionControlInternal(arrayList, NdStrings.WjIAZvM("CreateRepositoryMessage", string2));
            if (((NdScmWorkspaceVersionManager)object).hasBaselineFolderSupport() || ((NdScmWorkspaceVersionManager)object).hasAutoCheckoutParent()) {
                arrayList.clear();
                arrayList.addAll(list);
            }
            this.trace("Checkin: " + arrayList);
            ((NdScmWorkspaceVersionManager)object).checkInInternal(arrayList, NdStrings.WjIAZvM("CreateRepositoryMessage", string2));
            ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setUser(null);
            ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setPassword(null);
            ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setPersistCredentials(false);
            String string6 = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
            NdRepositoryItem ndRepositoryItem = object2.createRepositoryItem("com_blazesoft_repository_config.cfg");
            object2.addRepositoryItem(ndRepositoryItem, new NdRepositoryItemContent(string6), new NdRepositoryEntryAttribute[0]);
            if (((NdScmWorkspaceVersionManager)object).hasBaselineFolderSupport() && !((NdScmWorkspaceVersionManager)object).hasAutoCheckoutParent()) {
                ((NdScmWorkspaceVersionManager)object).ensureBaselineFolderIsCheckedOut((NdWorkspaceDirectory)object2, false);
            }
            Object object6 = ((NdScmWorkspaceVersionManager)object).convertEntryToPhysicalResource(ndRepositoryItem);
            Object object7 = ((NdScmWorkspaceVersionManager)object).convertAttributesToPhysicalResource(ndRepositoryItem);
            arrayList.clear();
            arrayList.add(object6);
            arrayList.add(object7);
            ((NdScmWorkspaceVersionManager)object).doVersionControlInternal(arrayList, NdStrings.WjIAZvM("CreateRepositoryMessage", string2));
            if (((NdScmWorkspaceVersionManager)object).hasBaselineFolderSupport() || ((NdScmWorkspaceVersionManager)object).hasAutoCheckoutParent()) {
                arrayList.clear();
                arrayList.add(object5);
            }
            ((NdScmWorkspaceVersionManager)object).checkInInternal(arrayList, NdStrings.WjIAZvM("CreateRepositoryMessage", string2));
            return;
        }
        finally {
            if (object != null) {
                ((NdScmWorkspaceVersionManager)object).closeConnection();
            }
            if (ndScmServerConnection.getWorkspaceFolder() == null) {
                this.cleanUpTemporaryWorkspace(string3);
            }
            ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setUser(string4);
            ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setPassword(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRepositoryWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        Object object;
        if (!(ndVersioningRepositoryConnection instanceof NdScmServerConnection)) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("InvalidRepositoryConnection"));
        }
        NdScmServerConnection ndScmServerConnection = (NdScmServerConnection)ndVersioningRepositoryConnection;
        String string = ndScmServerConnection.getRepositoryHomeFolder();
        NdWorkspaceConnection ndWorkspaceConnection2 = null;
        if (ndScmServerConnection.getWorkspaceFolder() != null && ndScmServerConnection.getWorkspaceFolder().length() > 0) {
            object = ndScmServerConnection.getWorkspaceFolder();
            ndWorkspaceConnection2 = this.createWorkspaceConnection((String)object, string, (NdVersioningRepositoryConnection)ndScmServerConnection);
        } else {
            ndWorkspaceConnection2 = this.createWorkspaceConnection(ndWorkspaceConnection, string, (NdVersioningRepositoryConnection)ndScmServerConnection);
        }
        object = this.createWorkspace(ndWorkspaceConnection2, ndVersioningRepositoryConnection);
        if (object == null) {
            return;
        }
        ((NdScmWorkspaceVersionManager)object).openConnection();
        try {
            NdRepository ndRepository;
            this.updateWorkspace((NdScmWorkspaceVersionManager)object, ndScmServerConnection, ndWorkspaceConnection);
            String string2 = ndScmServerConnection.getRepositoryName();
            NdRepository ndRepository2 = ndRepository = ((NdScmWorkspaceVersionManager)object).getRepository();
            NdRepositoryDirectory ndRepositoryDirectory = (NdRepositoryDirectory)ndRepository2.lookupRepositoryEntry(string2);
            if (ndRepositoryDirectory == null && !string2.equals(ndWorkspaceConnection.getRepositoryName())) {
                ndRepositoryDirectory = ((NdScmWorkspaceVersionManager)object).getRepository();
            }
            if (ndRepositoryDirectory == null) {
                throw new NdRepositoryException(NdStrings.WjIAZwN("NoRepositoryFolder", ((NdScmWorkspaceVersionManager)object).getRepositoryPath(), ((NdScmWorkspaceVersionManager)object).getWorkspacePath()));
            }
        }
        finally {
            ((NdScmWorkspaceVersionManager)object).closeConnection();
        }
    }

    public void removeVersioningRepository(NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "removeVersioningRepository");
    }

    public void removeRepositoryWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "removeRepositoryWorkspace");
    }

    public NdRepositoryEntryLockInfo[] listCheckedOutEntries(NdLocation ndLocation, boolean bl, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "listCheckedOutEntries");
    }

    public void releaseCheckedOutEntries(NdLocation ndLocation, boolean bl, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "releaseCheckedOutEntries");
    }

    public void releaseCheckedOutEntries(NdLocation[] ndLocationArray, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "releaseCheckedOutEntries");
    }

    public void commitWorkspaceConfiguration(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdWorkspace ndWorkspace = NdRepositoryFactory.newWorkspace(ndWorkspaceConnection);
        ndWorkspace.openConnection(1);
        NdRepositoryEntry ndRepositoryEntry = ((NdRepositoryDirectory)ndWorkspace.getPhysicalRepositoryEntry()).lookupRepositoryEntry("com_blazesoft_repository_config.cfg");
        if (ndRepositoryEntry != null) {
            NdWorkspaceItem ndWorkspaceItem = ndWorkspace.attachPhysicalItem((NdRepositoryItem)ndRepositoryEntry);
            NdRepositoryEntryLockInfo[] ndRepositoryEntryLockInfoArray = ndWorkspace.getWorkspaceVersionManager().getEntryLockInfos(new NdRepositoryEntry[]{ndWorkspaceItem});
            if (ndRepositoryEntryLockInfoArray[0].getLockStatus() == 2) {
                ndWorkspaceItem.checkIn(WjIBBbY);
            } else {
                throw new NdRepositoryException(NdStrings.WjIAZvM("RepositoryConfigurationIsNotCheckedOutBy", ndWorkspaceConnection.getUser()));
            }
        }
    }

    public void updateWorkspaceConfiguration(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdWorkspace ndWorkspace = NdRepositoryFactory.newWorkspace(ndWorkspaceConnection);
        ndWorkspace.openConnection(1);
        NdRepositoryEntry ndRepositoryEntry = ((NdRepositoryDirectory)ndWorkspace.getPhysicalRepositoryEntry()).lookupRepositoryEntry("com_blazesoft_repository_config.cfg");
        if (ndRepositoryEntry != null) {
            NdWorkspaceItem ndWorkspaceItem = ndWorkspace.attachPhysicalItem((NdRepositoryItem)ndRepositoryEntry);
            ndWorkspaceItem.update();
        }
    }

    protected abstract String createTemporaryWorkspaceLocation(NdScmServerConnection var1) throws NdRepositoryException;

    protected abstract void cleanUpTemporaryWorkspace(String var1) throws NdRepositoryException;

    protected abstract NdWorkspaceConnection createWorkspaceConnection(String var1, String var2, NdVersioningRepositoryConnection var3) throws NdRepositoryException;

    protected abstract NdWorkspaceConnection createWorkspaceConnection(NdWorkspaceConnection var1, String var2, NdVersioningRepositoryConnection var3) throws NdRepositoryException;

    protected abstract NdScmWorkspaceVersionManager createWorkspace(NdWorkspaceConnection var1, NdVersioningRepositoryConnection var2) throws NdRepositoryException;

    protected void updateWorkspace(NdScmWorkspaceVersionManager ndScmWorkspaceVersionManager, NdScmServerConnection ndScmServerConnection, NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        String string = ndScmServerConnection.getRepositoryName();
        NdRepository ndRepository = ndScmWorkspaceVersionManager.getRepository();
        NdRepository ndRepository2 = ndRepository;
        NdRepositoryDirectory ndRepositoryDirectory = (NdRepositoryDirectory)ndRepository2.lookupRepositoryEntry(string);
        if (ndRepositoryDirectory == null && !string.equals(ndWorkspaceConnection.getRepositoryName())) {
            ndRepositoryDirectory = ndScmWorkspaceVersionManager.getRepository();
        }
        if (ndRepositoryDirectory == null || ndRepositoryDirectory.lookupRepositoryEntry("com_blazesoft_repository_config.cfg") == null) {
            NdLocation ndLocation = NdRepositorySupport.getLocation(ndRepository2);
            ndLocation = ndLocation.appendExternalComponent(string);
            ndScmWorkspaceVersionManager.update(ndLocation, true);
            ((NdWorkspaceDirectory)((Object)ndRepository2)).resetEntries();
            ndRepositoryDirectory = (NdRepositoryDirectory)ndRepository2.lookupRepositoryEntry(string);
            if (ndRepositoryDirectory == null) {
                throw new NdRepositoryException(NdStrings.WjIAZwN("FailedToCreateWorkspaceForRepositoryCheckConnectionParameters", ndWorkspaceConnection.getRepositoryName(), string));
            }
            ((NdWorkspaceDirectory)ndRepositoryDirectory).resetEntries();
            return;
        }
        NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)ndRepositoryDirectory.lookupRepositoryEntry("com_blazesoft_repository_config.cfg");
        Object object = ndScmWorkspaceVersionManager.convertEntryToPhysicalResource(ndRepositoryItem);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        ndScmWorkspaceVersionManager.updateInternal(arrayList);
    }

    protected void updateRepositoryHomeFolder(NdScmWorkspaceVersionManager ndScmWorkspaceVersionManager, NdRepository ndRepository, NdLocation ndLocation) throws NdRepositoryException {
    }

    protected NdRepositoryVersionManagerConfig createVersionManagerConfig(NdScmServerConnection ndScmServerConnection) {
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = new NdRepositoryVersionManagerConfig();
        ndRepositoryVersionManagerConfig.setVersioningRepositoryConnection(ndScmServerConnection);
        NdRepositoryVersionManagerFactory ndRepositoryVersionManagerFactory = new NdRepositoryVersionManagerFactory(ndScmServerConnection.getVersionManagerClass());
        ndRepositoryVersionManagerConfig.setRepositoryVersionManagerFactory(ndRepositoryVersionManagerFactory);
        return ndRepositoryVersionManagerConfig;
    }

    protected void trace(String string) {
        if (WjIAXGJ) {
            WjIAXGI.fine(string);
        }
    }

    protected boolean isTracingEnabled() {
        return WjIAXGJ;
    }

    static {
        if (NdSystemProperties.isDebugModeEnabled()) {
            NdLogLevel ndLogLevel = NdLogLevel.OFF;
            String string = NdSystemProperties.getSystemProperty((String)"nd.debugLogLevel");
            if (string != null) {
                try {
                    ndLogLevel = NdLogLevel.parse((String)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            WjIAXGI.setLevel(ndLogLevel);
            WjIAXGJ = true;
            ((NdConsoleLogHandler)WjIAXGI.getHandlers()[0]).setStdOut(false);
            ((NdConsoleLogHandler)WjIAXGI.getHandlers()[0]).setFormat("{4,choice,0#|1#[{5}]} - {6}");
        } else {
            WjIAXGI.setLevel(NdLogLevel.OFF);
        }
    }
}

