/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.repository.base.NdContemporaryWorkspaceItemLoadingStrategy;
import com.blazesoft.repository.base.NdDefaultRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryFactory;
import com.blazesoft.repository.base.NdRepositoryEntryFilter;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionException;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdRepositoryVersionLabel;
import com.blazesoft.repository.base.NdRepositoryVersionNameConflictException;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdRepositoryVersionScmConnectionException;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingContext;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingStrategy;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingStrategyProvider;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.base.NdWorkspaceVersionManagerEvent;
import com.blazesoft.repository.base.NdWorkspaceVersionManagerListener;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.scm.NdScmRepositoryConfigurationEntryFilter;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmSupport;
import com.blazesoft.repository.scm.NdStrings;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.logging.NdConsoleLogHandler;
import com.blazesoft.util.logging.NdLogLevel;
import com.blazesoft.util.logging.NdLogger;
import com.blazesoft.util.logging.NdNamedLogManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public abstract class NdScmWorkspaceVersionManager
implements NdWorkspaceVersionManager,
NdWorkspaceItemLoadingStrategyProvider {
    private NdRepositoryEntryFactory WjIATAN;
    private NdRepository WjIATBO;
    private Vector WjIATCP;
    private ArrayList WjJzlcZ;
    private String WjIATDQ;
    private String WjIATER;
    private String WjIATFS;
    private File WjIATGT;
    private boolean WjIATHU;
    private NdScmServerConnection WjIATIV;
    private String WjIATJW;
    private boolean WjIATKX;
    private String WjIBaxY;
    private boolean WjIBMSK;
    private NdWorkspaceItemLoadingStrategy WjIOmfM;
    private static boolean WjIOZpN;
    private static final NdRepositoryVersionHistory[] WjIUVCJ;
    private static NdLogger WjIATLY;
    private static boolean WjIATMZ;

    protected void initializeRepository(NdRepository ndRepository) throws NdRepositoryException {
        this.WjIATCP = new Vector();
        this.WjIATBO = ndRepository;
        this.WjIATFS = this.initializeWorkspacePath(ndRepository);
        if (this.WjIATFS != null) {
            this.WjIATGT = new File(this.WjIATFS);
        }
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepository.getRepositoryConfig().getRepositoryVersionManagerConfig();
        try {
            this.WjIATIV = (NdScmServerConnection)ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        }
        catch (ClassCastException classCastException) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("NoScmServerConnection"));
        }
        this.initializeConnection(this.WjIATIV);
    }

    protected void initializeConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIATER = ndScmServerConnection.getRepositoryName();
        this.WjIATJW = ndScmServerConnection.getUser();
        this.WjIBaxY = ndScmServerConnection.getServerUrl();
        this.WjIATDQ = this.initializeRepositoryPath(this.WjIATBO);
    }

    protected String initializeWorkspacePath(NdRepository ndRepository) throws NdRepositoryException {
        return NdScmSupport.getPhysicalWorkspacePath(ndRepository);
    }

    protected String initializeRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        return NdScmSupport.getRepositoryPath(ndRepository);
    }

    private void WjIOmgN(NdRepositoryDirectory ndRepositoryDirectory, Vector vector) throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray = ndRepositoryDirectory.getRepositoryEntries();
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            NdRepositoryEntry ndRepositoryEntry = ndRepositoryEntryArray[i];
            vector.addElement(ndRepositoryEntry);
            if (!(ndRepositoryEntry instanceof NdRepositoryDirectory)) continue;
            this.WjIOmgN((NdRepositoryDirectory)ndRepositoryEntry, vector);
        }
    }

    protected void sendUpdateLocationNotifications(NdLocation ndLocation, NdRepositoryEntry[] ndRepositoryEntryArray, HashMap hashMap) throws NdRepositoryException {
        NdRepositoryEntry ndRepositoryEntry = this.lookupEntry(ndLocation);
        if (ndRepositoryEntry instanceof NdRepositoryDirectory) {
            Object object;
            int n;
            this.fireEvent(ndLocation, true, 1);
            if (ndRepositoryEntry instanceof NdWorkspaceDirectory) {
                ((NdWorkspaceDirectory)ndRepositoryEntry).resetEntries();
            }
            Vector vector = new Vector();
            this.WjIOmgN((NdRepositoryDirectory)ndRepositoryEntry, vector);
            Object[] objectArray = new NdRepositoryEntry[vector.size()];
            vector.copyInto(objectArray);
            HashMap<NdLocation, NdRepositoryEntry> hashMap2 = new HashMap<NdLocation, NdRepositoryEntry>();
            for (n = 0; n < ndRepositoryEntryArray.length; ++n) {
                hashMap2.put(NdRepositorySupport.getLocation(ndRepositoryEntryArray[n]), ndRepositoryEntryArray[n]);
            }
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n];
                if (hashMap.containsKey(NdRepositorySupport.getLocation((NdRepositoryEntry)object)) && object instanceof NdRepositoryItem && ((NdRepositoryItem)object).getLastModified().after((Date)hashMap.get(NdRepositorySupport.getLocation((NdRepositoryEntry)object)))) {
                    this.fireEvent(((NdWorkspaceEntry)object).getLocation(), false, 1);
                }
                if (hashMap2.containsKey(NdRepositorySupport.getLocation((NdRepositoryEntry)object))) {
                    hashMap2.remove(NdRepositorySupport.getLocation((NdRepositoryEntry)object));
                    continue;
                }
                this.trace("Notify add: " + object.getName());
                this.fireEvent(NdRepositorySupport.getLocation((NdRepositoryEntry)object), object instanceof NdRepositoryDirectory, 2);
            }
            Iterator iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                object = (NdRepositoryEntry)hashMap2.get(iterator.next());
                this.trace("Notify delete: " + object.getName());
                this.fireEvent(NdRepositorySupport.getLocation((NdRepositoryEntry)object), object instanceof NdRepositoryDirectory, 3);
            }
        } else if (ndRepositoryEntry instanceof NdRepositoryItem) {
            if (hashMap.containsKey(NdRepositorySupport.getLocation(ndRepositoryEntry)) && ((NdRepositoryItem)ndRepositoryEntry).getLastModified().after((Date)hashMap.get(NdRepositorySupport.getLocation(ndRepositoryEntry)))) {
                this.fireEvent(ndLocation, false, 1);
            }
        } else if (ndRepositoryEntry == null && hashMap.isEmpty()) {
            this.fireEvent(ndLocation, false, 2);
        }
    }

    protected void sendNewItemNotifications(NdWorkspaceDirectory ndWorkspaceDirectory) throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray = ndWorkspaceDirectory.getRepositoryEntries();
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            NdRepositoryEntry ndRepositoryEntry = ndRepositoryEntryArray[i];
            if (ndRepositoryEntry instanceof NdWorkspaceEntry) {
                this.trace("Notify add: " + ndRepositoryEntry.getName());
                this.fireEvent(((NdWorkspaceEntry)ndRepositoryEntry).getLocation(), ndRepositoryEntry instanceof NdRepositoryDirectory, 2);
            }
            if (!(ndRepositoryEntry instanceof NdWorkspaceDirectory)) continue;
            this.sendNewItemNotifications((NdWorkspaceDirectory)ndRepositoryEntry);
        }
    }

    protected void sendUpdateNotifications(WjIBaeG wjIBaeG) throws NdRepositoryException {
        this.WjICnZO(wjIBaeG, 1);
    }

    protected void sendCancelCheckOutNotifications(WjIBaeG wjIBaeG) throws NdRepositoryException {
        this.WjICnZO(wjIBaeG, 1);
    }

    private void WjICnZO(WjIBaeG wjIBaeG, int n) throws NdRepositoryException {
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        for (int i = 0; i < wjIAVlKArray.length; ++i) {
            this.fireEvent(wjIAVlKArray[i].WjIAVlD.getLocation(), wjIAVlKArray[i].WjIAVlJ, n);
        }
    }

    public String getWorkspacePath() {
        return this.WjIATFS;
    }

    public File getWorkspacePathFile() {
        return this.WjIATGT;
    }

    public String getRepositoryPath() {
        return this.WjIATDQ;
    }

    public String getRepositoryName() {
        return this.WjIATER;
    }

    public String getUser() {
        return this.WjIATJW;
    }

    public String getServerUrl() {
        return this.WjIBaxY;
    }

    public boolean hasVersionedFolderSupport() {
        return true;
    }

    public boolean hasBaselineFolderSupport() {
        return false;
    }

    public boolean hasAutoCheckoutParent() {
        return false;
    }

    public void cancelCheckOut(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("cancelCheckOut");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, true);
        this.cancelCheckOut(wjIBaeG);
    }

    public void cancelCheckOut(WjIBaeG wjIBaeG) throws NdRepositoryException {
        if (this.hasBaselineFolderSupport()) {
            this.ensureBaselineFolderIntegrity(wjIBaeG);
        }
        wjIBaeG.WjIBQXB(false);
        wjIBaeG.WjIAZSO(this.hasBaselineFolderSupport());
        List list = wjIBaeG.WjIAZWS(false, false, false);
        this.cancelCheckOutInternal(list);
        this.sendCancelCheckOutNotifications(wjIBaeG);
    }

    protected abstract void cancelCheckOutInternal(List var1) throws NdRepositoryException;

    public void checkIn(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        block9: {
            this.trace("checkIn");
            WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, true);
            try {
                this.checkIn(wjIBaeG, string);
            }
            catch (NdRepositoryException ndRepositoryException) {
                Object object;
                Object object2;
                if (!(ndRepositoryException instanceof NdRepositoryVersionNameConflictException)) break block9;
                Object[] objectArray = ((NdRepositoryVersionNameConflictException)ndRepositoryException).getConflictingEntries();
                if (objectArray != null && objectArray.length == 0) {
                    object2 = ndRepositoryException.getMessage();
                    Vector<NdRepositoryEntry> vector = new Vector<NdRepositoryEntry>();
                    block2: for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
                        object = NdRepositorySupport.getLocation(ndRepositoryEntryArray[i]);
                        String string2 = this.getRepositoryName() + object.toString();
                        if (((String)object2).indexOf(string2) > 0) {
                            vector.addElement(ndRepositoryEntryArray[i]);
                            continue;
                        }
                        for (NdRepositoryDirectory ndRepositoryDirectory = ndRepositoryEntryArray[i].getContainerDirectory(); ndRepositoryDirectory != null; ndRepositoryDirectory = ndRepositoryDirectory.getContainerDirectory()) {
                            NdLocation ndLocation = NdRepositorySupport.getLocation(ndRepositoryDirectory);
                            String string3 = this.getRepositoryName() + ((Object)ndLocation).toString();
                            if (((String)object2).indexOf(string3) <= 0) continue;
                            vector.addElement(ndRepositoryDirectory);
                            continue block2;
                        }
                    }
                    if (vector.size() > 0) {
                        objectArray = new NdRepositoryEntry[vector.size()];
                        vector.copyInto(objectArray);
                    }
                }
                if (objectArray != null && objectArray.length > 0) {
                    object2 = new Vector(objectArray.length);
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object3 = this.convertEntryToPhysicalResource(objectArray[i]);
                        ((Vector)object2).addElement(object3);
                        object = this.convertAttributesToPhysicalResource((NdRepositoryEntry)objectArray[i]);
                        ((Vector)object2).addElement(object);
                    }
                    Object[] objectArray2 = new Object[((Vector)object2).size()];
                    ((Vector)object2).copyInto(objectArray2);
                    this.internalProcessNameConflictEntries(objectArray2);
                    throw new NdRepositoryVersionNameConflictException(ndRepositoryException.getMessage(), (NdRepositoryEntry[])objectArray);
                }
                throw ndRepositoryException;
            }
        }
        this.WjIOmfM = null;
    }

    protected void internalProcessNameConflictEntries(Object[] objectArray) throws NdRepositoryException {
    }

    public void checkIn(WjIBaeG wjIBaeG, String string) throws NdRepositoryException {
        List list;
        if (this.hasBaselineFolderSupport()) {
            this.ensureBaselineFolderIntegrity(wjIBaeG);
            if (!this.hasAutoCheckoutParent()) {
                this.ensureBaselineFoldersCheckedOut(wjIBaeG, true);
            }
        }
        boolean bl = this.ensureDirectoriesInSCM(wjIBaeG, string);
        if (this.hasBaselineFolderSupport() && !this.hasAutoCheckoutParent()) {
            this.ensureBaselineFoldersCheckedOut(wjIBaeG, true);
        }
        if (wjIBaeG.WjIAZUQ()) {
            wjIBaeG.WjIBVbV(true);
            list = wjIBaeG.WjIAZWS(true, false, true);
            wjIBaeG.WjIBVbV(false);
            if (!list.isEmpty()) {
                List list2 = this.doVersionControlInternal(list, string);
                wjIBaeG.WjIBaeB(list2);
            }
        }
        if (wjIBaeG.WjIAZTP()) {
            list = this.getRemovedVersionControlledEntries(wjIBaeG);
            wjIBaeG.WjIBaeB(list);
        }
        wjIBaeG.WjIAZSO(this.hasVersionedFolderSupport());
        list = wjIBaeG.WjIAZYU();
        if (list.isEmpty()) {
            return;
        }
        this.checkInInternal(list, string);
    }

    public ArrayList getDuplicateEntries() {
        return null;
    }

    protected abstract void checkInInternal(List var1, String var2) throws NdRepositoryException;

    protected abstract List doVersionControlInternal(List var1, String var2) throws NdRepositoryException;

    public List getRemovedVersionControlledEntries(WjIBaeG wjIBaeG) throws NdRepositoryException {
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        HashSet<NdWorkspaceEntry> hashSet = new HashSet<NdWorkspaceEntry>(wjIAVlKArray.length, 1.0f);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < wjIAVlKArray.length; ++i) {
            NdWorkspaceEntry ndWorkspaceEntry;
            if (!wjIAVlKArray[i].WjIAVlI || hashSet.contains(ndWorkspaceEntry = (NdWorkspaceEntry)((Object)wjIAVlKArray[i].WjIAVlD.getContainerDirectory()))) continue;
            hashSet.add(ndWorkspaceEntry);
            arrayList.add(this.convertEntryToPhysicalResource(ndWorkspaceEntry));
            arrayList.add(this.convertAttributesToPhysicalResource(ndWorkspaceEntry));
        }
        List list = wjIBaeG.WjIAZWS(false, true, true);
        return this.getRemovedVersionControlledEntries(arrayList, list);
    }

    public List getRemovedVersionControlledEntries(List list, List list2) throws NdRepositoryException {
        if (this.hasBaselineFolderSupport()) {
            return list;
        }
        return list2;
    }

    protected abstract boolean isVersionedInternal(Object var1) throws NdRepositoryException;

    protected abstract boolean isCheckedOutInternal(Object var1) throws NdRepositoryException;

    public boolean isVersionControlledEntry(NdRepositoryEntry ndRepositoryEntry, boolean bl) throws NdRepositoryException {
        this.trace("isVersionControlled: " + ndRepositoryEntry.getName());
        Object object = bl ? this.convertAttributesToPhysicalResource(ndRepositoryEntry) : this.convertEntryToPhysicalResource(ndRepositoryEntry);
        return this.isVersionedInternal(object);
    }

    public void checkOut(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("checkOut");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, true);
        this.checkOut(wjIBaeG);
    }

    public void checkOut(WjIBaeG wjIBaeG) throws NdRepositoryException {
        wjIBaeG.WjIAZSO(this.hasBaselineFolderSupport());
        List list = wjIBaeG.WjIAZWS(false, false, false);
        this.checkOutInternal(list);
    }

    protected abstract void checkOutInternal(List var1) throws NdRepositoryException;

    public void delete(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("delete");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, true);
        this.delete(wjIBaeG);
    }

    public void delete(WjIBaeG wjIBaeG) throws NdRepositoryException {
        wjIBaeG.WjIAZSO(this.hasVersionedFolderSupport());
        List list = wjIBaeG.WjIAZWS(false, false, false);
        if (this.hasBaselineFolderSupport()) {
            if (!this.WjIBMSK || !this.hasAutoCheckoutParent()) {
                this.ensureBaselineFoldersCheckedOut(wjIBaeG, false);
            }
            if (!this.WjIBMSK) {
                this.cancelCheckOutInternal(list);
                this.sendCancelCheckOutNotifications(wjIBaeG);
            }
        }
        this.deleteInternal(list);
        if (this.hasAutoCheckoutParent()) {
            WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
            HashSet<NdWorkspaceEntry> hashSet = new HashSet<NdWorkspaceEntry>(wjIAVlKArray.length, 1.0f);
            for (int i = 0; i < wjIAVlKArray.length; ++i) {
                NdWorkspaceEntry ndWorkspaceEntry = (NdWorkspaceEntry)((Object)wjIAVlKArray[i].WjIAVlD.getContainerDirectory());
                if (hashSet.contains(ndWorkspaceEntry)) continue;
                hashSet.add(ndWorkspaceEntry);
                Object object = this.convertEntryToPhysicalResource(ndWorkspaceEntry);
                if (this.isCheckedOutInternal(object)) {
                    Object object2 = this.convertAttributesToPhysicalResource(ndWorkspaceEntry);
                    if (!this.isCheckedOutInternal(object2)) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object2);
                        this.checkOutInternal(arrayList);
                    }
                    if (NdRepositorySupport.getCheckedOutUserId(ndWorkspaceEntry) != null) continue;
                    this.fireEvent(ndWorkspaceEntry.getLocation(), true, 4);
                    continue;
                }
                throw new NdRepositoryException(NdStrings.WjIAZwN("ParentNotCheckedOut", ndWorkspaceEntry.getName(), wjIAVlKArray[i].WjIAVlD.getName()));
            }
        }
    }

    protected abstract void deleteInternal(List var1) throws NdRepositoryException;

    public void cancelDelete(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("cancelDelete");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, true);
        this.cancelDelete(wjIBaeG);
    }

    public void cancelDelete(WjIBaeG wjIBaeG) throws NdRepositoryException {
        wjIBaeG.WjIAZSO(this.hasBaselineFolderSupport());
        wjIBaeG.WjIBQXB(false);
        List list = wjIBaeG.WjIAZWS(false, false, false);
        if (this.hasBaselineFolderSupport()) {
            this.ensureBaselineFolderIntegrity(wjIBaeG, true);
        }
        this.cancelDeleteInternal(list);
        if (this.hasBaselineFolderSupport()) {
            wjIBaeG.WjIBQXB(true);
            List list2 = wjIBaeG.WjIAZYU();
            list2.removeAll(list);
            if (!list2.isEmpty()) {
                this.cancelCheckOutInternal(list2);
            }
        }
    }

    protected abstract void cancelDeleteInternal(List var1) throws NdRepositoryException;

    public void deleteLabel(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "deleteLabel");
    }

    public String difference(NdRepositoryItem ndRepositoryItem, String string, String string2) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "difference");
    }

    public NdRepositoryItem getItemByVersion(NdRepositoryItem ndRepositoryItem, String string) throws NdRepositoryException {
        this.trace("getItemByVersion");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(new NdRepositoryEntry[]{ndRepositoryItem}, false);
        return this.getItemByVersion(wjIBaeG, string);
    }

    public NdRepositoryItem getItemByVersion(WjIBaeG wjIBaeG, String string) throws NdRepositoryException {
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        if (!this.hasBaselineFolderSupport()) {
            // empty if block
        }
        String string2 = this.getContentByVersionInternal(wjIAVlKArray[0].WjIAVlE, string);
        String string3 = this.getContentByVersionInternal(wjIAVlKArray[0].WjIAVlF, string);
        if (string2 == null || string3 == null) {
            throw new NdRepositoryException(NdStrings.WjIAZwN("VersionNotFound", string, wjIAVlKArray[0].WjIAVlD.getName()));
        }
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = NdRepositorySupport.parseEntryAttributesFromContents(string3);
        return this.WjIATAN.newItem(NdRepositorySupport.getLocation(wjIAVlKArray[0].WjIAVlD), string2, ndRepositoryEntryAttributeArray);
    }

    protected abstract String getContentByVersionInternal(Object var1, String var2) throws NdRepositoryException;

    public void setRepositoryEntryFactory(NdRepositoryEntryFactory ndRepositoryEntryFactory) {
        this.WjIATAN = ndRepositoryEntryFactory;
    }

    public NdRepositoryEntryLockInfo[] getEntryLockInfos(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("getEntryLockInfos");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, false);
        NdRepositoryEntryLockInfo[] ndRepositoryEntryLockInfoArray = this.prepareEntryLockInfo(ndRepositoryEntryArray, wjIBaeG);
        HashMap<Object, NdRepositoryEntryLockInfo> hashMap = new HashMap<Object, NdRepositoryEntryLockInfo>(ndRepositoryEntryArray.length);
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            hashMap.put(wjIBaeG.WjIBadZ(i), ndRepositoryEntryLockInfoArray[i]);
        }
        this.getEntryLockInfos(wjIBaeG, hashMap);
        return ndRepositoryEntryLockInfoArray;
    }

    public void getEntryLockInfos(WjIBaeG wjIBaeG, Map map) throws NdRepositoryException {
        List list = wjIBaeG.WjIAZWS(false, false, false);
        this.getEntryLockInfosInternal(list, map);
    }

    protected abstract void getEntryLockInfosInternal(List var1, Map var2) throws NdRepositoryException;

    public NdRepositoryVersionHistory[][] getHistories(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("getHistories");
        if (WjIOZpN) {
            return this.getAncestralHistories(ndRepositoryEntryArray);
        }
        return this.getHistories(ndRepositoryEntryArray, false, null);
    }

    protected NdRepositoryVersionHistory[][] getHistories(NdRepositoryEntry[] ndRepositoryEntryArray, boolean bl, String string) throws NdRepositoryException {
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, false);
        List list = wjIBaeG.WjIAZWS(false, false, false);
        Object[] objectArray = list.toArray();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], new ArrayList());
        }
        if (bl) {
            this.getAncestralHistoriesInternal(list, hashMap, string);
        } else {
            this.getHistoriesInternal(list, hashMap);
        }
        NdRepositoryVersionHistory[][] ndRepositoryVersionHistoryArray = new NdRepositoryVersionHistory[ndRepositoryEntryArray.length][];
        int n = 0;
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            if (wjIAVlKArray[i].WjIAVlH) {
                ndRepositoryVersionHistoryArray[i] = WjIUVCJ;
                continue;
            }
            ArrayList arrayList = (ArrayList)hashMap.get(objectArray[n]);
            NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray2 = arrayList.toArray(new NdRepositoryVersionHistory[arrayList.size()]);
            ndRepositoryVersionHistoryArray[i] = ndRepositoryVersionHistoryArray2 != null ? ndRepositoryVersionHistoryArray2 : WjIUVCJ;
            int n2 = wjIBaeG.WjIBaeA(objectArray[n]);
            WjIAVlK wjIAVlK = wjIBaeG.WjIBabX(n2);
            for (int j = 0; j < ndRepositoryVersionHistoryArray2.length; ++j) {
                ndRepositoryVersionHistoryArray2[j].setLocation(wjIAVlK.WjIAVlD.getLocation());
            }
            ++n;
        }
        return ndRepositoryVersionHistoryArray;
    }

    public NdRepositoryVersionHistory[][] getAncestralHistories(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("getAncestralHistories");
        return this.getHistories(ndRepositoryEntryArray, true, null);
    }

    protected NdRepositoryVersionHistory[] getAncestralHistories(NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, NdWorkspaceItem ndWorkspaceItem, NdLocation ndLocation) throws NdRepositoryException {
        return null;
    }

    protected abstract void getHistoriesInternal(List var1, Map var2) throws NdRepositoryException;

    protected void getAncestralHistoriesInternal(List list, Map map, String string) throws NdRepositoryException {
        this.getHistoriesInternal(list, map);
    }

    public NdRepositoryVersionLabel[][] getLabels(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "getLabels");
    }

    public NdRepositoryVersionResultSet[] getStatusInfos(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        int n;
        this.trace("getStatusInfos");
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, false);
        wjIBaeG.WjIAZSO(this.hasVersionedFolderSupport());
        NdRepositoryVersionResultSet[] ndRepositoryVersionResultSetArray = this.prepareStatusInfo(ndRepositoryEntryArray, wjIBaeG);
        HashMap<Object, NdRepositoryVersionResultSet> hashMap = new HashMap<Object, NdRepositoryVersionResultSet>(ndRepositoryEntryArray.length);
        for (n = 0; n < ndRepositoryEntryArray.length; ++n) {
            hashMap.put(wjIBaeG.WjIBadZ(n), ndRepositoryVersionResultSetArray[n]);
        }
        this.getStatusInfos(wjIBaeG, hashMap);
        for (n = 0; n < ndRepositoryVersionResultSetArray.length; ++n) {
            NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRepositoryVersionResultSetArray[n];
            if (ndRepositoryVersionResultSet.isLocallyRestored() || ndRepositoryVersionResultSet.getWorkingVersionId() != null) continue;
            ndRepositoryVersionResultSet.setWorkingVersionId(ndRepositoryVersionResultSet.getCurrentVersionId());
        }
        return ndRepositoryVersionResultSetArray;
    }

    public void getStatusInfos(WjIBaeG wjIBaeG, Map map) throws NdRepositoryException {
        List list = wjIBaeG.WjIAZWS(false, false, false);
        this.getStatusInfosInternal(list, map);
    }

    protected abstract void getStatusInfosInternal(List var1, Map var2) throws NdRepositoryException;

    public boolean isFeatureSupported(int n) {
        switch (n) {
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean isServerConnected() throws NdRepositoryException {
        return this.WjIATHU;
    }

    public boolean isVersioned(NdLocation ndLocation, boolean bl) throws NdRepositoryException {
        if (!bl || !this.WjIATHU) {
            return this.isVersionedLocal(ndLocation);
        }
        return this.isVersionedInternal(this.convertLocationToPhysicalResource(ndLocation));
    }

    protected boolean isVersionedLocal(NdLocation ndLocation) throws NdRepositoryException {
        NdRepositoryEntry ndRepositoryEntry = this.lookupEntry(ndLocation);
        if (ndRepositoryEntry == null) {
            return false;
        }
        return NdRepositorySupport.getAttributeValue(ndRepositoryEntry, "com.blazesoft.repository.local.locallycreated") == null;
    }

    public void setLabel(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "setLabel");
    }

    public void update(NdLocation ndLocation, boolean bl) throws NdRepositoryException {
        Object object;
        this.trace("update-location");
        Object[] objectArray = new NdRepositoryEntry[]{};
        NdRepositoryEntry ndRepositoryEntry = this.lookupEntry(ndLocation);
        HashMap<NdLocation, Date> hashMap = new HashMap<NdLocation, Date>();
        Vector<Object> vector = new Vector<Object>();
        if (ndRepositoryEntry instanceof NdRepositoryDirectory) {
            object = new Vector();
            this.WjIOmgN((NdRepositoryDirectory)ndRepositoryEntry, (Vector)object);
            objectArray = new NdRepositoryEntry[object.size()];
            object.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof NdRepositoryItem)) continue;
                String string = NdRepositorySupport.getRepositoryEntryAttributeValue((NdRepositoryEntry)objectArray[i], "com.blazesoft.repository.local.locallycreated");
                if ("true".equals(string) && this.isVersionControlledEntry((NdRepositoryEntry)objectArray[i], false)) {
                    vector.addElement(objectArray[i]);
                    continue;
                }
                hashMap.put(NdRepositorySupport.getLocation((NdRepositoryEntry)objectArray[i]), ((NdRepositoryItem)objectArray[i]).getLastModified());
            }
        } else if (ndRepositoryEntry instanceof NdRepositoryItem) {
            object = NdRepositorySupport.getRepositoryEntryAttributeValue(ndRepositoryEntry, "com.blazesoft.repository.local.locallycreated");
            if ("true".equals(object) && this.isVersionControlledEntry(ndRepositoryEntry, false)) {
                vector.addElement(ndRepositoryEntry);
            } else {
                objectArray = new NdRepositoryEntry[]{ndRepositoryEntry};
                hashMap.put(NdRepositorySupport.getLocation((NdRepositoryEntry)objectArray[0]), ((NdRepositoryItem)objectArray[0]).getLastModified());
            }
        }
        if (vector.size() > 0) {
            object = new NdRepositoryEntry[vector.size()];
            vector.copyInto((Object[])object);
            throw new NdRepositoryVersionNameConflictException(NdStrings.WjIAZtK("UpdateFailedDueToConflictingEntries"), (NdRepositoryEntry[])object);
        }
        if (!(ndRepositoryEntry instanceof NdRepository)) {
            object = ((Object)ndLocation).toString() + ".innovator_attbs";
            this.updateLocationInternal(this.convertLocationToPhysicalResource(NdLocationFactory.createLocation((String)object)), false);
        }
        this.updateLocationInternal(this.convertLocationToPhysicalResource(ndLocation), bl);
        this.sendUpdateLocationNotifications(ndLocation, (NdRepositoryEntry[])objectArray, hashMap);
    }

    public NdWorkspaceItemLoadingStrategy getLoadingStrategy() {
        if (this.WjIOmfM == null) {
            this.WjIOmfM = new WjIOrVT(this);
        }
        return this.WjIOmfM;
    }

    protected boolean isDirectoryEntry(NdLocation ndLocation) {
        NdRepositoryEntry ndRepositoryEntry = this.lookupEntry(ndLocation);
        return ndRepositoryEntry instanceof NdRepositoryDirectory;
    }

    protected abstract void updateLocationInternal(Object var1, boolean var2) throws NdRepositoryException;

    public void update(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.trace("update-entries");
        Vector<NdRepositoryEntry> vector = new Vector<NdRepositoryEntry>();
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            String string;
            if (!(ndRepositoryEntryArray[i] instanceof NdRepositoryItem) || !"true".equals(string = NdRepositorySupport.getRepositoryEntryAttributeValue(ndRepositoryEntryArray[i], "com.blazesoft.repository.local.locallycreated")) || !this.isVersionControlledEntry(ndRepositoryEntryArray[i], false)) continue;
            vector.addElement(ndRepositoryEntryArray[i]);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new NdRepositoryEntry[vector.size()];
            vector.copyInto(objectArray);
            throw new NdRepositoryVersionNameConflictException(NdStrings.WjIAZtK("UpdateFailedDueToConflictingEntries"), (NdRepositoryEntry[])objectArray);
        }
        WjIBaeG wjIBaeG = this.convertEntriesToSet(ndRepositoryEntryArray, true);
        this.update(wjIBaeG);
    }

    public void update(WjIBaeG wjIBaeG) throws NdRepositoryException {
        HashMap<NdLocation, Date> hashMap = new HashMap<NdLocation, Date>();
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        if (!this.isUpdateEventDriven()) {
            for (int i = 0; i < wjIAVlKArray.length; ++i) {
                if (wjIAVlKArray[i].WjIAVlJ) continue;
                hashMap.put(wjIAVlKArray[i].WjIAVlD.getLocation(), ((NdRepositoryItem)((Object)wjIAVlKArray[i].WjIAVlD)).getLastModified());
            }
        }
        List list = wjIBaeG.WjIAZWS(false, false, false);
        this.updateInternal(list);
        if (this.isUpdateEventDriven()) {
            ArrayList arrayList = this.WjJzldA();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    NdLocation ndLocation = NdLocationFactory.createLocation((String)arrayList.get(i));
                    NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)NdRepositorySupport.lookupEntry((NdRepositoryDirectory)((NdWorkspace)this.WjIATBO).getPhysicalRepositoryEntry(), ndLocation);
                    if (ndRepositoryItem != null) {
                        this.fireEvent(ndLocation, false, 1);
                        continue;
                    }
                    this.fireEvent(ndLocation, false, 3);
                }
            }
            this.setUpdatedLocation(null);
        } else {
            for (int i = 0; i < wjIAVlKArray.length; ++i) {
                if (wjIAVlKArray[i].WjIAVlJ) {
                    this.fireEvent(wjIAVlKArray[i].WjIAVlD.getLocation(), wjIAVlKArray[i].WjIAVlJ, 1);
                    continue;
                }
                NdLocation ndLocation = wjIAVlKArray[i].WjIAVlD.getLocation();
                NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)NdRepositorySupport.lookupEntry((NdRepositoryDirectory)((NdWorkspace)this.WjIATBO).getPhysicalRepositoryEntry(), ndLocation);
                if (ndRepositoryItem != null && ndRepositoryItem.getLastModified().after((Date)hashMap.get(ndLocation))) {
                    this.fireEvent(ndLocation, false, 1);
                    continue;
                }
                if (ndRepositoryItem != null) continue;
                this.fireEvent(ndLocation, false, 3);
            }
        }
    }

    protected abstract void updateInternal(List var1) throws NdRepositoryException;

    protected boolean isUpdateEventDriven() {
        return false;
    }

    ArrayList WjJzldA() {
        return this.WjJzlcZ;
    }

    protected void setUpdatedLocation(ArrayList arrayList) {
        this.WjJzlcZ = arrayList;
    }

    public void openConnection() throws NdRepositoryException {
        this.trace("openConnection");
        if (this.WjIATHU) {
            return;
        }
        try {
            this.openConnection(this.WjIATIV);
            this.WjIATHU = true;
        }
        catch (NdRepositoryException ndRepositoryException) {
            this.WjIATHU = false;
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            this.WjIATHU = false;
            throw new NdRepositoryException(exception);
        }
        catch (Error error) {
            this.WjIATHU = false;
            throw new NdRepositoryException(error);
        }
    }

    public abstract void openConnection(NdScmServerConnection var1) throws NdRepositoryException;

    protected void verifyConnection() throws NdRepositoryVersionScmConnectionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws NdRepositoryException {
        this.trace("closeConnection");
        try {
            this.closeConnection(this.WjIATIV);
            Object var2_1 = null;
            this.WjIATHU = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.WjIATHU = false;
            throw throwable;
        }
    }

    public abstract void closeConnection(NdScmServerConnection var1) throws NdRepositoryException;

    public void addWorkspaceVersionManagerListener(NdWorkspaceVersionManagerListener ndWorkspaceVersionManagerListener) {
        this.WjIATCP.addElement(ndWorkspaceVersionManagerListener);
    }

    public void removeWorkspaceVersionManagerListener(NdWorkspaceVersionManagerListener ndWorkspaceVersionManagerListener) {
        this.WjIATCP.removeElement(ndWorkspaceVersionManagerListener);
    }

    public NdRepositoryEntryFilter getEntryFilter() {
        return new NdScmRepositoryConfigurationEntryFilter();
    }

    public void enablePersistentConnection(boolean bl) throws NdRepositoryException {
        this.WjIATKX = bl;
    }

    public boolean isPersistentConnectionEnabled() {
        return this.WjIATKX;
    }

    public void ensureBaselineFoldersCheckedOut(WjIBaeG wjIBaeG, boolean bl) throws NdRepositoryException {
        if (!this.hasBaselineFolderSupport() || this.hasAutoCheckoutParent()) {
            return;
        }
        if (bl && !wjIBaeG.WjIAZUQ()) {
            return;
        }
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        HashSet<NdWorkspaceDirectory> hashSet = new HashSet<NdWorkspaceDirectory>(wjIAVlKArray.length, 1.0f);
        for (int i = 0; i < wjIAVlKArray.length; ++i) {
            NdWorkspaceDirectory ndWorkspaceDirectory;
            if (bl && !wjIAVlKArray[i].WjIAVlH || hashSet.contains(ndWorkspaceDirectory = (NdWorkspaceDirectory)wjIAVlKArray[i].WjIAVlD.getContainerDirectory())) continue;
            hashSet.add(ndWorkspaceDirectory);
            this.ensureBaselineFolderIsCheckedOut(ndWorkspaceDirectory);
        }
    }

    public void ensureBaselineFolderIsCheckedOut(NdWorkspaceDirectory ndWorkspaceDirectory) throws NdRepositoryException {
        boolean bl = !(ndWorkspaceDirectory instanceof NdWorkspace);
        this.ensureBaselineFolderIsCheckedOut(ndWorkspaceDirectory, bl);
    }

    public void ensureBaselineFolderIsCheckedOut(NdWorkspaceDirectory ndWorkspaceDirectory, boolean bl) throws NdRepositoryException {
        Object object = this.convertEntryToPhysicalResource(ndWorkspaceDirectory);
        if (this.isVersionedInternal(object) && !this.isCheckedOutInternal(object)) {
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            if (bl && this.isVersionedInternal(object2 = this.convertAttributesToPhysicalResource(ndWorkspaceDirectory)) && !this.isCheckedOutInternal(object2)) {
                arrayList.add(object2);
            }
            this.checkOutInternal(arrayList);
            this.fireEvent(ndWorkspaceDirectory.getLocation(), true, 4);
        }
    }

    public void ensureBaselineFolderIntegrity(WjIBaeG wjIBaeG) throws NdRepositoryException {
        this.ensureBaselineFolderIntegrity(wjIBaeG, false);
    }

    public void ensureBaselineFolderIntegrity(WjIBaeG wjIBaeG, boolean bl) throws NdRepositoryException {
        Object object;
        NdWorkspaceEntry ndWorkspaceEntry;
        if (!bl && !wjIBaeG.WjIAZTP()) {
            return;
        }
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        HashMap<NdWorkspaceEntry, NdWorkspaceEntry[]> hashMap = new HashMap<NdWorkspaceEntry, NdWorkspaceEntry[]>(wjIAVlKArray.length, 1.0f);
        for (int i = 0; i < wjIAVlKArray.length; ++i) {
            if (!bl && !wjIAVlKArray[i].WjIAVlI) continue;
            ndWorkspaceEntry = (NdWorkspaceEntry)((Object)wjIAVlKArray[i].WjIAVlD.getContainerDirectory());
            object = (NdWorkspaceEntry[])hashMap.get(ndWorkspaceEntry);
            if (object == null) {
                object = new HashSet();
                hashMap.put(ndWorkspaceEntry, (NdWorkspaceEntry[])object);
            }
            object.add(wjIAVlKArray[i].WjIAVlD);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            ndWorkspaceEntry = (NdWorkspaceDirectory)iterator.next();
            object = (NdWorkspaceEntry[])ndWorkspaceEntry.getRepositoryEntries();
            Set set = (Set)hashMap.get(ndWorkspaceEntry);
            for (int i = 0; i < ((NdWorkspaceEntry[])object).length; ++i) {
                if (!object[i].isMarkedForDeletion() || set.contains(object[i])) continue;
                throw new NdRepositoryException(NdStrings.WjIAZwN("OperationRequiresAllDeletedItems", object[i].getName(), ndWorkspaceEntry.getName()));
            }
            WjIAVlK wjIAVlK = wjIBaeG.WjIBacY(ndWorkspaceEntry);
            if ((!bl || !this.hasAutoCheckoutParent()) && wjIAVlK != null) continue;
            this.trace("Auto-check-in-parent (ensure integrity)");
            Object object2 = this.convertEntryToPhysicalResource(ndWorkspaceEntry);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            Object object3 = this.convertAttributesToPhysicalResource(ndWorkspaceEntry);
            if (object3 != null) {
                arrayList.add(object3);
            }
            wjIBaeG.WjIBaeB(arrayList);
        }
    }

    public boolean ensureDirectoriesInSCM(WjIBaeG wjIBaeG, String string) throws NdRepositoryException {
        boolean bl = false;
        WjIAVlK[] wjIAVlKArray = wjIBaeG.WjIBaaW();
        HashMap<NdRepositoryEntry, Boolean> hashMap = new HashMap<NdRepositoryEntry, Boolean>(wjIAVlKArray.length, 1.0f);
        NdRepository ndRepository = this.getRepository();
        Vector<NdLocation> vector = new Vector<NdLocation>();
        Vector<NdRepositoryException> vector2 = new Vector<NdRepositoryException>();
        block2: for (int i = 0; i < wjIAVlKArray.length; ++i) {
            if (!wjIAVlKArray[i].WjIAVlH) continue;
            Stack<NdWorkspaceEntry> stack = new Stack<NdWorkspaceEntry>();
            for (NdRepositoryEntry ndRepositoryEntry = wjIAVlKArray[i].WjIAVlD; ndRepositoryEntry != ndRepository && (hashMap.get(ndRepositoryEntry) == null || hashMap.get(ndRepositoryEntry) == Boolean.FALSE); ndRepositoryEntry = ndRepositoryEntry.getContainerDirectory()) {
                if (!(ndRepositoryEntry instanceof NdRepositoryDirectory)) continue;
                if (hashMap.get(ndRepositoryEntry) == null) {
                    if (this.isVersionControlledEntry(ndRepositoryEntry, false)) {
                        hashMap.put(ndRepositoryEntry, Boolean.TRUE);
                        break;
                    }
                    hashMap.put(ndRepositoryEntry, Boolean.FALSE);
                }
                if (hashMap.get(ndRepositoryEntry) != Boolean.FALSE) continue;
                stack.push((NdWorkspaceEntry)ndRepositoryEntry);
            }
            bl = stack.isEmpty();
            while (!stack.empty()) {
                NdRepositoryEntry ndRepositoryEntry = (NdRepositoryEntry)stack.pop();
                try {
                    Object object;
                    if (this.hasBaselineFolderSupport() && !this.hasAutoCheckoutParent()) {
                        object = (NdWorkspaceDirectory)ndRepositoryEntry.getContainerDirectory();
                        this.ensureBaselineFolderIsCheckedOut((NdWorkspaceDirectory)object);
                    }
                    object = this.convertEntryToPhysicalResource(ndRepositoryEntry);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                    Object object2 = this.convertAttributesToPhysicalResource(ndRepositoryEntry);
                    arrayList.add(object2);
                    List list = this.doVersionControlInternal(arrayList, string);
                    hashMap.put(ndRepositoryEntry, Boolean.TRUE);
                    if (list == null || list.isEmpty()) continue;
                    wjIBaeG.WjIBaeB(list);
                }
                catch (NdRepositoryException ndRepositoryException) {
                    vector.addElement(NdRepositorySupport.getLocation(ndRepositoryEntry));
                    vector2.addElement(ndRepositoryException);
                    continue block2;
                }
            }
        }
        if (vector2.size() != 0) {
            this.WjIATNA(vector2, vector);
        }
        return bl;
    }

    private void WjIATNA(Vector vector, Vector vector2) throws NdRepositoryVersionException {
        Object[] objectArray = new Exception[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new NdLocation[vector2.size()];
        vector2.copyInto(objectArray2);
        throw new NdRepositoryVersionException((Exception[])objectArray, (NdLocation[])objectArray2);
    }

    public abstract Object convertEntryToPhysicalResource(NdRepositoryEntry var1) throws NdRepositoryException;

    public abstract Object convertAttributesToPhysicalResource(NdRepositoryEntry var1) throws NdRepositoryException;

    public abstract Object convertLocationToPhysicalResource(NdLocation var1) throws NdRepositoryException;

    protected NdDefaultRepositoryEntryLockInfo[] prepareEntryLockInfo(NdRepositoryEntry[] ndRepositoryEntryArray, WjIBaeG wjIBaeG) throws NdRepositoryException {
        NdDefaultRepositoryEntryLockInfo[] ndDefaultRepositoryEntryLockInfoArray = new NdDefaultRepositoryEntryLockInfo[ndRepositoryEntryArray.length];
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            ndDefaultRepositoryEntryLockInfoArray[i] = this.createLockInfo(ndRepositoryEntryArray[i]);
            WjIAVlK wjIAVlK = wjIBaeG.WjIBabX(i);
            if (wjIAVlK.WjIAVlH) {
                ndDefaultRepositoryEntryLockInfoArray[i].setUserId(this.getUser());
                continue;
            }
            if (!wjIAVlK.WjIAVlI) continue;
            ndDefaultRepositoryEntryLockInfoArray[i].setUserId(this.getUser());
            ndDefaultRepositoryEntryLockInfoArray[i].setLockStatus(2);
        }
        return ndDefaultRepositoryEntryLockInfoArray;
    }

    protected NdDefaultRepositoryEntryLockInfo createLockInfo(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdDefaultRepositoryEntryLockInfo ndDefaultRepositoryEntryLockInfo = new NdDefaultRepositoryEntryLockInfo(1, null, NdRepositorySupport.getLocation(ndRepositoryEntry));
        return ndDefaultRepositoryEntryLockInfo;
    }

    protected NdRepositoryVersionResultSet[] prepareStatusInfo(NdRepositoryEntry[] ndRepositoryEntryArray, WjIBaeG wjIBaeG) throws NdRepositoryException {
        NdRepositoryVersionResultSet[] ndRepositoryVersionResultSetArray = new NdRepositoryVersionResultSet[ndRepositoryEntryArray.length];
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            NdDefaultRepositoryEntryLockInfo ndDefaultRepositoryEntryLockInfo;
            ndRepositoryVersionResultSetArray[i] = this.createResultSet(ndRepositoryEntryArray[i]);
            WjIAVlK wjIAVlK = wjIBaeG.WjIBabX(i);
            if (wjIAVlK.WjIAVlH) {
                ndRepositoryVersionResultSetArray[i].setVersionStatus(this.belongsToThisUser(ndRepositoryEntryArray[i]) ? 1 : 2);
                ndDefaultRepositoryEntryLockInfo = new NdDefaultRepositoryEntryLockInfo(1, null, null, ndRepositoryVersionResultSetArray[i].getLocation());
                ndRepositoryVersionResultSetArray[i].setEntryLockInfo(ndDefaultRepositoryEntryLockInfo);
                continue;
            }
            if (!wjIAVlK.WjIAVlI) continue;
            ndRepositoryVersionResultSetArray[i].setLocallyDeleted(true);
            ndDefaultRepositoryEntryLockInfo = new NdDefaultRepositoryEntryLockInfo(2, this.getUser(), null, ndRepositoryVersionResultSetArray[i].getLocation());
            ndRepositoryVersionResultSetArray[i].setEntryLockInfo(ndDefaultRepositoryEntryLockInfo);
        }
        return ndRepositoryVersionResultSetArray;
    }

    protected NdRepositoryVersionResultSet createResultSet(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = new NdRepositoryVersionResultSet();
        ndRepositoryVersionResultSet.setLocation(NdRepositorySupport.getLocation(ndRepositoryEntry));
        ndRepositoryVersionResultSet.setEntryType(ndRepositoryEntry instanceof NdRepositoryDirectory ? 2 : 1);
        ndRepositoryVersionResultSet.setVersionStatus(-1);
        ndRepositoryVersionResultSet.setSuccessful(true);
        return ndRepositoryVersionResultSet;
    }

    protected NdRepositoryVersionHistory createVersionHistory(String string, String string2, Date date, String string3, boolean bl) {
        return new NdRepositoryVersionHistory(string, string2, date, string3, bl);
    }

    public NdRepositoryEntry lookupEntry(NdLocation ndLocation) {
        NdRepositoryEntry ndRepositoryEntry = null;
        try {
            ndRepositoryEntry = NdRepositorySupport.lookupEntry((NdRepositoryDirectory)this.WjIATBO, ndLocation);
        }
        catch (NdRepositoryException ndRepositoryException) {
            // empty catch block
        }
        return ndRepositoryEntry;
    }

    public boolean belongsToThisUser(NdRepositoryEntry ndRepositoryEntry) {
        String string = null;
        try {
            if (ndRepositoryEntry != null && (string = NdRepositorySupport.getCheckedOutUserId(ndRepositoryEntry)) == null) {
                string = NdRepositorySupport.getCreationUserId(ndRepositoryEntry);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            // empty catch block
        }
        return NdBaseObject.areEqual((Object)this.getUser(), (Object)string);
    }

    protected WjIBaeG convertEntriesToSet(NdRepositoryEntry[] ndRepositoryEntryArray, boolean bl) throws NdRepositoryException {
        int n = bl ? ndRepositoryEntryArray.length * 2 : ndRepositoryEntryArray.length;
        WjIBaeG wjIBaeG = this.createNewEntrySet(bl, n);
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            Object object = this.convertEntryToPhysicalResource(ndRepositoryEntryArray[i]);
            Object object2 = this.convertAttributesToPhysicalResource(ndRepositoryEntryArray[i]);
            wjIBaeG.WjIBaeD(ndRepositoryEntryArray[i], object, object2, i);
        }
        return wjIBaeG;
    }

    protected WjIBaeG createNewEntrySet(boolean bl, int n) {
        return new WjIBaeG(bl, n);
    }

    protected File convertLocationToFile(NdLocation ndLocation) {
        return NdScmSupport.convertLocationToFile(this.WjIATDQ, ndLocation);
    }

    protected File[] convertLocationsToFiles(NdLocation[] ndLocationArray) {
        return NdScmSupport.convertLocationsToFiles(this.WjIATDQ, ndLocationArray);
    }

    protected NdLocation convertFileToLocation(File file) {
        return NdScmSupport.convertFileToLocation(this.WjIATDQ, file);
    }

    protected String previousVersionId(String string) throws NdRepositoryException {
        int n;
        int n2;
        for (n2 = n = string.length() - 1; n2 >= 0 && Character.isDigit(string.charAt(n2)); --n2) {
        }
        if (n2 < 0) {
            try {
                Integer n3 = Integer.valueOf(string);
                int n4 = n3 - 1;
                return Integer.toString(n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NdRepositoryException(NdStrings.WjIAZvM("PreviousVersionIdError", string));
            }
        }
        if (n2 == n) {
            throw new NdRepositoryException(NdStrings.WjIAZvM("PreviousVersionIdError", string));
        }
        String string2 = string.substring(0, n2 + 1);
        String string3 = string.substring(n2 + 1);
        try {
            Integer n5 = Integer.valueOf(string3);
            int n6 = n5 - 1;
            return string2 + Integer.toString(n6);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NdRepositoryException(NdStrings.WjIAZvM("PreviousVersionIdError", string));
        }
    }

    protected NdRepositoryVersionHistory findVersionById(String string, NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray) {
        return null;
    }

    public void fireEvent(String string, boolean bl, int n) {
        File file = new File(string);
        File file2 = new File(this.getRepositoryPath());
        Vector<String> vector = new Vector<String>();
        while (!file2.equals(file)) {
            vector.insertElementAt(file.getName(), 0);
            file = file.getParentFile();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        NdLocation ndLocation = NdLocationFactory.createLocation((String[])objectArray, true);
        this.fireEvent(ndLocation, bl, n);
    }

    public void fireEvent(NdLocation ndLocation, boolean bl, int n) {
        NdWorkspaceVersionManagerEvent ndWorkspaceVersionManagerEvent = new NdWorkspaceVersionManagerEvent(this, ndLocation, bl, n);
        Object[] objectArray = new NdWorkspaceVersionManagerListener[this.WjIATCP.size()];
        this.WjIATCP.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].onWorkspaceVersionManagerEvent(ndWorkspaceVersionManagerEvent);
        }
    }

    public NdRepository getRepository() {
        return this.WjIATBO;
    }

    protected void trace(String string) {
        if (WjIATMZ) {
            WjIATLY.fine(string);
        }
    }

    protected boolean isTracingEnabled() {
        return WjIATMZ;
    }

    static {
        Object object;
        WjIOZpN = true;
        WjIUVCJ = new NdRepositoryVersionHistory[0];
        WjIATLY = NdNamedLogManager.getInstance().getLogger("SCMWorkspaceVersionManager");
        WjIATMZ = false;
        if (NdSystemProperties.isDebugModeEnabled()) {
            object = NdLogLevel.OFF;
            String string = NdSystemProperties.getSystemProperty((String)"nd.debugLogLevel");
            if (string != null) {
                try {
                    object = NdLogLevel.parse((String)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            WjIATLY.setLevel((NdLogLevel)object);
            WjIATMZ = true;
            ((NdConsoleLogHandler)WjIATLY.getHandlers()[0]).setStdOut(false);
            ((NdConsoleLogHandler)WjIATLY.getHandlers()[0]).setFormat("{4,choice,0#|1#[{5}]} - {6}");
        } else {
            WjIATLY.setLevel(NdLogLevel.OFF);
        }
        object = NdSystemProperties.getSystemProperty((String)"nd.versionManager.ancestralHistory");
        if (object != null && ((String)object).length() > 0) {
            WjIOZpN = new Boolean((String)object);
        }
    }

    private static class WjIOrVT
    extends NdContemporaryWorkspaceItemLoadingStrategy {
        private NdScmWorkspaceVersionManager WjIOrUS;

        public WjIOrVT(NdScmWorkspaceVersionManager ndScmWorkspaceVersionManager) {
            this.WjIOrUS = ndScmWorkspaceVersionManager;
        }

        protected NdRepositoryVersionHistory[] getAncestralHistory(NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, NdWorkspaceItem ndWorkspaceItem, NdLocation ndLocation) throws NdRepositoryException {
            return this.WjIOrUS.getAncestralHistories(ndWorkspaceItemLoadingContext, ndWorkspaceItem, ndLocation);
        }

        protected NdRepositoryVersionHistory findVersion(String string, NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray) {
            NdRepositoryVersionHistory ndRepositoryVersionHistory = this.WjIOrUS.findVersionById(string, ndRepositoryVersionHistoryArray);
            if (ndRepositoryVersionHistory != null) {
                return ndRepositoryVersionHistory;
            }
            return super.findVersion(string, ndRepositoryVersionHistoryArray);
        }
    }

    protected static class WjIAVlK {
        public NdWorkspaceEntry WjIAVlD;
        public Object WjIAVlE;
        public Object WjIAVlF;
        public int WjIAVlG;
        public boolean WjIAVlH;
        public boolean WjIAVlI;
        public boolean WjIAVlJ;

        protected WjIAVlK() {
        }
    }

    protected static class WjIBaeG {
        public Set WjIAZKG = new HashSet();
        private Map WjIAZLH;
        private Map WjIAZMI;
        private ArrayList WjIAZNJ;
        private boolean WjIAZOK;
        private boolean WjIAZPL;
        private boolean WjIBVaU;
        private boolean WjIAZQM;
        private boolean WjIAZRN;

        public WjIBaeG() {
            this(false, 10);
        }

        public WjIBaeG(boolean bl, int n) {
            this.WjIAZNJ = new ArrayList(n);
            this.WjIAZLH = new HashMap(n);
            this.WjIAZMI = new HashMap(n);
            this.WjIAZOK = bl;
        }

        public void WjIAZSO(boolean bl) {
            this.WjIAZPL = bl;
        }

        public void WjIBVbV(boolean bl) {
            this.WjIBVaU = bl;
        }

        public void WjIBQXB(final boolean bl) {
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    int n;
                    int n2;
                    WjIAVlK wjIAVlK = (WjIAVlK)object;
                    WjIAVlK wjIAVlK2 = (WjIAVlK)object2;
                    try {
                        n2 = wjIAVlK.WjIAVlD.getLocation().getComponentLength();
                        n = wjIAVlK2.WjIAVlD.getLocation().getComponentLength();
                    }
                    catch (Exception exception) {
                        n2 = 0;
                        n = 0;
                    }
                    if (bl) {
                        return n2 - n;
                    }
                    return n - n2;
                }
            };
            Collections.sort(this.WjIAZNJ, comparator);
        }

        public boolean WjIAZTP() {
            return this.WjIAZRN;
        }

        public boolean WjIAZUQ() {
            return this.WjIAZQM;
        }

        public List WjIAZVR() {
            return this.WjIAZWS(false, false, false);
        }

        public List WjIAZWS(boolean bl, boolean bl2, boolean bl3) {
            int n = this.WjIAZLH.size();
            ArrayList arrayList = new ArrayList(n);
            this.WjIAZZV(arrayList, bl, bl2, bl3);
            return arrayList;
        }

        public void WjIAZXT(List list) {
            this.WjIAZZV(list, true, true, false);
        }

        public List WjIAZYU() {
            List list = this.WjIAZWS(false, false, false);
            this.WjIAZKG.removeAll(list);
            list.addAll(this.WjIAZKG);
            return list;
        }

        public void WjIAZZV(List list, boolean bl, boolean bl2, boolean bl3) {
            HashSet<Object> hashSet = new HashSet<Object>(this.WjIAZNJ.size() * 2, 1.0f);
            Iterator iterator = this.WjIAZNJ.iterator();
            while (iterator.hasNext()) {
                WjIAVlK wjIAVlK = (WjIAVlK)iterator.next();
                if (wjIAVlK.WjIAVlH && !bl || wjIAVlK.WjIAVlI && !bl2 || !wjIAVlK.WjIAVlH && !wjIAVlK.WjIAVlI && bl3) continue;
                if (wjIAVlK.WjIAVlJ) {
                    if (this.WjIBVaU) continue;
                    if (this.WjIAZPL && !hashSet.contains(wjIAVlK.WjIAVlE)) {
                        list.add(wjIAVlK.WjIAVlE);
                        hashSet.add(wjIAVlK.WjIAVlE);
                    }
                    if (!this.WjIAZOK && this.WjIAZPL || hashSet.contains(wjIAVlK.WjIAVlF)) continue;
                    list.add(wjIAVlK.WjIAVlF);
                    hashSet.add(wjIAVlK.WjIAVlF);
                    continue;
                }
                if (!hashSet.contains(wjIAVlK.WjIAVlE)) {
                    list.add(wjIAVlK.WjIAVlE);
                    hashSet.add(wjIAVlK.WjIAVlE);
                }
                if (!this.WjIAZOK || hashSet.contains(wjIAVlK.WjIAVlF)) continue;
                list.add(wjIAVlK.WjIAVlF);
                hashSet.add(wjIAVlK.WjIAVlF);
            }
        }

        public WjIAVlK[] WjIBaaW() {
            return this.WjIAZNJ.toArray(new WjIAVlK[this.WjIAZNJ.size()]);
        }

        public WjIAVlK WjIBabX(int n) {
            return (WjIAVlK)this.WjIAZNJ.get(n);
        }

        public WjIAVlK WjIBacY(NdRepositoryEntry ndRepositoryEntry) {
            return (WjIAVlK)this.WjIAZMI.get(ndRepositoryEntry);
        }

        public Object WjIBadZ(int n) {
            WjIAVlK wjIAVlK = this.WjIBabX(n);
            if (wjIAVlK == null) {
                return null;
            }
            if (wjIAVlK.WjIAVlJ) {
                if (this.WjIAZPL) {
                    return wjIAVlK.WjIAVlE;
                }
                return wjIAVlK.WjIAVlF;
            }
            return wjIAVlK.WjIAVlE;
        }

        public NdWorkspaceEntry WjJCfbN(Object object) {
            WjIAVlK wjIAVlK = (WjIAVlK)this.WjIAZLH.get(object);
            return wjIAVlK.WjIAVlD;
        }

        public int WjIBaeA(Object object) {
            WjIAVlK wjIAVlK = (WjIAVlK)this.WjIAZLH.get(object);
            if (wjIAVlK != null) {
                return wjIAVlK.WjIAVlG;
            }
            return -1;
        }

        public void WjIBaeB(List list) {
            this.WjIAZKG.addAll(list);
        }

        public void WjIBaeC(Object object) {
            this.WjIAZKG.add(object);
        }

        public void WjIBaeD(NdRepositoryEntry ndRepositoryEntry, Object object, Object object2, int n) {
            WjIAVlK wjIAVlK = new WjIAVlK();
            wjIAVlK.WjIAVlD = (NdWorkspaceEntry)ndRepositoryEntry;
            wjIAVlK.WjIAVlE = object;
            wjIAVlK.WjIAVlF = object2;
            wjIAVlK.WjIAVlG = n;
            wjIAVlK.WjIAVlJ = ndRepositoryEntry instanceof NdRepositoryDirectory;
            this.WjIAZNJ.add(wjIAVlK);
            this.WjIAZLH.put(object, wjIAVlK);
            this.WjIAZMI.put(ndRepositoryEntry, wjIAVlK);
            this.WjIAZLH.put(object2, wjIAVlK);
            if (this.WjIBaeE(ndRepositoryEntry)) {
                this.WjIAZRN = true;
                wjIAVlK.WjIAVlI = true;
            } else if (this.WjIBaeF(ndRepositoryEntry)) {
                this.WjIAZQM = true;
                wjIAVlK.WjIAVlH = true;
            }
        }

        boolean WjIBaeE(NdRepositoryEntry ndRepositoryEntry) {
            return ((NdWorkspaceEntry)ndRepositoryEntry).isMarkedForDeletion();
        }

        boolean WjIBaeF(NdRepositoryEntry ndRepositoryEntry) {
            try {
                return ((NdWorkspaceEntry)ndRepositoryEntry).isMarkedForAddition();
            }
            catch (NdRepositoryException ndRepositoryException) {
                return false;
            }
        }
    }
}

