/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.ct;

import com.blazesoft.repository.scm.NdDefScmCommand;
import com.blazesoft.repository.scm.NdDefScmCommandClient;
import com.blazesoft.repository.scm.NdScmCommand;
import com.blazesoft.repository.scm.ct.NdLockInfoCommand;
import com.blazesoft.repository.scm.ct.NdLsCommand;
import com.blazesoft.repository.scm.ct.NdStatusCommand;
import com.blazesoft.repository.scm.ct.NdUpdateCommand;
import java.io.File;
import java.util.Map;

public class NdCleartoolClient
extends NdDefScmCommandClient {
    public NdCleartoolClient() {
        super("cleartool");
    }

    public boolean hasBaselineFolderSupport() {
        return true;
    }

    public NdScmCommand getCancelCheckOutCommand(File[] fileArray) {
        NdDefScmCommand ndDefScmCommand = new NdDefScmCommand("uncheckout");
        ndDefScmCommand.addArgument("-rm");
        ndDefScmCommand.initializeCommand(fileArray);
        ndDefScmCommand.setIgnoreErrorsWith(new String[]{"cleartool: Warning:", "A separate update"});
        return ndDefScmCommand;
    }

    public NdScmCommand getCheckInCommand(File[] fileArray, String string) {
        NdDefScmCommand ndDefScmCommand = new NdDefScmCommand("checkin");
        ndDefScmCommand.addArgument("-identical");
        ndDefScmCommand.addArgument("-comment");
        ndDefScmCommand.addArgument("\"" + string + "\"");
        ndDefScmCommand.initializeCommand(fileArray, string);
        return ndDefScmCommand;
    }

    public NdScmCommand getVersionControlCommand(File[] fileArray, String string) {
        NdDefScmCommand ndDefScmCommand = new NdDefScmCommand("mkelem");
        if (fileArray.length == 1) {
            if (fileArray[0].isDirectory()) {
                ndDefScmCommand.addArgument("-nco");
            } else {
                ndDefScmCommand.addArgument("-ci");
            }
        } else {
            ndDefScmCommand.addArgument("-ci");
        }
        ndDefScmCommand.addArgument("-c");
        ndDefScmCommand.addArgument("\"" + string + "\"");
        ndDefScmCommand.initializeCommand(fileArray);
        return ndDefScmCommand;
    }

    public NdScmCommand getIsVersionedCommand(File file) {
        NdLsCommand ndLsCommand = new NdLsCommand(file, false);
        ndLsCommand.initializeCommand(file);
        return ndLsCommand;
    }

    public NdScmCommand getIsCheckedOutCommand(File file) {
        NdLsCommand ndLsCommand = new NdLsCommand(file, true);
        ndLsCommand.initializeCommand(file);
        return ndLsCommand;
    }

    public NdScmCommand getCheckOutCommand(File[] fileArray) {
        NdDefScmCommand ndDefScmCommand = new NdDefScmCommand("checkout");
        ndDefScmCommand.addArgument("-ncomment");
        ndDefScmCommand.initializeCommand(fileArray);
        return ndDefScmCommand;
    }

    public NdScmCommand getDeleteCommand(File[] fileArray) {
        NdDefScmCommand ndDefScmCommand = new NdDefScmCommand("rmname");
        ndDefScmCommand.addArgument("-force");
        ndDefScmCommand.initializeCommand(fileArray);
        return ndDefScmCommand;
    }

    public NdScmCommand getCancelDeleteCommand(File[] fileArray) {
        NdDefScmCommand ndDefScmCommand = new NdDefScmCommand("ln");
        ndDefScmCommand.initializeCommand(fileArray);
        return ndDefScmCommand;
    }

    public NdScmCommand getEntryLockInfosCommand(File[] fileArray, Map map) {
        NdLockInfoCommand ndLockInfoCommand = new NdLockInfoCommand();
        ndLockInfoCommand.initializeCommand(fileArray, map);
        return ndLockInfoCommand;
    }

    public NdScmCommand getHistoriesCommand(File[] fileArray, Map map) {
        return super.getHistoriesCommand(fileArray, map);
    }

    public NdScmCommand getStatusInfosCommand(File[] fileArray, Map map) {
        NdStatusCommand ndStatusCommand = new NdStatusCommand();
        ndStatusCommand.initializeCommand(fileArray, map);
        return ndStatusCommand;
    }

    public NdScmCommand getUpdateCommand(File[] fileArray) {
        NdUpdateCommand ndUpdateCommand = new NdUpdateCommand();
        ndUpdateCommand.initializeCommand(fileArray);
        return ndUpdateCommand;
    }

    public NdScmCommand getUpdateLocationCommand(File file, boolean bl) {
        NdUpdateCommand ndUpdateCommand = new NdUpdateCommand();
        ndUpdateCommand.initializeCommand(file);
        return ndUpdateCommand;
    }

    public NdScmCommand getContentByVersionCommand(File file, String string) {
        return super.getContentByVersionCommand(file, string);
    }
}

