/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.subversion;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdRepositoryVersionScmConnectionException;
import com.blazesoft.repository.base.NdVersioningSystemEntry;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.scm.NdFileScmVersioningSystemVersionManager;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmSupport;
import com.blazesoft.repository.scm.subversion.NdStrings;
import com.blazesoft.repository.scm.subversion.NdSvnWorkspaceVersionManager;
import com.blazesoft.security.NdAccessController;
import com.blazesoft.security.NdPrivilegedExceptionAction;
import com.blazesoft.util.NdProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class NdSvnVersionSystemVersionManager
extends NdFileScmVersioningSystemVersionManager {
    public NdSvnVersionSystemVersionManager(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        super(ndScmServerConnection);
    }

    protected boolean isEntryVersioned(NdLocation ndLocation) throws NdRepositoryException {
        NdWorkspaceVersionManager ndWorkspaceVersionManager = ((NdWorkspace)this.getRepository()).getWorkspaceVersionManager();
        return ndWorkspaceVersionManager.isVersioned(ndLocation, true);
    }

    public NdVersioningSystemEntry[] getServerEntries(File file) throws NdRepositoryException {
        DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions((boolean)true);
        String string = this.WjJrMGC();
        SVNClientManager sVNClientManager = SVNClientManager.newInstance((DefaultSVNOptions)defaultSVNOptions, (String)this.getConnection().getUser(), (String)string);
        int n = 17;
        final Vector vector = new Vector();
        ISVNDirEntryHandler iSVNDirEntryHandler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry sVNDirEntry) throws SVNException {
                if (!sVNDirEntry.getName().endsWith(".innovator_attbs")) {
                    vector.addElement(sVNDirEntry);
                }
            }
        };
        try {
            sVNClientManager.getLogClient().doList(file, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, n, iSVNDirEntryHandler);
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (sVNErrorCode != null && sVNErrorCode == SVNErrorCode.FS_NOT_FOUND) {
                throw new NdRepositoryException(NdStrings.WjIBbNT("ScmServerDirectoryDeleted"), sVNException);
            }
            throw new NdRepositoryException(sVNException);
        }
        Object[] objectArray = new SVNDirEntry[vector.size()];
        vector.copyInto(objectArray);
        NdVersioningSystemEntry[] ndVersioningSystemEntryArray = new NdVersioningSystemEntry[objectArray.length - 1];
        for (int i = 0; i < ndVersioningSystemEntryArray.length; ++i) {
            ndVersioningSystemEntryArray[i] = new NdVersioningSystemEntry(objectArray[i + 1].getName(), objectArray[i + 1].getKind() == SVNNodeKind.DIR, false);
        }
        return ndVersioningSystemEntryArray;
    }

    public NdRepositoryVersionResultSet[] getStatusInfos(Object[] objectArray) throws NdRepositoryException {
        NdSvnWorkspaceVersionManager ndSvnWorkspaceVersionManager = new NdSvnWorkspaceVersionManager(this.getRepository());
        ndSvnWorkspaceVersionManager.openConnection(this.getConnection());
        File[] fileArray = new File[objectArray.length];
        NdRepositoryVersionResultSet[] ndRepositoryVersionResultSetArray = new NdRepositoryVersionResultSet[fileArray.length];
        HashMap<File, NdRepositoryVersionResultSet> hashMap = new HashMap<File, NdRepositoryVersionResultSet>();
        for (int i = 0; i < ndRepositoryVersionResultSetArray.length; ++i) {
            fileArray[i] = this.convertLocationToFile((NdLocation)objectArray[i]);
            ndRepositoryVersionResultSetArray[i] = new NdRepositoryVersionResultSet();
            ndRepositoryVersionResultSetArray[i].setLocation((NdLocation)objectArray[i]);
            hashMap.put(fileArray[i], ndRepositoryVersionResultSetArray[i]);
        }
        ndSvnWorkspaceVersionManager.getStatusInfos(fileArray, hashMap);
        ndSvnWorkspaceVersionManager.closeConnection();
        return ndRepositoryVersionResultSetArray;
    }

    public String getContent(File file) throws NdRepositoryException {
        DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions((boolean)true);
        String string = this.WjJrMGC();
        SVNClientManager sVNClientManager = SVNClientManager.newInstance((DefaultSVNOptions)defaultSVNOptions, (String)this.getConnection().getUser(), (String)string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string2 = file.getAbsolutePath();
        string2 = string2.substring(this.getRepositoryPath().length() + 1);
        try {
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.getConnection().getServerUrl());
            sVNURL = sVNURL.appendPath(this.getConnection().getRepositoryName(), false);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.separator);
            while (stringTokenizer.hasMoreElements()) {
                sVNURL = sVNURL.appendPath((String)stringTokenizer.nextElement(), false);
            }
            sVNClientManager.getWCClient().doGetFileContents(sVNURL, SVNRevision.HEAD, SVNRevision.HEAD, true, (OutputStream)byteArrayOutputStream);
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
        return byteArrayOutputStream.toString();
    }

    private String WjJrMGC() throws NdRepositoryException {
        String string = this.getConnection().getPassword();
        if (string != null && string.length() > 0) {
            try {
                final String string2 = string;
                string = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return NdRepositorySupport.decryptPassword(NdSvnVersionSystemVersionManager.this.getConnection(), string2);
                    }
                });
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        }
        return string;
    }

    public NdRepositoryEntryAttribute[] getAttributes(File file) throws NdRepositoryException {
        Object[] objectArray;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        String string = file.getAbsolutePath();
        File file2 = new File(string + ".innovator_attbs");
        String string2 = this.getContent(file2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        NdProperties ndProperties = new NdProperties();
        try {
            ndProperties.load((InputStream)byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        Enumeration enumeration = ndProperties.keys();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string3 = ndProperties.getProperty((String)objectArray);
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute((String)objectArray, string3);
            vector.addElement(ndRepositoryEntryAttribute);
        }
        objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void verifyConnection() throws NdRepositoryVersionScmConnectionException {
        DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions((boolean)true);
        try {
            String string = this.WjJrMGC();
            SVNClientManager sVNClientManager = SVNClientManager.newInstance((DefaultSVNOptions)defaultSVNOptions, (String)this.getConnection().getUser(), (String)string);
            final SVNStatus[] sVNStatusArray = new SVNStatus[1];
            ISVNStatusHandler iSVNStatusHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus sVNStatus) {
                    sVNStatusArray[0] = sVNStatus;
                }
            };
            sVNClientManager.getStatusClient().doStatus(new File(NdScmSupport.getWorkspacePath(this.getRepository()), "com_blazesoft_repository_config.cfg"), SVNRevision.HEAD, false, true, true, false, false, iSVNStatusHandler);
        }
        catch (Exception exception) {
            throw new NdRepositoryVersionScmConnectionException(NdStrings.WjIBbNV("ScmServerConnectionCouldNotBeEstablishedFor", this.getConnection().getServerUrl()), exception);
        }
    }

    static {
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        DAVRepositoryFactory.setup();
    }
}

