/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.subversion;

import com.blazesoft.repository.base.NdDefaultRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionNameConflictException;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdRepositoryVersionScmConnectionException;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.scm.NdFileScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmSupport;
import com.blazesoft.repository.scm.subversion.NdStrings;
import com.blazesoft.security.NdAccessController;
import com.blazesoft.security.NdPrivilegedExceptionAction;
import com.blazesoft.util.NdSystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class NdSvnWorkspaceVersionManager
extends NdFileScmWorkspaceVersionManager {
    private SVNClientManager WjIBbhV;
    private DefaultSVNOptions WjIHJvN;
    private String WjIHJvO;
    private NdScmServerConnection WjIPyrM;
    private String WjJyyCZ = ".svn";
    private ArrayList WjJBnbW;

    public NdSvnWorkspaceVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        super(ndRepository);
    }

    public void openConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIHJvN = SVNWCUtil.createDefaultOptions((boolean)true);
        this.WjIHJvN.setAuthStorageEnabled(false);
        this.WjIPyrM = ndScmServerConnection;
        String string = this.WjJrLhZ();
        BasicAuthenticationManager basicAuthenticationManager = new BasicAuthenticationManager(ndScmServerConnection.getUser(), string);
        basicAuthenticationManager.setAuthenticationForced(true);
        this.WjIBbhV = SVNClientManager.newInstance((ISVNOptions)this.WjIHJvN, (ISVNAuthenticationManager)basicAuthenticationManager);
        if (NdSystemProperties.isInitializeSvnRepositoryServerUrl()) {
            this.WjIHJvP();
        }
        try {
            this.verifyConnection();
        }
        catch (NdRepositoryVersionScmConnectionException ndRepositoryVersionScmConnectionException) {
            if (ndRepositoryVersionScmConnectionException.getSourceThrowable() instanceof SVNAuthenticationException) {
                throw new NdRepositoryException(NdStrings.WjIBbNV("SVNAuthenticationFailedFor", ndScmServerConnection.getUser()), ndRepositoryVersionScmConnectionException.getSourceThrowable());
            }
            throw ndRepositoryVersionScmConnectionException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyConnection() throws NdRepositoryVersionScmConnectionException {
        block7: {
            if (NdSystemProperties.isInitializeSvnRepositoryServerUrl()) {
                this.WjIHJvP();
            }
            try {
                final SVNStatus[] sVNStatusArray = new SVNStatus[1];
                ISVNStatusHandler iSVNStatusHandler = new ISVNStatusHandler(){

                    public void handleStatus(SVNStatus sVNStatus) {
                        sVNStatusArray[0] = sVNStatus;
                    }
                };
                SVNClientManager sVNClientManager = this.WjIBbhV;
                synchronized (sVNClientManager) {
                    this.WjIBbhV.getStatusClient().doStatus(new File(NdScmSupport.getWorkspacePath(this.getRepository()), "com_blazesoft_repository_config.cfg"), SVNRevision.HEAD, false, true, true, false, false, iSVNStatusHandler);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof SVNException)) break block7;
                SVNException sVNException = (SVNException)((Object)exception);
                if (exception instanceof SVNAuthenticationException) {
                    throw new NdRepositoryVersionScmConnectionException(exception);
                }
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_SVN_CONNECTION_CLOSED && sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_SVN_IO_ERROR && sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_AUTHORIZED) break block7;
                throw new NdRepositoryVersionScmConnectionException(NdStrings.WjIBbNV("ScmServerConnectionCouldNotBeEstablishedFor", this.getServerUrl()), exception);
            }
        }
    }

    private void WjIHJvP() throws NdRepositoryVersionScmConnectionException {
        try {
            SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
            File file = new File(NdScmSupport.getWorkspacePath(this.getRepository()));
            if (file.getName().equals(this.getRepositoryName())) {
                SVNAdminArea sVNAdminArea = sVNWCAccess.probeOpen(file.getParentFile(), false, 0);
                SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file.getParentFile(), false);
                this.WjIHJvO = sVNEntry.getURL();
                if (sVNAdminArea != null) {
                    sVNWCAccess.closeAdminArea(sVNAdminArea.getRoot());
                }
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw new NdRepositoryVersionScmConnectionException((Throwable)((Object)ndRepositoryException));
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryVersionScmConnectionException(sVNException);
        }
    }

    public String getServerUrl() {
        return this.WjIHJvO != null ? this.WjIHJvO : super.getServerUrl();
    }

    public void closeConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        if (this.WjIBbhV != null) {
            this.WjIBbhV.dispose();
            this.WjIBbhV = null;
        }
        this.WjIHJvO = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCheckOut(File[] fileArray) throws NdRepositoryException {
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                this.WjIBbhV.getWCClient().doUnlock(fileArray, false);
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) continue;
                    fileArray[i].delete();
                }
                this.update(fileArray);
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIn(File[] fileArray, String string) throws NdRepositoryException {
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                this.WjIBbhV.getCommitClient().doCommit(fileArray, false, string, null, null, false, true, SVNDepth.fromRecurse((boolean)false));
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            if (sVNException.getErrorMessage().getErrorCode().getCode() == SVNErrorCode.FS_ALREADY_EXISTS.getCode()) {
                NdRepositoryEntry ndRepositoryEntry = null;
                Object[] objectArray = sVNException.getErrorMessage().getChildErrorMessage().getRelatedObjects();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2;
                    int n;
                    if (!(objectArray[i] instanceof String) || (n = (string2 = (String)objectArray[i]).indexOf(this.WjIPyrM.getRepositoryName())) <= 0) continue;
                    String string3 = string2.substring(n + this.WjIPyrM.getRepositoryName().length());
                    NdLocation ndLocation = NdLocationFactory.createLocation(string3);
                    ndRepositoryEntry = NdScmSupport.lookupEntry(this.getRepository(), ndLocation);
                    break;
                }
                if (ndRepositoryEntry != null) {
                    throw new NdRepositoryVersionNameConflictException(NdStrings.WjIBbNT("CheckinFailedDueToConflictingEntries"), new NdRepositoryEntry[]{ndRepositoryEntry});
                }
                if (sVNException.getErrorMessage().hasChildErrorMessage()) {
                    String string4 = sVNException.getErrorMessage().getChildErrorMessage().getMessage();
                    throw new NdRepositoryVersionNameConflictException(NdStrings.WjIBbNT("CheckinFailedDueToConflictingEntries") + string4, new NdRepositoryEntry[0]);
                }
                throw new NdRepositoryVersionNameConflictException(NdStrings.WjIBbNT("CheckinFailedDueToConflictingEntries") + sVNException.getErrorMessage(), new NdRepositoryEntry[0]);
            }
            throw new NdRepositoryException(sVNException);
        }
    }

    protected void internalProcessNameConflictEntries(Object[] objectArray) throws NdRepositoryException {
        File[] fileArray = new File[objectArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = (File)objectArray[i];
        }
        this.WjJLklD(fileArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List doVersionControl(File[] fileArray, String string) throws NdRepositoryException {
        this.WjJBnbW = new ArrayList();
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.isVersioned(fileArray[i])) continue;
            try {
                this.trace("doAdd: " + fileArray[i]);
                SVNClientManager sVNClientManager = this.WjIBbhV;
                synchronized (sVNClientManager) {
                    this.WjIBbhV.getWCClient().doAdd(fileArray[i], false, false, false, false);
                    continue;
                }
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode().getCode() == SVNErrorCode.ENTRY_EXISTS.getCode() || sVNException.getErrorMessage().getErrorCode().getCode() == SVNErrorCode.FS_ALREADY_EXISTS.getCode()) {
                    this.WjJBnbW.add(fileArray[i]);
                    continue;
                }
                throw new NdRepositoryException(sVNException);
            }
        }
        if (this.WjJBnbW.size() > 0) {
            return this.WjJBnbW;
        }
        return null;
    }

    public ArrayList getDuplicateEntries() {
        return this.WjJBnbW;
    }

    public boolean isFeatureSupported(int n) {
        switch (n) {
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVersioned(File file) throws NdRepositoryException {
        this.trace("isControlled: " + file);
        try {
            boolean bl;
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                if (file.isDirectory() && (bl = SVNWCUtil.isVersionedDirectory((File)file))) {
                    SVNStatus sVNStatus = this.WjIBbhV.getStatusClient().doStatus(file, false);
                    if (sVNStatus == null) {
                        return false;
                    }
                    if (sVNStatus.getNodeStatus() != SVNStatusType.STATUS_ADDED) {
                        this.trace("isControlled: " + file + " " + bl);
                        return bl;
                    }
                    return false;
                }
                SVNStatus sVNStatus = this.WjIBbhV.getStatusClient().doStatus(file, false);
                bl = sVNStatus == null ? false : sVNStatus.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED && sVNStatus.getContentsStatus() != SVNStatusType.STATUS_NONE;
                this.trace("isControlled: " + file + " " + bl);
            }
            return bl;
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckedOut(File file) throws NdRepositoryException {
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                SVNStatus sVNStatus = this.WjIBbhV.getStatusClient().doStatus(file, false);
                return sVNStatus.getLocalLock() != null;
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOut(File[] fileArray) throws NdRepositoryException {
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.trace("checkOut: " + fileArray[i]);
                }
                this.WjIBbhV.getWCClient().doLock(fileArray, false, NdStrings.WjIBbNV("CheckoutMessage", this.getUser()));
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            this.trace("Error: " + sVNException.getMessage());
            throw new NdRepositoryException(sVNException);
        }
    }

    public void delete(File[] fileArray) throws NdRepositoryException {
        this.WjJLklD(fileArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WjJLklD(File[] fileArray, boolean bl) throws NdRepositoryException {
        boolean bl2 = false;
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.trace("delete: " + fileArray[i]);
                    if (fileArray[i].isDirectory() && !bl) {
                        bl2 = true;
                        this.update(new File[]{fileArray[i]});
                    }
                    if (bl) {
                        this.WjIBbhV.getWCClient().doDelete(fileArray[i], true, false, false);
                        continue;
                    }
                    this.WjIBbhV.getWCClient().doDelete(fileArray[i], true, true, false);
                }
                if (bl) {
                    try {
                        SVNCommitPacket sVNCommitPacket = this.WjIBbhV.getCommitClient().doCollectCommitItems(fileArray, false, false, null, null);
                        this.WjIBbhV.getCommitClient().doCommit(sVNCommitPacket, false, "delete");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl2 && !bl) {
                    this.WjIBbhV.getCommitClient().setCommitParameters((ISVNCommitParameters)new DefaultSVNCommitParameters(){

                        public ISVNCommitParameters.Action onMissingFile(File file) {
                            return DELETE;
                        }

                        public ISVNCommitParameters.Action onMissingDirectory(File file) {
                            return DELETE;
                        }
                    });
                    this.WjIBbhV.getCommitClient().doCommit(fileArray, false, "", null, null, false, false, SVNDepth.fromRecurse((boolean)true));
                }
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            this.trace("Error: " + sVNException.getMessage());
            throw new NdRepositoryException(sVNException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDelete(File[] fileArray) throws NdRepositoryException {
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.trace("cancel-delete: " + fileArray[i]);
                    this.WjIBbhV.getWCClient().doRevert(fileArray[i], false);
                }
                this.WjIBbhV.getWCClient().doUnlock(fileArray, false);
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            this.trace("Error: " + sVNException.getMessage());
            throw new NdRepositoryException(sVNException);
        }
    }

    public void getEntryLockInfos(File[] fileArray, Map map) throws NdRepositoryException {
        try {
            HashMap hashMap = this.WjIPysN(fileArray);
            for (int i = 0; i < fileArray.length; ++i) {
                SVNStatus sVNStatus = (SVNStatus)hashMap.get(fileArray[i].getAbsolutePath());
                if (sVNStatus == null) continue;
                NdDefaultRepositoryEntryLockInfo ndDefaultRepositoryEntryLockInfo = (NdDefaultRepositoryEntryLockInfo)map.get(fileArray[i]);
                SVNLock sVNLock = sVNStatus.getLocalLock();
                SVNLock sVNLock2 = sVNStatus.getRemoteLock();
                if (sVNLock != null && sVNLock2 != null) {
                    ndDefaultRepositoryEntryLockInfo.setUserId(this.getUser());
                    ndDefaultRepositoryEntryLockInfo.setLockStatus(2);
                    ndDefaultRepositoryEntryLockInfo.setLockTime(sVNLock.getCreationDate());
                    continue;
                }
                if (sVNLock2 == null) continue;
                ndDefaultRepositoryEntryLockInfo.setUserId(sVNLock2.getOwner());
                if (this.getUser().equals(sVNLock2.getOwner())) {
                    ndDefaultRepositoryEntryLockInfo.setLockStatus(3);
                } else {
                    ndDefaultRepositoryEntryLockInfo.setLockStatus(4);
                }
                ndDefaultRepositoryEntryLockInfo.setLockTime(sVNLock2.getCreationDate());
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
    }

    public void getHistories(File[] fileArray, Map map) throws NdRepositoryException {
        this.WjJzlPH(fileArray, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void WjJzlOG(File[] fileArray, Map map, File file) throws NdRepositoryException {
        try {
            Object object;
            Object object2;
            String string;
            for (int i = 0; i < fileArray.length; ++i) {
                this.trace("history-request: " + fileArray[i]);
            }
            String[] stringArray = this.getWorkspacePaths(fileArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.trace("history-request-paths: " + stringArray[i]);
            }
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.getServerUrl());
            this.trace("Svn URL: " + sVNURL.toString());
            final String string2 = this.WjIPyrM.getRepositoryName();
            final HashMap hashMap = new HashMap();
            final HashMap hashMap2 = new HashMap();
            String string3 = stringArray[0];
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            final String string4 = string3;
            int n = string3.lastIndexOf(".innovator_attbs");
            final String string5 = string3 = string3.substring(0, n);
            ISVNLogEntryHandler iSVNLogEntryHandler = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry sVNLogEntry) {
                    Set set = sVNLogEntry.getChangedPaths().keySet();
                    for (String string : set) {
                        int n;
                        ArrayList arrayList = null;
                        NdSvnWorkspaceVersionManager.this.trace("log-path: " + string);
                        NdSvnWorkspaceVersionManager.this.trace("log-entry: " + sVNLogEntry.getRevision() + ": " + sVNLogEntry.getMessage());
                        if (string.endsWith(string4)) {
                            if (set.contains(string5)) {
                                NdSvnWorkspaceVersionManager.this.trace("logged-skipped: " + string);
                                continue;
                            }
                            n = string.lastIndexOf(".innovator_attbs");
                            string = string.substring(0, n);
                        } else if (!string.endsWith(string5)) continue;
                        NdSvnWorkspaceVersionManager.this.trace("logged-as: " + string);
                        n = string.lastIndexOf("/" + string2 + "/");
                        if (n > 0) {
                            if (hashMap.get(string.substring(n)) == null) {
                                Vector<String> vector = new Vector<String>();
                                vector.addElement(string.substring(0, n));
                                hashMap.put(string.substring(n), vector);
                            } else {
                                Vector vector = (Vector)hashMap.get(string.substring(n));
                                if (!vector.contains(string.substring(0, n))) {
                                    vector.addElement(string.substring(0, n));
                                    hashMap.put(string.substring(n), vector);
                                }
                            }
                        }
                        if (hashMap2.containsKey(string)) {
                            arrayList = (ArrayList)hashMap2.get(string);
                        } else {
                            arrayList = new ArrayList();
                            hashMap2.put(string, arrayList);
                        }
                        arrayList.add(sVNLogEntry);
                        break;
                    }
                }
            };
            int n2 = 1000;
            if (NdSystemProperties.getSystemProperty((String)"MAX_SVN_HISTORY_ENTRY") != null) {
                string = NdSystemProperties.getSystemProperty((String)"MAX_SVN_HISTORY_ENTRY");
                try {
                    object2 = new Integer(string);
                    n2 = (Integer)object2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = this.WjIBbhV;
            synchronized (string) {
                try {
                    this.WjIBbhV.getLogClient().doLog(fileArray, SVNRevision.HEAD, SVNRevision.create((long)0L), SVNRevision.HEAD, false, true, (long)n2, iSVNLogEntryHandler);
                }
                catch (SVNException sVNException) {
                    this.verifyConnection();
                    object = new ArrayList<SVNRevisionRange>(1);
                    object.add(new SVNRevisionRange(SVNRevision.UNDEFINED, SVNRevision.UNDEFINED));
                    this.WjIBbhV.getLogClient().doLog(fileArray, object, SVNRevision.UNDEFINED, false, false, false, Integer.MAX_VALUE, null, iSVNLogEntryHandler);
                }
            }
            string = SVNRepositoryFactory.create((SVNURL)sVNURL, null);
            if (string.getAuthenticationManager() == null && this.WjIPyrM != null) {
                object2 = this.WjJrLhZ();
                string.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager((String)this.WjIPyrM.getUser(), (String)object2));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                Object object3;
                this.trace("history-processing-paths: " + stringArray[i]);
                object = string.getRepositoryPath(stringArray[i]);
                if (!((String)object).startsWith("/")) {
                    object = "/" + stringArray[i];
                }
                if (!string2.equals(this.getRepository().getName()) && ((String)object).startsWith("/" + this.getRepository().getName() + "/")) {
                    object = ((String)object).substring(this.getRepository().getName().length() + 1);
                }
                if (((String)object).indexOf("/" + this.WjIPyrM.getRepositoryName() + "/") < 0) {
                    object = "/" + this.WjIPyrM.getRepositoryName() + (String)object;
                }
                if (((String)object).endsWith(".innovator_attbs")) {
                    int n3 = ((String)object).lastIndexOf(".innovator_attbs");
                    object = ((String)object).substring(0, n3);
                }
                Object[] objectArray = new String[1];
                Object object4 = object;
                int n4 = ((String)object4).lastIndexOf("/" + string2 + "/");
                if (n4 > 0) {
                    object4 = ((String)object4).substring(n4);
                }
                if (!hashMap.isEmpty() && hashMap.get(object4) != null) {
                    object3 = (Vector)hashMap.get(object4);
                    objectArray = new String[((Vector)object3).size()];
                    ((Vector)object3).copyInto(objectArray);
                }
                object3 = object4;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j] != null) {
                        object3 = (String)objectArray[j] + (String)object4;
                    }
                    ArrayList arrayList = (ArrayList)hashMap2.get(object3);
                    File file2 = fileArray[i];
                    if (file != null) {
                        file2 = file;
                    }
                    ArrayList arrayList2 = (ArrayList)map.get(file2);
                    if (arrayList != null && arrayList2 != null) {
                        this.trace("history-found-matches: ");
                        for (SVNLogEntry sVNLogEntry : arrayList) {
                            SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)sVNLogEntry.getChangedPaths().get(object3);
                            if (sVNLogEntryPath == null) {
                                String string6 = (String)object3 + ".innovator_attbs";
                                sVNLogEntryPath = (SVNLogEntryPath)sVNLogEntry.getChangedPaths().get(string6);
                            }
                            char c = sVNLogEntryPath.getType();
                            arrayList2.add(0, this.createVersionHistory("" + sVNLogEntry.getRevision(), sVNLogEntry.getAuthor(), sVNLogEntry.getDate(), sVNLogEntry.getMessage(), c == 'D'));
                        }
                        continue;
                    }
                    this.trace("history-no-match: '" + arrayList + "':'" + arrayList2);
                }
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
    }

    private void WjJzlPH(File[] fileArray, Map map) throws NdRepositoryException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string;
            File file = fileArray[i];
            if (!file.getPath().endsWith(".innovator_attbs")) {
                file = new File(file.getPath() + ".innovator_attbs");
            }
            if (hashMap.containsKey(string = file.getAbsolutePath())) continue;
            this.WjJzlOG(new File[]{file}, map, fileArray[i]);
            hashMap.put(string, string);
        }
    }

    private String WjJrLhZ() throws NdRepositoryException {
        String string = this.WjIPyrM.getPassword();
        if (string != null && string.length() > 0) {
            try {
                final String string2 = string;
                string = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return NdRepositorySupport.decryptPassword(NdSvnWorkspaceVersionManager.this.WjIPyrM, string2);
                    }
                });
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        }
        return string;
    }

    boolean WjJzFiM(Vector vector, File file) {
        Object[] objectArray;
        String string = file.getPath();
        Enumeration enumeration = vector.elements();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string2 = objectArray.getPath();
            if (string.startsWith(string2)) {
                return true;
            }
            if (!string2.startsWith(string) && (file.isDirectory() || !string2.startsWith(file.getParentFile().getPath()))) continue;
            vector2.addElement(objectArray);
        }
        if (vector2.size() > 0) {
            objectArray = new File[vector2.size()];
            vector2.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                vector.removeElement(objectArray[i]);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap WjIPysN(File[] fileArray) throws SVNException, NdRepositoryVersionScmConnectionException {
        Object[] objectArray;
        final HashMap hashMap = new HashMap();
        if (fileArray.length == 1) {
            objectArray = new File[]{fileArray[0]};
        } else {
            Vector<File> vector = new Vector<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.WjJzFiM(vector, fileArray[i])) continue;
                if (fileArray[i].isDirectory()) {
                    vector.addElement(fileArray[i]);
                    continue;
                }
                vector.addElement(fileArray[i].getParentFile());
            }
            objectArray = new File[vector.size()];
            vector.copyInto(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ISVNStatusHandler iSVNStatusHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus sVNStatus) {
                    if (hashMap.get(sVNStatus.getFile().getAbsolutePath()) == null) {
                        hashMap.put(sVNStatus.getFile().getAbsolutePath(), sVNStatus);
                    }
                }
            };
            try {
                SVNClientManager sVNClientManager = this.WjIBbhV;
                synchronized (sVNClientManager) {
                    this.WjIBbhV.getStatusClient().doStatus((File)objectArray[i], SVNRevision.HEAD, true, true, true, false, false, iSVNStatusHandler);
                    continue;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SVNAuthenticationException) {
                    throw new NdRepositoryVersionScmConnectionException(NdStrings.WjIBbNV("ScmServerConnectionCouldNotBeEstablishedFor", this.getServerUrl()), exception);
                }
                if (!(exception instanceof SVNException)) continue;
                throw new SVNException(((SVNException)((Object)exception)).getErrorMessage());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNStatusType WjJjTcU(File file) throws SVNException {
        SVNStatusType sVNStatusType = null;
        SVNClientManager sVNClientManager = this.WjIBbhV;
        synchronized (sVNClientManager) {
            SVNStatus sVNStatus = this.WjIBbhV.getStatusClient().doStatus(file, true);
            if (sVNStatus != null) {
                sVNStatusType = sVNStatus.getRemoteContentsStatus();
            }
        }
        return sVNStatusType;
    }

    public void getStatusInfos(File[] fileArray, Map map) throws NdRepositoryException {
        try {
            HashMap hashMap = this.WjIPysN(fileArray);
            for (int i = 0; i < fileArray.length; ++i) {
                SVNStatus sVNStatus = (SVNStatus)hashMap.get(fileArray[i].getAbsolutePath());
                if (sVNStatus == null) continue;
                NdRepositoryVersionResultSet ndRepositoryVersionResultSet = (NdRepositoryVersionResultSet)map.get(fileArray[i]);
                SVNLock sVNLock = sVNStatus.getLocalLock();
                SVNStatusType sVNStatusType = sVNStatus.getContentsStatus();
                SVNStatusType sVNStatusType2 = sVNStatus.getRemoteContentsStatus();
                if (sVNLock != null) {
                    if (sVNStatusType == SVNStatusType.STATUS_MODIFIED) {
                        ndRepositoryVersionResultSet.setVersionStatus(this.belongsToThisUser(this.lookupEntry(ndRepositoryVersionResultSet.getLocation())) ? 3 : 4);
                    } else if (sVNStatusType == SVNStatusType.STATUS_NORMAL) {
                        ndRepositoryVersionResultSet.setVersionStatus(5);
                    }
                    ndRepositoryVersionResultSet.setCurrentVersionId("" + sVNStatus.getCommittedRevision().getNumber());
                    ndRepositoryVersionResultSet.setWorkingVersionId(ndRepositoryVersionResultSet.getCurrentVersionId());
                } else if (sVNStatusType == SVNStatusType.STATUS_ADDED) {
                    ndRepositoryVersionResultSet.setVersionStatus(this.belongsToThisUser(this.lookupEntry(ndRepositoryVersionResultSet.getLocation())) ? 1 : 2);
                } else {
                    ndRepositoryVersionResultSet.setWorkingVersionId("" + sVNStatus.getCommittedRevision().getNumber());
                    if (sVNStatusType2 == SVNStatusType.STATUS_MODIFIED) {
                        ndRepositoryVersionResultSet.setVersionStatus(7);
                        ndRepositoryVersionResultSet.setCurrentVersionId("" + sVNStatus.getRemoteRevision().getNumber());
                    } else if (sVNStatusType2 == SVNStatusType.STATUS_DELETED) {
                        if (sVNStatusType == SVNStatusType.STATUS_NORMAL) {
                            ndRepositoryVersionResultSet.setVersionStatus(7);
                        }
                        if (sVNStatus.getRemoteRevision() != null) {
                            ndRepositoryVersionResultSet.setCurrentVersionId("" + sVNStatus.getRemoteRevision().getNumber());
                        }
                        ndRepositoryVersionResultSet.setGloballyDeleted(true);
                    } else {
                        ndRepositoryVersionResultSet.setVersionStatus(5);
                        ndRepositoryVersionResultSet.setCurrentVersionId(ndRepositoryVersionResultSet.getWorkingVersionId());
                    }
                }
                int n = 1;
                String string = null;
                Date date = null;
                SVNLock sVNLock2 = sVNStatus.getRemoteLock();
                if (sVNLock != null && sVNLock2 != null) {
                    n = 2;
                    string = this.getUser();
                    date = sVNLock.getCreationDate();
                } else if (sVNLock2 != null) {
                    date = sVNLock2.getCreationDate();
                    string = sVNLock2.getOwner();
                    n = this.getUser().equals(string) ? 3 : 4;
                }
                NdDefaultRepositoryEntryLockInfo ndDefaultRepositoryEntryLockInfo = new NdDefaultRepositoryEntryLockInfo(n, string, date, ndRepositoryVersionResultSet.getLocation());
                ndRepositoryVersionResultSet.setEntryLockInfo(ndDefaultRepositoryEntryLockInfo);
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(File[] fileArray) throws NdRepositoryException {
        final ArrayList arrayList = new ArrayList();
        ISVNEventHandler iSVNEventHandler = new ISVNEventHandler(){

            public void handleEvent(SVNEvent sVNEvent, double d) throws SVNException {
                File file;
                SVNEvent sVNEvent2 = sVNEvent;
                if (sVNEvent2.getAction() == SVNEventAction.UPDATE_UPDATE && !(file = sVNEvent2.getFile()).getName().endsWith(".innovator_attbs") && !file.isDirectory()) {
                    String[] stringArray = NdSvnWorkspaceVersionManager.this.getRepositoryPaths(new File[]{file});
                    arrayList.add(stringArray[0]);
                }
            }

            public void checkCancelled() throws SVNCancelException {
            }
        };
        try {
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                for (int i = 0; i < fileArray.length; ++i) {
                    SVNUpdateClient sVNUpdateClient = this.WjIBbhV.getUpdateClient();
                    sVNUpdateClient.setEventHandler(iSVNEventHandler);
                    long l = sVNUpdateClient.doUpdate(fileArray[i], SVNRevision.HEAD, SVNDepth.fromRecurse((boolean)true), false, true);
                    this.trace("update: " + fileArray[i].getName() + " to revision: " + l);
                }
            }
            if (arrayList.size() > 0) {
                this.setUpdatedLocation(arrayList);
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(File file, boolean bl) throws NdRepositoryException {
        try {
            this.trace("updateFileLocation: " + file.getPath());
            SVNStatusType sVNStatusType = this.WjJjTcU(file);
            SVNClientManager sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                if (file.isDirectory() && sVNStatusType == SVNStatusType.STATUS_DELETED) {
                    Vector vector = new Vector();
                    File file2 = this.WjJpkhI(file, vector);
                    this.WjJpkhJ(file, vector);
                    if (this.WjJpExA(vector)) {
                        this.WjIBbhV.getUpdateClient().doUpdate(file2, SVNRevision.HEAD, SVNDepth.INFINITY, true, true);
                        this.WjJpEyB(file2, vector);
                    } else {
                        this.WjIBbhV.getUpdateClient().doUpdate(file2, SVNRevision.HEAD, SVNDepth.INFINITY, true, true);
                        this.WjJpkhK(vector);
                    }
                    this.fireEvent(file2.getPath(), true, 1);
                    return;
                }
            }
            if (!file.getParentFile().exists()) {
                this.updateLocation(file.getParentFile(), false);
            }
            sVNClientManager = this.WjIBbhV;
            synchronized (sVNClientManager) {
                this.WjIBbhV.getUpdateClient().doUpdate(file, SVNRevision.HEAD, SVNDepth.fromRecurse((boolean)bl), true, true);
            }
            if (file.isDirectory()) {
                this.WjJyyDA(file);
            }
        }
        catch (SVNException sVNException) {
            this.verifyConnection();
            throw new NdRepositoryException(sVNException);
        }
    }

    private void WjJyyDA(File file) throws NdRepositoryException {
        Vector<String> vector = new Vector<String>();
        this.WjJyyEB(file, vector);
        File file2 = file.getParentFile();
        if (!new File(file2, file.getName() + ".innovator_attbs").exists()) {
            vector.addElement(file.getAbsolutePath());
        }
        this.WjJpkhK(vector);
    }

    private void WjJyyEB(File file, Vector vector) {
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!file2.isDirectory() || this.WjJyyCZ.equals(file2.getName())) continue;
                this.WjJyyEB(file2, vector);
                if (new File(file, file2.getName() + ".innovator_attbs").exists()) continue;
                vector.addElement(file2.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentByVersion(File file, String string) throws NdRepositoryException, IOException {
        if (this.isServerConnected()) {
            try {
                SVNClientManager sVNClientManager = this.WjIBbhV;
                synchronized (sVNClientManager) {
                    long l = new Long(string);
                    SVNRevision sVNRevision = SVNRevision.create((long)l);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.WjIBbhV.getWCClient().doGetFileContents(file, SVNRevision.HEAD, sVNRevision, true, (OutputStream)byteArrayOutputStream);
                    return new String(byteArrayOutputStream.toByteArray(), "UTF8");
                }
            }
            catch (SVNException sVNException) {
                this.verifyConnection();
                throw new NdRepositoryException(sVNException);
            }
        }
        throw new NdRepositoryException(NdStrings.WjIBbNV("ScmServerIsNotConnected", this.getServerUrl()));
    }

    private boolean WjJmYdN(File file) throws SVNException {
        boolean bl = true;
        if (file == null) {
            return true;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                SVNStatusType sVNStatusType;
                File file2 = fileArray[i];
                if (file2.toString().endsWith(this.WjJyyCZ) || (sVNStatusType = this.WjJjTcU(file2)) != SVNStatusType.STATUS_NONE && sVNStatusType != SVNStatusType.UNKNOWN) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean WjJpExA(Vector vector) throws SVNException {
        boolean bl = true;
        if (vector == null || vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            File file = new File(string);
            if (this.WjJmYdN(file)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private File WjJpkhI(File file, Vector vector) throws SVNException {
        File file2 = file;
        if (vector.isEmpty()) {
            vector.addElement(file.getAbsolutePath());
        } else {
            vector.insertElementAt(file.getAbsolutePath(), vector.size());
        }
        if (file.getParentFile() != null) {
            SVNStatusType sVNStatusType = this.WjJjTcU(file = file.getParentFile());
            if (sVNStatusType == SVNStatusType.STATUS_DELETED) {
                file = this.WjJpkhI(file, vector);
            }
            file2 = file;
        }
        return file2;
    }

    private void WjJpkhJ(File file, Vector vector) throws SVNException {
        String[] stringArray;
        if (file != null && (stringArray = file.list()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                SVNStatusType sVNStatusType;
                File file2 = new File(file, stringArray[i]);
                if (!file2.isDirectory() || (sVNStatusType = this.WjJjTcU(file2)) != SVNStatusType.STATUS_DELETED) continue;
                vector.insertElementAt(file2.getAbsolutePath(), 0);
                this.WjJpkhJ(file2, vector);
            }
        }
    }

    private void WjJpkhK(Vector vector) throws NdRepositoryException {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = vector.elementAt(i).toString();
                NdScmSupport.createNewDirectoryAttributeFile(this.getRepository(), string, this.getUser().toString());
                this.fireEvent(string, true, 1);
            }
        }
    }

    private void WjJpEyB(File file, Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (i != vector.size() - 1) continue;
            String string = vector.get(i).toString();
            this.fireEvent(string, true, 1);
        }
    }

    protected boolean isUpdateEventDriven() {
        return true;
    }

    static {
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        DAVRepositoryFactory.setup();
    }
}

