/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryException;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepository;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryDirectory;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.wvcm.ControllableResource;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

public class NdWvcmRepositoryItem
extends NdWvcmRepositoryEntry
implements NdRepositoryItem {
    NdWvcmRepositoryItem(NdWvcmRepositoryDirectory ndWvcmRepositoryDirectory, String string, ControllableResource controllableResource) {
        super(ndWvcmRepositoryDirectory, string, controllableResource);
    }

    public NdRepositoryItemContent getContent() throws NdRepositoryException {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.getResource().doReadContent((OutputStream)byteArrayOutputStream, null);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotReadContent", this.getName()), this, wvcmException);
        }
        return new NdRepositoryItemContent(byArray);
    }

    public void setContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        NdWvcmRepository ndWvcmRepository = (NdWvcmRepository)NdRepositorySupport.getRepository(this);
        byte[] byArray = ndRepositoryItemContent.getRawData();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ControllableResource controllableResource = (ControllableResource)this.getResource().doWriteContent((InputStream)byteArrayInputStream, null, null);
            this.WjIAWSM(controllableResource);
            String string = ndWvcmRepository.WjIAWCA();
            if (string != null && string.length() > 0) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute("innovatorLastModifiedUser", string);
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{ndRepositoryEntryAttribute};
                this.getContainerDirectory().setRepositoryEntryAttributes(this, ndRepositoryEntryAttributeArray);
            }
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotWriteContent", this.getName()), this, wvcmException);
        }
    }

    public Date getLastModified() throws NdRepositoryException {
        try {
            return this.getResource().getLastModified();
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotReadLastModified", this.getName()), this, wvcmException);
        }
    }

    public void setLastModified(Date date) throws NdRepositoryException {
        this.getResource().setProperty(Resource.LAST_MODIFIED, (Object)date);
    }

    public boolean isReadable() throws NdRepositoryException {
        return true;
    }

    public boolean isWritable() throws NdRepositoryException {
        return true;
    }
}

