/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryConnection;
import com.blazesoft.security.NdAccessController;
import com.blazesoft.security.NdPrivilegedExceptionAction;
import javax.wvcm.ProviderFactory;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdWvcmSupport {
    public static ProviderFactory.Callback createProviderCallback(final NdRepositoryConnection ndRepositoryConnection) {
        return new ProviderFactory.Callback(){

            public ProviderFactory.Callback.Authentication getAuthentication(String string, int n) {
                if (n > 0) {
                    throw new IllegalAccessError(NdStrings.WjIAVSE("AccessFailure", string));
                }
                String string2 = ndRepositoryConnection.getPassword();
                if (string2 != null && string2.length() != 0) {
                    try {
                        final String string3 = string2;
                        string2 = (String)NdAccessController.doPrivileged((NdPrivilegedExceptionAction)new NdPrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return NdRepositorySupport.decryptPassword(ndRepositoryConnection, string3);
                            }
                        });
                    }
                    catch (Exception exception) {
                        throw new NdRepositoryRuntimeException(exception);
                    }
                }
                return new WjIAVZY(new String[]{ndRepositoryConnection.getUser(), string2});
            }
        };
    }

    public static WorkspaceProvider getWorkspaceProvider(NdScmServerConnection ndScmServerConnection) throws WvcmException {
        try {
            ProviderFactory.Callback callback = NdWvcmSupport.createProviderCallback(ndScmServerConnection);
            return (WorkspaceProvider)ProviderFactory.createProvider((String)ndScmServerConnection.getScmProvider(), (ProviderFactory.Callback)callback);
        }
        catch (Exception exception) {
            throw new WvcmException(exception.getMessage(), null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)exception);
        }
    }

    public static WorkspaceProvider getWorkspaceProvider(NdWvcmRepositoryConnection ndWvcmRepositoryConnection) throws WvcmException {
        try {
            ProviderFactory.Callback callback = NdWvcmSupport.createProviderCallback(ndWvcmRepositoryConnection);
            return (WorkspaceProvider)ProviderFactory.createProvider((String)ndWvcmRepositoryConnection.getWorkspaceProvider(), (ProviderFactory.Callback)callback);
        }
        catch (Exception exception) {
            throw new WvcmException(exception.getMessage(), null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)exception);
        }
    }

    static class WjIAVZY
    implements ProviderFactory.Callback.Authentication {
        private String[] WjIAVYX;

        WjIAVZY(String[] stringArray) {
            this.WjIAVYX = stringArray;
        }

        public String loginName() {
            return this.WjIAVYX[0];
        }

        public String password() {
            return this.WjIAVYX.length > 1 ? this.WjIAVYX[1] : "";
        }
    }
}

