/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdDefaultRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdRepositoryVersionScmConnectionException;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmPropertyRequest;
import com.blazesoft.repository.scm.wvcm.NdWvcmPropertyRequestFactory;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepository;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryEntry;
import com.blazesoft.repository.scm.wvcm.NdWvcmSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wvcm.Activity;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdWvcmWorkspaceVersionManager
extends NdScmWorkspaceVersionManager {
    private Workspace WjIATsZ;
    private WorkspaceProvider WjIATtA;
    private NdWvcmPropertyRequest WjIATtB;
    private int WjIATtC;
    private int WjIATtD;
    private int WjIATtE;
    private int WjIATtF;

    public NdWvcmWorkspaceVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        this.initializeRepository(ndRepository);
        this.WjIATtB = this.getPropertyRequestFactory().newPropertyRequest();
        this.WjIATsZ = this.initializeWorkspace(ndRepository);
    }

    public NdWvcmPropertyRequestFactory getPropertyRequestFactory() {
        return new NdWvcmPropertyRequestFactory();
    }

    public WorkspaceProvider getProvider() {
        return this.WjIATtA;
    }

    public boolean hasAutoCheckoutParent() {
        return true;
    }

    public boolean hasVersionedFolderSupport() {
        return true;
    }

    public boolean hasBaselineFolderSupport() {
        return true;
    }

    protected Workspace initializeWorkspace(NdRepository ndRepository) throws NdRepositoryException {
        NdRepository ndRepository2 = ndRepository;
        if (ndRepository instanceof NdWorkspace) {
            ndRepository2 = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
        }
        if (ndRepository2 instanceof NdWvcmRepository) {
            if (ndRepository instanceof NdWorkspace) {
                ((NdWorkspace)ndRepository).addWorkspaceListener((NdWvcmRepository)ndRepository2);
            }
            return ((NdWvcmRepository)ndRepository2).WjIAWCB();
        }
        return null;
    }

    protected String initializeWorkspacePath(NdRepository ndRepository) throws NdRepositoryException {
        NdRepository ndRepository2 = ndRepository;
        if (ndRepository instanceof NdWorkspace) {
            ndRepository2 = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
        }
        if (ndRepository2 instanceof NdWvcmRepository) {
            return ((NdWvcmRepository)ndRepository2).WjIAWCB().location().toString();
        }
        return super.initializeWorkspacePath(ndRepository);
    }

    protected String initializeRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        NdRepository ndRepository2 = ndRepository;
        if (ndRepository instanceof NdWorkspace) {
            ndRepository2 = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
        }
        if (ndRepository2 instanceof NdWvcmRepository) {
            return ((Resource)ndRepository2.getPhysicalDescription()).location().toString();
        }
        return super.initializeRepositoryPath(ndRepository);
    }

    public Object convertEntryToPhysicalResource(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdRepositoryEntry ndRepositoryEntry2 = ((NdWorkspaceEntry)ndRepositoryEntry).getPhysicalRepositoryEntry();
        return ((NdWvcmRepositoryEntry)ndRepositoryEntry2).getResource();
    }

    public Object convertAttributesToPhysicalResource(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdRepositoryEntry ndRepositoryEntry2 = ((NdWorkspaceEntry)ndRepositoryEntry).getPhysicalRepositoryEntry();
        return ((NdWvcmRepositoryEntry)ndRepositoryEntry2).getAttributeResource();
    }

    public Object convertLocationToPhysicalResource(NdLocation ndLocation) throws NdRepositoryException {
        try {
            Location location;
            NdRepository ndRepository = this.getRepository();
            if (ndRepository instanceof NdWorkspace) {
                ndRepository = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
            }
            Location location2 = location = ((NdWvcmRepository)ndRepository).getResource().location();
            String[] stringArray = ndLocation.getComponents();
            for (int i = 0; i < stringArray.length; ++i) {
                location2 = location2.child(stringArray[i]);
            }
            return this.getProvider().controllableResource(location2);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    public void openConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIATtC = 0;
        this.WjIATtD = 0;
        this.WjIATtE = 0;
        this.WjIATtF = 0;
        try {
            if (this.WjIATsZ == null || !this.isServerConnected()) {
                this.WjIATtA = this.createWorkspaceProvider(ndScmServerConnection);
                this.verifyConnection();
            } else {
                if (!this.isServerConnected()) {
                    this.verifyConnection();
                }
                this.WjIATtA = (WorkspaceProvider)this.WjIATsZ.provider();
            }
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryVersionScmConnectionException(wvcmException);
        }
    }

    protected void verifyConnection() throws NdRepositoryVersionScmConnectionException {
        try {
            this.WjIATsZ = this.createWorkspaceProxy(this.WjIATtA, this.getWorkspacePath());
            this.WjIATsZ = (Workspace)this.readProperties((Resource)this.WjIATsZ);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryVersionScmConnectionException(NdStrings.WjIAVSE("ScmServerConnectionCouldNotBeEstablishedFor", this.getServerUrl()), wvcmException);
        }
    }

    public void closeConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIATsZ = null;
        this.WjIATtA = null;
        this.trace("Status-requests: " + this.WjIATtC);
        this.trace("Lock-requests: " + this.WjIATtD);
        this.trace("PropList-requests: " + this.WjIATtE);
        this.trace("PropRes-requests: " + this.WjIATtF);
    }

    protected void cancelCheckOutInternal(List list) throws NdRepositoryException {
        ResourceList resourceList = this.WjIATtI(list);
        try {
            this.cancelCheckOut(resourceList);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void checkInInternal(List list, String string) throws NdRepositoryException {
        try {
            ResourceList resourceList = this.WjIATtI(list);
            resourceList = this.WjIATtG(resourceList);
            this.checkIn(resourceList, string);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected boolean isVersionedInternal(Object object) throws NdRepositoryException {
        try {
            Resource resource = this.WjIATtH((Resource)object);
            this.readProperty(resource, ControllableResource.IS_VERSION_CONTROLLED);
            return this.isVersioned(resource);
        }
        catch (WvcmException wvcmException) {
            if (wvcmException.getReasonCode().equals(WvcmException.ReasonCode.NOT_FOUND)) {
                return false;
            }
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected List doVersionControlInternal(List list, String string) throws NdRepositoryException {
        ResourceList resourceList = this.WjIATtI(list);
        try {
            return this.doVersionControl(resourceList, string);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected boolean isCheckedOutInternal(Object object) throws NdRepositoryException {
        try {
            Resource resource = this.WjIATtH((Resource)object);
            return this.isCheckedOut(resource);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void checkOutInternal(List list) throws NdRepositoryException {
        try {
            ResourceList resourceList = this.WjIATtI(list);
            this.checkOut(resourceList);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void deleteInternal(List list) throws NdRepositoryException {
        try {
            ResourceList resourceList = this.WjIATtI(list);
            this.doUnbindResources(resourceList);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void cancelDeleteInternal(List list) throws NdRepositoryException {
        try {
            ResourceList resourceList = this.WjIATtI(list);
            this.cancelDelete(resourceList);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void getEntryLockInfosInternal(List list, Map map) throws NdRepositoryException {
        Resource[] resourceArray = list.toArray(new Resource[0]);
        try {
            this.getEntryLockInfos(resourceArray, map);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void getHistoriesInternal(List list, Map map) throws NdRepositoryException {
        try {
            Resource[] resourceArray = list.toArray(new Resource[0]);
            this.getHistories(resourceArray, map);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void getAncestralHistoriesInternal(List list, Map map, String string) throws NdRepositoryException {
        try {
            Resource[] resourceArray = list.toArray(new Resource[0]);
            this.getHistories(resourceArray, map, true, string);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void getStatusInfosInternal(List list, Map map) throws NdRepositoryException {
        try {
            Resource[] resourceArray = list.toArray(new Resource[0]);
            this.getStatusInfos(resourceArray, map);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void updateLocationInternal(Object object, boolean bl) throws NdRepositoryException {
        this.updateLocation((Resource)object, bl);
    }

    public void updateLocation(Resource resource, boolean bl) throws NdRepositoryException {
        try {
            this.trace("updateResourceLocation", resource);
            if (this.WjIATsZ.equals(resource)) {
                this.trace("updateResourceLocation: resource == workspace");
                resource = this.getWorkspaceRoot(this.WjIATsZ);
                this.trace("updateResourceLocation: workspace-home ", resource);
            }
            Stream stream = (Stream)this.readProperty((Resource)this.WjIATsZ, Workspace.STREAM);
            this.trace("updateResourceLocation: workspace", (Resource)this.WjIATsZ);
            this.trace("updateResourceLocation: branch", (Resource)stream);
            ResourceList resourceList = this.getProvider().resourceList();
            resourceList.add((Object)resource);
            this.update(resourceList);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void updateInternal(List list) throws NdRepositoryException {
        ResourceList resourceList = this.WjIATtI(list);
        try {
            this.update(resourceList);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected String getContentByVersionInternal(Object object, String string) throws NdRepositoryException {
        try {
            return this.getContentByVersion((Resource)object, string);
        }
        catch (IOException iOException) {
            this.verifyConnection();
            throw new NdRepositoryException(iOException);
        }
        catch (WvcmException wvcmException) {
            this.verifyConnection();
            throw new NdRepositoryException(wvcmException);
        }
    }

    public String getContentByVersion(Resource resource, String string) throws WvcmException, IOException {
        ResourceList resourceList = this.getProvider().resourceList();
        resourceList.add((Object)resource);
        ResourceList.ResponseIterator responseIterator = this.readHistoryProperties(resourceList);
        ControllableResource controllableResource = (ControllableResource)responseIterator.next();
        ResourceList resourceList2 = controllableResource.getVersionHistory().getChildList();
        Iterator iterator = resourceList2.iterator();
        while (iterator.hasNext()) {
            Version version = (Version)iterator.next();
            if (!string.equals(version.getVersionName())) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            version.doReadContent((OutputStream)byteArrayOutputStream, null);
            return new String(byteArrayOutputStream.toByteArray(), "UTF8");
        }
        return null;
    }

    public void cancelCheckOut(ResourceList resourceList) throws WvcmException {
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            ControllableResource controllableResource = (ControllableResource)iterator.next();
            this.doCancelCheckOut(controllableResource);
        }
    }

    public void doCancelCheckOut(ControllableResource controllableResource) throws WvcmException {
        this.trace("Cancel checkout", (Resource)controllableResource);
        controllableResource.doUncheckout(null);
    }

    public void checkIn(ResourceList resourceList, String string) throws WvcmException {
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            ControllableResource controllableResource = (ControllableResource)iterator.next();
            this.trace("CheckIn", (Resource)controllableResource, ControllableResource.IS_CHECKED_OUT);
        }
        this.WjIATsZ.doCheckin(resourceList, string, new ControllableResource.CheckinFlag[]{ControllableResource.CheckinFlag.CHECKIN_IDENTICAL}, null);
    }

    public boolean isVersioned(Resource resource) throws WvcmException {
        if (resource instanceof ControllableResource) {
            if (((ControllableResource)resource).getIsCheckedOut()) {
                return true;
            }
            return ((ControllableResource)resource).getIsVersionControlled();
        }
        return false;
    }

    public List doVersionControl(ResourceList resourceList, String string) throws WvcmException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            ControllableResource controllableResource = (ControllableResource)iterator.next();
            controllableResource.setComment(string);
            this.doVersionControlResource((Resource)controllableResource, string);
            this.trace("doVersionControl", (Resource)controllableResource);
            ResourceList resourceList2 = controllableResource.getParentList();
            if (resourceList2.isEmpty()) continue;
            this.trace("parent for ", (Resource)controllableResource);
            this.trace("parent = ", (Resource)resourceList2.get(0));
            Resource resource = (Resource)resourceList2.get(0);
            if (resource instanceof Workspace) {
                Resource resource2 = (Resource)this.readProperty(resource, Workspace.CONTROLLABLE_RESOURCE_HOME);
                this.trace("Parent is workspace->add home folder", resource2);
                arrayList.add(resource2);
                continue;
            }
            arrayList.add(resourceList2.get(0));
        }
        return arrayList;
    }

    public Resource doVersionControlResource(Resource resource, String string) throws WvcmException {
        ControllableResource controllableResource = (ControllableResource)resource;
        controllableResource.setComment(string);
        controllableResource = controllableResource.doVersionControl(null);
        Location location = controllableResource.location();
        Location location2 = location.parent();
        ControllableFolder controllableFolder = this.WjIATtA.controllableFolder(location2);
        return controllableFolder;
    }

    public boolean isCheckedOut(Resource resource) throws WvcmException {
        return resource instanceof ControllableResource && ((ControllableResource)resource).getIsCheckedOut();
    }

    public void checkOut(ResourceList resourceList) throws WvcmException {
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            ControllableResource controllableResource = (ControllableResource)iterator.next();
            this.doCheckOut(controllableResource);
        }
    }

    public void doCheckOut(ControllableResource controllableResource) throws WvcmException {
        try {
            controllableResource.doCheckout(new ControllableResource.CheckoutFlag[]{ControllableResource.CheckoutFlag.RESERVED}, null);
        }
        catch (WvcmException wvcmException) {
            this.trace("CheckOutError on", wvcmException.getResource());
            throw wvcmException;
        }
    }

    public ResourceList doUnbindResources(ResourceList resourceList) throws WvcmException {
        ResourceList resourceList2 = this.newResourceList((Provider)this.WjIATtA);
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            ControllableResource controllableResource = (ControllableResource)iterator.next();
            ControllableResource controllableResource2 = this.doUnbindResource(controllableResource);
            if (controllableResource2 == null) continue;
            resourceList2.add((Object)controllableResource2);
        }
        return resourceList2;
    }

    public ControllableResource doUnbindResource(ControllableResource controllableResource) throws WvcmException {
        ControllableFolder controllableFolder;
        Location location = controllableResource.location();
        this.trace("Removal request for : ", (Resource)controllableResource);
        Location location2 = location.parent();
        if (location2 == null) {
            this.trace("null parent may have been deleted.");
            controllableFolder = controllableResource.getParentList();
            this.trace("Return parent for", (Resource)controllableResource);
            this.trace("parent = ", (Resource)controllableFolder.get(0));
            location = this.WjIATtA.location(this.toString((Resource)controllableResource));
            location2 = location.parent();
        }
        controllableFolder = this.WjIATtA.controllableFolder(location2);
        ResourceList resourceList = controllableResource.getParentList();
        if (resourceList.isEmpty()) {
            this.trace("No parents for", (Resource)controllableResource);
        } else {
            this.trace("parents for", (Resource)controllableResource);
            this.trace("parent = ", (Resource)resourceList.get(0));
        }
        controllableFolder = (ControllableFolder)controllableFolder.doUnbindChild(location.lastSegment(), null);
        controllableFolder = (ControllableFolder)this.readProperties((Resource)controllableFolder);
        this.trace("Delete: ", (Resource)controllableFolder, ControllableResource.IS_CHECKED_OUT);
        return controllableFolder;
    }

    public void cancelDelete(ResourceList resourceList) throws WvcmException {
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            ControllableResource controllableResource = (ControllableResource)iterator.next();
            this.doCancelDelete(controllableResource);
        }
    }

    public void doCancelDelete(ControllableResource controllableResource) throws WvcmException {
        Location location = controllableResource.location();
        Location location2 = location.parent();
        if (location2 == null) {
            location = this.WjIATtA.location(this.toString((Resource)controllableResource));
            location2 = location.parent();
        }
        this.trace("Cancel delete for " + location + " in " + location2);
        ControllableFolder controllableFolder = this.WjIATtA.controllableFolder(location2);
        controllableFolder = (ControllableFolder)this.readProperties((Resource)controllableFolder);
        controllableFolder.doUnbindChild(location.lastSegment(), null);
    }

    public void getEntryLockInfos(Resource[] resourceArray, Map map) throws WvcmException {
        Map map2 = this.convertMapFromResourceToLocation(resourceArray, map);
        ResourceList resourceList = this.newResourceList((Provider)this.WjIATtA);
        for (int i = 0; i < resourceArray.length; ++i) {
            resourceList.add((Object)resourceArray[i]);
        }
        ResourceList.ResponseIterator responseIterator = this.readLockStatusProperties(resourceList);
        while (responseIterator.hasNext()) {
            NdDefaultRepositoryEntryLockInfo ndDefaultRepositoryEntryLockInfo;
            Resource resource = (Resource)responseIterator.next();
            if (resource instanceof Folder || !(resource instanceof ControllableResource)) continue;
            ControllableResource controllableResource = (ControllableResource)resource;
            if (controllableResource.getIsCheckedOut()) {
                ndDefaultRepositoryEntryLockInfo = (NdDefaultRepositoryEntryLockInfo)map.get(controllableResource);
                if (ndDefaultRepositoryEntryLockInfo == null && map2 != null) {
                    ndDefaultRepositoryEntryLockInfo = (NdDefaultRepositoryEntryLockInfo)map2.get(controllableResource.location());
                }
                ndDefaultRepositoryEntryLockInfo.setUserId(this.getUser());
                ndDefaultRepositoryEntryLockInfo.setLockStatus(this.getLockStatus(controllableResource));
                continue;
            }
            if (!controllableResource.getIsVersionControlled()) continue;
            ndDefaultRepositoryEntryLockInfo = (NdDefaultRepositoryEntryLockInfo)map.get(controllableResource);
            if (ndDefaultRepositoryEntryLockInfo == null && map2 != null) {
                ndDefaultRepositoryEntryLockInfo = (NdDefaultRepositoryEntryLockInfo)map2.get(controllableResource.location());
            }
            ndDefaultRepositoryEntryLockInfo.setUserId(this.getLockOwner(controllableResource));
            ndDefaultRepositoryEntryLockInfo.setLockStatus(this.getLockStatus(controllableResource));
        }
        responseIterator.release();
    }

    public void getHistories(Resource[] resourceArray, Map map) throws WvcmException {
        this.getHistories(resourceArray, map, false, null);
    }

    public void getHistories(Resource[] resourceArray, Map map, boolean bl, String string) throws WvcmException {
        Map map2 = this.convertMapFromResourceToLocation(resourceArray, map);
        ResourceList resourceList = this.newResourceList((Provider)this.WjIATtA);
        for (int i = 0; i < resourceArray.length; ++i) {
            resourceList.add((Object)resourceArray[i]);
        }
        ResourceList.ResponseIterator responseIterator = bl ? this.readAncestralHistoryProperties(resourceList, string) : this.readHistoryProperties(resourceList);
        while (responseIterator.hasNext()) {
            Resource resource = (Resource)responseIterator.next();
            ArrayList arrayList = (ArrayList)map.get(resource);
            if (arrayList == null && map2 != null) {
                arrayList = (ArrayList)map2.get(resource.location());
            }
            this.getHistories(resource, arrayList);
        }
    }

    public void getHistories(Resource resource, ArrayList arrayList) throws WvcmException {
        VersionHistory versionHistory = ((ControllableResource)resource).getVersionHistory();
        ResourceList resourceList = versionHistory.getChildList();
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            Version version = (Version)iterator.next();
            boolean bl = version.getParentList().isEmpty();
            arrayList.add(0, this.createVersionHistory(version.getVersionName(), version.getCreatorDisplayName(), version.getCreationDate(), version.getComment(), bl));
        }
    }

    public void getStatusInfos(Resource[] resourceArray, Map map) throws WvcmException {
        Map map2 = this.convertMapFromResourceToLocation(resourceArray, map);
        ResourceList resourceList = this.newResourceList((Provider)this.WjIATtA);
        for (int i = 0; i < resourceArray.length; ++i) {
            resourceList.add((Object)resourceArray[i]);
        }
        ResourceList.ResponseIterator responseIterator = this.readStatusProperties(resourceList);
        while (responseIterator.hasNext()) {
            Resource resource = (Resource)responseIterator.next();
            NdRepositoryVersionResultSet ndRepositoryVersionResultSet = (NdRepositoryVersionResultSet)map.get(resource);
            if (ndRepositoryVersionResultSet == null && map2 != null) {
                ndRepositoryVersionResultSet = (NdRepositoryVersionResultSet)map2.get(resource.location());
            }
            if (ndRepositoryVersionResultSet == null) continue;
            this.fillInStatusInfo(resource, ndRepositoryVersionResultSet);
        }
        responseIterator.release();
    }

    public void update(ResourceList resourceList) throws WvcmException {
        VersionHistory versionHistory;
        Object object;
        Stream stream = (Stream)this.readProperty((Resource)this.WjIATsZ, Workspace.STREAM);
        ResourceList resourceList2 = (ResourceList)this.readProperty((Resource)stream, Stream.VERSION_LIST);
        HashMap<VersionHistory, Version> hashMap = new HashMap<VersionHistory, Version>();
        Iterator iterator = resourceList2.iterator();
        while (iterator.hasNext()) {
            object = (Version)iterator.next();
            versionHistory = (VersionHistory)this.readProperty((Resource)object, ControllableResource.VERSION_HISTORY);
            hashMap.put(versionHistory, (Version)object);
        }
        this.trace("UpdateWorkspace", (Resource)this.WjIATsZ);
        this.trace(" branch", (Resource)stream);
        iterator = this.newResourceList((Provider)this.WjIATtA);
        object = resourceList.iterator();
        while (object.hasNext()) {
            Version version;
            versionHistory = (Resource)object.next();
            this.trace("Resource", (Resource)versionHistory);
            VersionHistory versionHistory2 = (VersionHistory)this.readProperty((Resource)versionHistory, ControllableResource.VERSION_HISTORY);
            Version version2 = (Version)hashMap.get(versionHistory2);
            if (version2 != null) {
                this.trace("Found version", (Resource)version2);
                iterator.add(version2);
            }
            if ((version = versionHistory2.doLatestActivityVersionReport((Activity)stream, null)) == null) continue;
            this.trace("FoundLatestActivity: ", (Resource)version);
        }
        this.WjIATsZ = this.WjIATsZ.doUpdate(resourceList2, null);
    }

    public WorkspaceProvider createWorkspaceProvider(NdScmServerConnection ndScmServerConnection) throws WvcmException {
        return NdWvcmSupport.getWorkspaceProvider(ndScmServerConnection);
    }

    public Workspace createWorkspaceProxy(WorkspaceProvider workspaceProvider, String string) throws WvcmException {
        return this.WjIATsZ;
    }

    protected void fillInStatusInfo(Resource resource, NdRepositoryVersionResultSet ndRepositoryVersionResultSet) throws WvcmException {
        if (resource instanceof ControllableResource) {
            ControllableResource controllableResource = (ControllableResource)resource;
            if (controllableResource.getIsCheckedOut()) {
                if (this.isResourceModified(controllableResource)) {
                    ndRepositoryVersionResultSet.setVersionStatus(this.belongsToThisUser(this.lookupEntry(ndRepositoryVersionResultSet.getLocation())) ? 3 : 4);
                } else {
                    ndRepositoryVersionResultSet.setVersionStatus(5);
                }
                ndRepositoryVersionResultSet.setCurrentVersionId(controllableResource.getCheckedOut().getVersionName());
                ndRepositoryVersionResultSet.setWorkingVersionId(ndRepositoryVersionResultSet.getCurrentVersionId());
            } else if (controllableResource.getIsVersionControlled()) {
                ndRepositoryVersionResultSet.setVersionStatus(this.getUpToDateStatus(controllableResource));
                if (ndRepositoryVersionResultSet.getVersionStatus() == 5) {
                    ndRepositoryVersionResultSet.setCurrentVersionId(controllableResource.getCheckedIn().getVersionName());
                    ndRepositoryVersionResultSet.setWorkingVersionId(ndRepositoryVersionResultSet.getCurrentVersionId());
                } else if (ndRepositoryVersionResultSet.getVersionStatus() == 7) {
                    Version version = this.getSuccessorVersion(controllableResource.getCheckedIn());
                    if (version != null) {
                        ndRepositoryVersionResultSet.setCurrentVersionId(version.getVersionName());
                    }
                    ndRepositoryVersionResultSet.setWorkingVersionId(controllableResource.getCheckedIn().getVersionName());
                }
            } else if (controllableResource.getIsVersionControllable()) {
                ndRepositoryVersionResultSet.setVersionStatus(this.belongsToThisUser(this.lookupEntry(ndRepositoryVersionResultSet.getLocation())) ? 1 : 2);
            }
        }
    }

    protected void updateWorkspaceProperties() throws WvcmException {
        this.WjIATsZ = (Workspace)this.readProperties((Resource)this.WjIATsZ);
    }

    protected String getOwner(Resource resource) throws WvcmException {
        return resource.getCreatorDisplayName();
    }

    protected boolean isResourceModified(ControllableResource controllableResource) throws WvcmException {
        Version version = controllableResource.getCheckedOut();
        Date date = version.getLastModified();
        Date date2 = controllableResource.getLastModified();
        if (date2.after(date)) {
            return true;
        }
        if (controllableResource.getContentIdentifier() != null) {
            if (!controllableResource.getContentIdentifier().equals(version.getContentIdentifier())) {
                return true;
            }
        } else if (controllableResource instanceof Folder) {
            Map map = ((Folder)controllableResource).getChildMap();
            Map map2 = (Map)this.readProperty((Resource)version, Folder.CHILD_MAP);
            if (map.size() != map2.size()) {
                return true;
            }
            Set set = map2.keySet();
            set.removeAll(map.keySet());
            if (!set.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    protected int getUpToDateStatus(ControllableResource controllableResource) throws WvcmException {
        if (this.isResourceUpToDate(controllableResource)) {
            return 5;
        }
        return 7;
    }

    protected Version getSuccessorVersion(Version version) throws WvcmException {
        ResourceList resourceList = version.getSuccessorList();
        if (resourceList.isEmpty()) {
            return null;
        }
        int n = resourceList.size() - 1;
        return (Version)resourceList.get(n);
    }

    protected boolean isResourceUpToDate(ControllableResource controllableResource) throws WvcmException {
        Version version = controllableResource.getCheckedIn();
        if (version == null) {
            version = controllableResource.getCheckedOut();
        }
        return version.getSuccessorList().isEmpty();
    }

    protected int getLockStatus(ControllableResource controllableResource) throws WvcmException {
        if (controllableResource.getIsCheckedOut()) {
            return 2;
        }
        if (controllableResource.getIsVersionControlled()) {
            Version version = controllableResource.getCheckedIn();
            ResourceList resourceList = version.getCheckoutList();
            if (resourceList.isEmpty()) {
                return 1;
            }
            Resource resource = (Resource)resourceList.get(0);
            if (this.getUser().equals(this.getOwner(resource))) {
                return 3;
            }
            return 4;
        }
        return 1;
    }

    protected String getLockOwner(ControllableResource controllableResource) throws WvcmException {
        if (controllableResource.getIsCheckedOut()) {
            return this.getUser();
        }
        if (controllableResource.getIsVersionControlled()) {
            Version version = controllableResource.getCheckedIn();
            ResourceList resourceList = version.getCheckoutList();
            if (resourceList.isEmpty()) {
                return null;
            }
            Resource resource = (Resource)resourceList.get(0);
            return this.getOwner(resource);
        }
        return null;
    }

    protected boolean checkedOutByThisWorkspace(ControllableResource controllableResource) throws WvcmException {
        ResourceList resourceList = this.WjIATsZ.getWorkspaceCheckoutList();
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource.location().equals(controllableResource.location())) {
                return true;
            }
            if (!resource.equals(controllableResource)) continue;
            return true;
        }
        return false;
    }

    protected Resource readProperties(Resource resource) throws WvcmException {
        this.trace("readProperties-resource", resource);
        ++this.WjIATtF;
        return this.WjIATtB.readProperties(resource);
    }

    protected ResourceList.ResponseIterator readProperties(ResourceList resourceList) throws WvcmException {
        this.trace("readProperties-list");
        ++this.WjIATtE;
        return this.WjIATtB.readProperties(resourceList);
    }

    protected ControllableFolder getWorkspaceRoot(Workspace workspace) throws WvcmException {
        return (ControllableFolder)this.readProperty((Resource)workspace, Workspace.CONTROLLABLE_RESOURCE_HOME);
    }

    protected Object readProperty(Resource resource, PropertyNameList.PropertyName propertyName) throws WvcmException {
        return this.WjIATtB.readProperty(resource, propertyName);
    }

    protected Resource requestProperty(Resource resource, PropertyNameList.PropertyName propertyName) throws WvcmException {
        return this.WjIATtB.requestProperty(resource, propertyName);
    }

    protected ResourceList.ResponseIterator readStatusProperties(ResourceList resourceList) throws WvcmException {
        this.trace("readStatusProperties");
        ++this.WjIATtC;
        return this.WjIATtB.readStatusProperties(resourceList);
    }

    protected ResourceList.ResponseIterator readLockStatusProperties(ResourceList resourceList) throws WvcmException {
        this.trace("readLockStatusProperties");
        ++this.WjIATtD;
        return this.WjIATtB.readLockStatusProperties(resourceList);
    }

    protected ResourceList.ResponseIterator readHistoryProperties(ResourceList resourceList) throws WvcmException {
        this.trace("readHistoryProperties");
        return this.WjIATtB.readHistoryProperties(resourceList);
    }

    protected ResourceList.ResponseIterator readAncestralHistoryProperties(ResourceList resourceList, String string) throws WvcmException {
        this.trace("readAncestralHistoryProperties");
        return this.WjIATtB.readAncestralHistoryProperties(resourceList, string);
    }

    ResourceList WjIATtG(ResourceList resourceList) {
        this.trace("readDefaultProperties");
        try {
            ResourceList resourceList2 = this.newResourceList((Provider)this.getProvider());
            ResourceList.ResponseIterator responseIterator = this.readProperties(resourceList);
            while (responseIterator.hasNext()) {
                resourceList2.add(responseIterator.next());
            }
            responseIterator.release();
            resourceList.clear();
            return resourceList2;
        }
        catch (WvcmException wvcmException) {
            return resourceList;
        }
    }

    Resource WjIATtH(Resource resource) {
        ResourceList resourceList = this.newResourceList((Provider)this.getProvider());
        resourceList.add((Object)resource);
        resourceList = this.WjIATtG(resourceList);
        return (Resource)resourceList.get(0);
    }

    private ResourceList WjIATtI(List list) {
        ResourceList resourceList = this.newResourceList((Provider)this.getProvider());
        resourceList.addAll((Collection)list);
        return resourceList;
    }

    protected ResourceList newResourceList(Provider provider) {
        return provider.resourceList();
    }

    NdLocation WjIATtJ(Resource resource) {
        NdRepository ndRepository = this.getRepository();
        if (ndRepository instanceof NdWorkspace) {
            ndRepository = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
        }
        Location location = ((NdWvcmRepository)ndRepository).getResource().location();
        Vector<String> vector = new Vector<String>();
        Location location2 = resource.location();
        while (!location.equals(location2)) {
            vector.insertElementAt(location2.lastSegment(), 0);
            location2 = location2.parent();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length != 0 && ((String)objectArray[objectArray.length - 1]).endsWith(".innovator_attbs")) {
            Object object = objectArray[objectArray.length - 1];
            int n = ".innovator_attbs".length();
            objectArray[objectArray.length - 1] = object = ((String)object).substring(0, ((String)object).length() - n);
        }
        return NdLocationFactory.createLocation((String[])objectArray, true);
    }

    Workspace WjIATtK() {
        return this.WjIATsZ;
    }

    WorkspaceProvider WjIATtL() {
        return this.WjIATtA;
    }

    protected Map convertMapFromResourceToLocation(Resource[] resourceArray, Map map) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < resourceArray.length; ++i) {
            hashMap.put(resourceArray[i].location(), map.get(resourceArray[i]));
        }
        return hashMap;
    }

    protected String toString(Resource resource) throws WvcmException {
        Location location = (Location)this.readProperty(resource, Resource.PATHNAME_LOCATION);
        return location.string();
    }

    protected void trace(String string, Resource resource) {
        if (this.isTracingEnabled()) {
            String string2 = null;
            try {
                string2 = this.toString(resource);
            }
            catch (WvcmException wvcmException) {
                string2 = resource.location().toString();
            }
            this.trace(string + "[" + string2 + "]");
        }
    }

    protected void trace(String string, Resource resource, PropertyNameList.PropertyName propertyName) {
        if (this.isTracingEnabled()) {
            String string2 = null;
            Object object = null;
            try {
                string2 = this.toString(resource);
                object = this.readProperty(resource, propertyName);
            }
            catch (WvcmException wvcmException) {
                string2 = resource.toString();
                object = wvcmException.getMessage();
            }
            this.trace(string + "[" + string2 + "] " + propertyName.getName() + ": " + object);
        }
    }

    public void browse(String string, Folder folder) throws WvcmException {
        ResourceList resourceList = (ResourceList)this.readProperty((Resource)folder, Folder.CHILD_LIST);
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource instanceof Folder) {
                this.browse(string, (Folder)resource);
            }
            Location location = (Location)this.readProperty(resource, Resource.PATHNAME_LOCATION);
            this.trace(string + "-res: " + resource.location(), resource);
        }
    }
}

