/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm.cc;

import com.ibm.rational.clearcase.remote_core.copyarea.CopyAreaFile;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.cc.CcFile;
import com.ibm.rational.wvcm.stp.cc.CcResource;
import java.io.IOException;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

public class NdCcSupport {
    public static CopyAreaFile getCopyAreaFile(CcResource ccResource) throws IOException, WvcmException {
        StpLocation stpLocation = ccResource.stpLocation();
        if (stpLocation.getNamespace() == StpLocation.Namespace.WORKSPACE) {
            return new CopyAreaFile(((CcFile)ccResource).getClientPath());
        }
        return new CopyAreaFile(stpLocation.getFile());
    }

    public static boolean isCopyAreaFileVersioned(CopyAreaFile copyAreaFile) throws IOException {
        return !copyAreaFile.getOid().isNil();
    }

    public static CopyAreaFile createCopyAreaFile(CcResource ccResource) throws WvcmException {
        CopyAreaFile copyAreaFile = null;
        try {
            copyAreaFile = NdCcSupport.getCopyAreaFile(ccResource);
            if (!NdCcSupport.isCopyAreaFileVersioned(copyAreaFile)) {
                return null;
            }
        }
        catch (IOException iOException) {
            throw NdCcSupport.makeWvcmException(iOException.getMessage(), (Resource)ccResource, WvcmException.ReasonCode.NOT_FOUND, iOException);
        }
        return copyAreaFile;
    }

    public static boolean isCheckedOut(CcResource ccResource) throws WvcmException {
        try {
            CopyAreaFile copyAreaFile = NdCcSupport.createCopyAreaFile(ccResource);
            if (copyAreaFile != null) {
                return copyAreaFile.isCheckedout();
            }
        }
        catch (IOException iOException) {
            throw NdCcSupport.makeWvcmException(iOException.getMessage(), (Resource)ccResource, WvcmException.ReasonCode.NOT_FOUND, iOException);
        }
        return false;
    }

    public static WvcmException makeWvcmException(String string, Resource resource, WvcmException.ReasonCode reasonCode, Exception exception) {
        if (exception instanceof WvcmException) {
            return (WvcmException)exception;
        }
        return new WvcmException(string, resource, reasonCode, (Throwable[])new Exception[]{exception});
    }
}

