/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.security;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.config.NdRepositoryAuthorizationManagerFactory;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.security.NdAuthenticationServiceFactory;
import com.blazesoft.repository.security.NdRepositoryInvalidSignatureException;
import com.blazesoft.repository.security.NdSecurityConfig;
import com.blazesoft.repository.security.NdStrings;
import com.blazesoft.repository.security.WjIAHyY;
import com.blazesoft.repository.security.WjIAcNR;
import com.blazesoft.security.NdAuthenticationService;

public class NdConfigSigner {
    private static final String WjIAaaL = "SecurityConfig";
    private static final String WjIAaaM = "RepositoryAuthorizationManagerFactory";
    private static final String WjIAaaN = "Signature";

    private NdConfigSigner() {
    }

    public static void sign(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        NdRepositoryConfigWriter ndRepositoryConfigWriter = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter();
        String string = ndRepositoryConfigWriter.save(ndRepositoryConfig);
        NdSecurityConfig ndSecurityConfig = ndRepositoryConfig.getSecurityConfig();
        if (ndSecurityConfig == null) {
            throw new NdRepositoryException(NdStrings.WjIysnA("NoSecurityConfig"));
        }
        NdAuthenticationServiceFactory ndAuthenticationServiceFactory = ndSecurityConfig.getAuthenticationServiceFactory();
        if (ndAuthenticationServiceFactory == null) {
            throw new NdRepositoryException(NdStrings.WjIysnA("NoAuthorizationServiceFactory"));
        }
        NdAuthenticationService ndAuthenticationService = ndAuthenticationServiceFactory.createAuthenticationService();
        WjIAcNR wjIAcNR = WjIAHyY.WjIAHxX(WjIAaaL, new String[]{WjIAaaN});
        String string2 = wjIAcNR.WjIAKuP(string);
        ndSecurityConfig.setRawSignature(ndAuthenticationService.generateSignature(string2));
        NdRepositoryAuthorizationManagerFactory ndRepositoryAuthorizationManagerFactory = ndRepositoryConfig.getRepositoryAuthorizationManagerFactory();
        if (ndRepositoryAuthorizationManagerFactory != null) {
            WjIAcNR wjIAcNR2 = WjIAHyY.WjIAHxX(WjIAaaM, new String[0]);
            String string3 = wjIAcNR2.WjIAKuP(string);
            ndRepositoryConfig.setRawAuthorizationManagerSignature(ndAuthenticationService.generateSignature(string3));
        }
    }

    public static void verify(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        NdSecurityConfig ndSecurityConfig = ndRepositoryConfig.getSecurityConfig();
        if (ndSecurityConfig == null) {
            throw new NdRepositoryException(NdStrings.WjIysnA("NoSecurityConfig"));
        }
        NdAuthenticationServiceFactory ndAuthenticationServiceFactory = ndSecurityConfig.getAuthenticationServiceFactory();
        if (ndAuthenticationServiceFactory == null) {
            throw new NdRepositoryException(NdStrings.WjIysnA("NoAuthorizationServiceFactory"));
        }
        NdAuthenticationService ndAuthenticationService = ndAuthenticationServiceFactory.createAuthenticationService();
        NdConfigSigner.verify(ndRepositoryConfig, ndSecurityConfig, ndAuthenticationService);
    }

    public static void verify(NdRepositoryConfig ndRepositoryConfig, NdSecurityConfig ndSecurityConfig, NdAuthenticationService ndAuthenticationService) throws NdRepositoryException {
        WjIAcNR wjIAcNR;
        String string;
        NdRepositoryConfigWriter ndRepositoryConfigWriter = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter();
        String string2 = ndRepositoryConfigWriter.save(ndRepositoryConfig);
        WjIAcNR wjIAcNR2 = WjIAHyY.WjIAHxX(WjIAaaL, new String[]{WjIAaaN});
        String string3 = wjIAcNR2.WjIAKuP(string2);
        if (!ndAuthenticationService.verifySignature(string3, ndSecurityConfig.getRawSignature())) {
            throw new NdRepositoryInvalidSignatureException(NdStrings.WjIysnA("InvalidSecurityConfigSig"));
        }
        NdRepositoryAuthorizationManagerFactory ndRepositoryAuthorizationManagerFactory = ndRepositoryConfig.getRepositoryAuthorizationManagerFactory();
        if (ndRepositoryAuthorizationManagerFactory != null && !ndAuthenticationService.verifySignature(string = (wjIAcNR = WjIAHyY.WjIAHxX(WjIAaaM, new String[0])).WjIAKuP(string2), ndRepositoryConfig.getRawAuthorizationManagerFactorySignature())) {
            throw new NdRepositoryInvalidSignatureException(NdStrings.WjIysnA("InvalidAuthMgrSig"));
        }
    }
}

