/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.split;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.split.NdExternalSystemFolderLoader;
import com.blazesoft.repository.split.NdStrings;
import com.blazesoft.util.NdProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class NdAbstractExternalSystemFolderLoader
implements NdExternalSystemFolderLoader {
    protected static final String FILE_SEP_SRL = "/";
    private NdWorkspace WjITyRT;

    NdAbstractExternalSystemFolderLoader(NdWorkspace ndWorkspace) {
        this.WjITyRT = ndWorkspace;
    }

    NdAbstractExternalSystemFolderLoader() {
        this(null);
    }

    protected NdWorkspace getWorkspace() {
        if (this.WjITyRT == null) {
            throw new NdRepositoryRuntimeException(NdStrings.WjITzND("ExternalSystemFolderLoaderConfigWOWorkspace"));
        }
        return this.WjITyRT;
    }

    protected boolean isValidSystemDir(NdWorkspaceDirectory ndWorkspaceDirectory) throws NdRepositoryException {
        String string = NdRepositorySupport.getAbsolutePath(ndWorkspaceDirectory);
        return string.startsWith("/system");
    }

    protected NdRepositoryEntryAttribute[] getAttributes(String string, InputStream inputStream) throws NdRepositoryException {
        Object[] objectArray;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        try {
            objectArray = new NdProperties();
            objectArray.load(inputStream);
            Enumeration enumeration = objectArray.keys();
            enumeration = objectArray.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)objectArray.get((Object)string2);
                vector.addElement(new NdRepositoryEntryAttribute(string2, string3));
            }
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(NdStrings.WjITzPF("CannotGetAttbsFileFromFile", string), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new NdRepositoryException(NdStrings.WjITzPF("CannotGetAttbsFileFromFile", string), iOException);
                }
            }
        }
        objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected String getBaseName(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }
}

