/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.tools;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.dotnet.NdFile;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryAdmin;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.config.NdRepositoryConfigSupport;
import com.blazesoft.repository.config.legacy.NdBaseRepositoryConfig;
import com.blazesoft.repository.file.NdFileRepository;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.jdbc.NdJdbcRepository;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.tools.NdFileRepositoryUtil;
import com.blazesoft.repository.tools.NdJdbcRepositoryUtil;
import com.blazesoft.repository.tools.NdRepositoryConverterUtil;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.WjHBnHN;
import com.blazesoft.util.WjHzAhT;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class NdRepositoryUtil {
    private Object WjHIHGN;
    private String WjHEmPG;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Hashtable;

    private Object WjHIHGP() throws NdRepositoryException {
        if (this.WjHIHGN == null) {
            try {
                Class<?> clazz = Class.forName("com.blazesoft.repository.tools.NdJndiLdapRepositoryUtil");
                this.WjHIHGN = clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdRepositoryException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new NdRepositoryException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new NdRepositoryException(illegalAccessException);
            }
        }
        return this.WjHIHGN;
    }

    public void convertRepository(NdRepository ndRepository, NdRepository ndRepository2) throws NdRepositoryException {
        this.convertWorkspace((NdWorkspace)ndRepository, (NdWorkspace)ndRepository2);
    }

    public void convertWorkspace(NdWorkspace ndWorkspace, NdWorkspace ndWorkspace2) throws NdRepositoryException {
        NdRepositoryConverterUtil ndRepositoryConverterUtil = new NdRepositoryConverterUtil();
        ndRepositoryConverterUtil.convertWorkspace(ndWorkspace, ndWorkspace2);
    }

    public NdRepository connectRepository(Hashtable hashtable) throws NdRepositoryException {
        return this.connectWorkspace(hashtable);
    }

    public NdWorkspace connectWorkspace(Hashtable hashtable) throws NdRepositoryException {
        NdWorkspace ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
        ndWorkspace.openConnection(1);
        return ndWorkspace;
    }

    public NdWorkspaceDirectory copyWorkspaceDirectory(NdWorkspaceDirectory ndWorkspaceDirectory, NdWorkspaceDirectory ndWorkspaceDirectory2, NdWorkspaceDirectory ndWorkspaceDirectory3, String string, boolean bl) throws NdRepositoryException {
        NdBaseObject.advAssertNonNull((Object)ndWorkspaceDirectory);
        NdBaseObject.advAssertNonNull((Object)ndWorkspaceDirectory2);
        NdBaseObject.advAssertNonNull((Object)ndWorkspaceDirectory3);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndWorkspaceDirectory.getRepositoryEntryAttributes(ndWorkspaceDirectory2);
        if (ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length > 0) {
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (ndRepositoryEntryAttributeArray[i].getAttbId().equals("innovatorName")) {
                    ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute("innovatorName", string);
                    continue;
                }
                if (ndRepositoryEntryAttributeArray[i].getAttbId().equals("innovatorDisplayName")) {
                    ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute("innovatorDisplayName", string);
                    continue;
                }
                if (!ndRepositoryEntryAttributeArray[i].getAttbId().equals("guid")) continue;
                ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute("guid", new WjHzAhT(null).WjHzAhS(WjHzAhT.WjHzAhP));
            }
        }
        NdWorkspaceDirectory ndWorkspaceDirectory4 = ndWorkspaceDirectory3.createWorkspaceDirectory(string, bl);
        ndWorkspaceDirectory3.addRepositoryDirectory(ndWorkspaceDirectory4, ndRepositoryEntryAttributeArray);
        NdWorkspaceEntry[] ndWorkspaceEntryArray = (NdWorkspaceEntry[])ndWorkspaceDirectory2.getRepositoryEntries();
        if (ndWorkspaceEntryArray != null && ndWorkspaceEntryArray.length > 0) {
            for (int i = 0; i < ndWorkspaceEntryArray.length; ++i) {
                NdWorkspaceEntry ndWorkspaceEntry = ndWorkspaceEntryArray[i];
                if (ndWorkspaceEntry instanceof NdWorkspaceDirectory) {
                    this.copyWorkspaceDirectory(ndWorkspaceDirectory2, (NdWorkspaceDirectory)ndWorkspaceEntry, ndWorkspaceDirectory4, ndWorkspaceEntry.getName(), bl);
                    continue;
                }
                this.copyWorkspaceItem(ndWorkspaceDirectory2, (NdWorkspaceItem)ndWorkspaceEntry, ndWorkspaceDirectory4, ndWorkspaceEntry.getName(), bl);
            }
        }
        return ndWorkspaceDirectory4;
    }

    public NdWorkspaceItem copyWorkspaceItem(NdWorkspaceDirectory ndWorkspaceDirectory, NdWorkspaceItem ndWorkspaceItem, NdWorkspaceDirectory ndWorkspaceDirectory2, String string, boolean bl) throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndWorkspaceDirectory.getRepositoryEntryAttributes(ndWorkspaceItem);
        NdRepositoryItemContent ndRepositoryItemContent = ndWorkspaceItem.getContent();
        if (ndWorkspaceDirectory2 == null) {
            ndWorkspaceDirectory2 = ndWorkspaceDirectory;
        }
        if (ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length > 0) {
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (!ndRepositoryEntryAttributeArray[i].getAttbId().equals("innovatorName")) continue;
                ndRepositoryEntryAttributeArray[i] = new NdRepositoryEntryAttribute("innovatorName", string);
            }
        }
        NdWorkspaceItem ndWorkspaceItem2 = ndWorkspaceDirectory2.createWorkspaceItem(string, bl);
        ndWorkspaceDirectory2.addRepositoryItem(ndWorkspaceItem2, new NdRepositoryItemContent(ndRepositoryItemContent.getData()), ndRepositoryEntryAttributeArray);
        return ndWorkspaceItem2;
    }

    public NdWorkspaceItem copyWorkspaceItem(NdWorkspaceDirectory ndWorkspaceDirectory, NdWorkspaceItem ndWorkspaceItem, String string, boolean bl) throws NdRepositoryException {
        return this.copyWorkspaceItem(ndWorkspaceDirectory, ndWorkspaceItem, null, string, bl);
    }

    public NdJdbcRepository createJdbcRepository(String string, Hashtable hashtable, boolean bl) throws NdRepositoryException {
        return this.createJdbcRepositoryEntry(string, hashtable, bl);
    }

    public NdJdbcRepository createJdbcRepository(String string, Hashtable hashtable) throws NdRepositoryException {
        return this.createJdbcRepositoryEntry(string, hashtable, false);
    }

    public void createJdbcTable(String string, Hashtable hashtable, boolean bl) throws NdRepositoryException {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        this.WjHEmPG = ndJdbcRepositoryUtil.createJdbcRepositoryEntry(string, hashtable, bl, true);
    }

    protected NdJdbcRepository createJdbcRepositoryEntry(String string, Hashtable hashtable, boolean bl) throws NdRepositoryException {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        this.WjHEmPG = ndJdbcRepositoryUtil.createJdbcRepositoryEntry(string, hashtable, bl);
        NdJdbcRepositoryConnection ndJdbcRepositoryConnection = new NdJdbcRepositoryConnection(NdRepositoryConfigSupport.convertLegacyArgs(hashtable));
        return new NdJdbcRepository(ndJdbcRepositoryConnection);
    }

    public void changeJdbcRepositoryConfig(Hashtable hashtable, boolean bl) throws NdRepositoryException {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        ndJdbcRepositoryUtil.changeJdbcRepositoryConfig(hashtable, bl);
    }

    public void getJdbcRepositoryConfig(Hashtable hashtable) throws NdRepositoryException {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        ndJdbcRepositoryUtil.getJdbcRepositoryConfig(hashtable);
    }

    public NdRepository createLdapRepository(String string, Hashtable hashtable) throws NdRepositoryException {
        if (!NdDotNETLib.isDotNETSupportEnabled()) {
            try {
                Object object = this.WjHIHGP();
                Method method = object.getClass().getDeclaredMethod("createLdapRepository", class$java$lang$String == null ? (class$java$lang$String = NdRepositoryUtil.class$("java.lang.String")) : class$java$lang$String, class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryUtil.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                method.invoke(object, string, hashtable);
                return this.connectRepository(hashtable);
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        }
        throw new NdRepositoryException();
    }

    public void changeLdapRepositoryConfig(String string, Hashtable hashtable, boolean bl) throws NdRepositoryException {
        if (!NdDotNETLib.isDotNETSupportEnabled()) {
            try {
                Object object = this.WjHIHGP();
                Method method = object.getClass().getDeclaredMethod("changeLdapRepositoryConfig", class$java$lang$String == null ? (class$java$lang$String = NdRepositoryUtil.class$("java.lang.String")) : class$java$lang$String, class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryUtil.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE);
                method.invoke(object, string, hashtable, bl ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        } else {
            throw new NdRepositoryException();
        }
    }

    public void getLdapRepositoryConfig(String string, Hashtable hashtable) throws NdRepositoryException {
        if (!NdDotNETLib.isDotNETSupportEnabled()) {
            try {
                Object object = this.WjHIHGP();
                Method method = object.getClass().getDeclaredMethod("getLdapRepositoryConfig", class$java$lang$String == null ? (class$java$lang$String = NdRepositoryUtil.class$("java.lang.String")) : class$java$lang$String, class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryUtil.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                method.invoke(object, string, hashtable);
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        } else {
            throw new NdRepositoryException();
        }
    }

    public NdFileRepository createFileRepository(Hashtable hashtable, NdBaseRepositoryConfig ndBaseRepositoryConfig) throws NdRepositoryException {
        NdFileRepositoryUtil ndFileRepositoryUtil = new NdFileRepositoryUtil();
        NdFileRepository ndFileRepository = ndFileRepositoryUtil.createFileRepository(hashtable, ndBaseRepositoryConfig);
        if (ndFileRepository != null) {
            ndFileRepository = (NdFileRepository)this.connectRepository(hashtable);
        }
        return ndFileRepository;
    }

    public void changeFileRepositoryConfig(Hashtable hashtable, NdBaseRepositoryConfig ndBaseRepositoryConfig, boolean bl) throws NdRepositoryException {
        NdFileRepositoryUtil ndFileRepositoryUtil = new NdFileRepositoryUtil();
        ndFileRepositoryUtil.changeFileRepositoryConfig(hashtable, ndBaseRepositoryConfig, bl);
    }

    public void getFileRepositoryConfig(Hashtable hashtable) throws NdRepositoryException {
        NdFileRepositoryUtil ndFileRepositoryUtil = new NdFileRepositoryUtil();
        ndFileRepositoryUtil.getFileRepositoryConfig(hashtable);
    }

    public void listFileCheckouts(Hashtable hashtable) throws NdRepositoryException {
        NdFileRepositoryUtil ndFileRepositoryUtil = new NdFileRepositoryUtil();
        ndFileRepositoryUtil.listCheckouts(hashtable);
    }

    public void cancelFileCheckouts(Hashtable hashtable) throws NdRepositoryException {
        NdFileRepositoryUtil ndFileRepositoryUtil = new NdFileRepositoryUtil();
        ndFileRepositoryUtil.cancelCheckouts(hashtable);
    }

    public void listJdbcCheckouts(Hashtable hashtable) throws NdRepositoryException {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        ndJdbcRepositoryUtil.listCheckouts(hashtable);
    }

    public void cancelJdbcCheckouts(Hashtable hashtable) throws NdRepositoryException {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        ndJdbcRepositoryUtil.cancelCheckouts(hashtable);
    }

    public void listLdapCheckouts(Hashtable hashtable) throws NdRepositoryException {
        if (!NdDotNETLib.isDotNETSupportEnabled()) {
            try {
                Object object = this.WjHIHGP();
                Method method = object.getClass().getDeclaredMethod("listCheckouts", class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryUtil.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                method.invoke(object, hashtable);
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        } else {
            throw new NdRepositoryException();
        }
    }

    public void cancelLdapCheckouts(Hashtable hashtable) throws NdRepositoryException {
        if (!NdDotNETLib.isDotNETSupportEnabled()) {
            try {
                Object object = this.WjHIHGP();
                Method method = object.getClass().getDeclaredMethod("cancelCheckouts", class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryUtil.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                method.invoke(object, hashtable);
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        } else {
            throw new NdRepositoryException();
        }
    }

    public void deleteWorkspace(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        NdRepositoryAdminFactory ndRepositoryAdminFactory = NdRepositoryUtil.tryDefaultRepositoryAdminFactory(ndWorkspaceConnection);
        if (ndRepositoryAdminFactory == null) {
            throw new NdRepositoryException("Could not get repository admin.");
        }
        NdRepositoryAdmin ndRepositoryAdmin = ndRepositoryAdminFactory.newRepositoryAdmin();
        ndRepositoryAdmin.removeWorkspace(ndWorkspaceConnection);
    }

    public String getRepositoryId() {
        return this.WjHEmPG;
    }

    public static NdRepositoryAdminFactory tryDefaultRepositoryAdminFactory(NdRepositoryConnection ndRepositoryConnection) {
        NdRepositoryAdminFactory ndRepositoryAdminFactory = null;
        if (ndRepositoryConnection instanceof NdFileRepositoryConnection) {
            ndRepositoryAdminFactory = new NdRepositoryAdminFactory("com.blazesoft.repository.file.NdFileRepositoryAdmin");
        } else if (ndRepositoryConnection instanceof NdJdbcRepositoryConnection) {
            ndRepositoryAdminFactory = new NdRepositoryAdminFactory("com.blazesoft.repository.jdbc.NdJdbcRepositoryAdmin");
        }
        return ndRepositoryAdminFactory;
    }

    public static boolean isCommandSuccessful(WjHBnHN wjHBnHN, String string, String[] stringArray) throws NdRepositoryException {
        if (wjHBnHN != null) {
            if (wjHBnHN.WjHBnHM() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\n Following command failed:\n");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(NdRepositoryUtil.convertStringArrayToString(stringArray, " "));
                stringBuffer.append("\n Command line output:\n");
                stringBuffer.append(NdRepositoryUtil.convertStringArrayToString(wjHBnHN.WjHBnHL(), "\n"));
                stringBuffer.append("\n");
                stringBuffer.append(NdRepositoryUtil.convertStringArrayToString(wjHBnHN.WjHBnHK(), "\n"));
                throw new NdRepositoryException(stringBuffer.toString());
            }
            return true;
        }
        return false;
    }

    public static String convertStringArrayToString(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static void deleteDirectoryOrFile(String string) throws NdRepositoryException {
        NdFile ndFile = NdDotNETLib.getFileSupport().getFile(string);
        if (ndFile.isDirectory()) {
            String[] stringArray = ndFile.list();
            for (int i = 0; i < stringArray.length; ++i) {
                NdFile ndFile2 = NdDotNETLib.getFileSupport().getFile(ndFile, stringArray[i]);
                if (ndFile2.isDirectory()) {
                    NdRepositoryUtil.deleteDirectoryOrFile(ndFile2.getAbsolutePath());
                    ndFile2.delete();
                    continue;
                }
                if (!ndFile2.isFile()) continue;
                ndFile2.delete();
            }
            ndFile.delete();
        } else if (ndFile.isFile()) {
            ndFile.delete();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

