/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.zip;

import com.blazesoft.repository.base.NdAbstractWorkspaceConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.zip.NdStrings;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class NdZipRepositoryConnection
extends NdAbstractWorkspaceConnection
implements NdWorkspaceConnection {
    public static final String REPOSITORY_ZIP_PATH_TAG = "com_blazesoft_repository_zip_path";
    private String WjInJaL;
    private Hashtable WjInJbM;
    private static NdRepositoryAdminFactory WjInJcN = new NdRepositoryAdminFactory("com.blazesoft.repository.zip.NdZipRepositoryAdmin");
    private String WjIyoDS;

    public NdZipRepositoryConnection() {
    }

    public NdZipRepositoryConnection(Hashtable hashtable) {
        this.WjInJbM = hashtable;
        this.setUser((String)hashtable.get("com_blazesoft_repository_username"));
        this.setPassword((String)hashtable.get("com_blazesoft_repository_password"));
        this.WjInJaL = (String)hashtable.get(REPOSITORY_ZIP_PATH_TAG);
        this.setRepositoryName((String)hashtable.get("com_blazesoft_repository_repositoryname"));
    }

    private String WjIUNpR(String string) {
        String string2;
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException((Throwable)iOException);
        }
        string2 = string2.trim();
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private boolean WjIUNpS(NdZipRepositoryConnection ndZipRepositoryConnection) {
        if (this.WjInJaL != null) {
            String string = ndZipRepositoryConnection.getZipFilePath();
            if (string == null) {
                return false;
            }
            boolean bl = this.WjIUNpR(this.WjInJaL).equals(this.WjIUNpR(string));
            return bl;
        }
        return this.WjInJaL == ndZipRepositoryConnection.WjInJaL;
    }

    public String getSystemDescription() {
        if (this.WjIyoDS == null) {
            this.WjIyoDS = NdStrings.WjInMYT("ZipRepository", this.getRepositoryName());
            if (this.WjInJaL != null) {
                this.WjIyoDS = NdStrings.WjInMYU("ZipRepositoryAt", this.WjIyoDS, this.WjInJaL);
            }
        }
        return this.WjIyoDS;
    }

    public void setSystemDescription(String string) {
        this.WjIyoDS = string;
    }

    public Hashtable getConnectionArgs() {
        if (this.WjInJbM == null) {
            this.WjInJbM = new Hashtable();
            if (this.getUser() != null) {
                this.WjInJbM.put("com_blazesoft_repository_username", this.getUser());
            }
            if (this.getPassword() != null) {
                this.WjInJbM.put("com_blazesoft_repository_password", this.getPassword());
            }
            if (this.getZipFilePath() != null) {
                this.WjInJbM.put(REPOSITORY_ZIP_PATH_TAG, this.getZipFilePath());
            }
            if (this.getRepositoryName() != null) {
                this.WjInJbM.put("com_blazesoft_repository_repositoryname", this.getRepositoryName());
            }
            this.WjInJbM.put("com_blazesoft_repository_connectionclass", this.getClass().getName());
        }
        return this.WjInJbM;
    }

    public String getRepositoryClassName() {
        return "com.blazesoft.repository.zip.NdZipRepository";
    }

    public NdRepositoryAdminFactory getRepositoryAdminFactory() {
        return WjInJcN;
    }

    public String getZipFilePath() {
        return this.WjInJaL;
    }

    public boolean isSameWorkspace(NdWorkspaceConnection ndWorkspaceConnection) {
        boolean bl = super.isSameWorkspace(ndWorkspaceConnection);
        if (!bl && ndWorkspaceConnection instanceof NdFileRepositoryConnection) {
            NdZipRepositoryConnection ndZipRepositoryConnection = (NdZipRepositoryConnection)ndWorkspaceConnection;
            bl = this.WjIUNpS(ndZipRepositoryConnection);
        }
        return bl;
    }

    public void setZipFilePath(String string) {
        this.WjInJaL = string;
    }
}

