/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.rma;

import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.rma.NdRMAException;
import com.blazesoft.rma.NdRmaProject;
import com.blazesoft.rma.NdRmaProjectTemplate;
import com.blazesoft.rma.NdRmaProjectTemplateCategory;
import com.blazesoft.rma.NdRmaRepositoryVersioningOperations;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public interface NdRmaRepository {
    public static final int REPOSITORY_TYPE_UNKNOWN = 0;
    public static final int REPOSITORY_TYPE_FILE = 1;
    public static final int REPOSITORY_TYPE_FILE_CVS_SERVER = 2;
    public static final int REPOSITORY_TYPE_JDBC = 3;
    public static final int REPOSITORY_TYPE_JNDI_LDAP = 4;
    public static final int REPOSITORY_TYPE_URL = 5;
    public static final int REPOSITORY_TYPE_RMI = 6;
    public static final int REPOSITORY_TYPE_MONGODB = 7;
    public static final int REPOSITORY_TYPE_NEW_FILE_CVS_SERVER = 8;
    public static final int REPOSITORY_TYPE_FILE_SVN_SERVER = 9;
    public static final int REPOSITORY_VERSIONING_TYPE_UNKNOWN = 0;
    public static final int REPOSITORY_VERSIONING_TYPE_BVS = 1;
    public static final int REPOSITORY_VERSIONING_TYPE_CVS = 2;
    public static final int REPOSITORY_VERSIONING_TYPE_SVN = 3;
    public static final int REPOSITORY_VERSIONING_TYPE_CC = 4;

    public NdRmaProject openProject(String var1) throws NdRMAException;

    public NdRmaProject openProject(NdLocation var1) throws NdRMAException;

    public NdRmaProject createProject(NdLocation var1, String var2, boolean var3, boolean var4) throws NdRMAException;

    public boolean isVersionControlled();

    public boolean isPrivateWorkspaceUsed();

    public boolean isFileBasedWorkspace();

    public boolean isConnected();

    public void disconnect() throws NdRMAException;

    public NdRepositoryConnection getRepositoryConnection();

    public int getRepositoryType();

    public int getRepositoryVersioningType();

    public String getRepositoryLocation();

    public String getRepositoryStorageLocation();

    public Date getConnectionDate();

    public String formatDateForDisplay(Date var1);

    public String formatDateForDisplay(Date var1, Locale var2, TimeZone var3);

    public NdCalendar getDisplayCalendar();

    public NdRmaRepositoryVersioningOperations getVersioningOperations();

    public NdRmaProjectTemplateCategory[] getProjectTemplateCategories() throws NdRMAException;

    public NdRmaProject createProject(String var1, NdRmaProjectTemplate var2) throws NdRMAException;

    public void deleteProject(NdRmaProject var1) throws NdRMAException;

    public NdRmaProjectTemplate getProjectTemplate(NdLocation var1) throws NdRMAException;

    public NdLocation[] getBusinessUserProjectLocations() throws NdRMAException;

    public NdLocation[] getAllProjectLocations() throws NdRMAException;

    public boolean isExistingProjectLocation(NdLocation var1);

    public NdRmaProject copyProject(NdRmaProject var1, NdLocation var2, String var3) throws NdRMAException;

    public NdRmaProject moveProject(NdRmaProject var1, NdLocation var2, String var3) throws NdRMAException;
}

