/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.admin;

import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.template.repository.NdPromDirectory;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdPromItemFactory;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomConnectionContext;
import com.blazesoft.template.repository.NdRomConnectionException;
import com.blazesoft.template.repository.NdRomDirectory;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.NdRomProject;
import com.blazesoft.template.repository.NdRomSchemaElement;
import com.blazesoft.template.repository.NdRomSchemaManager;
import com.blazesoft.template.repository.NdRomVersioningDirectory;
import com.blazesoft.template.repository.NdRomVersioningEntrySet;
import com.blazesoft.template.repository.NdRomVersioningLoadingContextEntrySet;
import com.blazesoft.template.repository.admin.NdRomAdmin;
import com.blazesoft.template.repository.admin.NdStrings;
import com.blazesoft.template.repository.impl.NdRomDirectoryImpl;
import com.blazesoft.template.repository.impl.WjHKXIF;
import com.blazesoft.template.repository.objects.NdPromInstance;
import com.blazesoft.template.repository.objects.NdPromTemplate;
import com.blazesoft.template.repository.objects.smartforms.NdPromSmartFormsModelContent;
import com.blazesoft.template.repository.util.WjHUSwX;
import com.blazesoft.util.NdBase64;
import java.util.ArrayList;

public class NdRomAdminSFMigrationSupport {
    public static NdPromTemplate getFormTemplate(NdPromProject ndPromProject) throws NdRomException {
        throw new RuntimeException(NdStrings.WjImXyS("SmartFormsIsObsolete"));
    }

    public static ArrayList getProjectsInDirectory(NdRomDirectory ndRomDirectory, NdRomConnectionContext ndRomConnectionContext) throws NdRomException {
        ArrayList<NdPromProject> arrayList = new ArrayList<NdPromProject>();
        NdRomEntry[] ndRomEntryArray = ndRomDirectory.getEntries();
        for (int i = 0; i < ndRomEntryArray.length; ++i) {
            if (ndRomEntryArray[i] instanceof WjHKXIF) {
                arrayList.add(ndRomConnectionContext.getProjectFactory().createProject((NdRomProject)ndRomEntryArray[i]));
                continue;
            }
            if (!(ndRomEntryArray[i] instanceof NdRomDirectory)) continue;
            arrayList.addAll(NdRomAdminSFMigrationSupport.getProjectsInDirectory((NdRomDirectoryImpl)ndRomEntryArray[i], ndRomConnectionContext));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceUnversionedInstance(NdRomAdmin ndRomAdmin, NdWorkspaceConnection ndWorkspaceConnection, NdPromProject ndPromProject, NdPromItem ndPromItem, NdPromInstance ndPromInstance) throws NdRomException {
        ndPromProject.acquireLock();
        try {
            NdPromItem ndPromItem2 = NdRomAdminSFMigrationSupport.createItemForPromInstance(ndPromProject, ndPromInstance);
            NdPromDirectory ndPromDirectory = (NdPromDirectory)ndPromItem.getParentDirectory();
            ndPromDirectory.removeItem(ndPromItem);
            ndPromItem.save();
            ndPromDirectory.addItem(ndPromItem2);
            ndPromItem2.save();
        }
        finally {
            ndPromProject.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceVersionedInstance(NdRomAdmin ndRomAdmin, NdWorkspaceConnection ndWorkspaceConnection, NdPromProject ndPromProject, NdPromItem ndPromItem, NdPromInstance[] ndPromInstanceArray) throws NdRomException {
        String[] stringArray = NdRomAdminSFMigrationSupport.getCheckinComments(ndPromItem);
        if (ndPromInstanceArray.length > 0) {
            ndPromProject.acquireLock();
            try {
                NdPromItem ndPromItem2 = NdRomAdminSFMigrationSupport.createItemForPromInstance(ndPromProject, ndPromInstanceArray[0]);
                NdPromDirectory ndPromDirectory = (NdPromDirectory)ndPromItem.getParentDirectory();
                ndRomAdmin.checkOut(ndWorkspaceConnection, ndPromItem.getLocation(), false);
                ndRomAdmin.delete(ndWorkspaceConnection, ndPromItem.getRomEntry().getLocation());
                ndRomAdmin.checkIn(ndWorkspaceConnection, ndPromItem.getRomEntry().getLocation(), NdStrings.WjImXyS("ItemDeleted"), false);
                ndPromDirectory.addItem(ndPromItem2);
                ndPromItem2.save();
                for (int i = 0; i < ndPromInstanceArray.length; ++i) {
                    WjHUSwX.WjIdmwD(ndPromItem2);
                    ndPromItem2.setItemStorageContent(ndPromInstanceArray[i]);
                    ndPromItem2.save();
                    WjHUSwX.WjIdmwC(ndPromItem2, stringArray[i]);
                }
            }
            finally {
                ndPromProject.releaseLock();
            }
        }
    }

    public static ArrayList getProjects(NdWorkspaceConnection ndWorkspaceConnection, NdRomConnectionContext ndRomConnectionContext) throws NdRomException {
        ArrayList arrayList;
        try {
            NdRomDirectory ndRomDirectory = ndRomConnectionContext.getRoot();
            arrayList = NdRomAdminSFMigrationSupport.getProjectsInDirectory(ndRomDirectory, ndRomConnectionContext);
        }
        catch (NdRomConnectionException ndRomConnectionException) {
            throw new NdRomException((Throwable)((Object)ndRomConnectionException));
        }
        return arrayList;
    }

    public static String getDecodedModelString(NdPromSmartFormsModelContent ndPromSmartFormsModelContent) {
        return new String(NdRomAdminSFMigrationSupport.WjISLOJ(ndPromSmartFormsModelContent.toString()));
    }

    private static byte[] WjISLOJ(String string) {
        return NdBase64.decode((String)string);
    }

    public static NdPromItem createItemForPromInstance(NdPromProject ndPromProject, NdPromInstance ndPromInstance) throws NdRomException {
        NdRomSchemaManager ndRomSchemaManager = ndPromProject.getRomConnectionContext().getSchemaManager();
        int n = ndPromInstance.getType();
        int n2 = ndPromInstance.getSubType();
        int n3 = ndRomSchemaManager.lookupEntityConfig(n, n2).getTarget();
        NdRomSchemaElement ndRomSchemaElement = ndRomSchemaManager.lookupSchemaElement(n, n2, 3, n3);
        NdPromItemFactory ndPromItemFactory = ndRomSchemaElement.getItemFactory();
        return ndPromItemFactory.newItem(ndPromInstance, ndPromProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NdRomVersioningEntrySet WjISLOK(NdPromProject ndPromProject, NdPromItem ndPromItem, String string) throws NdRomException {
        ndPromProject.acquireLock();
        try {
            NdRomDirectory ndRomDirectory = ndPromItem.getParentDirectory();
            NdRomEntry[] ndRomEntryArray = new NdRomEntry[]{ndPromItem};
            NdLocation ndLocation = ndPromItem.getLocation();
            NdRomVersioningLoadingContextEntrySet ndRomVersioningLoadingContextEntrySet = new NdRomVersioningLoadingContextEntrySet(ndRomDirectory, ndRomEntryArray, ndLocation, string);
            return ndRomVersioningLoadingContextEntrySet;
        }
        finally {
            ndPromProject.releaseLock();
        }
    }

    public static NdPromItem[] getItemVersions(NdPromProject ndPromProject, NdPromItem ndPromItem) throws NdRomException {
        String[] stringArray = NdRomAdminSFMigrationSupport.getVersionIds(ndPromItem);
        NdPromItem[] ndPromItemArray = new NdPromItem[stringArray.length];
        NdRomVersioningEntrySet ndRomVersioningEntrySet = null;
        NdRomVersioningDirectory ndRomVersioningDirectory = (NdRomVersioningDirectory)ndPromItem.getParentDirectory();
        for (int i = 0; i < stringArray.length; ++i) {
            ndRomVersioningEntrySet = NdRomAdminSFMigrationSupport.WjISLOK(ndPromProject, ndPromItem, stringArray[i]);
            NdRomEntry[] ndRomEntryArray = ndRomVersioningDirectory.getEntriesByVersion(ndRomVersioningEntrySet);
            ndPromItemArray[i] = (NdPromItem)ndRomEntryArray[0];
        }
        return ndPromItemArray;
    }

    public static String[] getVersionIds(NdPromItem ndPromItem) throws NdRomException {
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray = WjHUSwX.WjIqiGQ(ndPromItem.getRomEntry());
        String[] stringArray = new String[ndRepositoryVersionHistoryArray.length];
        for (int i = 0; i < ndRepositoryVersionHistoryArray.length; ++i) {
            stringArray[ndRepositoryVersionHistoryArray.length - i - 1] = ndRepositoryVersionHistoryArray[i].getVersionId();
        }
        return stringArray;
    }

    public static String[] getCheckinComments(NdPromItem ndPromItem) throws NdRomException {
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray = WjHUSwX.WjIqiGQ(ndPromItem.getRomEntry());
        String[] stringArray = new String[ndRepositoryVersionHistoryArray.length];
        for (int i = 0; i < ndRepositoryVersionHistoryArray.length; ++i) {
            stringArray[ndRepositoryVersionHistoryArray.length - i - 1] = ndRepositoryVersionHistoryArray[i].getComment();
        }
        return stringArray;
    }
}

