/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.admin.extensions;

import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.tools.NdEntryUpdateInfo;
import com.blazesoft.template.repository.NdRomConnectionManager;
import com.blazesoft.template.repository.NdRomDirectory;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.NdRomExplicitEntrySet;
import com.blazesoft.template.repository.NdRomFactory;
import com.blazesoft.template.repository.NdRomItem;
import com.blazesoft.template.repository.NdRomMutableItem;
import com.blazesoft.template.repository.NdRomVersioningDirectory;
import com.blazesoft.template.repository.admin.extensions.NdConnectedRomAdminExtensionContext;
import com.blazesoft.template.repository.admin.extensions.NdRomAdminExtension;
import com.blazesoft.template.repository.admin.extensions.NdRomAdminExtensionContext;

public abstract class NdRomItemAdminExtension
implements NdRomAdminExtension {
    private NdRomAdminExtensionContext WjIOsPD;
    private NdRomConnectionManager WjIOsQE;
    private boolean WjIOsRF;

    protected abstract void processArgs(String[] var1) throws NdRomException;

    protected abstract boolean updateItem(NdRomItem var1);

    protected boolean updateRom() throws NdRomException {
        return this.updateDirectory(this.WjIOsQE.getConnectionContext().getRoot(), true);
    }

    protected final NdRomAdminExtensionContext getRomAdminExtensionContext() {
        return this.WjIOsPD;
    }

    protected final NdRomConnectionManager getRomConnectionManager() {
        return this.WjIOsQE;
    }

    protected final boolean isVersioned() {
        return this.WjIOsRF;
    }

    protected boolean updateDirectory(NdRomDirectory ndRomDirectory, boolean bl) {
        boolean bl2 = true;
        try {
            NdRomEntry[] ndRomEntryArray = ndRomDirectory.getEntries();
            for (int i = 0; i < ndRomEntryArray.length; ++i) {
                if (ndRomEntryArray[i] instanceof NdRomDirectory) {
                    if (!bl) continue;
                    boolean bl3 = this.updateDirectory((NdRomDirectory)ndRomEntryArray[i], bl);
                    if (!bl2) continue;
                    bl2 = bl3;
                    continue;
                }
                NdRomItem ndRomItem = (NdRomItem)ndRomEntryArray[i];
                boolean bl4 = this.updateItem(ndRomItem);
                if (!bl2) continue;
                bl2 = bl4;
            }
        }
        catch (NdRomException ndRomException) {
            this.WjIOsPD.addUpdateInfo(new NdEntryUpdateInfo(ndRomDirectory.getLocation(), 4, (Exception)((Object)ndRomException)));
            bl2 = false;
        }
        return bl2;
    }

    protected NdEntryUpdateInfo updateItemContent(NdRomItem ndRomItem, String string, String string2) {
        NdEntryUpdateInfo ndEntryUpdateInfo;
        NdLocation ndLocation = ndRomItem.getLocation();
        try {
            if (this.WjIOsRF) {
                NdRomVersioningDirectory ndRomVersioningDirectory = (NdRomVersioningDirectory)ndRomItem.getParentDirectory();
                NdRomExplicitEntrySet ndRomExplicitEntrySet = new NdRomExplicitEntrySet((NdRomDirectory)ndRomVersioningDirectory, false, new NdRomEntry[]{ndRomItem});
                NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRomVersioningDirectory.getStatusInfos(ndRomExplicitEntrySet)[0];
                NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndRomVersioningDirectory.getLockInfos(ndRomExplicitEntrySet)[0];
                if (ndRepositoryVersionResultSet.getVersionStatus() == 1) {
                    ((NdRomMutableItem)ndRomItem).setContent(string);
                } else if (ndRepositoryEntryLockInfo.getLockStatus() == 2) {
                    ((NdRomMutableItem)ndRomItem).setContent(string);
                } else {
                    ndRomVersioningDirectory.checkOut(ndRomExplicitEntrySet);
                    ((NdRomMutableItem)ndRomItem).setContent(string);
                    ndRomVersioningDirectory.checkIn(string2, ndRomExplicitEntrySet);
                }
            } else {
                ((NdRomMutableItem)ndRomItem).setContent(string);
            }
            ndEntryUpdateInfo = new NdEntryUpdateInfo(ndLocation, 0);
        }
        catch (NdRomException ndRomException) {
            int n = this.WjIOsRF ? 3 : 4;
            ndEntryUpdateInfo = new NdEntryUpdateInfo(ndLocation, n, (Exception)((Object)ndRomException));
        }
        return ndEntryUpdateInfo;
    }

    protected void connect() throws NdRomException {
        if (this.WjIOsPD instanceof NdConnectedRomAdminExtensionContext) {
            this.WjIOsQE = ((NdConnectedRomAdminExtensionContext)this.WjIOsPD).getRomConnectionManager();
        } else {
            NdRomConnectionManager ndRomConnectionManager = NdRomFactory.newRepositoryConnectionManager(this.WjIOsPD.getWorkspaceConnection());
            ndRomConnectionManager.connect(1);
            this.WjIOsQE = ndRomConnectionManager;
        }
    }

    protected void disconnect() throws NdRomException {
        if (this.WjIOsPD instanceof NdConnectedRomAdminExtensionContext) {
            return;
        }
        NdRomConnectionManager ndRomConnectionManager = this.WjIOsQE;
        if (ndRomConnectionManager != null) {
            ndRomConnectionManager.disconnect();
            this.WjIOsQE = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(NdRomAdminExtensionContext ndRomAdminExtensionContext, String[] stringArray) throws NdRomException {
        boolean bl;
        this.WjIOsPD = ndRomAdminExtensionContext;
        this.processArgs(stringArray);
        this.connect();
        this.WjIOsRF = this.WjIOsQE.getConnectionContext().isVersionControlledRepository();
        try {
            bl = this.updateRom();
        }
        finally {
            try {
                this.disconnect();
            }
            finally {
                this.WjIOsPD = null;
                this.WjIOsRF = false;
            }
        }
        return bl;
    }
}

