/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.deploy;

import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.NdTemplateResolveException;
import com.blazesoft.template.repository.NdPromDirectory;
import com.blazesoft.template.repository.NdPromEntry;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomConnectionContext;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.deploy.NdAbstractPromExtractor;
import com.blazesoft.template.repository.deploy.NdPromItemExtractor;
import com.blazesoft.template.repository.deploy.NdPromItemFilter;
import com.blazesoft.template.repository.deploy.NdPromItemFixedResolvableFilter;
import com.blazesoft.template.repository.deploy.NdRomExtractorConfig;
import com.blazesoft.template.repository.deploy.NdStrings;
import com.blazesoft.template.repository.query.NdRomQuery;
import com.blazesoft.template.repository.query.NdRomQueryResultItem;
import com.blazesoft.template.repository.query.NdRomQueryResultSet;
import com.blazesoft.template.repository.util.NdPromProjectUtil;
import com.blazesoft.template.repository.util.NdRomSchemaSupport;
import com.blazesoft.template.repository.util.WjHUSwX;
import java.util.Date;
import java.util.Vector;

public class NdPromDefaultItemExtractor
extends NdAbstractPromExtractor
implements NdPromItemExtractor {
    private Date WjHNvLL;
    private NdPromItemFilter WjHNvMM;
    private NdPromItemFilter WjHNvNN;
    private int WjHPaSD;
    static /* synthetic */ Class class$com$blazesoft$template$repository$NdPromItem;

    public NdPromDefaultItemExtractor(NdRomExtractorConfig ndRomExtractorConfig, NdRomConnectionContext ndRomConnectionContext) throws NdRomException {
        this(ndRomExtractorConfig, ndRomConnectionContext, 0);
    }

    public NdPromDefaultItemExtractor(NdRomExtractorConfig ndRomExtractorConfig, NdRomConnectionContext ndRomConnectionContext, int n) throws NdRomException {
        super(ndRomExtractorConfig, ndRomConnectionContext);
        this.construct();
        this.WjHPaSD = n;
    }

    public NdPromDefaultItemExtractor(NdRomSchemaSupport ndRomSchemaSupport) {
        super(ndRomSchemaSupport);
        this.construct();
    }

    protected void construct() {
        this.WjHNvNN = this.WjHNvMM = new NdPromItemFixedResolvableFilter();
    }

    public NdPromItem[] extract(NdPromProject ndPromProject) throws NdRomException {
        if (this.getQueryConfig() != null) {
            if (this.getQueryManager() == null) {
                throw new NdRomException(NdStrings.WjHNgcP("CannotFindQueryManager"));
            }
            NdRomQuery ndRomQuery = this.lookupQuery(this.getQueryConfig());
            NdRomQueryResultSet ndRomQueryResultSet = this.executeQuery(ndRomQuery, ndPromProject);
            NdPromItem[] ndPromItemArray = this.getItemsFromResultSet(ndRomQuery.getName(), ndRomQueryResultSet);
            return this.filterItems(ndPromProject, ndPromItemArray);
        }
        NdPromItemFilter ndPromItemFilter = this.getItemFilter(ndPromProject);
        if (ndPromItemFilter != null) {
            this.setFilter(ndPromItemFilter);
        }
        return this.extractItems(ndPromProject);
    }

    protected NdPromItem[] extractItems(NdPromProject ndPromProject) throws NdRomException {
        NdPromEntry[] ndPromEntryArray;
        this.WjHNvLL = new Date();
        Vector vector = new Vector(100);
        try {
            ndPromEntryArray = this.getAllDirectoriesForBreadth(ndPromProject);
            for (int i = 0; i < ndPromEntryArray.length; ++i) {
                this.extract(ndPromEntryArray[i], vector);
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        catch (NdTemplateResolveException ndTemplateResolveException) {
            throw new NdRomException(ndTemplateResolveException);
        }
        ndPromEntryArray = new NdPromItem[vector.size()];
        vector.copyInto(ndPromEntryArray);
        return ndPromEntryArray;
    }

    protected NdPromItem[] getItemsFromResultSet(String string, NdRomQueryResultSet ndRomQueryResultSet) throws NdRomException {
        NdRomQueryResultItem[] ndRomQueryResultItemArray = ndRomQueryResultSet.getResults();
        int n = ndRomQueryResultItemArray.length;
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < n; ++i) {
            Object object = ndRomQueryResultItemArray[i].getResultObject();
            if (object instanceof NdPromItem) {
                vector.addElement(object);
                continue;
            }
            if (object instanceof NdPromDirectory) {
                NdPromItem[] ndPromItemArray = this.extract((NdPromDirectory)object);
                for (int j = 0; j < ndPromItemArray.length; ++j) {
                    vector.addElement(ndPromItemArray[j]);
                }
                continue;
            }
            throw new NdRomException(NdStrings.WjHNggT("ErrorQueryResultType", object, string, (class$com$blazesoft$template$repository$NdPromItem == null ? (class$com$blazesoft$template$repository$NdPromItem = NdPromDefaultItemExtractor.class$("com.blazesoft.template.repository.NdPromItem")) : class$com$blazesoft$template$repository$NdPromItem).getName()));
        }
        Object[] objectArray = new NdPromItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected NdPromItem[] filterItems(NdPromProject ndPromProject, NdPromItem[] ndPromItemArray) throws NdRomException {
        NdPromItemFilter ndPromItemFilter = this.getItemFilter(ndPromProject);
        if (ndPromItemFilter == null) {
            return ndPromItemArray;
        }
        Vector<NdPromItem> vector = new Vector<NdPromItem>(ndPromItemArray.length);
        for (int i = 0; i < ndPromItemArray.length; ++i) {
            if (!ndPromItemFilter.isPromItemIncluded(ndPromItemArray[i])) continue;
            vector.addElement(ndPromItemArray[i]);
        }
        Object[] objectArray = new NdPromItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void extract(NdPromDirectory ndPromDirectory, Vector vector) throws NdRomException, NdTemplateException, NdTemplateResolveException {
        NdRomEntry[] ndRomEntryArray = WjHUSwX.WjHUSvW(ndPromDirectory, false);
        for (int i = 0; i < ndRomEntryArray.length; ++i) {
            this.extract(ndRomEntryArray[i], vector);
        }
    }

    protected void extract(NdRomEntry ndRomEntry, Vector vector) throws NdRomException, NdTemplateException, NdTemplateResolveException {
        if (!this.WjHXZZC(ndRomEntry)) {
            if (ndRomEntry instanceof NdPromDirectory) {
                this.extract((NdPromDirectory)ndRomEntry, vector);
            } else if (ndRomEntry instanceof NdPromItem) {
                this.extract((NdPromItem)ndRomEntry, vector);
            } else {
                throw new IllegalArgumentException("Can't extract element of type: " + ndRomEntry.getClass().getName());
            }
        }
    }

    private boolean WjHXZZC(NdRomEntry ndRomEntry) {
        if (ndRomEntry == null) {
            return true;
        }
        String string = ndRomEntry.getStorageName();
        return string != null && string.startsWith("__Items for__");
    }

    protected void addItem(NdPromItem ndPromItem, Vector vector) {
        vector.addElement(ndPromItem);
    }

    protected void extractParameterizedEntity(NdPromItem ndPromItem, Vector vector) {
        throw new IllegalArgumentException("Parameterized entities not yet supported");
    }

    protected void extract(NdPromItem ndPromItem, Vector vector) throws NdRomException {
        if (this.getCurrentFilter().isPromItemIncluded(ndPromItem)) {
            this.addItem(ndPromItem, vector);
        }
    }

    protected NdPromItemFilter getCurrentFilter() {
        NdPromItemFilter ndPromItemFilter = this.WjHNvNN;
        if (ndPromItemFilter == null) {
            ndPromItemFilter = this.WjHNvMM;
        }
        return ndPromItemFilter;
    }

    protected NdPromDirectory[] getAllDirectoriesForBreadth(NdPromProject ndPromProject) throws NdRomException {
        NdPromDirectory[] ndPromDirectoryArray;
        switch (this.WjHPaSD) {
            case 0: {
                ndPromDirectoryArray = NdPromProjectUtil.getAllDirectories(ndPromProject, true, true);
                break;
            }
            case 1: {
                ndPromDirectoryArray = NdPromProjectUtil.getAllDirectories(ndPromProject, false, true);
                break;
            }
            case 2: {
                ndPromDirectoryArray = NdPromProjectUtil.getAllDirectories(ndPromProject.getSystemProject(), false, true);
                break;
            }
            default: {
                throw new NdRomException(NdStrings.WjHNgcP("InvalidBreadthTypeProvided"));
            }
        }
        return ndPromDirectoryArray;
    }

    public boolean hasChanged(NdPromProject ndPromProject) throws NdRomException {
        boolean bl = false;
        if (this.WjHNvLL == null) {
            bl = true;
        } else {
            NdPromItem[] ndPromItemArray = this.extract(ndPromProject);
            for (int i = 0; i < ndPromItemArray.length; ++i) {
                NdPromItem ndPromItem = ndPromItemArray[i];
                if (!ndPromItem.getLastModified().after(this.WjHNvLL)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setFilter(NdPromItemFilter ndPromItemFilter) {
        this.WjHNvNN = ndPromItemFilter;
    }

    public void resetFilter() {
        this.setFilter(this.WjHNvMM);
    }

    public void setBreadth(int n) {
        this.WjHPaSD = n;
    }

    public void resetBreadth() {
        this.setBreadth(0);
    }

    public NdPromItem[] extract(NdPromDirectory ndPromDirectory) throws NdRomException {
        Object[] objectArray;
        Vector vector = new Vector(100);
        try {
            this.extract(ndPromDirectory, vector);
            objectArray = new NdPromItem[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        catch (NdTemplateResolveException ndTemplateResolveException) {
            throw new NdRomException(ndTemplateResolveException);
        }
        return objectArray;
    }

    public NdPromItem[] extract(NdPromItem[] ndPromItemArray) throws NdRomException {
        Vector<NdPromItem> vector = new Vector<NdPromItem>(100);
        for (int i = 0; i < ndPromItemArray.length; ++i) {
            if (!this.getCurrentFilter().isPromItemIncluded(ndPromItemArray[i])) continue;
            vector.addElement(ndPromItemArray[i]);
        }
        Object[] objectArray = new NdPromItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

