/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.query.checker;

import com.blazesoft.template.repository.objects.rules.NdPromSrlArithmeticAssignment;
import com.blazesoft.template.repository.objects.rules.NdPromSrlAssignment;
import com.blazesoft.template.repository.objects.rules.NdPromSrlBetween;
import com.blazesoft.template.repository.objects.rules.NdPromSrlBinaryExpression;
import com.blazesoft.template.repository.objects.rules.NdPromSrlBlock;
import com.blazesoft.template.repository.objects.rules.NdPromSrlCall;
import com.blazesoft.template.repository.objects.rules.NdPromSrlCast;
import com.blazesoft.template.repository.objects.rules.NdPromSrlClassTest;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConcat;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstBuiltIn;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstDate;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstInteger;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstMoney;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstReal;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstString;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstTime;
import com.blazesoft.template.repository.objects.rules.NdPromSrlConstTimeStamp;
import com.blazesoft.template.repository.objects.rules.NdPromSrlCreate;
import com.blazesoft.template.repository.objects.rules.NdPromSrlDelete;
import com.blazesoft.template.repository.objects.rules.NdPromSrlElse;
import com.blazesoft.template.repository.objects.rules.NdPromSrlEveryIndexed;
import com.blazesoft.template.repository.objects.rules.NdPromSrlExpression;
import com.blazesoft.template.repository.objects.rules.NdPromSrlForEach;
import com.blazesoft.template.repository.objects.rules.NdPromSrlGenericType;
import com.blazesoft.template.repository.objects.rules.NdPromSrlIdentifier;
import com.blazesoft.template.repository.objects.rules.NdPromSrlIf;
import com.blazesoft.template.repository.objects.rules.NdPromSrlIndex;
import com.blazesoft.template.repository.objects.rules.NdPromSrlIndexed;
import com.blazesoft.template.repository.objects.rules.NdPromSrlInstantiation;
import com.blazesoft.template.repository.objects.rules.NdPromSrlIt;
import com.blazesoft.template.repository.objects.rules.NdPromSrlLocalNamedObject;
import com.blazesoft.template.repository.objects.rules.NdPromSrlLoop;
import com.blazesoft.template.repository.objects.rules.NdPromSrlMemberProperty;
import com.blazesoft.template.repository.objects.rules.NdPromSrlMethod;
import com.blazesoft.template.repository.objects.rules.NdPromSrlNew;
import com.blazesoft.template.repository.objects.rules.NdPromSrlOld;
import com.blazesoft.template.repository.objects.rules.NdPromSrlQuantifiedTest;
import com.blazesoft.template.repository.objects.rules.NdPromSrlQuantity;
import com.blazesoft.template.repository.objects.rules.NdPromSrlRaw;
import com.blazesoft.template.repository.objects.rules.NdPromSrlReturn;
import com.blazesoft.template.repository.objects.rules.NdPromSrlSelect;
import com.blazesoft.template.repository.objects.rules.NdPromSrlStatement;
import com.blazesoft.template.repository.objects.rules.NdPromSrlThrow;
import com.blazesoft.template.repository.objects.rules.NdPromSrlTry;
import com.blazesoft.template.repository.objects.rules.NdPromSrlUnaryExpression;
import com.blazesoft.template.repository.objects.rules.WjHKGbW;
import com.blazesoft.template.repository.objects.rules.WjHKNWK;
import com.blazesoft.template.repository.query.NdPromInternalQueryUtil;
import com.blazesoft.template.repository.query.NdPromQueryContext;
import com.blazesoft.template.repository.query.NdPromQueryElementLookup;
import com.blazesoft.template.repository.query.NdRomQueryContext;
import com.blazesoft.template.repository.query.NdRomQueryException;
import com.blazesoft.template.repository.query.checker.NdRomQueryPrimitive;

public abstract class NdPromSrlExpressionEvaluator {
    private NdRomQueryPrimitive WjIaedU;

    public NdPromSrlExpressionEvaluator(NdRomQueryPrimitive ndRomQueryPrimitive) {
        this.WjIaedU = ndRomQueryPrimitive;
    }

    public NdPromSrlExpressionEvaluator() {
        this(null);
    }

    protected boolean isConstantExpr(NdPromSrlExpression ndPromSrlExpression) {
        int n = ndPromSrlExpression.getExpressionType();
        return n == 9 || n == 10 || n == 11 || n == 12 || n == 14 || n == 15 || n == 16 || n == 17;
    }

    protected NdRomQueryContext getQueryContext() {
        return this.WjIaedU.getQueryContext();
    }

    protected Object lookupElement(String string) throws NdRomQueryException {
        return this.getLookup().lookupElement(string, this.getQueryContext().getScope());
    }

    protected Object lookupElement(NdPromSrlGenericType ndPromSrlGenericType) throws NdRomQueryException {
        return this.getLookup().lookupElement(ndPromSrlGenericType, this.getQueryContext().getScope());
    }

    protected Object lookupElement(String string, Object object) throws NdRomQueryException {
        return this.getLookup().lookupElement(string, object);
    }

    protected NdPromQueryElementLookup getLookup() {
        return ((NdPromQueryContext)this.getQueryContext()).getLookup();
    }

    public void evaluateExpressions(NdPromSrlExpression[] ndPromSrlExpressionArray) throws NdRomQueryException {
        int n = ndPromSrlExpressionArray != null ? ndPromSrlExpressionArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.evaluateExpression(ndPromSrlExpressionArray[i]);
        }
    }

    public void evaluateExpression(NdPromSrlExpression ndPromSrlExpression) throws NdRomQueryException {
        if (ndPromSrlExpression != null) {
            int n = ndPromSrlExpression.getExpressionType();
            if (n == 18) {
                this.evaluateIdentifier((NdPromSrlIdentifier)ndPromSrlExpression);
            } else if (n == 15) {
                this.evaluateConstString((NdPromSrlConstString)ndPromSrlExpression);
            } else if (n == 11) {
                this.evaluateConstInteger((NdPromSrlConstInteger)ndPromSrlExpression);
            } else if (n == 9) {
                this.evaluateConstBuiltIn((NdPromSrlConstBuiltIn)ndPromSrlExpression);
            } else if (n == 14) {
                this.evaluateConstReal((NdPromSrlConstReal)ndPromSrlExpression);
            } else if (n == 12) {
                this.evaluateConstMoney((NdPromSrlConstMoney)ndPromSrlExpression);
            } else if (n == 10) {
                this.evaluateConstDate((NdPromSrlConstDate)ndPromSrlExpression);
            } else if (n == 16) {
                this.evaluateConstTime((NdPromSrlConstTime)ndPromSrlExpression);
            } else if (n == 17) {
                this.evaluateConstTimeStamp((NdPromSrlConstTimeStamp)ndPromSrlExpression);
            } else if (n == 22) {
                this.evaluateMemberProperty((NdPromSrlMemberProperty)ndPromSrlExpression);
            } else if (ndPromSrlExpression instanceof NdPromSrlBinaryExpression) {
                this.evaluateBinaryExpr((NdPromSrlBinaryExpression)ndPromSrlExpression);
            } else if (n == 8) {
                this.evaluateConcat((NdPromSrlConcat)ndPromSrlExpression);
            } else if (n == 5) {
                this.evaluateCall((NdPromSrlCall)ndPromSrlExpression);
            } else if (n == 19) {
                this.evaluateIndexed((NdPromSrlIndexed)ndPromSrlExpression);
            } else if (n == 34) {
                this.evaluateEveryIndexed((NdPromSrlEveryIndexed)ndPromSrlExpression);
            } else if (n == 21) {
                this.evaluateIt((NdPromSrlIt)ndPromSrlExpression);
            } else if (n == 23) {
                this.evaluateMethod((NdPromSrlMethod)ndPromSrlExpression);
            } else if (n == 6) {
                this.evaluateCast((NdPromSrlCast)ndPromSrlExpression);
            } else if (n == 20) {
                this.evaluateInstantiation((NdPromSrlInstantiation)ndPromSrlExpression);
            } else if (ndPromSrlExpression instanceof NdPromSrlUnaryExpression) {
                this.evaluateUnaryExpr((NdPromSrlUnaryExpression)ndPromSrlExpression);
            } else if (n == 7) {
                this.evaluateClassTest((NdPromSrlClassTest)ndPromSrlExpression);
            } else if (n == 27) {
                this.evaluateQuantity((NdPromSrlQuantity)ndPromSrlExpression);
            } else if (n == 26) {
                this.evaluateQuantifiedTest((NdPromSrlQuantifiedTest)ndPromSrlExpression);
            } else if (n == 28) {
                this.evaluateRaw((NdPromSrlRaw)ndPromSrlExpression);
            } else if (n == 24) {
                this.evaluateNew((NdPromSrlNew)ndPromSrlExpression);
            } else if (n == 25) {
                this.evaluateOld((NdPromSrlOld)ndPromSrlExpression);
            } else if (n == 1) {
                this.evaluateBetween((NdPromSrlBetween)ndPromSrlExpression);
            } else {
                throw new NdRomQueryException("A unknown expr type: " + ndPromSrlExpression.getClass().getName());
            }
        }
    }

    public void evaluateUnaryExpr(NdPromSrlUnaryExpression ndPromSrlUnaryExpression) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlUnaryExpression.getSrlExpression());
    }

    public void evaluateConcat(NdPromSrlConcat ndPromSrlConcat) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlConcat.getSrlExpression1());
        this.evaluateExpression(ndPromSrlConcat.getSrlExpression2());
    }

    public void evaluateConstBuiltIn(NdPromSrlConstBuiltIn ndPromSrlConstBuiltIn) throws NdRomQueryException {
    }

    public void evaluateConstDate(NdPromSrlConstDate ndPromSrlConstDate) throws NdRomQueryException {
    }

    public void evaluateConstInteger(NdPromSrlConstInteger ndPromSrlConstInteger) throws NdRomQueryException {
    }

    public void evaluateConstMoney(NdPromSrlConstMoney ndPromSrlConstMoney) throws NdRomQueryException {
    }

    public void evaluateConstReal(NdPromSrlConstReal ndPromSrlConstReal) throws NdRomQueryException {
    }

    public void evaluateConstString(NdPromSrlConstString ndPromSrlConstString) throws NdRomQueryException {
    }

    public void evaluateConstTime(NdPromSrlConstTime ndPromSrlConstTime) throws NdRomQueryException {
    }

    public void evaluateConstTimeStamp(NdPromSrlConstTimeStamp ndPromSrlConstTimeStamp) throws NdRomQueryException {
    }

    public void evaluateIndexed(NdPromSrlIndexed ndPromSrlIndexed) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlIndexed.getSrlExpression());
        NdPromSrlIndex[] ndPromSrlIndexArray = ndPromSrlIndexed.getSrlIndexes();
        for (int i = 0; i < ndPromSrlIndexArray.length; ++i) {
            this.evaluateExpression(ndPromSrlIndexArray[i].getSrlExpression());
        }
    }

    public void evaluateEveryIndexed(NdPromSrlEveryIndexed ndPromSrlEveryIndexed) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlEveryIndexed.getSrlExpression());
    }

    public void evaluateRaw(NdPromSrlRaw ndPromSrlRaw) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlRaw.getSrlExpression());
    }

    public void evaluateIt(NdPromSrlIt ndPromSrlIt) throws NdRomQueryException {
    }

    public void evaluateBetween(NdPromSrlBetween ndPromSrlBetween) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlBetween.getSrlExpression());
        this.evaluateExpression(ndPromSrlBetween.getSrlLowerLimit().getSrlExpression());
        this.evaluateExpression(ndPromSrlBetween.getSrlUpperLimit().getSrlExpression());
    }

    public abstract void evaluateBinaryExpr(NdPromSrlBinaryExpression var1) throws NdRomQueryException;

    public abstract void evaluateCall(NdPromSrlCall var1) throws NdRomQueryException;

    public abstract void evaluateCast(NdPromSrlCast var1) throws NdRomQueryException;

    public abstract void evaluateClassTest(NdPromSrlClassTest var1) throws NdRomQueryException;

    public abstract void evaluateIdentifier(NdPromSrlIdentifier var1) throws NdRomQueryException;

    public abstract void evaluateInstantiation(NdPromSrlInstantiation var1) throws NdRomQueryException;

    public abstract void evaluateMemberProperty(NdPromSrlMemberProperty var1) throws NdRomQueryException;

    public abstract void evaluateNew(NdPromSrlNew var1) throws NdRomQueryException;

    public abstract void evaluateOld(NdPromSrlOld var1) throws NdRomQueryException;

    public abstract void evaluateQuantifiedTest(NdPromSrlQuantifiedTest var1) throws NdRomQueryException;

    public abstract void evaluateMethod(NdPromSrlMethod var1) throws NdRomQueryException;

    public abstract void evaluateQuantity(NdPromSrlQuantity var1) throws NdRomQueryException;

    public void evaluateStatements(NdPromSrlStatement[] ndPromSrlStatementArray) throws NdRomQueryException {
        int n = ndPromSrlStatementArray != null ? ndPromSrlStatementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.evaluateStatement(ndPromSrlStatementArray[i]);
        }
    }

    public void evaluateStatement(NdPromSrlStatement ndPromSrlStatement) throws NdRomQueryException {
        if (ndPromSrlStatement != null) {
            int n = ndPromSrlStatement.getStatementType();
            if (n == 6) {
                this.evaluateAssignment((NdPromSrlAssignment)ndPromSrlStatement);
            } else if (n == 5) {
                this.evaluateArithmeticAssignment((NdPromSrlArithmeticAssignment)ndPromSrlStatement);
            } else if (n == 7) {
                this.evaluateInstantiationAssignment((WjHKGbW)ndPromSrlStatement);
            } else if (n == 16) {
                this.evaluateCall((NdPromSrlCall)ndPromSrlStatement);
            } else if (n == 15) {
                this.evaluateVariableDeclaration((WjHKNWK)ndPromSrlStatement);
            } else if (n == 11) {
                this.evaluateReturn((NdPromSrlReturn)ndPromSrlStatement);
            } else if (n == 18) {
                this.evaluateMethod((NdPromSrlMethod)ndPromSrlStatement);
            } else if (n == 8) {
                this.evaluateIf((NdPromSrlIf)ndPromSrlStatement);
            } else if (n == 4) {
                this.evaluateForEach((NdPromSrlForEach)ndPromSrlStatement);
            } else if (n == 9) {
                this.evaluateLocalNamedObject((NdPromSrlLocalNamedObject)ndPromSrlStatement);
            } else if (n == 12) {
                this.evaluateSelect((NdPromSrlSelect)ndPromSrlStatement);
            } else if (n == 10) {
                this.evaluateLoop((NdPromSrlLoop)ndPromSrlStatement);
            } else if (n == 2) {
                this.evaluateCreate((NdPromSrlCreate)ndPromSrlStatement);
            } else if (n == 3) {
                this.evaluateDelete((NdPromSrlDelete)ndPromSrlStatement);
            } else if (n == 1) {
                this.evaluateBlock((NdPromSrlBlock)ndPromSrlStatement);
            } else if (n == 17) {
                this.evaluateMemberProperty((NdPromSrlMemberProperty)ndPromSrlStatement);
            } else if (n == 19) {
                this.evaluateRaw((NdPromSrlRaw)ndPromSrlStatement);
            } else if (n == 13) {
                this.evaluateThrow((NdPromSrlThrow)ndPromSrlStatement);
            } else if (n == 14) {
                this.evaluateTry((NdPromSrlTry)ndPromSrlStatement);
            } else {
                throw new NdRomQueryException("A unknown stmt type: " + ndPromSrlStatement.getClass().getName());
            }
        }
    }

    public void evaluateBlock(NdPromSrlBlock ndPromSrlBlock) throws NdRomQueryException {
        this.evaluateStatements(ndPromSrlBlock.getSrlStatements());
    }

    public void evaluateDelete(NdPromSrlDelete ndPromSrlDelete) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlDelete.getSrlExpression());
    }

    public void evaluateIf(NdPromSrlIf ndPromSrlIf) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlIf.getSrlTest().getSrlExpression());
        this.evaluateStatements(ndPromSrlIf.getSrlThen().getSrlStatements());
        NdPromSrlElse ndPromSrlElse = ndPromSrlIf.getSrlElse();
        this.evaluateStatements(ndPromSrlElse != null ? ndPromSrlElse.getSrlStatements() : new NdPromSrlStatement[]{});
    }

    public void evaluateLoop(NdPromSrlLoop ndPromSrlLoop) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlLoop.getSrlLoopTest().getSrlExpression());
        this.evaluateStatements(ndPromSrlLoop.getSrlDo().getSrlStatements());
    }

    public void evaluateReturn(NdPromSrlReturn ndPromSrlReturn) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlReturn.getSrlExpression());
    }

    public void evaluateThrow(NdPromSrlThrow ndPromSrlThrow) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlThrow.getSrlExpression());
    }

    public void evaluateAssignment(NdPromSrlAssignment ndPromSrlAssignment) throws NdRomQueryException {
        this.evaluateExpression(ndPromSrlAssignment.getSrlExpression());
        this.evaluateExpression(ndPromSrlAssignment.getAssigneeSrlExpression());
    }

    public abstract void evaluateTry(NdPromSrlTry var1) throws NdRomQueryException;

    public abstract void evaluateSelect(NdPromSrlSelect var1) throws NdRomQueryException;

    public abstract void evaluateArithmeticAssignment(NdPromSrlArithmeticAssignment var1) throws NdRomQueryException;

    public abstract void evaluateInstantiationAssignment(WjHKGbW var1) throws NdRomQueryException;

    public abstract void evaluateCreate(NdPromSrlCreate var1) throws NdRomQueryException;

    public abstract void evaluateForEach(NdPromSrlForEach var1) throws NdRomQueryException;

    public abstract void evaluateLocalNamedObject(NdPromSrlLocalNamedObject var1) throws NdRomQueryException;

    public abstract void evaluateVariableDeclaration(WjHKNWK var1) throws NdRomQueryException;

    protected void dbgTrace(String string) {
        NdPromInternalQueryUtil.verboseDbgTrace(string);
    }
}

