/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.query.java.xref;

import com.blazesoft.engines.rules.NdClassProviderResource;
import com.blazesoft.engines.rules.jdbc.NdDefJDBCClassProviderResource;
import com.blazesoft.objects.base.NdExternalValueProperty;
import com.blazesoft.template.repository.NdPromDirectory;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomDirectory;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.NdRomItem;
import com.blazesoft.template.repository.objects.bom.NdPromBom;
import com.blazesoft.template.repository.objects.bom.NdPromClass;
import com.blazesoft.template.repository.objects.bom.NdPromExternalBomContent;
import com.blazesoft.template.repository.objects.flow.NdPromFlowDecision;
import com.blazesoft.template.repository.objects.flow.NdPromFlowDecisionBranch;
import com.blazesoft.template.repository.objects.flow.NdPromFlowEventset;
import com.blazesoft.template.repository.objects.flow.NdPromFlowFlow;
import com.blazesoft.template.repository.objects.flow.NdPromFlowLoop;
import com.blazesoft.template.repository.objects.flow.NdPromFlowRuleflow;
import com.blazesoft.template.repository.objects.group.NdPromGroup;
import com.blazesoft.template.repository.objects.group.NdPromGroupItem;
import com.blazesoft.template.repository.objects.rules.NdPromSrlNamedObject;
import com.blazesoft.template.repository.objects.rules.NdPromSrlReasonCodeList;
import com.blazesoft.template.repository.objects.rules.NdPromSrlRuleset;
import com.blazesoft.template.repository.query.NdPromInternalQueryUtil;
import com.blazesoft.template.repository.query.NdPromQueryUtil;
import com.blazesoft.template.repository.query.java.NdPromJavaQueryIterator;
import com.blazesoft.template.repository.util.WjHUSwX;

public class NdPromJavaXRefQueryIterator
extends NdPromJavaQueryIterator {
    public NdPromJavaXRefQueryIterator(boolean bl) {
        super(bl);
    }

    public NdPromJavaXRefQueryIterator() {
    }

    private void WjIaKEM(NdPromProject ndPromProject, NdPromDirectory[] ndPromDirectoryArray) throws NdRomException {
        if (ndPromDirectoryArray != null) {
            for (int i = 0; i < ndPromDirectoryArray.length; ++i) {
                this._updateStackFromDirectoryInProject(ndPromProject, ndPromDirectoryArray[i]);
            }
        }
    }

    protected void _updateStackFromDirectoryInProject(NdPromProject ndPromProject, NdPromDirectory ndPromDirectory) throws NdRomException {
        if (ndPromDirectory != null) {
            NdRomEntry[] ndRomEntryArray = WjHUSwX.WjHUSvW(ndPromDirectory, false);
            int n = ndRomEntryArray == null ? 0 : ndRomEntryArray.length;
            for (int i = 0; i < n; ++i) {
                if (ndRomEntryArray[i] instanceof NdRomItem) {
                    this.updateStack((Object)ndPromProject, ndRomEntryArray[i]);
                    continue;
                }
                if (!(ndRomEntryArray[i] instanceof NdRomDirectory)) continue;
                this._updateStackFromDirectoryInProject(ndPromProject, (NdPromDirectory)ndRomEntryArray[i]);
            }
        }
    }

    protected void _updateStackFromDirectory(NdPromDirectory ndPromDirectory) throws NdRomException {
        if (ndPromDirectory != null) {
            NdRomEntry[] ndRomEntryArray = WjHUSwX.WjHUSvW(ndPromDirectory, false);
            int n = ndRomEntryArray == null ? 0 : ndRomEntryArray.length;
            for (int i = 0; i < n; ++i) {
                if (ndRomEntryArray[i] instanceof NdRomItem) {
                    this.updateStack((Object)ndPromDirectory, ndRomEntryArray[i]);
                    continue;
                }
                if (!(ndRomEntryArray[i] instanceof NdPromDirectory)) continue;
                this._updateStackFromDirectory((NdPromDirectory)ndRomEntryArray[i]);
            }
        }
    }

    protected void updateStackFromRuleset(NdPromSrlRuleset ndPromSrlRuleset) {
        Object[] objectArray = ndPromSrlRuleset.getSrlRulesetItems();
        this.updateStack((Object)ndPromSrlRuleset, objectArray);
    }

    protected void updateStackFromClass(NdPromClass ndPromClass) {
        Object[] objectArray = ndPromClass.getDeclaredProperties();
        this.updateStack((Object)ndPromClass, objectArray);
        NdExternalValueProperty ndExternalValueProperty = ndPromClass.getDeclaredValueProperty();
        if (ndExternalValueProperty != null) {
            this.updateStack((Object)ndPromClass, ndExternalValueProperty);
        }
    }

    protected void updateStackFromNamedObject(NdPromSrlNamedObject ndPromSrlNamedObject) {
        Object[] objectArray = ndPromSrlNamedObject.getSrlProperties();
        this.updateStack((Object)ndPromSrlNamedObject, objectArray);
    }

    protected void updateStackFromReasonCodeList(NdPromSrlReasonCodeList ndPromSrlReasonCodeList) {
        Object[] objectArray = ndPromSrlReasonCodeList.getSrlReasonCodes();
        this.updateStack((Object)ndPromSrlReasonCodeList, objectArray);
    }

    protected void updateStackFromBom(NdPromBom ndPromBom) {
        NdPromClass[] ndPromClassArray = ndPromBom.getClasses();
        for (int i = 0; i < ndPromClassArray.length; ++i) {
            if (!NdPromQueryUtil.isUserDefinedClass(ndPromBom, ndPromClassArray[i])) continue;
            this.updateStack((Object)ndPromBom, ndPromClassArray[i]);
        }
    }

    protected void updateStackFromRuleflow(NdPromFlowRuleflow ndPromFlowRuleflow) {
        Object[] objectArray = new Object[]{ndPromFlowRuleflow.getFlowFlow()};
        this.updateStack((Object)ndPromFlowRuleflow, objectArray);
    }

    protected void updateStackFromRuleflowDecision(NdPromFlowDecision ndPromFlowDecision) {
        Object[] objectArray = ndPromFlowDecision.getFlowDecisionBranches();
        this.updateStack((Object)ndPromFlowDecision, objectArray);
    }

    protected void updateStackFromRuleflowDecisionBranch(NdPromFlowDecisionBranch ndPromFlowDecisionBranch) {
        NdPromFlowFlow ndPromFlowFlow = ndPromFlowDecisionBranch.getFlowFlow();
        this.updateStack((Object)ndPromFlowDecisionBranch, ndPromFlowFlow);
    }

    protected void updateStackFromRuleflowLoop(NdPromFlowLoop ndPromFlowLoop) {
        Object[] objectArray = new Object[]{ndPromFlowLoop.getFlowFlow()};
        this.updateStack((Object)ndPromFlowLoop, objectArray);
    }

    protected void updateStackFromRuleflowEventset(NdPromFlowEventset ndPromFlowEventset) {
        Object[] objectArray = ndPromFlowEventset.getFlowEvents();
        this.updateStack((Object)ndPromFlowEventset, objectArray);
    }

    protected void updateStackFromRuleflowFlow(NdPromFlowFlow ndPromFlowFlow) {
        Object[] objectArray = ndPromFlowFlow.getFlowFlowItems();
        this.updateStack((Object)ndPromFlowFlow, objectArray);
    }

    protected void updateStackFromPromProject(NdPromProject ndPromProject) {
        try {
            this.WjIaKEM(ndPromProject, ndPromProject.getAllNonSystemDirectories());
        }
        catch (NdRomException ndRomException) {
            NdPromInternalQueryUtil.verboseDbgTrace((Exception)((Object)ndRomException));
        }
    }

    protected void updateStackFromExternalBomContent(NdPromExternalBomContent ndPromExternalBomContent) {
        Object[] objectArray;
        NdPromBom ndPromBom;
        NdClassProviderResource ndClassProviderResource;
        try {
            ndClassProviderResource = ndPromExternalBomContent.getClassProviderResource();
            ndPromBom = ndPromExternalBomContent.getBom();
        }
        catch (NdRomException ndRomException) {
            NdPromInternalQueryUtil.verboseDbgTrace((Exception)((Object)ndRomException));
            return;
        }
        if (ndClassProviderResource instanceof NdDefJDBCClassProviderResource) {
            objectArray = NdPromQueryUtil.getConnectionParams(((NdDefJDBCClassProviderResource)ndClassProviderResource).getConnectionInfos());
            this.updateStack((Object)ndPromExternalBomContent, objectArray);
        }
        int n = (objectArray = ndPromBom.getClasses()) == null ? 0 : objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!NdPromQueryUtil.isUserDefinedClass(ndPromBom, (NdPromClass)objectArray[i]) || ndPromBom.isCollectionClass((NdPromClass)objectArray[i])) continue;
            this.updateStack((Object)ndPromExternalBomContent, objectArray[i]);
        }
    }

    protected void updateStackFromGroup(NdPromGroup ndPromGroup) {
        if (ndPromGroup != null) {
            NdPromGroupItem[] ndPromGroupItemArray = ndPromGroup.getGroupItems();
            int n = ndPromGroupItemArray != null ? ndPromGroupItemArray.length : 0;
            for (int i = 0; i < n; ++i) {
                this.updateStack((Object)ndPromGroup, ndPromGroupItemArray[i]);
            }
        }
    }

    protected void updateStackFromPromDirectory(NdPromDirectory ndPromDirectory) {
        try {
            this._updateStackFromDirectory(ndPromDirectory);
        }
        catch (NdRomException ndRomException) {
            NdPromInternalQueryUtil.verboseDbgTrace((Exception)((Object)ndRomException));
            return;
        }
    }
}

