/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.reports;

import com.blazesoft.template.repository.reports.NdReportDetails;
import com.blazesoft.template.repository.reports.NdReportException;
import com.blazesoft.template.repository.reports.NdReportFileGenerator;
import com.blazesoft.template.repository.reports.NdReportTemplateLoader;
import com.blazesoft.template.repository.reports.NdStringBufferPool;
import com.blazesoft.template.repository.reports.NdStrings;
import com.blazesoft.util.NdGenerator;
import com.blazesoft.util.NdHashMap;
import com.blazesoft.util.WjHAavZ;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public abstract class NdDefReportFileGenerator
extends NdReportFileGenerator {
    private NdReportTemplateLoader WjISSMI = this.createTemplateLoader();
    private NdStringBufferPool WjISSNJ;
    private boolean WjISSOK;
    private String WjISSPL;
    protected static final int FILE_TYPE_NONE = 0;
    protected static final int FILE_TYPE_CONTENT = 1;
    protected static final int FILE_TYPE_NAVIGATION = 2;

    protected NdDefReportFileGenerator(NdStringBufferPool ndStringBufferPool) {
        this.WjISSNJ = ndStringBufferPool;
        this.WjISSPL = "";
    }

    protected NdDefReportFileGenerator() {
        this(null);
    }

    private void WjITrCH(String string, String string2, Object object, NdHashMap ndHashMap) throws NdReportException {
        try {
            if (object != null) {
                String string3 = this.getAbsoluteFileName(string2);
                Object object2 = null;
                if (object instanceof String) {
                    this.WjISSPL = string;
                    object2 = this.generateTextContent(string, (String)object);
                    if (!this.getReportDetails().getConfig().getBooleanProperty("inMemory")) {
                        this.generateTextFile(string3, (String)object2);
                    }
                } else if (object instanceof BufferedInputStream) {
                    object2 = this.generateBinaryContent((BufferedInputStream)object);
                    if (!this.getReportDetails().getConfig().getBooleanProperty("inMemory")) {
                        this.generateBinaryFile(string3, (byte[])object2);
                    }
                }
                ndHashMap.put((Object)string2, object2);
            }
        }
        catch (Exception exception) {
            throw new NdReportException(NdStrings.WjISPJK("ErrorGeneratingFile", string2, exception.toString()));
        }
    }

    protected static String cleanFileNameSeps(String string) {
        String string2 = string;
        string2 = string2.replace('\\', FILE_SEP_CHAR);
        if ((string2 = string2.replace('/', FILE_SEP_CHAR)).startsWith(FILE_SEP)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    protected static String replaceNameElement(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, string.indexOf(string2)));
        stringBuffer.append(string3);
        stringBuffer.append(string.substring(string.indexOf(string2) + string2.length()));
        return stringBuffer.toString();
    }

    protected static String replaceContentsSuffix(String string) {
        int n = string.indexOf("Contents");
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append(NdStrings.WjISPGH("Contents"));
            stringBuffer.append(string.substring(n + "Contents".length()));
            return stringBuffer.toString();
        }
        return string;
    }

    protected boolean isShowingLinks() {
        return this.WjISSOK;
    }

    protected void setShowingLinks(boolean bl) {
        this.WjISSOK = bl;
    }

    protected NdStringBufferPool getStringBufferPool() {
        return this.WjISSNJ;
    }

    protected NdReportTemplateLoader getTemplateLoader() {
        return this.WjISSMI;
    }

    protected String generateRelativeFileName(String string) throws NdReportException {
        return this.generateRelativeFileName(string, 0);
    }

    protected File createValidFile(String string) throws NdReportException {
        File file = new File(string);
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new NdReportException(NdStrings.WjISPIJ("ErrorCreatingFile", string));
        }
        return file;
    }

    protected String generateTextContent(String string, String string2) {
        this.WjISSPL = string;
        return this.WjHAbhB(new NdGenerator.GeneratorSource((WjHAavZ)this, string, string2));
    }

    protected void generateTextFile(String string, String string2) throws IOException, NdReportException {
        File file = this.createValidFile(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(outputStreamWriter), false);
        printWriter.write(string2);
        printWriter.close();
    }

    protected void generateBinaryFile(String string, byte[] byArray) throws IOException, NdReportException {
        File file = this.createValidFile(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.close();
    }

    protected byte[] generateBinaryContent(BufferedInputStream bufferedInputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[]{};
        n = bufferedInputStream.available();
        byArray = new byte[n];
        bufferedInputStream.read(byArray);
        bufferedInputStream.close();
        return byArray;
    }

    protected String getCurrentTemplateName() {
        return this.WjISSPL;
    }

    protected String getAbsoluteFileName(String string) {
        return this.getReportDetails().getLocation().toString() + File.separator + string;
    }

    protected abstract NdReportTemplateLoader createTemplateLoader();

    protected abstract String generateRelativeFileName(String var1, int var2) throws NdReportException;

    protected abstract NdReportDetails getReportDetails();

    public void generateFile(String string, NdHashMap ndHashMap) throws NdReportException {
        String string2 = this.generateRelativeFileName(string, 1);
        String string3 = this.getTemplateLoader().loadContentsTemplate(string);
        this.WjITrCH(string, string2, string3, ndHashMap);
    }

    public void generateNavigationFile(String string, NdHashMap ndHashMap) throws NdReportException {
        String string2 = this.generateRelativeFileName(string, 2);
        Object object = this.getTemplateLoader().loadNavigationTemplate(string);
        this.WjITrCH(string, string2, object, ndHashMap);
    }

    public void generateBinaryFile(String string, NdHashMap ndHashMap) throws NdReportException {
        String string2 = this.generateRelativeFileName(string);
        Object object = this.getTemplateLoader().loadBinaryContentsTemplate(string);
        this.WjITrCH(string, string2, object, ndHashMap);
    }

    public String generationTime() {
        return new Date().toLocaleString();
    }
}

