/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.reports;

import com.blazesoft.template.repository.objects.rules.NdPromSrlFunctional;
import com.blazesoft.template.repository.objects.rules.WjHKPCR;
import com.blazesoft.template.repository.reports.NdReportDetails;
import com.blazesoft.template.repository.reports.stat.NdEntityAdapter;
import com.blazesoft.template.repository.reports.stat.NdStaticReportConstants;
import com.blazesoft.util.NdIOUtil;
import com.blazesoft.util.NdSystemProperties;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NdReportUtility {
    private static final int WjISROJ = 128;
    private static final int WjJfinF = 50;
    private static final int WjJfinG = 47;

    protected static boolean isSignature(String string) {
        return string.indexOf("(") != -1 && string.indexOf(")->") != -1;
    }

    protected static String cleanSignature(String string) {
        String string2 = string;
        if (NdReportUtility.isSignature(string)) {
            String string3 = string.substring(0, string.indexOf("("));
            String string4 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            StringBuffer stringBuffer = new StringBuffer("");
            if (string4.indexOf(":") != -1) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    stringBuffer.append(string5.substring(string5.indexOf(":")));
                }
            }
            string2 = string3 + stringBuffer.toString();
        }
        return string2;
    }

    protected static String adjustNameLength(NdReportDetails ndReportDetails, String string) {
        Hashtable hashtable;
        String string2 = string;
        String string3 = string;
        if (string3.length() > 50 && (string2 = (String)(hashtable = ndReportDetails.WjJfhZZ()).get(string3)) == null) {
            string2 = string3.substring(0, 47);
            int n = 1;
            while (hashtable.contains(string2 + n)) {
                ++n;
            }
            string2 = string2 + n;
            hashtable.put(string3, string2);
        }
        return string2;
    }

    public static boolean isTopLevelEntity(NdEntityAdapter ndEntityAdapter) {
        boolean bl = false;
        String string = ndEntityAdapter.getType();
        for (int i = 0; i < NdStaticReportConstants.TOP_LEVEL_RES_TYPES.length; ++i) {
            String string2 = NdStaticReportConstants.TOP_LEVEL_RES_TYPES[i];
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getCleanSignature(NdPromSrlFunctional ndPromSrlFunctional) {
        return NdReportUtility.cleanSignature(WjHKPCR.WjJaqoN(ndPromSrlFunctional));
    }

    public static String makePlural(String string) {
        String string2 = string;
        string2 = string.toLowerCase().endsWith("s") ? string2 + "es" : (string.toLowerCase().endsWith("y") ? string2.substring(0, string2.length() - 1) + "ies" : string2 + "s");
        return string2;
    }

    public static String removeWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String removeSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isJavaIdentifierPart(cArray[i])) continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String convertToLink(NdReportDetails ndReportDetails, String string) {
        String string2;
        Hashtable hashtable = null;
        if (ndReportDetails != null && (string2 = (hashtable = ndReportDetails.WjJEhBD()).get(string)) instanceof String) {
            return string2;
        }
        string2 = NdReportUtility.removeWhitespace(string);
        string2 = NdReportUtility.removeSpecialChars(string2);
        string2 = NdReportUtility.adjustNameLength(ndReportDetails, string2);
        if (!NdSystemProperties.isRetainNonAsciiCharsInZipEntryName()) {
            string2 = NdIOUtil.replaceUnicodeCharsInName((String)string2);
        }
        if (hashtable != null) {
            int n = 1;
            String string3 = string2;
            while (true) {
                if (!hashtable.contains(string3)) break;
                string3 = string2 + "_" + n;
                ++n;
            }
            string2 = string3;
            hashtable.put(string, string2);
        }
        return string2;
    }

    public static String createComplexEntityPageLink(NdReportDetails ndReportDetails, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<A HREF=\"");
        stringBuffer.append(ndReportDetails.getPrefix());
        stringBuffer.append(string2);
        stringBuffer.append(NdReportUtility.convertToLink(ndReportDetails, string3));
        stringBuffer.append(".html\">");
        stringBuffer.append(string);
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    public static String createComplexEntityPageInnerLink(NdReportDetails ndReportDetails, String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<A HREF=\"");
        stringBuffer.append(ndReportDetails.getPrefix());
        stringBuffer.append(string2);
        stringBuffer.append(NdReportUtility.convertToLink(ndReportDetails, string3));
        stringBuffer.append(".html#");
        stringBuffer.append(string4);
        stringBuffer.append(NdReportUtility.convertToLink(ndReportDetails, string5));
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    public static String createSimpleEntityPageLink(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<A HREF=\"");
        stringBuffer.append(string2);
        stringBuffer.append(NdReportUtility.makePlural(string3));
        stringBuffer.append(".html\">");
        stringBuffer.append(string);
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    public static String makeNameValid(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) {
                bl = false;
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (!Character.isWhitespace(cArray[i]) || bl) continue;
            bl = true;
            stringBuffer.append("_");
        }
        return stringBuffer.toString();
    }

    public static String createSimpleEntityPageInnerLink(NdReportDetails ndReportDetails, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<A HREF=\"");
        stringBuffer.append(ndReportDetails.getPrefix());
        stringBuffer.append(NdReportUtility.makePlural(string2));
        stringBuffer.append(".html#");
        stringBuffer.append(NdReportUtility.convertToLink(ndReportDetails, string3));
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }
}

