/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.reports.stat;

import com.blazesoft.template.engine.NdTemplate;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.objects.NdPromInstance;
import com.blazesoft.template.repository.reports.NdDefReportFileGenerator;
import com.blazesoft.template.repository.reports.NdReportDetails;
import com.blazesoft.template.repository.reports.NdReportException;
import com.blazesoft.template.repository.reports.NdReportTemplateLoader;
import com.blazesoft.template.repository.reports.NdReportUtility;
import com.blazesoft.template.repository.reports.NdStringBufferPool;
import com.blazesoft.template.repository.reports.stat.NdEntityAdapter;
import com.blazesoft.template.repository.reports.stat.NdStaticReportConstants;
import com.blazesoft.template.repository.reports.stat.NdStaticReportDetails;
import com.blazesoft.template.repository.reports.stat.NdStaticReportDocSupport;
import com.blazesoft.template.repository.reports.stat.NdStrings;
import com.blazesoft.template.repository.reports.stat.NdSubReportGenerator;
import com.blazesoft.util.NdGenerator;
import com.blazesoft.util.NdHashMap;
import com.blazesoft.util.NdLocalizedConstants;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public abstract class NdStaticReportFileGenerator
extends NdDefReportFileGenerator
implements NdStaticReportConstants {
    private int WjISNqE;
    private int WjISNrF;
    private String WjISNsG;
    private Stack WjISNtH;
    private String WjISNuI;
    public static final String GENERATOR_PREFIX = "SR";
    public static final String GUIDE_DIR = "guide";
    protected static final String PROP_TYPE_LOC = "Loc";
    protected static final String PROP_TYPE_PLURAL = "Plural";
    protected static final String PROP_TYPE_LINK = "Link";
    protected static final String PROP_TYPE_TYPE = "Type";
    protected static final String PROP_TYPE_ID = "ID";
    protected static final String PROP_VAL_TRUE = "true";

    protected NdStaticReportFileGenerator(NdStringBufferPool ndStringBufferPool) {
        super(ndStringBufferPool);
        this.WjHAavU(GENERATOR_PREFIX);
        this.setShowingLinks(true);
        this.WjISNtH = new Stack();
    }

    private String WjISNxL(String string, NdGenerator.CommandAttributes commandAttributes) {
        String string2 = string;
        String string3 = commandAttributes.getProperty(PROP_TYPE_LOC);
        String string4 = commandAttributes.getProperty(PROP_TYPE_PLURAL);
        String string5 = commandAttributes.getProperty(PROP_TYPE_LINK);
        if (string4 != null && string4.equalsIgnoreCase(PROP_VAL_TRUE)) {
            string2 = NdReportUtility.makePlural(string2);
        }
        if (string3 != null && string3.equalsIgnoreCase(PROP_VAL_TRUE)) {
            string2 = NdStrings.WjISQNJ(string2);
        } else if (string5 != null && string5.equalsIgnoreCase(PROP_VAL_TRUE)) {
            string2 = NdReportUtility.convertToLink(this.getReportDetails(), string2);
        }
        return string2;
    }

    protected NdEntityAdapter getCurrentEntityAdapter() {
        return (NdEntityAdapter)this.WjISNtH.peek();
    }

    protected void pushCurrentEntityAdapter(NdEntityAdapter ndEntityAdapter) {
        this.WjISNtH.push(ndEntityAdapter);
    }

    protected NdEntityAdapter popCurrentEntityAdapter() {
        return (NdEntityAdapter)this.WjISNtH.pop();
    }

    protected void setCurrentType(String string) {
        this.WjISNsG = string;
    }

    protected String getCurrentType() {
        return this.WjISNsG;
    }

    protected NdEntityAdapter[] getEntityAdaptersForType(String string) {
        return this.getParentEntityAdapter().getSubEntityAdaptersForType(string);
    }

    protected String generateRelativeFileName(String string, NdEntityAdapter ndEntityAdapter, boolean bl) {
        String string2 = string;
        NdStaticReportDetails ndStaticReportDetails = ndEntityAdapter.getReportDetails();
        if (string.indexOf("Prefix") != -1) {
            string2 = NdStaticReportFileGenerator.replaceNameElement(string2, "Prefix", ndStaticReportDetails.getPrefix());
        }
        if (string.indexOf("Name") != -1) {
            string2 = NdStaticReportFileGenerator.replaceNameElement(string2, "Name", NdReportUtility.convertToLink(ndStaticReportDetails, ndEntityAdapter.getName()));
        }
        String string3 = ndEntityAdapter.getType();
        if (string.indexOf("Types") != -1) {
            string2 = NdStaticReportFileGenerator.replaceNameElement(string2, "Types", NdReportUtility.makePlural(string3));
        } else if (string.indexOf(PROP_TYPE_TYPE) != -1) {
            string2 = NdStaticReportFileGenerator.replaceNameElement(string2, PROP_TYPE_TYPE, string3);
        }
        if (bl) {
            string2 = GUIDE_DIR + FILE_SEP + string2;
        }
        string2 = NdStaticReportFileGenerator.cleanFileNameSeps(string2);
        return string2;
    }

    protected String generateRelativeFileName(String string, int n) {
        String string2 = "";
        string2 = n == 1 ? this.generateRelativeFileName(string, this.getCurrentEntityAdapter(), true) : this.generateRelativeFileName(string, this.getCurrentEntityAdapter(), false);
        return string2;
    }

    protected NdReportTemplateLoader createTemplateLoader() {
        return new NdReportTemplateLoader("static");
    }

    protected NdReportDetails getReportDetails() {
        return this.getCurrentEntityAdapter().getReportDetails();
    }

    protected boolean isRmaReport() {
        return "contentReport".equals(this.getReportDetails().getConfig().getStringProperty("reportType"));
    }

    protected abstract NdEntityAdapter getParentEntityAdapter();

    protected NdStaticReportDocSupport getDocCommentSupport() {
        return this.getCurrentEntityAdapter().getReportDetails().getDocSupport();
    }

    protected boolean hasCommentTags() {
        NdStaticReportDocSupport ndStaticReportDocSupport = this.getDocCommentSupport();
        if (ndStaticReportDocSupport != null) {
            NdEntityAdapter ndEntityAdapter = this.getCurrentEntityAdapter();
            String[] stringArray = ndStaticReportDocSupport.getTopLevelTagList();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = ndStaticReportDocSupport.getDocContentsForDocType(ndEntityAdapter, stringArray[i]);
                if (string.length() <= 0) continue;
                return true;
            }
            String[] stringArray2 = ndStaticReportDocSupport.getCustomTags(ndEntityAdapter.getDocComment());
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = ndStaticReportDocSupport.getDocContentsForDocType(ndEntityAdapter, stringArray2[i]);
                if (string.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void generateNavigationFiles(NdHashMap ndHashMap) throws NdReportException {
        Vector vector = this.getTemplateLoader().getNavigationTemplates();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.generateNavigationFile(string, ndHashMap);
        }
    }

    public String projectName() {
        try {
            return this.getParentEntityAdapter().getReportDetails().getPromProject().getDisplayName();
        }
        catch (NdRomException ndRomException) {
            this.getCurrentEntityAdapter().getReportDetails().addException((Exception)((Object)ndRomException));
            return null;
        }
    }

    public String prefix() {
        return this.getParentEntityAdapter().getReportDetails().getPrefix();
    }

    public String getTitle() {
        return this.getParentEntityAdapter().getReportDetails().getTitle();
    }

    public String displayName(NdGenerator.CommandAttributes commandAttributes) {
        return this.WjISNxL(this.getCurrentEntityAdapter().getDisplayName(), commandAttributes);
    }

    public String name(NdGenerator.CommandAttributes commandAttributes) {
        return this.WjISNxL(this.getCurrentEntityAdapter().getName(), commandAttributes);
    }

    public String type(NdGenerator.CommandAttributes commandAttributes) {
        return this.WjISNxL(this.getCurrentEntityAdapter().getType(), commandAttributes);
    }

    public String severityImageName() {
        return "notImplelemtedYet";
    }

    public String docCommentLabel() {
        String string = "";
        boolean bl = this.docComment().length() > 0;
        boolean bl2 = this.hasCommentTags();
        if (bl || bl2) {
            string = "<STRONG>" + NdStrings.WjISQNJ("Comment") + ":</STRONG>";
            if (bl) {
                string = string + "<BR/><BR/>";
            }
        }
        return string;
    }

    public String docCommentFirstLine() {
        String string = "";
        NdStaticReportDocSupport ndStaticReportDocSupport = this.getDocCommentSupport();
        if (ndStaticReportDocSupport != null) {
            string = ndStaticReportDocSupport.commentFirstLine(this.getCurrentEntityAdapter());
        }
        return string;
    }

    public String docComment() {
        String string = "";
        NdStaticReportDocSupport ndStaticReportDocSupport = this.getDocCommentSupport();
        if (ndStaticReportDocSupport != null) {
            string = ndStaticReportDocSupport.commentFullText(this.getCurrentEntityAdapter());
        }
        return string;
    }

    public String docCategory() {
        String string = "";
        NdStaticReportDocSupport ndStaticReportDocSupport = this.getDocCommentSupport();
        if (ndStaticReportDocSupport != null && this.docContents().length() > 0) {
            string = ndStaticReportDocSupport.getDocLabelForDocType(this.WjISNuI);
        }
        return string;
    }

    public String docContents() {
        String string = "";
        NdStaticReportDocSupport ndStaticReportDocSupport = this.getDocCommentSupport();
        if (ndStaticReportDocSupport != null) {
            string = ndStaticReportDocSupport.getDocContentsForDocType(this.getCurrentEntityAdapter(), this.WjISNuI);
        }
        return string;
    }

    public String additionalInformation(NdGenerator.CommandAttributes commandAttributes) {
        String string = commandAttributes.getProperty(PROP_TYPE_LINK);
        boolean bl = string != null && PROP_VAL_TRUE.equals(string);
        return this.getCurrentEntityAdapter().getAdditionalInformation(bl);
    }

    public void setSectionNumber(int n) {
        this.WjISNqE = n;
    }

    public String sectionNumber() {
        return String.valueOf(this.WjISNqE);
    }

    public void setSubSectionNumber(int n) {
        this.WjISNrF = n;
    }

    public String subSectionNumber() {
        return String.valueOf(this.WjISNrF);
    }

    public String summary(NdGenerator.CommandAttributes commandAttributes) {
        return NdStrings.WjISQNL("Summary", this.type(commandAttributes));
    }

    public String details(NdGenerator.CommandAttributes commandAttributes) {
        return NdStrings.WjISQNL("Details", this.type(commandAttributes));
    }

    public String overviewTitle(NdGenerator.CommandAttributes commandAttributes) {
        return NdStrings.WjISQNM("OverviewTitle", this.type(commandAttributes), this.getTitle());
    }

    public String abbreviatedOverviewTitle(NdGenerator.CommandAttributes commandAttributes) {
        return NdStrings.WjISQNN("AbbreviatedOverviewTitle", this.type(commandAttributes), this.getTitle(), this.generationTime());
    }

    public String reportTitle(NdGenerator.CommandAttributes commandAttributes) {
        return NdStrings.WjISQNM("ReportTitle", this.type(commandAttributes), this.getTitle());
    }

    public String abbreviatedReportTitle(NdGenerator.CommandAttributes commandAttributes) {
        return NdStrings.WjISQNN("AbbreviatedReportTitle", this.type(commandAttributes), this.getTitle(), this.generationTime());
    }

    public String projectSummaryTitle() {
        if (this.isRmaReport()) {
            return NdStrings.WjISQNL("RMAProjectSummaryTitle", this.getTitle());
        }
        return NdStrings.WjISQNL("ProjectSummaryTitle", this.getTitle());
    }

    public String abbreviatedProjectSummaryTitle() {
        if (this.isRmaReport()) {
            return NdStrings.WjISQNM("RMAAbbreviatedProjectSummaryTitle", this.getTitle(), this.generationTime());
        }
        return NdStrings.WjISQNM("AbbreviatedProjectSummaryTitle", this.getTitle(), this.generationTime());
    }

    public String projectContentsSummary() {
        if (this.isRmaReport()) {
            return NdStrings.WjISQNJ("RmaProjectContentsSummary");
        }
        return NdStrings.WjISQNJ("ProjectContentsSummary");
    }

    public String crossReferenceInformation() {
        return NdStrings.WjISQNJ("CrossReferenceInformation");
    }

    public String potentialConflictSummary() {
        return NdStrings.WjISQNJ("PotentialConflictSummary");
    }

    public String projectSummary() {
        if (this.isRmaReport()) {
            return NdStrings.WjISQNJ("RmaProjectSummary");
        }
        return NdStrings.WjISQNJ("ProjectSummary");
    }

    public String printerFriendlyVersion() {
        return NdStrings.WjISQNJ("PrinterFriendlyVersion");
    }

    public String generatedReportTitle() {
        if (this.isRmaReport()) {
            return NdStrings.WjISQNJ("RmaReportTitle");
        }
        return NdStrings.WjISQNJ("GeneratedReportTitle");
    }

    public String generatedReportIntro() {
        return NdStrings.WjISQNJ("GeneratedReportIntro");
    }

    public String generatedReportInstructions() {
        return NdStrings.WjISQNJ("GeneratedReportInstructions");
    }

    public String copyrightMessage() {
        return "";
    }

    public String noFramesMessage() {
        return NdStrings.WjISQNJ("NoFramesMessage");
    }

    public String externalParentMessage() {
        if (!"instance".equals(this.getCurrentEntityAdapter().getType())) {
            return "";
        }
        String string = "";
        String string2 = "template";
        Object object = this.getCurrentEntityAdapter().getEntity();
        try {
            if (object instanceof NdPromInstance) {
                string = this._getNameOfTemplate((NdPromInstance)object);
            } else if (object instanceof NdPromItem && ((NdPromItem)object).getItemContent() instanceof NdPromInstance) {
                string = this._getNameOfTemplate((NdPromInstance)((NdPromItem)object).getItemContent());
            }
        }
        catch (NdRomException ndRomException) {
            this.getCurrentEntityAdapter().getReportDetails().addException((Exception)((Object)ndRomException));
        }
        return string.length() > 0 ? NdStrings.WjISQNJ(string2) + NdLocalizedConstants.getColon() + string : "";
    }

    protected String _getNameOfTemplate(NdPromInstance ndPromInstance) {
        try {
            NdTemplate ndTemplate = ndPromInstance.getTemplate();
            if (ndTemplate != null) {
                return ndTemplate.getDisplayName() != null ? ndTemplate.getDisplayName() : ndTemplate.getIdeName();
            }
        }
        catch (NdTemplateException ndTemplateException) {
            this.getCurrentEntityAdapter().getReportDetails().addException((Exception)((Object)ndTemplateException));
        }
        return "";
    }

    public String subReport(NdGenerator.CommandAttributes commandAttributes) throws NdReportException {
        NdStaticReportDetails ndStaticReportDetails;
        NdSubReportGenerator ndSubReportGenerator;
        String string = "";
        String string2 = commandAttributes.getProperty(PROP_TYPE_ID);
        if (string2 != null && (ndSubReportGenerator = (ndStaticReportDetails = this.getCurrentEntityAdapter().getReportDetails()).getSubReportGenerator(string2)) != null) {
            string = ndSubReportGenerator.getSubReport(this.isShowingLinks(), this.getCurrentEntityAdapter());
        }
        return string;
    }

    public String hasCrossReference(NdGenerator.GeneratorSource generatorSource) {
        NdStaticReportDetails ndStaticReportDetails;
        NdSubReportGenerator ndSubReportGenerator;
        String string = "";
        if (this.getCurrentEntityAdapter() != null && (ndSubReportGenerator = (ndStaticReportDetails = this.getCurrentEntityAdapter().getReportDetails()).getSubReportGenerator("CrossReference")) != null) {
            string = this.WjHAbhB(generatorSource);
        }
        return string;
    }

    public String hasImage(NdGenerator.GeneratorSource generatorSource) {
        return "";
    }

    public String isComplexEntity(NdGenerator.GeneratorSource generatorSource) {
        String string = "";
        if (NdEntityAdapter.isComplex(this.getCurrentType())) {
            string = this.WjHAbhB(generatorSource);
        }
        return string;
    }

    public String isNotComplexEntity(NdGenerator.GeneratorSource generatorSource) {
        String string = "";
        if (!NdEntityAdapter.isComplex(this.getCurrentType())) {
            string = this.WjHAbhB(generatorSource);
        }
        return string;
    }

    public String hasExternalParent(NdGenerator.GeneratorSource generatorSource) {
        String string = "";
        if ("instance".equals(this.getCurrentEntityAdapter().getType())) {
            string = this.WjHAbhB(generatorSource);
        }
        return string;
    }

    public String parentEntity(NdGenerator.GeneratorSource generatorSource) {
        StringBuffer stringBuffer = this.getStringBufferPool().get();
        this.setCurrentType(this.getCurrentEntityAdapter().getType());
        stringBuffer.append(this.WjHAbhB(generatorSource));
        String string = stringBuffer.toString();
        this.getStringBufferPool().put(stringBuffer);
        return string;
    }

    public String docElements(NdGenerator.GeneratorSource generatorSource) {
        Object object;
        StringBuffer stringBuffer = this.getStringBufferPool().get();
        NdEntityAdapter ndEntityAdapter = this.getCurrentEntityAdapter();
        NdStaticReportDocSupport ndStaticReportDocSupport = this.getDocCommentSupport();
        if (ndStaticReportDocSupport != null) {
            object = ndStaticReportDocSupport.getTopLevelTagList();
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.WjISNuI = object[i];
                stringBuffer.append(this.WjHAbhB(generatorSource));
                this.WjISNuI = null;
            }
            String[] stringArray = ndStaticReportDocSupport.getCustomTags(ndEntityAdapter.getDocComment());
            for (int i = 0; i < stringArray.length; ++i) {
                this.WjISNuI = stringArray[i];
                stringBuffer.append(this.WjHAbhB(generatorSource));
                this.WjISNuI = null;
            }
        }
        object = stringBuffer.toString();
        this.getStringBufferPool().put(stringBuffer);
        return object;
    }

    public String comment(NdGenerator.GeneratorSource generatorSource) {
        return "";
    }

    public String generationTimeMessage() {
        return NdStrings.WjISQNL("GenerationTimeMessage", this.generationTime());
    }

    public String description() {
        return this.getCurrentEntityAdapter().getReportDetails().getConfig().getStringProperty("description");
    }
}

