/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.reports.stat;

import com.blazesoft.objects.base.WjHBlWX;
import com.blazesoft.objects.base.WjHBmgM;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryConnectionLoader;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdPromProjectFactory;
import com.blazesoft.template.repository.NdRomConnectionContext;
import com.blazesoft.template.repository.NdRomConnectionException;
import com.blazesoft.template.repository.NdRomConnectionManager;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.NdRomFactory;
import com.blazesoft.template.repository.NdRomProject;
import com.blazesoft.template.repository.reports.NdReportConfig;
import com.blazesoft.template.repository.reports.NdReportException;
import com.blazesoft.template.repository.reports.NdReportGenerationLauncher;
import com.blazesoft.template.repository.reports.stat.NdStaticReportConstants;
import com.blazesoft.template.repository.reports.stat.NdStaticReportDetails;
import com.blazesoft.template.repository.reports.stat.NdStaticReportDetailsFactory;
import com.blazesoft.template.repository.reports.stat.NdStrings;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.NdExtensibleClassLoadingContextSupport;
import com.blazesoft.util.NdHashMap;
import java.io.File;
import java.util.Enumeration;

public class NdStaticReportGenerationLauncher
extends NdReportGenerationLauncher
implements NdStaticReportConstants {
    private NdClassLoadingContext WjISRnK = NdExtensibleClassLoadingContextSupport.newExtensibleClassLoadingContext((WjHBmgM)new WjHBlWX("nd.advisor.devutil"), null);

    private NdRomConnectionManager WjISRnL(String string) throws NdReportException {
        NdRepositoryConnection ndRepositoryConnection = null;
        if (string == null || string.length() == 0 || string.startsWith("-")) {
            throw new NdReportException(NdStrings.WjISQNJ("InvalidConnectionPath"));
        }
        File file = new File(string);
        try {
            Object object;
            if (file.exists()) {
                object = NdRepositoryConnectionLoader.getDefaultConnectionLoader(this.WjISRnK);
                ndRepositoryConnection = ((NdRepositoryConnectionLoader)((Object)object)).load(string);
            }
            if (ndRepositoryConnection instanceof NdWorkspaceConnection) {
                object = NdRomFactory.newRepositoryConnectionManager((NdWorkspaceConnection)ndRepositoryConnection);
                object.connect(0);
                return object;
            }
            throw new NdReportException(NdStrings.WjISQNL("FailedLoadingRepositoryConnectionFrom", string));
        }
        catch (NdRomConnectionException ndRomConnectionException) {
            throw new NdReportException((Throwable)((Object)ndRomConnectionException));
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw new NdReportException((Throwable)((Object)ndRepositoryException));
        }
        catch (NdRomException ndRomException) {
            throw new NdReportException((Throwable)((Object)ndRomException));
        }
    }

    private NdPromProject WjISRnM(NdRomConnectionManager ndRomConnectionManager, String string) throws NdReportException {
        NdPromProject ndPromProject;
        try {
            ndPromProject = null;
            NdRomConnectionContext ndRomConnectionContext = ndRomConnectionManager.getConnectionContext();
            NdLocation ndLocation = NdLocationFactory.createLocation(string);
            NdRomEntry ndRomEntry = ndRomConnectionContext.getRoot().lookupEntry(ndLocation);
            if (!(ndRomEntry instanceof NdRomProject)) {
                throw new NdReportException(NdStrings.WjISQNL("IsNotAValidProjectLocation", ((Object)ndLocation).toString()));
            }
            NdPromProjectFactory ndPromProjectFactory = ndRomConnectionContext.getProjectFactory();
            ndPromProject = ndPromProjectFactory.createProject((NdRomProject)ndRomEntry);
        }
        catch (NdRomConnectionException ndRomConnectionException) {
            throw new NdReportException((Throwable)((Object)ndRomConnectionException));
        }
        catch (NdRomException ndRomException) {
            throw new NdReportException((Throwable)((Object)ndRomException));
        }
        return ndPromProject;
    }

    private void WjISRnN(NdStaticReportDetails ndStaticReportDetails) {
        Exception[] exceptionArray = ndStaticReportDetails.getExceptions();
        int n = exceptionArray.length;
        if (n > 0) {
            System.err.println();
            System.err.println("With " + n + " errors:");
            for (int i = 0; i < n; ++i) {
                System.err.println(exceptionArray[i].getMessage());
            }
        }
    }

    private void WjITqNM(NdHashMap ndHashMap) {
        Enumeration enumeration = ndHashMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = ndHashMap.get((Object)string);
            System.out.print(string + ":\t");
            if (object instanceof String) {
                System.out.println("TEXT");
                continue;
            }
            System.out.println("BINARY");
        }
    }

    protected static void displayUsage() {
        System.err.println(NdStrings.WjISQNJ("ReportGenerationUsage"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate(String[] stringArray) {
        NdReportConfig ndReportConfig = new NdReportConfig();
        ndReportConfig.setProperty("reportType", "contentReport");
        String string = null;
        String string2 = null;
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-p")) {
                    ndReportConfig.setProperty("prefix", stringArray[++i].trim());
                    continue;
                }
                if (stringArray[i].equals("-l")) {
                    ndReportConfig.setProperty("location", stringArray[++i].trim());
                    continue;
                }
                if (stringArray[i].equals("-i")) {
                    ndReportConfig.setProperty("instanceOnly", new Boolean(stringArray[++i].trim()));
                    continue;
                }
                if (stringArray[i].equals("-m")) {
                    ndReportConfig.setProperty("inMemory", new Boolean(stringArray[++i].trim()));
                    continue;
                }
                if (stringArray[i].equals("-c")) {
                    string2 = stringArray[++i].trim();
                    continue;
                }
                string = stringArray[i].trim();
            }
        } else {
            NdStaticReportGenerationLauncher.displayUsage();
            System.exit(2);
        }
        if (string == null || string2 == null) {
            NdStaticReportGenerationLauncher.displayUsage();
            System.exit(2);
        }
        if (ndReportConfig.getStringProperty("prefix") == null) {
            ndReportConfig.setProperty("prefix", NdStaticReportGenerationLauncher.getDefaultPrefixName(string));
        }
        NdRomConnectionManager ndRomConnectionManager = null;
        ndRomConnectionManager = this.WjISRnL(string2);
        NdPromProject ndPromProject = this.WjISRnM(ndRomConnectionManager, string);
        NdStaticReportDetails ndStaticReportDetails = NdStaticReportDetailsFactory.createReportDetails(ndPromProject, ndReportConfig);
        ndStaticReportDetails.finish();
        if (ndReportConfig.getBooleanProperty("inMemory")) {
            this.WjITqNM(ndStaticReportDetails.getContentMap());
            System.out.println("Report complete.");
        } else {
            System.out.println("Report complete. Located at " + ndReportConfig.getStringProperty("location"));
        }
        this.WjISRnN(ndStaticReportDetails);
        Object var9_10 = null;
        if (ndRomConnectionManager == null) return;
        try {
            ndRomConnectionManager.disconnect();
            return;
        }
        catch (NdRomException ndRomException) {
            ndRomException.printStackTrace();
        }
        return;
        {
            catch (NdReportException ndReportException) {
                ndReportException.printStackTrace();
                Object var9_11 = null;
                if (ndRomConnectionManager == null) return;
                try {
                    ndRomConnectionManager.disconnect();
                    return;
                }
                catch (NdRomException ndRomException) {
                    ndRomException.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (ndRomConnectionManager == null) throw throwable;
            try {
                ndRomConnectionManager.disconnect();
                throw throwable;
            }
            catch (NdRomException ndRomException) {
                ndRomException.printStackTrace();
            }
            throw throwable;
        }
    }
}

