/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.util;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.template.engine.NdInstantiation;
import com.blazesoft.template.engine.NdInstantiationElement;
import com.blazesoft.template.engine.NdInstantiationException;
import com.blazesoft.template.engine.NdSourceInfo;
import com.blazesoft.template.engine.NdSourceInfoCollector;
import com.blazesoft.template.engine.NdStructuredInstance;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.source.NdInstantiationSourceInfo;
import com.blazesoft.template.repository.NdPromEntry;
import com.blazesoft.template.repository.NdPromInvalidItemContentException;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.objects.NdPromEntity;
import com.blazesoft.template.repository.objects.NdPromInstance;
import com.blazesoft.template.repository.objects.WjHKOpN;
import com.blazesoft.template.repository.objects.group.NdPromGroup;
import com.blazesoft.template.repository.objects.group.NdPromGroupItem;
import com.blazesoft.template.repository.util.NdStrings;
import com.blazesoft.template.repository.util.WjHUSwX;
import com.blazesoft.util.NdBaseObject;
import java.util.Vector;

public class NdPromInstanceUtil {
    public static boolean hasExternalSubInstance(NdPromInstance ndPromInstance) throws NdRomException {
        NdPromProject ndPromProject = ndPromInstance.getProject();
        ndPromProject.acquireLock();
        try {
            NdSourceInfo[] ndSourceInfoArray = NdSourceInfoCollector.collect(ndPromInstance);
            if (ndSourceInfoArray != null && ndSourceInfoArray.length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NdInstantiationException ndInstantiationException) {
            throw new NdRomException((Throwable)((Object)ndInstantiationException));
        }
        finally {
            ndPromProject.releaseLock();
        }
        return false;
    }

    public static boolean isEntryExternalSubInstance(NdRomEntry ndRomEntry) throws NdRomException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndRomEntry.getEntryAttributes(new String[]{"isSeparateStoredSubInstance"});
        return ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length == 1 && ndRepositoryEntryAttributeArray[0] != null && Boolean.TRUE.toString().equalsIgnoreCase(ndRepositoryEntryAttributeArray[0].getAttbValue());
    }

    public static boolean isSubInstanceExternal(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromProject ndPromProject = ndStructuredInstance.getManager().getProject();
        ndPromProject.acquireLock();
        try {
            boolean bl = ndStructuredInstance.getSourceInfo() != null;
            return bl;
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        finally {
            ndPromProject.releaseLock();
        }
    }

    public static NdPromEntity getResolvedEntity(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromEntity ndPromEntity;
        NdInstantiation ndInstantiation = ndStructuredInstance.getInstantiation();
        if (ndInstantiation instanceof NdPromInstance && (ndPromEntity = ((NdPromInstance)ndInstantiation).getResolvedEntity()) instanceof NdPromGroup) {
            NdPromGroupItem[] ndPromGroupItemArray = ((NdPromGroup)ndPromEntity).getGroupItems();
            for (int i = 0; i < ndPromGroupItemArray.length; ++i) {
                if (WjHKOpN.WjIFFvM((NdPromEntity)((Object)ndPromGroupItemArray[i])) != ndStructuredInstance) continue;
                return (NdPromEntity)((Object)ndPromGroupItemArray[i]);
            }
        }
        return null;
    }

    public static NdPromItem lookupPromItemForSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdInstantiationSourceInfo ndInstantiationSourceInfo;
        NdPromInstance ndPromInstance = (NdPromInstance)ndStructuredInstance.getInstantiation();
        if (ndPromInstance == null) {
            throw new NdRomException(NdStrings.WjHNtbG("SubInstanceNotAttached", ndStructuredInstance.getDisplayPath()));
        }
        NdPromItem ndPromItem = ndPromInstance.getItem();
        if (ndPromItem == null) {
            throw new NdRomException(NdStrings.WjHNtbG("CouldNotLocateInstance", ndPromInstance.getDisplayName()));
        }
        NdPromProject ndPromProject = ndPromItem.getProject();
        ndPromProject.acquireLock();
        try {
            ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        finally {
            ndPromProject.releaseLock();
        }
        if (ndInstantiationSourceInfo == null) {
            throw new NdRomException(NdStrings.WjHNtbG("SubInstanceIsNotStoredSeparately", ndStructuredInstance.getDisplayPath()));
        }
        NdLocation ndLocation = ndInstantiationSourceInfo.getRepositoryLocation();
        return ndLocation != null ? (NdPromItem)ndPromProject.lookupEntryByAbsoluteLocation(ndLocation) : null;
    }

    public static void saveSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
        NdPromInstanceUtil.saveSubInstance(ndPromItem, ndStructuredInstance);
    }

    public static void saveSubInstance(NdPromItem ndPromItem, NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromInstance ndPromInstance;
        try {
            ndPromInstance = (NdPromInstance)ndPromItem.getItemContent();
        }
        catch (NdPromInvalidItemContentException ndPromInvalidItemContentException) {
            ndPromInstance = (NdPromInstance)ndPromItem.getItemContent();
        }
        ndStructuredInstance.populateInstantiation(ndPromInstance);
        ndPromItem.save();
    }

    public static void checkInSubInstance(NdStructuredInstance ndStructuredInstance, String string) throws NdRomException {
        NdPromProject ndPromProject = ndStructuredInstance.getManager().getProject();
        ndPromProject.acquireLock();
        try {
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
            if (ndInstantiationSourceInfo != null) {
                NdPromInstanceUtil.saveSubInstance(ndStructuredInstance);
                NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
                WjHUSwX.WjIdmwC(ndPromItem, string);
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        finally {
            ndPromProject.releaseLock();
        }
    }

    public static void checkOutSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromProject ndPromProject = ndStructuredInstance.getManager().getProject();
        ndPromProject.acquireLock();
        try {
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
            if (ndInstantiationSourceInfo != null) {
                NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
                WjHUSwX.WjIdmwD(ndPromItem);
                ndStructuredInstance.loadFromSource();
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        finally {
            ndPromProject.releaseLock();
        }
    }

    public static void cancelCheckOutSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromProject ndPromProject = ndStructuredInstance.getManager().getProject();
        ndPromProject.acquireLock();
        try {
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
            if (ndInstantiationSourceInfo != null) {
                NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
                WjHUSwX.WjIdmwE(ndPromItem);
                ndStructuredInstance.loadFromSource();
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        finally {
            ndPromProject.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdInstantiationElement getStructuredInstanceForExternalPromInstance(NdPromItem ndPromItem) {
        try {
            NdPromProject ndPromProject = ndPromItem.getProject();
            ndPromProject.acquireLock();
            try {
                NdPromEntry ndPromEntry = NdPromInstanceUtil.getParentOfExternalInstance(ndPromItem);
                NdPromInstance ndPromInstance = (NdPromInstance)((NdPromItem)ndPromEntry).getItemContent();
                NdSourceInfo[] ndSourceInfoArray = NdSourceInfoCollector.collect(ndPromInstance);
                if (ndSourceInfoArray == null) return null;
                if (ndSourceInfoArray.length <= 0) return null;
                NdLocation ndLocation = ndPromItem.getLocation();
                int n = 0;
                while (n < ndSourceInfoArray.length) {
                    NdSourceInfo ndSourceInfo = ndSourceInfoArray[n];
                    NdLocation ndLocation2 = ndSourceInfo.getRepositoryLocation();
                    if (ndLocation2 != null && ndLocation2.equals(ndLocation)) {
                        String string = ndSourceInfo.getPath();
                        NdInstantiationElement ndInstantiationElement = ndPromInstance.lookup(string);
                        return ndInstantiationElement;
                    }
                    ++n;
                }
                return null;
            }
            finally {
                ndPromProject.releaseLock();
            }
        }
        catch (NdRomException ndRomException) {
            return null;
        }
        catch (NdInstantiationException ndInstantiationException) {
            // empty catch block
        }
        return null;
    }

    public static String getDisplayPathForExternalPromInstance(NdPromItem ndPromItem, boolean bl) throws NdRomException {
        NdInstantiationElement ndInstantiationElement;
        String string = "";
        NdPromEntry ndPromEntry = NdPromInstanceUtil.getParentOfExternalInstance(ndPromItem);
        if (ndPromEntry != null) {
            string = string + WjHUSwX.WjIdmnR(ndPromEntry);
        }
        if ((ndInstantiationElement = NdPromInstanceUtil.getStructuredInstanceForExternalPromInstance(ndPromItem)) != null) {
            string = string + "." + ndInstantiationElement.getDisplayPath();
        }
        if (bl) {
            string = string + "/" + ndPromItem.getDisplayName();
        }
        return string;
    }

    public static NdPromEntry getParentOfExternalInstance(NdPromItem ndPromItem) throws NdRomException {
        String[] stringArray = ndPromItem.getParentDirectory().getLocation().getComponents();
        String string = stringArray[stringArray.length - 1];
        string = string.substring("__Items for__".length());
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length - 1);
        stringArray2[stringArray.length - 1] = string;
        NdLocation ndLocation = NdLocationFactory.createLocation(stringArray2, true);
        return ndPromItem.getProject().lookupEntryByAbsoluteLocation(ndLocation);
    }

    public static NdPromItem[] getExternalInstanceItems(NdPromInstance ndPromInstance) throws NdRomException {
        Object[] objectArray;
        NdPromProject ndPromProject = ndPromInstance.getProject();
        Vector<NdPromEntry> vector = new Vector<NdPromEntry>();
        try {
            objectArray = NdSourceInfoCollector.collect(ndPromInstance);
            for (int i = 0; i < objectArray.length; ++i) {
                NdLocation ndLocation;
                if (!(objectArray[i] instanceof NdInstantiationSourceInfo) || (ndLocation = objectArray[i].getRepositoryLocation()) == null) continue;
                vector.addElement(ndPromProject.lookupEntryByAbsoluteLocation(ndLocation));
            }
        }
        catch (NdInstantiationException ndInstantiationException) {
            throw new NdRomException((Throwable)((Object)ndInstantiationException));
        }
        objectArray = new NdPromItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void checkInExternalInstances(NdPromInstance ndPromInstance, String string) throws NdRomException {
        Vector<NdWorkspaceItem> vector = new Vector<NdWorkspaceItem>();
        NdWorkspaceDirectory ndWorkspaceDirectory = null;
        NdPromItem[] ndPromItemArray = NdPromInstanceUtil.getExternalInstanceItems(ndPromInstance);
        for (int i = 0; i < ndPromItemArray.length; ++i) {
            try {
                NdWorkspaceItem ndWorkspaceItem = (NdWorkspaceItem)ndPromItemArray[i].getWorkspaceEntry();
                NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndWorkspaceItem.getEntryLockInfo();
                if (!NdRepositorySupport.isCheckedOutByThisUser(ndRepositoryEntryLockInfo)) continue;
                vector.addElement(ndWorkspaceItem);
                if (ndWorkspaceDirectory != null) continue;
                ndWorkspaceDirectory = (NdWorkspaceDirectory)ndWorkspaceItem.getContainerDirectory();
                continue;
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRomException((Throwable)((Object)ndRepositoryException));
            }
        }
        Object[] objectArray = new NdWorkspaceEntry[vector.size()];
        vector.copyInto(objectArray);
        if (ndWorkspaceDirectory != null) {
            try {
                ndWorkspaceDirectory.checkIn((NdWorkspaceEntry[])objectArray, string, false, false);
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRomException((Throwable)((Object)ndRepositoryException));
            }
        }
    }

    public static NdPromInstance getInstanceSection(NdPromInstance ndPromInstance, String string) throws NdRomException {
        NdPromInstance ndPromInstance2;
        if (string.equals("0") || string.equals("0")) {
            ndPromInstance2 = ndPromInstance;
        } else if (string.equals("2")) {
            ndPromInstance2 = (NdPromInstance)ndPromInstance.getInstanceManagementProperties();
        } else if (string.equals("3")) {
            ndPromInstance2 = (NdPromInstance)ndPromInstance.getItem().getEntryManagementProperties();
        } else {
            throw NdBaseObject.internalError((String)("Unexpected instance section " + string));
        }
        return ndPromInstance2;
    }

    public static NdInstantiationElement getStoredInstantiationElement(NdInstantiationElement ndInstantiationElement, String string) throws NdTemplateException {
        NdInstantiationElement ndInstantiationElement2 = null;
        if (string != null && string.trim().length() > 0) {
            ndInstantiationElement2 = ndInstantiationElement.safeLookup(string);
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndInstantiationElement2.getSourceInfo();
            while (ndInstantiationSourceInfo == null && ndInstantiationElement2 != null) {
                if ((ndInstantiationElement2 = ndInstantiationElement2.getParent()) == null) continue;
                ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndInstantiationElement2.getSourceInfo();
            }
        }
        if (ndInstantiationElement2 == null) {
            ndInstantiationElement2 = ndInstantiationElement;
        }
        return ndInstantiationElement2;
    }
}

