/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.consistency;

import com.blazesoft.template.repository.objects.flow.NdPromFlowTest;
import com.blazesoft.template.repository.objects.rules.NdPromSrlUntil;
import com.blazesoft.template.repository.objects.rules.NdPromSrlWhile;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdAnomalyType;
import com.blazesoft.verifier.NdToken;
import com.blazesoft.verifier.NdVerifierCallback;
import com.blazesoft.verifier.cfa.NdBranchAnnotation;
import com.blazesoft.verifier.cfa.consistency.NdConsistencyAnomalyHelper;
import com.blazesoft.verifier.cfa.consistency.NdMonotonicTerm;
import com.blazesoft.verifier.cfa.consistency.NdSplitConsistencyToken;
import com.blazesoft.verifier.cfa.consistency.NdStrings;
import com.blazesoft.verifier.cfg.NdStateVertex;
import com.blazesoft.verifier.dfa.NdMonotonicPropagationToken;
import com.blazesoft.verifier.er.NdExternalAstNode;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.prom.NdVerifierAdapter;
import com.blazesoft.verifier.util.NdStack;
import com.blazesoft.verifier.util.NdVerifierLog;

public class NdLoopConsistencyVerifier
extends NdVerifierAdapter {
    public static final String COMPONENT_ID = "LoopConsistencyVerifier";
    public static final int STATE_NOT_TESTED = 0;
    public static final int STATE_BODY_TESTED = 1;
    public static final int STATE_BODY_REDUNDANT = 2;
    public static final Integer STATE_NOT_TESTED_V = new Integer(0);
    public static final Integer STATE_BODY_TESTED_V = new Integer(1);
    public static final Integer STATE_BODY_REDUNDANT_V = new Integer(2);
    public static final NdAnomalyType[] SUPPORTED_ANOMALIES = new NdAnomalyType[]{NdSplitConsistencyToken.PROCEDURAL_LOOP_REDUNDANT, NdSplitConsistencyToken.PROCEDURAL_LOOP_INFINITE};
    private NdStack WjInmxZ = new NdStack();

    private void WjIBfSP(boolean bl, String string, NdExternalAstNode ndExternalAstNode, NdToken ndToken, NdToken ndToken2, NdVerifierCallback ndVerifierCallback) {
        Integer n = (Integer)this.WjInmxZ.pop();
        switch (n) {
            case 0: {
                NdMonotonicTerm ndMonotonicTerm = ((NdMonotonicPropagationToken)ndToken2).peekMonotonicTerm();
                if (ndMonotonicTerm == NdMonotonicTerm.TERM_REDUNDANT) {
                    this.WjInmxZ.push(STATE_BODY_REDUNDANT_V);
                } else {
                    this.WjInmxZ.push(STATE_BODY_TESTED_V);
                }
                if (!NdVerifierLog.isTraceEnabled(COMPONENT_ID)) break;
                NdVerifierLog.trace(COMPONENT_ID, string + ": first test condition passed");
                break;
            }
            case 1: {
                NdMonotonicTerm ndMonotonicTerm = ((NdMonotonicPropagationToken)ndToken2).peekMonotonicTerm();
                if (ndMonotonicTerm == NdMonotonicTerm.TERM_CONSTANT_TRUE || ndMonotonicTerm.isUnset()) {
                    if (NdVerifierLog.isTraceEnabled(COMPONENT_ID)) {
                        NdVerifierLog.trace(COMPONENT_ID, string + ": infinite loop");
                    }
                    if (NdSplitConsistencyToken.PROCEDURAL_LOOP_INFINITE.isEnabled()) {
                        ndVerifierCallback.fireAnomaly(NdConsistencyAnomalyHelper.makeAnomaly(COMPONENT_ID, NdSplitConsistencyToken.PROCEDURAL_LOOP_INFINITE, NdStrings.WjIBjaW(NdSplitConsistencyToken.PROCEDURAL_LOOP_INFINITE.getMessageId()), ndExternalAstNode));
                    }
                } else if (ndMonotonicTerm == NdMonotonicTerm.TERM_UNDECIDABLE) {
                    if (NdVerifierLog.isTraceEnabled(COMPONENT_ID)) {
                        NdVerifierLog.trace(COMPONENT_ID, string + ": finitness is undecidable and ignored");
                    }
                } else if (NdVerifierLog.isTraceEnabled(COMPONENT_ID)) {
                    NdVerifierLog.trace(COMPONENT_ID, string + ": loop is finite");
                }
                if (!NdVerifierLog.isTraceEnabled(COMPONENT_ID)) break;
                NdVerifierLog.trace(COMPONENT_ID, string + ": body and second test condition passed");
                break;
            }
            case 2: {
                if (!NdVerifierLog.isTraceEnabled(COMPONENT_ID)) break;
                NdVerifierLog.trace(COMPONENT_ID, string + ": ignored redundant loop");
                break;
            }
            default: {
                throw NdBaseObject.apiError((String)"Unexpected loop verifier state");
            }
        }
    }

    public String getComponentName() {
        return COMPONENT_ID;
    }

    public void setContext(NdVerificationContext ndVerificationContext) {
    }

    public NdAnomalyType[] getSupportedAnomalies() {
        return SUPPORTED_ANOMALIES;
    }

    public void verify(NdPromSrlWhile ndPromSrlWhile, NdStateVertex ndStateVertex, NdToken ndToken, NdToken ndToken2, NdVerifierCallback ndVerifierCallback) {
        this.WjIBfSP(true, "While", ndStateVertex.getAstToken(), ndToken, ndToken2, ndVerifierCallback);
    }

    public void verify(NdPromSrlUntil ndPromSrlUntil, NdStateVertex ndStateVertex, NdToken ndToken, NdToken ndToken2, NdVerifierCallback ndVerifierCallback) {
        this.WjIBfSP(false, "Until", ndStateVertex.getAstToken(), ndToken, ndToken2, ndVerifierCallback);
    }

    public void verify(NdPromFlowTest ndPromFlowTest, NdStateVertex ndStateVertex, NdToken ndToken, NdToken ndToken2, NdVerifierCallback ndVerifierCallback) {
        this.WjIBfSP(true, "Rule Flow Loop", ndStateVertex.getAstToken(), ndToken, ndToken2, ndVerifierCallback);
    }

    public void verifyLoopBegin(NdExternalAstNode ndExternalAstNode, NdToken ndToken, NdVerifierCallback ndVerifierCallback) {
        if (NdVerifierLog.isTraceEnabled(COMPONENT_ID)) {
            NdVerifierLog.trace(COMPONENT_ID, "Loop: started");
        }
        this.WjInmxZ.push(STATE_NOT_TESTED_V);
    }

    public void verifyLoopEnd(NdExternalAstNode ndExternalAstNode, NdBranchAnnotation ndBranchAnnotation, NdToken ndToken, NdVerifierCallback ndVerifierCallback) {
        if (NdVerifierLog.isTraceEnabled(COMPONENT_ID)) {
            NdVerifierLog.trace(COMPONENT_ID, "Loop: completed");
        }
    }
}

