/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.consistency;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.predicate.NdConstantTerm;

public class NdMonotonicTerm {
    public static final int UNSET = 0;
    public static final int CONSTANT_N = 1;
    public static final int CONSTANT_P = 2;
    public static final int CONSTANT = 3;
    public static final int MONOTONIC_UP = 4;
    public static final int MONOTONIC_DN = 5;
    public static final int UNDECIDABLE = 6;
    public static final int REDUNDANT = 7;
    public static final NdMonotonicTerm TERM_UNSET = new NdMonotonicTerm(0, "unset");
    public static final NdMonotonicTerm TERM_CONSTANT_P = new NdMonotonicTerm(2, "constant+");
    public static final NdMonotonicTerm TERM_CONSTANT_N = new NdMonotonicTerm(1, "constant-");
    public static final NdMonotonicTerm TERM_CONSTANT_TRUE = TERM_CONSTANT_P;
    public static final NdMonotonicTerm TERM_CONSTANT_FALSE = TERM_CONSTANT_N;
    public static final NdMonotonicTerm TERM_CONSTANT = new NdMonotonicTerm(3, "constant?");
    public static final NdMonotonicTerm TERM_MONOTONIC_UP = new NdMonotonicTerm(4, "monotonic+");
    public static final NdMonotonicTerm TERM_MONOTONIC_DN = new NdMonotonicTerm(5, "monotonic-");
    public static final NdMonotonicTerm TERM_UNDECIDABLE = new NdMonotonicTerm(6, "undecidable");
    public static final NdMonotonicTerm TERM_REDUNDANT = new NdMonotonicTerm(7, "redundant");
    public final String label;
    public final int index;
    public final NdConstantTerm value;

    private NdMonotonicTerm(int n, String string) {
        this.label = string;
        this.index = n;
        this.value = null;
    }

    public NdMonotonicTerm(NdConstantTerm ndConstantTerm) {
        NdBaseObject.advAssertNonNull((Object)ndConstantTerm);
        this.index = 3;
        this.value = ndConstantTerm;
        this.label = "constant?";
    }

    public NdMonotonicTerm(NdConstantTerm ndConstantTerm, boolean bl) {
        this.index = bl ? 2 : 1;
        NdBaseObject.advAssertNonNull((Object)ndConstantTerm);
        this.value = ndConstantTerm;
        this.label = bl ? "constant+" : "constant-";
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdMonotonicTerm) {
            NdMonotonicTerm ndMonotonicTerm = (NdMonotonicTerm)object;
            if (this.index == ndMonotonicTerm.index) {
                bl = this.value == null && ndMonotonicTerm.value == null ? true : this.value != null && this.value.equals(ndMonotonicTerm.value);
            }
        }
        return bl;
    }

    public boolean isUnset() {
        return this.index == 0;
    }

    public boolean isConstant() {
        return this.index == 3;
    }

    public boolean isConstantP() {
        return this.index == 2;
    }

    public boolean isConstantN() {
        return this.index == 1;
    }

    public boolean isMonotonicUp() {
        return this.index == 4;
    }

    public boolean isMonotonicDn() {
        return this.index == 5;
    }

    public boolean isUndecidable() {
        return this.index == 6;
    }
}

