/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.test.NdAssert;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdDomain;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalDomain;
import com.blazesoft.verifier.predicate.NdConstantString;
import com.blazesoft.verifier.predicate.WjIDdTC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class NdBasisImpl
implements NdBasis {
    private Set WjIwLkX;
    private Map WjIwLkY;
    private List WjIwLkZ;
    private LinearBasis WjIwLlA;
    private Map WjIwVpA;
    private NdDomain WjIQXnN;

    public NdBasisImpl(NdDomain ndDomain) {
        this(ndDomain, 1);
    }

    public NdBasisImpl(NdDomain ndDomain, int n) {
        this.WjIQXnN = ndDomain;
        this.WjIwLkX = new TreeSet();
        this.WjIwLkY = new HashMap();
        this.WjIwLkZ = new ArrayList();
        this.WjIwLlA = new LinearBasis(this, n);
        this.WjIwVpA = new HashMap();
    }

    private void WjIwVqB(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            NdStringIntervalDomain ndStringIntervalDomain = this.getStringDomain((WjIDdTC)entry.getKey());
            ndStringIntervalDomain.union((NdStringIntervalDomain)entry.getValue());
            entry.setValue(ndStringIntervalDomain);
        }
    }

    public NdDomain getDomain() {
        return this.WjIQXnN;
    }

    void WjIQXoO(NdDomain ndDomain) {
        this.WjIQXnN = ndDomain;
    }

    public boolean isRectangular() {
        return this.WjIwLlA.isRectangular();
    }

    public NdBasis getComboBasis() {
        return this;
    }

    public LinearBasis getLinearView() {
        return this.WjIwLlA;
    }

    public void markAxisAsLinear(WjIDdTC wjIDdTC) {
        int n = this.getVariableIndex(wjIDdTC.WjIDbiT);
        this.WjIwLlA.WjIwKWM((WjIDdTC)this.WjIwLkZ.get(n));
    }

    public void updateStringDomain(WjIDdTC wjIDdTC, NdConstantString ndConstantString) {
        NdStringIntervalDomain ndStringIntervalDomain = (NdStringIntervalDomain)this.WjIwVpA.get(wjIDdTC);
        if (ndStringIntervalDomain == null) {
            ndStringIntervalDomain = new NdStringIntervalDomain();
            this.WjIwVpA.put(wjIDdTC, ndStringIntervalDomain);
        }
        ndStringIntervalDomain.add(ndConstantString.WjIDhSD());
    }

    public NdStringIntervalDomain getStringDomain(WjIDdTC wjIDdTC) {
        NdStringIntervalDomain ndStringIntervalDomain = (NdStringIntervalDomain)this.WjIwVpA.get(wjIDdTC);
        if (ndStringIntervalDomain == null) {
            ndStringIntervalDomain = new NdStringIntervalDomain();
            this.WjIwVpA.put(wjIDdTC, ndStringIntervalDomain);
        }
        return ndStringIntervalDomain;
    }

    public void setStringDomain(WjIDdTC wjIDdTC, NdStringIntervalDomain ndStringIntervalDomain) {
        NdAssert.assertNotNull((Object)wjIDdTC);
        NdAssert.assertNotNull((Object)ndStringIntervalDomain);
        this.WjIwVpA.put(wjIDdTC, ndStringIntervalDomain);
    }

    public int getLinearPrecisionMultiplier() {
        return this.WjIwLlA.getLinearPrecisionMultiplier();
    }

    public void addVariable(WjIDdTC wjIDdTC) {
        NdBaseObject.advAssertNonNull((Object)wjIDdTC);
        if (!this.WjIwLkX.contains(wjIDdTC.WjIDbiT)) {
            this.WjIwLkX.add(wjIDdTC.WjIDbiT);
            this.WjIwLkY.put(wjIDdTC.WjIDbiT, new Integer(this.WjIwLkZ.size()));
            this.WjIwLkZ.add(wjIDdTC);
        }
    }

    public int getVariableIndex(String string) {
        NdBaseObject.advAssertNonNull((Object)string);
        if (!this.WjIwLkX.contains(string)) {
            throw new NoSuchElementException(string);
        }
        return (Integer)this.WjIwLkY.get(string);
    }

    public WjIDdTC getVariable(int n) {
        if (n < 0 || n >= this.WjIwLkZ.size()) {
            throw new NoSuchElementException("" + n);
        }
        return (WjIDdTC)this.WjIwLkZ.get(n);
    }

    public void union(NdBasis ndBasis) {
        int n;
        NdBaseObject.advAssertNonNull((Object)ndBasis);
        NdBasisImpl ndBasisImpl = (NdBasisImpl)ndBasis;
        int n2 = ndBasisImpl.WjIwLkZ.size();
        for (n = 0; n < n2; ++n) {
            this.addVariable((WjIDdTC)ndBasisImpl.WjIwLkZ.get(n));
        }
        n2 = ndBasisImpl.WjIwLlA.WjIwKWG.size();
        for (n = 0; n < n2; ++n) {
            this.markAxisAsLinear((WjIDdTC)ndBasisImpl.WjIwLlA.WjIwKWG.get(n));
        }
        this.WjIwLlA.updatePrecision(ndBasisImpl.getLinearPrecisionMultiplier());
        this.WjIwLlA.WjIwKWK = (byte)(this.WjIwLlA.WjIwKWK & (ndBasisImpl.WjIwLlA.WjIwKWK ? 1 : 0));
        this.WjIwVqB(ndBasisImpl.WjIwVpA);
    }

    public int getDimension() {
        return this.WjIwLkX.size();
    }

    public Iterator dimensionNameIterator() {
        return this.WjIwLkX.iterator();
    }

    public boolean contains(String string) {
        if (string != null) {
            return this.WjIwLkX.contains(string);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Basis:\n");
        int n = this.WjIwLkZ.size();
        for (int i = 0; i < n; ++i) {
            WjIDdTC wjIDdTC = (WjIDdTC)this.WjIwLkZ.get(i);
            stringBuffer.append("\t").append(i).append(" - ").append(wjIDdTC.WjIDbiT).append(": ").append(wjIDdTC.WjIDbjU);
            if (wjIDdTC.WjIDbjU == NdConstantString.WjIDhSC) {
                stringBuffer.append(" of ").append(this.getStringDomain(wjIDdTC));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean intersects(NdBasis ndBasis) {
        int n = ndBasis.getDimension();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            WjIDdTC wjIDdTC;
            WjIDdTC wjIDdTC2;
            if (!this.contains(ndBasis.getVariable(i).WjIDbnY()) || (wjIDdTC2 = this.getVariable(this.getVariableIndex((wjIDdTC = ndBasis.getVariable(i)).WjIDbnY()))).WjICXCU() != wjIDdTC.WjICXCU()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object != null && object instanceof NdBasisImpl) {
            NdBasisImpl ndBasisImpl = (NdBasisImpl)object;
            if (ndBasisImpl.WjIwLkZ.size() == this.WjIwLkZ.size()) {
                int n = this.WjIwLkZ.size();
                for (int i = 0; i < n; ++i) {
                    bl = true;
                    if (this.WjIwLkZ.get(i).equals(ndBasisImpl.WjIwLkZ.get(i))) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return 1;
    }

    public class LinearBasis
    implements NdBasis {
        private List WjIwKWG = new ArrayList();
        private Map WjIwKWH = new HashMap();
        private final int WjIwKWI;
        private int WjIwKWJ;
        private boolean WjIwKWK;
        private final NdBasis WjIwKWL;

        private LinearBasis(NdBasis ndBasis, int n) {
            this.WjIwKWI = n;
            this.WjIwKWJ = 1;
            this.WjIwKWL = ndBasis;
            this.WjIwKWK = true;
        }

        public void updatePrecision(int n) {
            if (n > this.WjIwKWJ) {
                this.WjIwKWJ = n;
                if (this.WjIwKWJ > this.WjIwKWI) {
                    this.WjIwKWJ = this.WjIwKWI;
                }
            }
        }

        public void clearRectangularity() {
            this.WjIwKWK = false;
        }

        public boolean isRectangular() {
            return this.WjIwKWK;
        }

        public NdBasis getComboBasis() {
            return this.WjIwKWL;
        }

        public NdDomain getDomain() {
            return this.WjIwKWL.getDomain();
        }

        private void WjIwKWM(WjIDdTC wjIDdTC) {
            if (!this.WjIwKWH.containsKey(wjIDdTC.WjIDbiT)) {
                this.WjIwKWH.put(wjIDdTC.WjIDbiT, new Integer(this.WjIwKWG.size()));
                this.WjIwKWG.add(wjIDdTC);
            }
        }

        public boolean contains(String string) {
            return this.WjIwKWH.containsKey(string);
        }

        public boolean intersects(NdBasis ndBasis) {
            return this.WjIwKWL.intersects(((LinearBasis)ndBasis).getComboBasis());
        }

        public int getDimension() {
            return this.WjIwKWG.size();
        }

        public int getLinearPrecisionMultiplier() {
            return this.WjIwKWJ;
        }

        public WjIDdTC getVariable(int n) {
            if (n < 0 || n >= this.WjIwKWG.size()) {
                throw new NoSuchElementException("" + n);
            }
            return (WjIDdTC)this.WjIwKWG.get(n);
        }

        public int getVariableIndex(String string) {
            NdBaseObject.advAssertNonNull((Object)string);
            if (!this.WjIwKWH.containsKey(string)) {
                throw new NoSuchElementException(string);
            }
            return (Integer)this.WjIwKWH.get(string);
        }

        public void union(NdBasis ndBasis) {
            throw NdBaseObject.apiError((String)"Not applicable to the basis view");
        }
    }
}

