/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.test.NdAssert;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConstraint;
import com.blazesoft.verifier.cfa.spatial.NdConstraintNotSupportedException;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdLinearTerm;
import com.blazesoft.verifier.cfa.spatial.formula.NdFormulaHelper;
import com.blazesoft.verifier.cfa.spatial.intervals.NdAbstractIntervalConstraint;
import com.blazesoft.verifier.cfa.spatial.intervals.NdBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdEnumeratedTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalConstraint;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalHelper;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalDomain;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalFactory;
import com.blazesoft.verifier.cfa.spatial.intervals.NdTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableEnumeratedTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdImplicitDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIncompatibleDimensionException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraFactory;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.predicate.NdArithmeticalAddFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalDivFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalDivIntFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalMinusFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalModFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalMulFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalSubFormula;
import com.blazesoft.verifier.predicate.NdConjunctiveNaryFormula;
import com.blazesoft.verifier.predicate.NdConsequentFormula;
import com.blazesoft.verifier.predicate.NdConstantDate;
import com.blazesoft.verifier.predicate.NdConstantDuration;
import com.blazesoft.verifier.predicate.NdConstantEnumeratedItem;
import com.blazesoft.verifier.predicate.NdConstantInteger;
import com.blazesoft.verifier.predicate.NdConstantLogical;
import com.blazesoft.verifier.predicate.NdConstantMoney;
import com.blazesoft.verifier.predicate.NdConstantNull;
import com.blazesoft.verifier.predicate.NdConstantRangeFormula;
import com.blazesoft.verifier.predicate.NdConstantReal;
import com.blazesoft.verifier.predicate.NdConstantReasonCode;
import com.blazesoft.verifier.predicate.NdConstantSpecial;
import com.blazesoft.verifier.predicate.NdConstantString;
import com.blazesoft.verifier.predicate.NdConstantTerm;
import com.blazesoft.verifier.predicate.NdConstantTime;
import com.blazesoft.verifier.predicate.NdConstantTimeStamp;
import com.blazesoft.verifier.predicate.NdDisjunctiveNaryFormula;
import com.blazesoft.verifier.predicate.NdFormula;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdFormulaVisitor;
import com.blazesoft.verifier.predicate.NdFunctionFormula;
import com.blazesoft.verifier.predicate.NdIndexedFormula;
import com.blazesoft.verifier.predicate.NdIntersectionNaryFormula;
import com.blazesoft.verifier.predicate.NdLogicalAndFormula;
import com.blazesoft.verifier.predicate.NdLogicalExistsFormula;
import com.blazesoft.verifier.predicate.NdLogicalForallFormula;
import com.blazesoft.verifier.predicate.NdLogicalNotFormula;
import com.blazesoft.verifier.predicate.NdLogicalOrFormula;
import com.blazesoft.verifier.predicate.NdOperator;
import com.blazesoft.verifier.predicate.NdQuantifiedFormula;
import com.blazesoft.verifier.predicate.NdRelationalIntersection;
import com.blazesoft.verifier.predicate.NdRelationalPredicate;
import com.blazesoft.verifier.predicate.NdRelationalSelectEvery;
import com.blazesoft.verifier.predicate.NdRelationalUnion;
import com.blazesoft.verifier.predicate.NdStructPatternNaryFormula;
import com.blazesoft.verifier.predicate.NdTimeConstraintTernaryFormula;
import com.blazesoft.verifier.predicate.NdTopLevelPredicate;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.predicate.WjIDdiX;
import com.blazesoft.verifier.predicate.WjIDiGZ;
import com.blazesoft.verifier.predicate.WjILOZH;
import com.blazesoft.verifier.predicate.WjILPjH;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.type.NdModelEnumeratedItemType;
import com.blazesoft.verifier.type.NdModelType;
import com.blazesoft.verifier.util.NdStack;
import com.blazesoft.verifier.util.NdVerifierLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NdConvexBuilder
implements NdFormulaVisitor {
    public static final String NAME = "Convex Builder";
    private static Map WjIwXvV = new HashMap();
    private static Map WjIwXvW;
    private static final NdPolyhedraFactory WjIwXvX;
    protected NdStack operandStack;
    protected NdVerificationContext _context;

    public NdConvexBuilder(NdVerificationContext ndVerificationContext) {
        this._context = ndVerificationContext;
        this.operandStack = new NdStack();
    }

    private void WjIwXvY(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        this.operandStack.push(arrayList);
    }

    private boolean WjIRHTW(NdFormula ndFormula) {
        NdModelType ndModelType = ndFormula.WjICXCU();
        return ndModelType == NdConstantReal.WjIDgkX || ndModelType == NdConstantInteger.WjICYZG || ndModelType == NdConstantMoney.WjIDgFP || ndModelType == NdConstantTime.WjIDihH || ndModelType == NdConstantTimeStamp.WjIDiZZ || ndModelType == NdConstantDate.WjIDiPY || ndModelType == NdConstantDuration.WjIDgSE || ndModelType.isEnumerated();
    }

    protected boolean isLinear(NdBasis ndBasis, NdFormula ndFormula) {
        return !ndBasis.isRectangular() && this.WjIRHTW(ndFormula);
    }

    public static NdImplicitDef intervalsToLinearConstraints(NdBasisImpl.LinearBasis linearBasis, List list) {
        int n = linearBasis.getDimension();
        ArrayList<NdLinearTerm> arrayList = new ArrayList<NdLinearTerm>(2);
        NdImplicitDef ndImplicitDef = WjIwXvX.getImplicitDef(n, n + 1);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            boolean bl2;
            double d;
            double d2;
            Object object;
            NdIntervalConstraint ndIntervalConstraint = (NdIntervalConstraint)list.get(i);
            int n3 = linearBasis.getVariableIndex(ndIntervalConstraint.getVariableName());
            if (n3 < 0 || !ndIntervalConstraint.isDenseLinearOrder()) continue;
            NdSingleInterval ndSingleInterval = ndIntervalConstraint.getInterval();
            if (ndSingleInterval.getIntervalType() == NdIntegerInterval.TYPE) {
                object = (NdIntegerInterval)ndSingleInterval;
                d2 = ((NdIntegerInterval)object).isLeftInfinite() ? Double.NEGATIVE_INFINITY : (double)((NdIntegerInterval)object).getLeftBound();
                d = ((NdIntegerInterval)object).isRightInfinite() ? Double.POSITIVE_INFINITY : (double)((NdIntegerInterval)object).getRightBound();
                bl2 = ((NdIntegerInterval)object).isLeftOpen();
                bl = ((NdIntegerInterval)object).isRightOpen();
            } else if (ndSingleInterval.getIntervalType() == NdRealInterval.TYPE) {
                object = (NdRealInterval)ndSingleInterval;
                d2 = ((NdRealInterval)object).isLeftInfinite() ? Double.NEGATIVE_INFINITY : ((NdRealInterval)object).getLeftBound();
                d = ((NdRealInterval)object).isRightInfinite() ? Double.POSITIVE_INFINITY : ((NdRealInterval)object).getRightBound();
                bl2 = ((NdRealInterval)object).isLeftOpen();
                bl = ((NdRealInterval)object).isRightOpen();
            } else {
                NdAssert.fail((String)"Linear Dense Order type is expected");
                d = 0.0;
                d2 = 0.0;
                bl = false;
                bl2 = false;
            }
            try {
                if (d2 != Double.NEGATIVE_INFINITY) {
                    arrayList.add(new NdLinearTerm(linearBasis.getVariable(n3)));
                    arrayList.add(new NdLinearTerm(d2));
                    object = NdImplicitDef.prepareCoefficients(linearBasis, arrayList);
                    if (bl2) {
                        ndImplicitDef.addConstraint((long[])object, 0, ((Object)object).length, 2);
                    } else {
                        ndImplicitDef.addConstraint((long[])object, 0, ((Object)object).length, 1);
                    }
                    arrayList.clear();
                }
                if (d == Double.POSITIVE_INFINITY) continue;
                arrayList.add(new NdLinearTerm(-1.0, linearBasis.getVariable(n3)));
                arrayList.add(new NdLinearTerm(d));
                object = NdImplicitDef.prepareCoefficients(linearBasis, arrayList);
                if (bl) {
                    ndImplicitDef.addConstraint((long[])object, 0, ((Object)object).length, 2);
                } else {
                    ndImplicitDef.addConstraint((long[])object, 0, ((Object)object).length, 1);
                }
                arrayList.clear();
                continue;
            }
            catch (NdIncompatibleDimensionException ndIncompatibleDimensionException) {
                // empty catch block
            }
        }
        return ndImplicitDef;
    }

    private NdConstraint WjIwXwA(NdBasisImpl.LinearBasis linearBasis, List list, NdRelationalPredicate ndRelationalPredicate) throws NdFormulaException {
        int n;
        if (ndRelationalPredicate.WjIDdjS == NdOperator.WjICYSE) {
            n = 2;
        } else if (ndRelationalPredicate.WjIDdjS == NdOperator.WjICYSF) {
            n = 1;
        } else if (ndRelationalPredicate.WjIDdjS == NdOperator.WjICYSH) {
            n = 0;
        } else {
            throw new NdFormulaException(ndRelationalPredicate, "Unexpected operator: " + ndRelationalPredicate.WjIDdjS);
        }
        try {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) instanceof NdLinearTerm) continue;
                if (list.get(i) instanceof WjIDdTC) {
                    list.set(i, new NdLinearTerm((WjIDdTC)list.get(i)));
                    continue;
                }
                throw new NdFormulaException(ndRelationalPredicate, "Incompatible terms");
            }
            long[] lArray = NdImplicitDef.prepareCoefficients(linearBasis, list);
            NdImplicitDef ndImplicitDef = WjIwXvX.getImplicitDef(1, linearBasis.getDimension() + 1);
            ndImplicitDef.addConstraint(lArray, 0, lArray.length, n);
            if (NdVerifierLog.isTraceEnabled(NAME)) {
                NdVerifierLog.trace(NAME, "Added inequality " + ndRelationalPredicate);
            }
            return ndImplicitDef;
        }
        catch (NdPolyhedraException ndPolyhedraException) {
            throw new NdFormulaException("Error adding linear constraints", ndRelationalPredicate.toString(), (Throwable)((Object)ndPolyhedraException));
        }
    }

    private NdIntervalType WjIwXxB(NdModelType ndModelType) {
        NdIntervalType ndIntervalType;
        if (ndModelType.isEnumerated()) {
            ndIntervalType = NdEnumeratedTypeInterval.TYPE;
        } else {
            ndIntervalType = (NdIntervalType)WjIwXvW.get(ndModelType);
            if (ndIntervalType == null) {
                ndIntervalType = NdReferenceTypeInterval.TYPE;
            }
        }
        return ndIntervalType;
    }

    private NdConstraint WjIwXyC(NdBasis ndBasis, NdRelationalPredicate ndRelationalPredicate) throws NdFormulaException {
        NdAbstractIntervalConstraint ndAbstractIntervalConstraint;
        block21: {
            block20: {
                WjIwUqR wjIwUqR = new WjIwUqR(ndRelationalPredicate);
                WjIwYdI wjIwYdI = (WjIwYdI)WjIwXvV.get(wjIwUqR.WjIwUnO);
                NdModelType ndModelType = ndRelationalPredicate.WjICZYQ();
                if (ndModelType == NdConstantDuration.WjIDgSE) {
                    ndModelType = wjIwUqR.WjIwUmN.WjICXCU();
                }
                NdIntervalType ndIntervalType = this.WjIwXxB(ndModelType);
                if (wjIwYdI == null || !wjIwYdI.WjIwXUZ(ndIntervalType)) break block20;
                switch (ndIntervalType.getType()) {
                    case 1: {
                        long l = NdFormulaHelper.getLongConstant(wjIwUqR.WjIwUoP);
                        ndAbstractIntervalConstraint = new NdVariableIntegerInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwXVA(l));
                        break block21;
                    }
                    case 2: {
                        double d = NdFormulaHelper.getDoubleConstant(wjIwUqR.WjIwUoP);
                        ndAbstractIntervalConstraint = new NdVariableRealInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwXWB(d));
                        break block21;
                    }
                    case 3: {
                        boolean bl = NdFormulaHelper.getBooleanConstant(wjIwUqR.WjIwUoP);
                        ndAbstractIntervalConstraint = new NdVariableBooleanInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwYaF(bl));
                        break block21;
                    }
                    case 5: {
                        boolean bl = NdFormulaHelper.isNullConstant(wjIwUqR.WjIwUoP);
                        ndAbstractIntervalConstraint = new NdVariableBooleanInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwYcH(bl ? NdConstantNull.WjIDeLB : NdConstantNull.WjIDeLC));
                        break block21;
                    }
                    case 6: {
                        NdModelEnumeratedItemType ndModelEnumeratedItemType = NdFormulaHelper.getEnumeratedItem(wjIwUqR.WjIwUoP);
                        ndAbstractIntervalConstraint = new NdVariableEnumeratedTypeInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwXYD(ndModelEnumeratedItemType));
                        break block21;
                    }
                    case 4: {
                        if (wjIwUqR.WjIwUoP == NdConstantNull.WjIDeLB) {
                            NdStringIntervalDomain ndStringIntervalDomain = ((NdBasisImpl)ndBasis).getStringDomain(wjIwUqR.WjIwUmN);
                            ndAbstractIntervalConstraint = new NdVariableStringInterval(wjIwUqR.WjIwUmN, ndStringIntervalDomain.getComplement());
                        } else if (wjIwUqR.WjIwUoP == NdConstantNull.WjIDeLC) {
                            NdStringIntervalDomain ndStringIntervalDomain = ((NdBasisImpl)ndBasis).getStringDomain(wjIwUqR.WjIwUmN);
                            ndAbstractIntervalConstraint = new NdVariableStringInterval(wjIwUqR.WjIwUmN, ndStringIntervalDomain.getComplement());
                        } else {
                            NdConstantString ndConstantString = (NdConstantString)wjIwUqR.WjIwUoP;
                            NdStringIntervalDomain ndStringIntervalDomain = ((NdBasisImpl)ndBasis).getStringDomain(wjIwUqR.WjIwUmN);
                            if (wjIwUqR.WjIwUnO == NdOperator.WjICYSI) {
                                NdStringInterval ndStringInterval = ndStringIntervalDomain.getInterval().subtract(ndConstantString.WjIDhSD());
                                ndStringInterval = (NdStringInterval)ndStringInterval.union(ndStringIntervalDomain.getComplement());
                                ndAbstractIntervalConstraint = new NdVariableStringInterval(wjIwUqR.WjIwUmN, ndStringInterval);
                            } else {
                                ndAbstractIntervalConstraint = new NdVariableStringInterval(wjIwUqR.WjIwUmN, NdStringIntervalFactory.getInstance().getInterval(ndStringIntervalDomain, ndConstantString));
                            }
                        }
                        break block21;
                    }
                    case 10: {
                        ndAbstractIntervalConstraint = new NdVariableMoneyInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwXXC((NdConstantMoney)wjIwUqR.WjIwUoP));
                        break block21;
                    }
                    case 7: {
                        ndAbstractIntervalConstraint = new NdVariableTimeInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIwXZE((NdConstantTime)wjIwUqR.WjIwUoP));
                        break block21;
                    }
                    case 8: {
                        ndAbstractIntervalConstraint = new NdVariableDateInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIxIwC((NdConstantDate)wjIwUqR.WjIwUoP));
                        break block21;
                    }
                    case 9: {
                        ndAbstractIntervalConstraint = new NdVariableTimeStampInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIxMdD((NdConstantTimeStamp)wjIwUqR.WjIwUoP));
                        break block21;
                    }
                    case 11: {
                        ndAbstractIntervalConstraint = new NdVariableDurationInterval(wjIwUqR.WjIwUmN, wjIwYdI.WjIxYtG((NdConstantDuration)wjIwUqR.WjIwUoP));
                        break block21;
                    }
                    default: {
                        throw NdBaseObject.apiError((String)("Unexpected Interval Type " + ndIntervalType + " in formula " + ndRelationalPredicate));
                    }
                }
            }
            throw new NdConstraintNotSupportedException(new NdTopLevelPredicate(ndRelationalPredicate), ndRelationalPredicate);
        }
        return ndAbstractIntervalConstraint;
    }

    public NdDateInterval createDateInterval(NdOperator ndOperator, NdConstantDate ndConstantDate) throws NdFormulaException {
        WjIwYdI wjIwYdI = (WjIwYdI)WjIwXvV.get(ndOperator);
        return wjIwYdI.WjIxIwC(ndConstantDate);
    }

    public NdTimeInterval createTimeInterval(NdOperator ndOperator, NdConstantTime ndConstantTime) throws NdFormulaException {
        WjIwYdI wjIwYdI = (WjIwYdI)WjIwXvV.get(ndOperator);
        return wjIwYdI.WjIwXZE(ndConstantTime);
    }

    public void clear() {
        this.operandStack.clear();
    }

    public NdComboShape getConvex(NdFormula ndFormula, NdBasis ndBasis) throws NdFormulaException {
        return this.getConvex(ndFormula, ndBasis, null);
    }

    public NdComboShape getConvex(NdFormula ndFormula, NdBasis ndBasis, NdTopLevelPredicate ndTopLevelPredicate) throws NdFormulaException {
        ArrayList<NdConstraint> arrayList = new ArrayList<NdConstraint>();
        ArrayList<NdConstraint> arrayList2 = new ArrayList<NdConstraint>();
        while (!this.operandStack.isEmpty()) {
            NdConstraint ndConstraint = (NdConstraint)this.operandStack.pop();
            if (ndConstraint.isPolyhedral()) {
                arrayList2.add(ndConstraint);
                continue;
            }
            arrayList.add(ndConstraint);
        }
        boolean bl = false;
        NdHyperCube ndHyperCube = null;
        NdPolyhedron ndPolyhedron = null;
        int n = arrayList.size();
        if (n != 0) {
            ndHyperCube = new NdHyperCube(ndBasis);
            for (int i = 0; i < n; ++i) {
                NdIntervalConstraint ndIntervalConstraint = (NdIntervalConstraint)arrayList.get(i);
                String string = ndIntervalConstraint.getVariable().WjIDbnY();
                NdSingleInterval ndSingleInterval = ndHyperCube.getInterval(string);
                if (ndSingleInterval != null) {
                    NdSingleInterval ndSingleInterval2 = ndSingleInterval.intersect(ndIntervalConstraint.getInterval());
                    if (ndSingleInterval2.isEmpty()) {
                        bl = true;
                        break;
                    }
                    ndHyperCube.putInterval(string, ndSingleInterval2);
                    continue;
                }
                ndHyperCube.putInterval(string, ndIntervalConstraint.getInterval());
            }
        }
        if (!bl && (n = arrayList2.size()) > 0) {
            NdImplicitDef ndImplicitDef = (NdImplicitDef)arrayList2.get(0);
            try {
                for (int i = 1; i < n; ++i) {
                    ndImplicitDef.addConstraints((NdImplicitDef)arrayList2.get(i));
                }
                ndPolyhedron = NdPolyhedron.makePolyhedron(((NdBasisImpl)ndBasis).getLinearView(), ndImplicitDef);
            }
            catch (NdIncompatibleDimensionException ndIncompatibleDimensionException) {
                NdBaseObject.advAssert((boolean)false);
            }
            catch (NdPolyhedraException ndPolyhedraException) {
                throw new NdFormulaException("Error adding linear constraints", ndFormula.toString(), (Throwable)((Object)ndPolyhedraException));
            }
        }
        NdComboShape ndComboShape = bl ? NdComboShape.makeEmptyShape(ndTopLevelPredicate) : (ndPolyhedron != null && ndPolyhedron.isEmptySet() ? NdComboShape.makeEmptyShape(ndTopLevelPredicate) : (ndHyperCube != null ? (ndPolyhedron != null ? new NdComboShape(ndHyperCube, ndPolyhedron, ndTopLevelPredicate) : new NdComboShape(ndHyperCube, ndTopLevelPredicate)) : (ndPolyhedron != null ? new NdComboShape(ndPolyhedron, ndTopLevelPredicate) : NdComboShape.makeUniversum(ndTopLevelPredicate))));
        return ndComboShape;
    }

    public Object visit(NdArithmeticalAddFormula ndArithmeticalAddFormula, Object object) throws NdFormulaException {
        List list = (List)this.operandStack.pop();
        List list2 = (List)this.operandStack.pop();
        list2.addAll(list);
        this.operandStack.push(list2);
        return object;
    }

    public Object visit(NdArithmeticalDivFormula ndArithmeticalDivFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndArithmeticalDivFormula);
    }

    public Object visit(NdArithmeticalDivIntFormula ndArithmeticalDivIntFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndArithmeticalDivIntFormula);
    }

    public Object visit(NdArithmeticalMinusFormula ndArithmeticalMinusFormula, Object object) throws NdFormulaException {
        List list = (List)this.operandStack.pop();
        NdLinearTerm ndLinearTerm = (NdLinearTerm)list.get(0);
        if (ndLinearTerm.x == null) {
            this.operandStack.clear();
            throw new NdConstraintNotSupportedException(null, ndArithmeticalMinusFormula);
        }
        list.set(0, new NdLinearTerm(-ndLinearTerm.a, ndLinearTerm.x));
        this.operandStack.push(list);
        return object;
    }

    public Object visit(NdArithmeticalModFormula ndArithmeticalModFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndArithmeticalModFormula);
    }

    public Object visit(NdArithmeticalMulFormula ndArithmeticalMulFormula, Object object) throws NdFormulaException {
        List list = (List)this.operandStack.pop();
        List list2 = (List)this.operandStack.pop();
        if (list2.size() == 1 || list.size() == 1) {
            NdLinearTerm ndLinearTerm = (NdLinearTerm)list2.get(0);
            NdLinearTerm ndLinearTerm2 = (NdLinearTerm)list.get(0);
            if (ndLinearTerm.x != null && Math.abs(ndLinearTerm.a) == 1.0 && ndLinearTerm2.x == null) {
                NdLinearTerm ndLinearTerm3 = new NdLinearTerm(ndLinearTerm.a > 0.0 ? ndLinearTerm2.a : -ndLinearTerm2.a, ndLinearTerm.x);
                list2.set(0, ndLinearTerm3);
                this.operandStack.push(list2);
            } else {
                this.operandStack.clear();
                throw new NdConstraintNotSupportedException(null, ndArithmeticalMulFormula);
            }
        }
        return object;
    }

    public Object visit(NdArithmeticalSubFormula ndArithmeticalSubFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndArithmeticalSubFormula);
    }

    public Object visit(NdConstantLogical ndConstantLogical, Object object) throws NdFormulaException {
        this.WjIwXvY(ndConstantLogical);
        return object;
    }

    public Object visit(NdConstantDate ndConstantDate, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantDate.WjIDaaB()));
        return object;
    }

    public Object visit(NdConstantDuration ndConstantDuration, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantDuration.WjIDaaB()));
        return object;
    }

    public Object visit(NdConstantMoney ndConstantMoney, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantMoney.WjIDgFT()));
        return object;
    }

    public Object visit(NdConstantReal ndConstantReal, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantReal.WjIDgnA()));
        return object;
    }

    public Object visit(NdConstantTime ndConstantTime, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantTime.WjIDaaB()));
        return object;
    }

    public Object visit(NdConstantTimeStamp ndConstantTimeStamp, Object object) throws NdFormulaException {
        this.WjIwXvY(ndConstantTimeStamp);
        return object;
    }

    public Object visit(NdConstantInteger ndConstantInteger, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantInteger.WjIDaaB()));
        return object;
    }

    public Object visit(NdConstantString ndConstantString, Object object) throws NdFormulaException {
        this.WjIwXvY(ndConstantString);
        return object;
    }

    public Object visit(NdConstantNull ndConstantNull, Object object) throws NdFormulaException {
        this.WjIwXvY(ndConstantNull);
        return object;
    }

    public Object visit(NdConstantSpecial ndConstantSpecial, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndConstantSpecial);
    }

    public Object visit(NdConstantEnumeratedItem ndConstantEnumeratedItem, Object object) throws NdFormulaException {
        this.WjIwXvY(new NdLinearTerm(ndConstantEnumeratedItem.WjIDcSH()));
        return object;
    }

    public Object visit(NdFunctionFormula ndFunctionFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndFunctionFormula);
    }

    public Object visit(NdIndexedFormula ndIndexedFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndIndexedFormula);
    }

    public Object visit(NdLogicalNotFormula ndLogicalNotFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndLogicalNotFormula);
    }

    public Object visit(NdLogicalOrFormula ndLogicalOrFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndLogicalOrFormula);
    }

    public Object visit(NdQuantifiedFormula ndQuantifiedFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndQuantifiedFormula);
    }

    public Object visit(NdLogicalAndFormula ndLogicalAndFormula, Object object) throws NdFormulaException {
        return object;
    }

    public Object visit(NdIntersectionNaryFormula ndIntersectionNaryFormula, Object object) throws NdFormulaException {
        return object;
    }

    public Object visit(NdConjunctiveNaryFormula ndConjunctiveNaryFormula, Object object) throws NdFormulaException {
        return object;
    }

    public Object visit(NdRelationalPredicate ndRelationalPredicate, Object object) throws NdFormulaException {
        NdConstraint ndConstraint;
        NdBasis ndBasis = (NdBasis)object;
        NdBaseObject.advAssert((this.operandStack.size() >= 2 ? 1 : 0) != 0);
        this.operandStack.pop();
        List list = (List)this.operandStack.pop();
        if (this.isLinear(ndBasis, ndRelationalPredicate.WjIDdjT)) {
            NdBasisImpl.LinearBasis linearBasis = ((NdBasisImpl)object).getLinearView();
            ndConstraint = this.WjIwXwA(linearBasis, list, ndRelationalPredicate);
        } else {
            ndConstraint = this.WjIwXyC(ndBasis, ndRelationalPredicate);
        }
        this.operandStack.push(ndConstraint);
        return ndConstraint;
    }

    public NdImplicitDef toLinearConstraints(NdBasisImpl.LinearBasis linearBasis, WjIDdTC wjIDdTC, NdSingleInterval ndSingleInterval) throws NdPolyhedraException {
        long[] lArray;
        Object object;
        NdAssert.assertTrue((boolean)linearBasis.contains(wjIDdTC.WjIDbnY()));
        NdIntervalType ndIntervalType = ndSingleInterval.getIntervalType();
        NdLinearTerm ndLinearTerm = null;
        NdLinearTerm ndLinearTerm2 = null;
        int n = 0;
        int n2 = 0;
        if (ndIntervalType == NdRealInterval.TYPE) {
            object = (NdRealInterval)ndSingleInterval;
            if (((NdRealInterval)object).isEquality()) {
                ndLinearTerm = new NdLinearTerm(-((NdRealInterval)object).getLeftBound());
                n = 0;
            } else {
                if (!((NdRealInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdRealInterval)object).getLeftBound());
                    int n3 = n = ((NdRealInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdRealInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdRealInterval)object).getRightBound());
                    n2 = ((NdRealInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else if (ndIntervalType == NdIntegerInterval.TYPE) {
            object = (NdIntegerInterval)ndSingleInterval;
            if (((NdIntegerInterval)object).isEquality()) {
                n = 0;
                ndLinearTerm = new NdLinearTerm(-((NdIntegerInterval)object).getLeftBound());
            } else {
                if (!((NdIntegerInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdIntegerInterval)object).getLeftBound());
                    int n4 = n = ((NdIntegerInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdIntegerInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdIntegerInterval)object).getRightBound());
                    n2 = ((NdIntegerInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else if (ndIntervalType == NdDateInterval.TYPE) {
            object = (NdDateInterval)ndSingleInterval;
            if (((NdDateInterval)object).isEquality()) {
                n = 0;
                ndLinearTerm = new NdLinearTerm(-((NdDateInterval)object).getLeftBound().WjIDaaB());
            } else {
                if (!((NdDateInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdDateInterval)object).getLeftBound().WjIDaaB());
                    int n5 = n = ((NdDateInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdDateInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdDateInterval)object).getRightBound().WjIDaaB());
                    n2 = ((NdDateInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else if (ndIntervalType == NdTimeInterval.TYPE) {
            object = (NdTimeInterval)ndSingleInterval;
            if (((NdTimeInterval)object).isEquality()) {
                n = 0;
                ndLinearTerm = new NdLinearTerm(-((NdTimeInterval)object).getLeftBound().WjIDaaB());
            } else {
                if (!((NdTimeInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdTimeInterval)object).getLeftBound().WjIDaaB());
                    int n6 = n = ((NdTimeInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdTimeInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdTimeInterval)object).getRightBound().WjIDaaB());
                    n2 = ((NdTimeInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else if (ndIntervalType == NdTimeStampInterval.TYPE) {
            object = (NdTimeStampInterval)ndSingleInterval;
            if (((NdTimeStampInterval)object).isEquality()) {
                n = 0;
                ndLinearTerm = new NdLinearTerm(-((NdTimeStampInterval)object).getLeftBound().WjIDaaB());
            } else {
                if (!((NdTimeStampInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdTimeStampInterval)object).getLeftBound().WjIDaaB());
                    int n7 = n = ((NdTimeStampInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdTimeStampInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdTimeStampInterval)object).getRightBound().WjIDaaB());
                    n2 = ((NdTimeStampInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else if (ndIntervalType == NdMoneyInterval.TYPE) {
            object = (NdMoneyInterval)ndSingleInterval;
            if (((NdMoneyInterval)object).isEquality()) {
                n = 0;
                ndLinearTerm = new NdLinearTerm(-((NdMoneyInterval)object).getLeftBound().WjIDgFT());
            } else {
                if (!((NdMoneyInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdMoneyInterval)object).getLeftBound().WjIDgFT());
                    int n8 = n = ((NdMoneyInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdMoneyInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdMoneyInterval)object).getRightBound().WjIDgFT());
                    n2 = ((NdMoneyInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else if (ndIntervalType == NdDurationInterval.TYPE) {
            object = (NdDurationInterval)ndSingleInterval;
            if (((NdDurationInterval)object).isEquality()) {
                n = 0;
                ndLinearTerm = new NdLinearTerm(-((NdDurationInterval)object).getLeftBound().WjIDaaB());
            } else {
                if (!((NdDurationInterval)object).isLeftInfinite()) {
                    ndLinearTerm = new NdLinearTerm(-((NdDurationInterval)object).getLeftBound().WjIDaaB());
                    int n9 = n = ((NdDurationInterval)object).isLeftOpen() ? 2 : 1;
                }
                if (!((NdDurationInterval)object).isRightInfinite()) {
                    ndLinearTerm2 = new NdLinearTerm(((NdDurationInterval)object).getRightBound().WjIDaaB());
                    n2 = ((NdDurationInterval)object).isRightOpen() ? 2 : 1;
                }
            }
        } else {
            NdAssert.fail((String)"Unexpected interval type");
        }
        object = new ArrayList();
        NdImplicitDef ndImplicitDef = WjIwXvX.getImplicitDef(2, linearBasis.getDimension() + 1);
        if (ndLinearTerm != null) {
            object.add(new NdLinearTerm(wjIDdTC));
            object.add(ndLinearTerm);
            lArray = NdImplicitDef.prepareCoefficients(linearBasis, (List)object);
            ndImplicitDef.addConstraint(lArray, 0, lArray.length, n);
        }
        if (ndLinearTerm2 != null) {
            object.clear();
            object.add(new NdLinearTerm(-1.0, wjIDdTC));
            object.add(ndLinearTerm2);
            lArray = NdImplicitDef.prepareCoefficients(linearBasis, (List)object);
            ndImplicitDef.addConstraint(lArray, 0, lArray.length, n2);
        }
        return ndImplicitDef;
    }

    public Object visit(NdTopLevelPredicate ndTopLevelPredicate, Object object) throws NdFormulaException {
        return object;
    }

    public Object visit(WjIDdTC wjIDdTC, Object object) throws NdFormulaException {
        if (this.WjIRHTW(wjIDdTC)) {
            this.WjIwXvY(new NdLinearTerm(wjIDdTC));
        } else {
            this.WjIwXvY(wjIDdTC);
        }
        return object;
    }

    public Object visit(NdRelationalIntersection ndRelationalIntersection, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndRelationalIntersection);
    }

    public Object visit(NdRelationalUnion ndRelationalUnion, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndRelationalUnion);
    }

    public Object visit(NdRelationalSelectEvery ndRelationalSelectEvery, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndRelationalSelectEvery);
    }

    public Object visit(NdConstantReasonCode ndConstantReasonCode, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndConstantReasonCode);
    }

    public Object visit(NdTimeConstraintTernaryFormula ndTimeConstraintTernaryFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndTimeConstraintTernaryFormula);
    }

    public Object visit(WjILOZH wjILOZH, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, wjILOZH);
    }

    public Object visit(NdStructPatternNaryFormula ndStructPatternNaryFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndStructPatternNaryFormula);
    }

    public Object visit(NdConsequentFormula ndConsequentFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndConsequentFormula);
    }

    public Object visit(NdConstantRangeFormula ndConstantRangeFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndConstantRangeFormula);
    }

    public Object visit(NdDisjunctiveNaryFormula ndDisjunctiveNaryFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndDisjunctiveNaryFormula);
    }

    public Object visit(NdLogicalExistsFormula ndLogicalExistsFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndLogicalExistsFormula);
    }

    public Object visit(NdLogicalForallFormula ndLogicalForallFormula, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, ndLogicalForallFormula);
    }

    public Object visit(WjIDdiX wjIDdiX, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, wjIDdiX);
    }

    public Object visit(WjIDiGZ wjIDiGZ, Object object) throws NdFormulaException {
        return null;
    }

    public Object visit(WjILPjH wjILPjH, Object object) throws NdFormulaException {
        this.operandStack.clear();
        throw new NdConstraintNotSupportedException(null, wjILPjH);
    }

    static {
        WjIwXvV.put(NdOperator.WjICYSD, new WjIwUOO());
        WjIwXvV.put(NdOperator.WjICYSG, new WjIwURE());
        WjIwXvV.put(NdOperator.WjICYSE, new WjIwUXG());
        WjIwXvV.put(NdOperator.WjICYSF, new WjIwUXR());
        WjIwXvV.put(NdOperator.WjICYSH, new WjIwUYY());
        WjIwXvV.put(NdOperator.WjICYSI, new WjIwUsE());
        WjIwXvW = new HashMap();
        WjIwXvW.put(NdConstantInteger.WjICYZG, NdIntegerInterval.TYPE);
        WjIwXvW.put(NdConstantLogical.WjIDcxG, NdBooleanInterval.TYPE);
        WjIwXvW.put(NdConstantMoney.WjIDgFP, NdMoneyInterval.TYPE);
        WjIwXvW.put(NdConstantReal.WjIDgkX, NdRealInterval.TYPE);
        WjIwXvW.put(NdConstantString.WjIDhSC, NdStringInterval.TYPE);
        WjIwXvW.put(NdConstantTime.WjIDihH, NdTimeInterval.TYPE);
        WjIwXvW.put(NdConstantDate.WjIDiPY, NdDateInterval.TYPE);
        WjIwXvW.put(NdConstantTimeStamp.WjIDiZZ, NdTimeStampInterval.TYPE);
        WjIwXvW.put(NdConstantDuration.WjIDgSE, NdDurationInterval.TYPE);
        WjIwXvW.put(NdConstantNull.WjIDeLA, NdReferenceTypeInterval.TYPE);
        WjIwXvX = NdPolyhedraFactory.getInstance();
    }

    class WjIwUqR {
        final WjIDdTC WjIwUmN;
        final NdOperator WjIwUnO;
        final NdConstantTerm WjIwUoP;

        public WjIwUqR(NdRelationalPredicate ndRelationalPredicate) throws NdFormulaException {
            if (!(ndRelationalPredicate.WjIDdjU instanceof NdConstantTerm)) {
                throw new NdConstraintNotSupportedException(null, ndRelationalPredicate);
            }
            if (ndRelationalPredicate.WjIDdjT instanceof NdArithmeticalMinusFormula) {
                this.WjIwUmN = (WjIDdTC)ndRelationalPredicate.WjIDdjT.WjICXxP()[0];
                this.WjIwUoP = NdConvexBuilder.this._context.getConstantFormulaEvaluator().negate((NdConstantTerm)ndRelationalPredicate.WjIDdjU);
                this.WjIwUnO = this.WjIwUpQ(ndRelationalPredicate.WjIDdjS);
            } else if (ndRelationalPredicate.WjIDdjT instanceof WjIDdTC) {
                this.WjIwUmN = (WjIDdTC)ndRelationalPredicate.WjIDdjT;
                this.WjIwUoP = (NdConstantTerm)ndRelationalPredicate.WjIDdjU;
                this.WjIwUnO = ndRelationalPredicate.WjIDdjS;
            } else if (ndRelationalPredicate.WjIDdjT instanceof NdArithmeticalAddFormula) {
                NdArithmeticalAddFormula ndArithmeticalAddFormula = (NdArithmeticalAddFormula)ndRelationalPredicate.WjIDdjT;
                NdFormula ndFormula = ndArithmeticalAddFormula.WjIDdjT;
                if (ndFormula instanceof NdArithmeticalMinusFormula) {
                    this.WjIwUmN = (WjIDdTC)ndFormula.WjICXxP()[0];
                    this.WjIwUoP = (NdConstantTerm)ndArithmeticalAddFormula.WjIDdjU;
                    this.WjIwUnO = this.WjIwUpQ(ndRelationalPredicate.WjIDdjS);
                } else {
                    NdBaseObject.advAssert((boolean)(ndFormula instanceof WjIDdTC));
                    this.WjIwUmN = (WjIDdTC)ndFormula;
                    this.WjIwUoP = NdConvexBuilder.this._context.getConstantFormulaEvaluator().negate((NdConstantTerm)ndArithmeticalAddFormula.WjIDdjU);
                    this.WjIwUnO = ndRelationalPredicate.WjIDdjS;
                }
            } else {
                throw new NdConstraintNotSupportedException(null, ndRelationalPredicate);
            }
        }

        public String toString() {
            return this.WjIwUmN.toString() + " " + this.WjIwUnO + " " + this.WjIwUoP;
        }

        private NdOperator WjIwUpQ(NdOperator ndOperator) {
            NdOperator ndOperator2;
            if (ndOperator == NdOperator.WjICYSE) {
                ndOperator2 = NdOperator.WjICYSD;
            } else if (ndOperator == NdOperator.WjICYSF) {
                ndOperator2 = NdOperator.WjICYSG;
            } else if (ndOperator == NdOperator.WjICYSG) {
                ndOperator2 = NdOperator.WjICYSF;
            } else if (ndOperator == NdOperator.WjICYSD) {
                ndOperator2 = NdOperator.WjICYSE;
            } else {
                NdBaseObject.advAssert((boolean)false);
                ndOperator2 = null;
            }
            return ndOperator2;
        }
    }

    static class WjIwUsE
    implements WjIwYdI {
        WjIwUsE() {
        }

        public NdStringInterval WjIQXFV(NdStringIntervalDomain ndStringIntervalDomain, NdConstantString ndConstantString) {
            return NdStringIntervalFactory.getInstance().getInterval(ndStringIntervalDomain, ndConstantString);
        }

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull ndConstantNull) {
            return ndConstantNull == NdConstantNull.WjIDeLB ? NdReferenceTypeInterval.NOT_NULL : NdReferenceTypeInterval.NULL;
        }

        public boolean WjIwXUZ(NdIntervalType ndIntervalType) {
            return ndIntervalType == NdStringInterval.TYPE || ndIntervalType == NdReferenceTypeInterval.TYPE;
        }

        public NdBooleanInterval WjIwYaF(boolean bl) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdIntegerInterval WjIwXVA(long l) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType ndModelEnumeratedItemType) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdRealInterval WjIwXWB(double d) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdMoneyInterval WjIwXXC(NdConstantMoney ndConstantMoney) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdTimeInterval WjIwXZE(NdConstantTime ndConstantTime) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp ndConstantTimeStamp) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdDateInterval WjIxIwC(NdConstantDate ndConstantDate) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdDurationInterval WjIxYtG(NdConstantDuration ndConstantDuration) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }
    }

    static class WjIwUYY
    implements WjIwYdI {
        WjIwUYY() {
        }

        public boolean WjIwXUZ(NdIntervalType ndIntervalType) {
            return true;
        }

        public NdIntegerInterval WjIwXVA(long l) {
            return NdIntervalHelper.makeIntegerInterval('[', l, l, ']');
        }

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType ndModelEnumeratedItemType) {
            return NdIntervalHelper.makeEnumeratedOrderedInterval('[', ndModelEnumeratedItemType, ndModelEnumeratedItemType, ']');
        }

        public NdRealInterval WjIwXWB(double d) {
            return NdIntervalHelper.makeRealInterval('[', d, d, ']');
        }

        public NdMoneyInterval WjIwXXC(NdConstantMoney ndConstantMoney) {
            return NdIntervalHelper.makeMoneyInterval('[', ndConstantMoney, ndConstantMoney, ']');
        }

        public NdTimeInterval WjIwXZE(NdConstantTime ndConstantTime) {
            return NdIntervalHelper.makeTimeInterval('[', ndConstantTime, ndConstantTime, ']');
        }

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp ndConstantTimeStamp) {
            return NdIntervalHelper.makeTimeStampInterval('[', ndConstantTimeStamp, ndConstantTimeStamp, ']');
        }

        public NdDateInterval WjIxIwC(NdConstantDate ndConstantDate) {
            return NdIntervalHelper.makeDateInterval('[', ndConstantDate, ndConstantDate, ']');
        }

        public NdDurationInterval WjIxYtG(NdConstantDuration ndConstantDuration) {
            return NdIntervalHelper.makeDurationInterval('[', ndConstantDuration, ndConstantDuration, ']');
        }

        public NdStringInterval WjIQXFV(NdStringIntervalDomain ndStringIntervalDomain, NdConstantString ndConstantString) {
            return NdStringIntervalFactory.getInstance().getInterval(ndStringIntervalDomain, ndConstantString);
        }

        public NdBooleanInterval WjIwYaF(boolean bl) {
            return bl ? NdBooleanInterval.TRUE : NdBooleanInterval.FALSE;
        }

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull ndConstantNull) {
            return ndConstantNull == NdConstantNull.WjIDeLB ? NdReferenceTypeInterval.NULL : NdReferenceTypeInterval.NOT_NULL;
        }
    }

    static class WjIwUOO
    implements WjIwYdI {
        WjIwUOO() {
        }

        public boolean WjIwXUZ(NdIntervalType ndIntervalType) {
            return ndIntervalType == NdRealInterval.TYPE || ndIntervalType == NdIntegerInterval.TYPE || ndIntervalType == NdMoneyInterval.TYPE || ndIntervalType == NdTimeInterval.TYPE || ndIntervalType == NdTimeStampInterval.TYPE || ndIntervalType == NdDateInterval.TYPE || ndIntervalType == NdDurationInterval.TYPE || ndIntervalType == NdEnumeratedTypeInterval.TYPE;
        }

        public NdIntegerInterval WjIwXVA(long l) {
            return NdIntervalHelper.makeIntegerInterval('(', Long.MIN_VALUE, l, ')');
        }

        public NdRealInterval WjIwXWB(double d) {
            return NdIntervalHelper.makeRealInterval('(', Double.NEGATIVE_INFINITY, d, ')');
        }

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType ndModelEnumeratedItemType) {
            return NdIntervalHelper.makeEnumeratedOrderedInterval('[', ndModelEnumeratedItemType.getEnumeratedType().getFirstItem(), ndModelEnumeratedItemType, ')');
        }

        public NdMoneyInterval WjIwXXC(NdConstantMoney ndConstantMoney) {
            return NdIntervalHelper.makeMoneyInterval('(', (NdConstantMoney)ndConstantMoney.WjICZaZ(), ndConstantMoney, ')');
        }

        public NdTimeInterval WjIwXZE(NdConstantTime ndConstantTime) {
            return NdIntervalHelper.makeTimeInterval('[', (NdConstantTime)ndConstantTime.WjICZaZ(), ndConstantTime, ')');
        }

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp ndConstantTimeStamp) {
            return NdIntervalHelper.makeTimeStampInterval('[', (NdConstantTimeStamp)ndConstantTimeStamp.WjICZaZ(), ndConstantTimeStamp, ')');
        }

        public NdDateInterval WjIxIwC(NdConstantDate ndConstantDate) {
            return NdIntervalHelper.makeDateInterval('[', (NdConstantDate)ndConstantDate.WjICZaZ(), ndConstantDate, ')');
        }

        public NdDurationInterval WjIxYtG(NdConstantDuration ndConstantDuration) {
            return NdIntervalHelper.makeDurationInterval('[', (NdConstantDuration)ndConstantDuration.WjICZaZ(), ndConstantDuration, ')');
        }

        public NdStringInterval WjIQXFV(NdStringIntervalDomain ndStringIntervalDomain, NdConstantString ndConstantString) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdBooleanInterval WjIwYaF(boolean bl) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull ndConstantNull) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }
    }

    static class WjIwURE
    implements WjIwYdI {
        WjIwURE() {
        }

        public boolean WjIwXUZ(NdIntervalType ndIntervalType) {
            return ndIntervalType == NdRealInterval.TYPE || ndIntervalType == NdIntegerInterval.TYPE || ndIntervalType == NdMoneyInterval.TYPE || ndIntervalType == NdTimeInterval.TYPE || ndIntervalType == NdTimeStampInterval.TYPE || ndIntervalType == NdDateInterval.TYPE || ndIntervalType == NdDurationInterval.TYPE || ndIntervalType == NdEnumeratedTypeInterval.TYPE;
        }

        public NdIntegerInterval WjIwXVA(long l) {
            return NdIntervalHelper.makeIntegerInterval('(', Long.MIN_VALUE, l, ']');
        }

        public NdRealInterval WjIwXWB(double d) {
            return NdIntervalHelper.makeRealInterval('(', Double.NEGATIVE_INFINITY, d, ']');
        }

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType ndModelEnumeratedItemType) {
            return NdIntervalHelper.makeEnumeratedOrderedInterval('[', ndModelEnumeratedItemType.getEnumeratedType().getFirstItem(), ndModelEnumeratedItemType, ']');
        }

        public NdMoneyInterval WjIwXXC(NdConstantMoney ndConstantMoney) {
            return NdIntervalHelper.makeMoneyInterval('(', (NdConstantMoney)ndConstantMoney.WjICZaZ(), ndConstantMoney, ']');
        }

        public NdTimeInterval WjIwXZE(NdConstantTime ndConstantTime) {
            return NdIntervalHelper.makeTimeInterval('[', (NdConstantTime)ndConstantTime.WjICZaZ(), ndConstantTime, ']');
        }

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp ndConstantTimeStamp) {
            return NdIntervalHelper.makeTimeStampInterval('[', (NdConstantTimeStamp)ndConstantTimeStamp.WjICZaZ(), ndConstantTimeStamp, ']');
        }

        public NdDateInterval WjIxIwC(NdConstantDate ndConstantDate) {
            return NdIntervalHelper.makeDateInterval('[', (NdConstantDate)ndConstantDate.WjICZaZ(), ndConstantDate, ']');
        }

        public NdDurationInterval WjIxYtG(NdConstantDuration ndConstantDuration) {
            return NdIntervalHelper.makeDurationInterval('[', (NdConstantDuration)ndConstantDuration.WjICZaZ(), ndConstantDuration, ']');
        }

        public NdStringInterval WjIQXFV(NdStringIntervalDomain ndStringIntervalDomain, NdConstantString ndConstantString) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdBooleanInterval WjIwYaF(boolean bl) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull ndConstantNull) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }
    }

    static class WjIwUXG
    implements WjIwYdI {
        WjIwUXG() {
        }

        public boolean WjIwXUZ(NdIntervalType ndIntervalType) {
            return ndIntervalType == NdRealInterval.TYPE || ndIntervalType == NdIntegerInterval.TYPE || ndIntervalType == NdMoneyInterval.TYPE || ndIntervalType == NdTimeInterval.TYPE || ndIntervalType == NdTimeStampInterval.TYPE || ndIntervalType == NdDateInterval.TYPE || ndIntervalType == NdDurationInterval.TYPE || ndIntervalType == NdEnumeratedTypeInterval.TYPE;
        }

        public NdIntegerInterval WjIwXVA(long l) {
            return NdIntervalHelper.makeIntegerInterval('(', l, Long.MAX_VALUE, ')');
        }

        public NdRealInterval WjIwXWB(double d) {
            return NdIntervalHelper.makeRealInterval('(', d, Double.POSITIVE_INFINITY, ')');
        }

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType ndModelEnumeratedItemType) {
            return NdIntervalHelper.makeEnumeratedOrderedInterval('(', ndModelEnumeratedItemType, ndModelEnumeratedItemType.getEnumeratedType().getLastItem(), ']');
        }

        public NdMoneyInterval WjIwXXC(NdConstantMoney ndConstantMoney) {
            return NdIntervalHelper.makeMoneyInterval('(', ndConstantMoney, (NdConstantMoney)ndConstantMoney.WjICZbA(), ')');
        }

        public NdTimeInterval WjIwXZE(NdConstantTime ndConstantTime) {
            return NdIntervalHelper.makeTimeInterval('(', ndConstantTime, (NdConstantTime)ndConstantTime.WjICZbA(), ']');
        }

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp ndConstantTimeStamp) {
            return NdIntervalHelper.makeTimeStampInterval('(', ndConstantTimeStamp, (NdConstantTimeStamp)ndConstantTimeStamp.WjICZbA(), ']');
        }

        public NdDateInterval WjIxIwC(NdConstantDate ndConstantDate) {
            return NdIntervalHelper.makeDateInterval('(', ndConstantDate, (NdConstantDate)ndConstantDate.WjICZbA(), ']');
        }

        public NdDurationInterval WjIxYtG(NdConstantDuration ndConstantDuration) {
            return NdIntervalHelper.makeDurationInterval('(', ndConstantDuration, (NdConstantDuration)ndConstantDuration.WjICZbA(), ']');
        }

        public NdStringInterval WjIQXFV(NdStringIntervalDomain ndStringIntervalDomain, NdConstantString ndConstantString) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdBooleanInterval WjIwYaF(boolean bl) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull ndConstantNull) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }
    }

    static class WjIwUXR
    implements WjIwYdI {
        WjIwUXR() {
        }

        public boolean WjIwXUZ(NdIntervalType ndIntervalType) {
            return ndIntervalType == NdRealInterval.TYPE || ndIntervalType == NdIntegerInterval.TYPE || ndIntervalType == NdMoneyInterval.TYPE || ndIntervalType == NdTimeInterval.TYPE || ndIntervalType == NdDateInterval.TYPE || ndIntervalType == NdTimeStampInterval.TYPE || ndIntervalType == NdDurationInterval.TYPE || ndIntervalType == NdEnumeratedTypeInterval.TYPE;
        }

        public NdIntegerInterval WjIwXVA(long l) {
            return NdIntervalHelper.makeIntegerInterval('[', l, Long.MAX_VALUE, ')');
        }

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType ndModelEnumeratedItemType) {
            return NdIntervalHelper.makeEnumeratedOrderedInterval('[', ndModelEnumeratedItemType, ndModelEnumeratedItemType.getEnumeratedType().getLastItem(), ']');
        }

        public NdRealInterval WjIwXWB(double d) {
            return NdIntervalHelper.makeRealInterval('[', d, Double.POSITIVE_INFINITY, ')');
        }

        public NdMoneyInterval WjIwXXC(NdConstantMoney ndConstantMoney) {
            return NdIntervalHelper.makeMoneyInterval('[', ndConstantMoney, (NdConstantMoney)ndConstantMoney.WjICZbA(), ')');
        }

        public NdTimeInterval WjIwXZE(NdConstantTime ndConstantTime) {
            return NdIntervalHelper.makeTimeInterval('[', ndConstantTime, (NdConstantTime)ndConstantTime.WjICZbA(), ']');
        }

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp ndConstantTimeStamp) {
            return NdIntervalHelper.makeTimeStampInterval('[', ndConstantTimeStamp, (NdConstantTimeStamp)ndConstantTimeStamp.WjICZbA(), ']');
        }

        public NdDateInterval WjIxIwC(NdConstantDate ndConstantDate) {
            return NdIntervalHelper.makeDateInterval('[', ndConstantDate, (NdConstantDate)ndConstantDate.WjICZbA(), ']');
        }

        public NdDurationInterval WjIxYtG(NdConstantDuration ndConstantDuration) {
            return NdIntervalHelper.makeDurationInterval('[', ndConstantDuration, (NdConstantDuration)ndConstantDuration.WjICZbA(), ']');
        }

        public NdStringInterval WjIQXFV(NdStringIntervalDomain ndStringIntervalDomain, NdConstantString ndConstantString) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdBooleanInterval WjIwYaF(boolean bl) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull ndConstantNull) {
            throw NdBaseObject.apiError((String)"Operator is not supported");
        }
    }

    static interface WjIwYdI {
        public static final String WjIwXUY = "Operator is not supported";

        public boolean WjIwXUZ(NdIntervalType var1);

        public NdIntegerInterval WjIwXVA(long var1);

        public NdRealInterval WjIwXWB(double var1);

        public NdMoneyInterval WjIwXXC(NdConstantMoney var1);

        public NdEnumeratedTypeInterval WjIwXYD(NdModelEnumeratedItemType var1);

        public NdTimeInterval WjIwXZE(NdConstantTime var1);

        public NdDateInterval WjIxIwC(NdConstantDate var1);

        public NdTimeStampInterval WjIxMdD(NdConstantTimeStamp var1);

        public NdDurationInterval WjIxYtG(NdConstantDuration var1);

        public NdBooleanInterval WjIwYaF(boolean var1);

        public NdStringInterval WjIQXFV(NdStringIntervalDomain var1, NdConstantString var2);

        public NdReferenceTypeInterval WjIwYcH(NdConstantNull var1);
    }
}

