/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.test.NdAssert;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdDiscreetConvex;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalConstraint;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.predicate.WjIDdTC;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NdHyperCube
implements NdDiscreetConvex {
    public static final NdHyperCube EMPTY_SET = new NdHyperCube();
    private NdBasis WjIwLVX;
    private final Map WjIwLVY;
    private boolean WjIwLVZ;
    private int WjIwLWA;
    private boolean WjIwLXB;
    private final boolean WjIwLYC;

    private NdHyperCube() {
        this.WjIwLVY = null;
        this.WjIwLYC = true;
    }

    public NdHyperCube(NdBasis ndBasis) {
        NdBaseObject.advAssertNonNull((Object)ndBasis);
        this.WjIwLVY = new HashMap();
        this.WjIwLVX = ndBasis;
        this.WjIwLVZ = false;
        this.WjIwLXB = false;
        this.WjIwLYC = false;
    }

    void WjIAyxB(boolean bl) {
    }

    public boolean isEmptySet() {
        return this.WjIwLYC;
    }

    public boolean isUniversum() {
        NdAssert.fail((String)"Not implemented");
        return false;
    }

    public Object accept(NdShapeVisitor ndShapeVisitor, Object object) throws NdShapeException {
        return ndShapeVisitor.visit(this, object);
    }

    public NdShape[] getElements() {
        NdShape[] ndShapeArray = new NdShape[this.WjIwLVY.size()];
        int n = 0;
        Iterator iterator = this.WjIwLVY.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NdSingleInterval ndSingleInterval = (NdSingleInterval)this.WjIwLVY.get(string);
            int n2 = this.WjIwLVX.getVariableIndex(string);
            WjIDdTC wjIDdTC = this.WjIwLVX.getVariable(n2);
            ndShapeArray[n++] = ndSingleInterval.makeShape(wjIDdTC);
        }
        return ndShapeArray;
    }

    public NdIntervalConstraint getConstraint(WjIDdTC wjIDdTC) {
        NdIntervalConstraint ndIntervalConstraint = null;
        NdSingleInterval ndSingleInterval = this.getInterval(wjIDdTC.WjIDbnY());
        if (ndSingleInterval != null) {
            ndIntervalConstraint = (NdIntervalConstraint)((Object)ndSingleInterval.makeShape(wjIDdTC));
        }
        return ndIntervalConstraint;
    }

    public NdShape getElement(WjIDdTC wjIDdTC) {
        NdShape ndShape = null;
        NdSingleInterval ndSingleInterval = this.getInterval(wjIDdTC.WjIDbnY());
        if (ndSingleInterval != null) {
            ndShape = ndSingleInterval.makeShape(wjIDdTC);
        }
        return ndShape;
    }

    public NdIntervalConstraint[] getConstraints() {
        NdIntervalConstraint[] ndIntervalConstraintArray = new NdIntervalConstraint[this.WjIwLVY.size()];
        int n = 0;
        Iterator iterator = this.WjIwLVY.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NdSingleInterval ndSingleInterval = (NdSingleInterval)this.WjIwLVY.get(string);
            int n2 = this.WjIwLVX.getVariableIndex(string);
            WjIDdTC wjIDdTC = this.WjIwLVX.getVariable(n2);
            ndIntervalConstraintArray[n++] = (NdIntervalConstraint)((Object)ndSingleInterval.makeShape(wjIDdTC));
        }
        return ndIntervalConstraintArray;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isContinuous() {
        return false;
    }

    public boolean isDegenerate() {
        this.WjIwLVZ = false;
        Iterator iterator = this.WjIwLVY.values().iterator();
        while (iterator.hasNext()) {
            if (!((NdInterval)iterator.next()).isDegenerate()) continue;
            this.WjIwLVZ = true;
            break;
        }
        return this.WjIwLVZ;
    }

    public NdConvexShape cloneMe() {
        NdHyperCube ndHyperCube = new NdHyperCube(this.WjIwLVX);
        Iterator iterator = this.WjIwLVY.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ndHyperCube.WjIwLVY.put(string, this.WjIwLVY.get(string));
        }
        ndHyperCube.WjIAyxB(true);
        return ndHyperCube;
    }

    public NdConvexShape intersect(NdConvexShape ndConvexShape) {
        NdHyperCube ndHyperCube;
        if (ndConvexShape == EMPTY_SET) {
            ndHyperCube = (NdHyperCube)ndConvexShape;
        } else {
            NdBaseObject.advAssert((ndConvexShape.getBasis() == this.WjIwLVX ? 1 : 0) != 0);
            ndHyperCube = new NdHyperCube(this.WjIwLVX);
            NdHyperCube ndHyperCube2 = (NdHyperCube)ndConvexShape;
            int n = this.WjIwLVX.getDimension();
            for (int i = 0; i < n; ++i) {
                NdSingleInterval ndSingleInterval;
                String string = this.WjIwLVX.getVariable((int)i).WjIDbiT;
                NdSingleInterval ndSingleInterval2 = this.getInterval(string);
                NdSingleInterval ndSingleInterval3 = ndHyperCube2.getInterval(string);
                if (ndSingleInterval2 == null && ndSingleInterval3 == null) continue;
                if (ndSingleInterval2 == null) {
                    ndSingleInterval = ndSingleInterval3;
                } else if (ndSingleInterval3 == null) {
                    ndSingleInterval = ndSingleInterval2;
                } else {
                    ndSingleInterval = ndSingleInterval2.intersect(ndSingleInterval3);
                    if (ndSingleInterval.isEmpty()) {
                        ndHyperCube = EMPTY_SET;
                        break;
                    }
                }
                ndHyperCube.putInterval(string, ndSingleInterval);
            }
        }
        ndHyperCube.WjIAyxB(true);
        return ndHyperCube;
    }

    public NdConvexShape transpose(NdBasis ndBasis) throws NdShapeException {
        NdBaseObject.advAssert((ndBasis != null && ndBasis.getDimension() >= this.WjIwLVX.getDimension() ? 1 : 0) != 0);
        NdHyperCube ndHyperCube = new NdHyperCube(ndBasis);
        int n = this.WjIwLVX.getDimension();
        for (int i = 0; i < n; ++i) {
            String string = this.WjIwLVX.getVariable((int)i).WjIDbiT;
            if (!ndBasis.contains(string)) {
                throw new NdShapeException("IncompatibleBasis");
            }
            NdSingleInterval ndSingleInterval = this.getInterval(string);
            if (ndSingleInterval == null) continue;
            ndHyperCube.putInterval(string, ndSingleInterval);
        }
        ndHyperCube.WjIAyxB(true);
        return ndHyperCube;
    }

    public void addBound(List list) {
        NdBaseObject.apiError((String)"HyperCube does not support multivariate bounds");
    }

    public void putInterval(String string, NdSingleInterval ndSingleInterval) {
        NdAssert.assertNotNull((Object)ndSingleInterval);
        this.WjIwLVZ |= ndSingleInterval.isDegenerate();
        this.WjIwLVY.put(string, ndSingleInterval);
        this.WjIwLXB = false;
    }

    public NdSingleInterval getInterval(String string) {
        return (NdSingleInterval)this.WjIwLVY.get(string);
    }

    public NdConvexShape projection(WjIDdTC[] wjIDdTCArray) {
        NdHyperCube ndHyperCube;
        int n;
        WjIDdTC[] wjIDdTCArray2 = new WjIDdTC[wjIDdTCArray.length];
        int n2 = 0;
        for (n = 0; n < wjIDdTCArray.length; ++n) {
            if (!this.WjIwLVY.containsKey(wjIDdTCArray[n].WjIDbnY())) continue;
            wjIDdTCArray2[n2++] = wjIDdTCArray[n];
        }
        if (n2 > 0) {
            ndHyperCube = new NdHyperCube(this.WjIwLVX);
            for (n = 0; n < n2; ++n) {
                String string = wjIDdTCArray2[n].WjIDbnY();
                ndHyperCube.WjIwLVY.put(string, this.WjIwLVY.get(string));
            }
        } else {
            ndHyperCube = EMPTY_SET;
        }
        ndHyperCube.WjIAyxB(true);
        return ndHyperCube;
    }

    public NdHyperCube removeIntervals(WjIDdTC[] wjIDdTCArray) {
        NdHyperCube ndHyperCube;
        WjIDdTC[] wjIDdTCArray2 = new WjIDdTC[wjIDdTCArray.length];
        int n = 0;
        for (int i = 0; i < wjIDdTCArray.length; ++i) {
            if (!this.WjIwLVY.containsKey(wjIDdTCArray[i].WjIDbnY())) continue;
            wjIDdTCArray2[n++] = wjIDdTCArray[i];
        }
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.WjIwLVY);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                hashMap.remove(wjIDdTCArray2[i].WjIDbnY());
            }
        }
        if (hashMap.size() == 0) {
            ndHyperCube = EMPTY_SET;
        } else {
            ndHyperCube = new NdHyperCube(this.WjIwLVX);
            ndHyperCube.WjIwLVY.putAll(hashMap);
        }
        ndHyperCube.WjIAyxB(true);
        return ndHyperCube;
    }

    public int getDimension() {
        return this.WjIwLVY.size();
    }

    public NdBasis getBasis() {
        return this.WjIwLVX;
    }

    public boolean equals(Object object) {
        NdHyperCube ndHyperCube = (NdHyperCube)object;
        return ndHyperCube != null && ((Object)this.WjIwLVY).equals(ndHyperCube.WjIwLVY);
    }

    public int hashCode() {
        if (!this.WjIwLXB) {
            this.WjIwLWA = 0;
            Iterator iterator = this.WjIwLVY.values().iterator();
            while (iterator.hasNext()) {
                this.WjIwLWA |= iterator.next().hashCode();
            }
            this.WjIwLXB = true;
        }
        return this.WjIwLWA;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.WjIwLVY.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.WjIwLVY.get(string);
            stringBuffer.append(string).append(" : ");
            stringBuffer.append(v.toString());
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    public String toAnalyticalString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = this.WjIwLVY.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NdInterval ndInterval = (NdInterval)this.WjIwLVY.get(string);
            if (!bl) {
                stringBuffer.append(" and ");
            } else {
                bl = false;
            }
            stringBuffer.append(ndInterval.toAnalyticalString(string));
        }
        return stringBuffer.toString();
    }
}

