/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationMessage;
import com.blazesoft.verifier.NdVerificationStatusMessage;
import com.blazesoft.verifier.NdVerifierCallback;
import com.blazesoft.verifier.cfa.NdBranchAnnotation;
import com.blazesoft.verifier.cfa.NdControlFlowAnomaly;
import com.blazesoft.verifier.cfa.consistency.NdSplitCoverageVerifier;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConstraintNotSupportedException;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdDisjointBasesDomain;
import com.blazesoft.verifier.cfa.spatial.NdDisjunct;
import com.blazesoft.verifier.cfa.spatial.NdMaxCoverageVariablesException;
import com.blazesoft.verifier.cfa.spatial.NdOverlap;
import com.blazesoft.verifier.cfa.spatial.NdPlainPredicateSetContradictionAnomaly;
import com.blazesoft.verifier.cfa.spatial.NdPlainPredicateSetIncompletenessAnomaly;
import com.blazesoft.verifier.cfa.spatial.NdPlainPredicateSetOverlapAnomaly;
import com.blazesoft.verifier.cfa.spatial.NdSpatialEngineImpl;
import com.blazesoft.verifier.cfa.spatial.algorithm.NdOverlapDetector;
import com.blazesoft.verifier.cfa.spatial.formula.NdFormulaGenerator;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdOverflowException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraFactory;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.er.NdExternalAstNode;
import com.blazesoft.verifier.normalization.NdBranchPreprocessor;
import com.blazesoft.verifier.predicate.NdFormula;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdTopLevelPredicate;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.util.NdVerifierLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NdIntervalAnalyzer {
    public static final String NAME = (class$com$blazesoft$verifier$cfa$spatial$NdIntervalAnalyzer == null ? (class$com$blazesoft$verifier$cfa$spatial$NdIntervalAnalyzer = NdIntervalAnalyzer.class$("com.blazesoft.verifier.cfa.spatial.NdIntervalAnalyzer")) : class$com$blazesoft$verifier$cfa$spatial$NdIntervalAnalyzer).getName();
    private static final int WjIwKAB = 1000;
    private int WjIwKAC = 10;
    private long WjIwKAD = 1000000L;
    private static final NdPolyhedraFactory WjIwKAE = NdPolyhedraFactory.getInstance();
    private NdFormulaGenerator WjIwKAF;
    private List WjIwKAG;
    private HashSet WjIwKAH;
    private LinkedList WjIwKAI;
    private NdVerificationContext WjIwKAJ;
    private NdOverlapDetector WjIwKAK;
    static /* synthetic */ Class class$com$blazesoft$verifier$cfa$spatial$NdIntervalAnalyzer;

    public NdIntervalAnalyzer(NdVerificationContext ndVerificationContext) {
        NdBaseObject.advAssertNonNull((Object)ndVerificationContext);
        this.WjIwKAJ = ndVerificationContext;
        this.WjIwKAG = new ArrayList();
        this.WjIwKAH = new HashSet();
        this.WjIwKAI = new LinkedList();
        this.WjIwKAF = new NdFormulaGenerator(this.WjIwKAJ);
        this.WjIwKAK = new NdOverlapDetector(ndVerificationContext);
    }

    private final boolean WjIwKAL(NdVerifierCallback ndVerifierCallback) {
        boolean bl = !ndVerifierCallback.fireStatusUpdate(NdVerificationStatusMessage.makeInProgress(NdSplitCoverageVerifier.NAME, 0.0));
        Thread.yield();
        return bl;
    }

    private void WjIwKAN(NdConvexShape ndConvexShape) {
        NdPolyhedron ndPolyhedron = ((NdComboShape)ndConvexShape).polyhedron;
        if (ndPolyhedron != null) {
            WjIwKAE.recyclePolyhedron(ndPolyhedron);
        }
    }

    private List WjIwKAM(NdDisjointBasesDomain ndDisjointBasesDomain, List list, boolean bl, NdVerifierCallback ndVerifierCallback) {
        ArrayList arrayList = new ArrayList();
        NdSpatialEngineImpl ndSpatialEngineImpl = new NdSpatialEngineImpl(this.WjIwKAJ);
        if (NdVerifierLog.isTraceEnabled(NAME)) {
            NdVerifierLog.trace(NAME, "[analyzeDisjuncts: Initial domain partitioning]");
        }
        long l = 0L;
        HashSet<NdComboShape> hashSet = new HashSet<NdComboShape>();
        HashMap<String, NdTopLevelPredicate> hashMap = new HashMap<String, NdTopLevelPredicate>();
        HashMap<String, NdTopLevelPredicate> hashMap2 = new HashMap<String, NdTopLevelPredicate>();
        ArrayList<NdDisjunct> arrayList2 = new ArrayList<NdDisjunct>();
        Iterator iterator = ndDisjointBasesDomain.basisIterator();
        block7: while (iterator.hasNext()) {
            Object object;
            NdDisjunct ndDisjunct;
            int n;
            ArrayList<NdComboShape> arrayList3 = new ArrayList<NdComboShape>();
            NdBasisImpl ndBasisImpl = (NdBasisImpl)iterator.next();
            List list2 = ndDisjointBasesDomain.getDisjuncts(ndBasisImpl);
            ArrayList<NdDisjunct> arrayList4 = new ArrayList<NdDisjunct>();
            hashSet.clear();
            hashMap.clear();
            hashMap2.clear();
            int n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                ndDisjunct = (NdDisjunct)list2.get(n);
                if (ndDisjunct.convex != null) continue;
                try {
                    ndDisjunct.convex = ndSpatialEngineImpl.createConvexShape(ndBasisImpl, ndDisjunct.disjunct);
                    if (ndDisjunct.convex.isEmptySet()) {
                        if (!hashMap2.containsKey(ndDisjunct.testCondition.WjIDeuD())) {
                            hashMap.put(ndDisjunct.testCondition.WjIDeuD(), ndDisjunct.testCondition);
                        }
                        if (!NdVerifierLog.isTraceEnabled(NAME)) continue;
                        NdVerifierLog.trace(NAME, "Contradicting disjunct: " + ndDisjunct);
                        continue;
                    }
                    ndDisjunct.testCondition.WjIDesY(ndDisjunct.convex);
                    arrayList4.add(ndDisjunct);
                    if (hashMap.containsKey(ndDisjunct.testCondition.WjIDeuD())) {
                        hashMap.remove(ndDisjunct.testCondition.WjIDeuD());
                    }
                    hashMap2.put(ndDisjunct.testCondition.WjIDeuD(), ndDisjunct.testCondition);
                    continue;
                }
                catch (NdConstraintNotSupportedException ndConstraintNotSupportedException) {
                    ndDisjunct.convex = NdComboShape.makeEmptyShape();
                    this.WjIwKAG.add(new NdConstraintNotSupportedException(ndDisjunct.testCondition, ndConstraintNotSupportedException.WjICXRL()));
                    if (!NdVerifierLog.isTraceEnabled(NAME)) continue;
                    ndConstraintNotSupportedException.printStackTrace();
                    continue;
                }
                catch (NdFormulaException ndFormulaException) {
                    if (ndFormulaException.getSourceThrowable() instanceof NdOverflowException) {
                        this.WjIwKAG.add(new NdOverflowException(ndDisjunct.testCondition, ndFormulaException.WjICXRL()));
                        if (!NdVerifierLog.isTraceEnabled(NAME)) continue;
                        ndFormulaException.printStackTrace();
                        continue;
                    }
                    NdVerifierLog.logError(NAME, "Internal error in formula " + ndFormulaException.WjICXRL() + " original predicate " + ndDisjunct.testCondition + ndFormulaException.getMessage(), (Throwable)((Object)ndFormulaException));
                    if (NdVerifierLog.isTraceEnabled(NAME)) {
                        ndFormulaException.printStackTrace();
                    }
                    NdBaseObject.advAssert((boolean)false);
                }
            }
            if (hashMap.size() > 0) {
                list.addAll(hashMap.values());
            }
            if (bl) {
                arrayList2.clear();
                n2 = arrayList4.size();
                for (n = 0; n < n2; ++n) {
                    ndDisjunct = (NdDisjunct)arrayList4.get(n);
                    try {
                        if (ndDisjunct.testCondition.WjIDeuC() || !hashMap2.containsKey(ndDisjunct.testCondition.WjIDeuD())) continue;
                        ArrayList arrayList5 = new ArrayList();
                        ndSpatialEngineImpl.difference(ndBasisImpl, NdComboShape.makeUniversum(ndBasisImpl), ndDisjunct.convex, arrayList5, ndVerifierCallback);
                        if (ndVerifierCallback.isInterrupted()) break block7;
                        int n3 = arrayList5.size();
                        for (int i = 0; i < n3; ++i) {
                            if (i > 0 && i % (1000000 / i) == 0) {
                                if (NdVerifierLog.isTraceEnabled(NAME)) {
                                    NdVerifierLog.trace(NAME, "Iteration on initial cut " + i + " size=" + this.WjIwKAH.size());
                                }
                                if (this.WjIwKAL(ndVerifierCallback)) break block7;
                            }
                            if ((object = (NdConvexShape)arrayList5.get(i)).isDegenerate() || this.WjIwKAH.contains(object)) continue;
                            this.WjIwKAH.add(object);
                            this.WjIwKAI.add(object);
                        }
                        arrayList2.add(ndDisjunct);
                        continue;
                    }
                    catch (NdFormulaException ndFormulaException) {
                        if (ndFormulaException.getSourceThrowable() instanceof NdOverflowException) {
                            this.WjIwKAG.add(new NdOverflowException(ndDisjunct.testCondition, ndFormulaException.WjICXRL()));
                            if (!NdVerifierLog.isTraceEnabled(NAME)) continue;
                            ndFormulaException.printStackTrace();
                            continue;
                        }
                        NdVerifierLog.logError(NAME, "Internal error in formula " + ndFormulaException.WjICXRL() + " original predicate " + ndDisjunct.testCondition + ndFormulaException.getMessage(), (Throwable)((Object)ndFormulaException));
                        if (NdVerifierLog.isTraceEnabled(NAME)) {
                            ndFormulaException.printStackTrace();
                        }
                        NdBaseObject.advAssert((boolean)false);
                    }
                }
            }
            if (NdVerifierLog.isTraceEnabled(NAME)) {
                NdVerifierLog.trace(NAME, "------------------------------------------------------------------------");
                NdVerifierLog.trace(NAME, "Domain is initially splitted to :");
                Iterator iterator2 = this.WjIwKAI.iterator();
                while (iterator2.hasNext()) {
                    NdConvexShape ndConvexShape = (NdConvexShape)iterator2.next();
                    NdVerifierLog.trace(NAME, "\t" + ndConvexShape.toAnalyticalString());
                }
                NdVerifierLog.trace(NAME, "[analyzeDisjuncts: sweeping/cutting convexes]");
            }
            n = 0;
            n2 = 0;
            int n4 = 0;
            int n5 = 0;
            while (!this.WjIwKAH.isEmpty()) {
                if (l % 1000L == 0L) {
                    if (NdVerifierLog.isTraceEnabled(NAME)) {
                        NdVerifierLog.trace(NAME, "Iteration on sweeping " + l + " " + this.WjIwKAH.size() + " convexes to do, in=" + n + ", inDup=" + n2 + ", out=" + n4 + ", non covered=" + n5);
                    }
                    if (this.WjIwKAL(ndVerifierCallback)) break block7;
                    n2 = 0;
                    n4 = 0;
                    n = 0;
                }
                NdComboShape ndComboShape = (NdComboShape)this.WjIwKAI.removeLast();
                NdBaseObject.advAssert((boolean)this.WjIwKAH.remove(ndComboShape));
                NdOverlap ndOverlap = NdOverlap.NO_OVERLAP;
                object = new ArrayList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    NdDisjunct ndDisjunct2 = (NdDisjunct)arrayList2.get(i);
                    try {
                        if (NdVerifierLog.isTraceEnabled(NAME)) {
                            NdVerifierLog.trace(NAME, "Comparing test:" + ndComboShape.toAnalyticalString());
                            NdVerifierLog.trace(NAME, "against formula:" + ndDisjunct2.toString());
                            if (NdVerifierLog.isTraceEnabled(NAME)) {
                                // empty if block
                            }
                        }
                        object.clear();
                        NdConvexShape ndConvexShape = ndDisjunct2.convex;
                        ndOverlap = ndSpatialEngineImpl.partition(ndBasisImpl, ndComboShape, ndConvexShape, (List)object, true, ndVerifierCallback);
                        if (this.WjIwKAL(ndVerifierCallback)) {
                            break block7;
                        }
                    }
                    catch (NdFormulaException ndFormulaException) {
                        if (ndFormulaException.getSourceThrowable() instanceof NdOverflowException) {
                            this.WjIwKAG.add(new NdOverflowException(ndDisjunct2.testCondition, ndFormulaException.WjICXRL()));
                            if (!NdVerifierLog.isTraceEnabled(NAME)) break block7;
                            ndFormulaException.printStackTrace();
                            break block7;
                        }
                        NdVerifierLog.logError(NAME, "Internal error in formula " + ndFormulaException.WjICXRL() + " original predicate " + ndDisjunct2 + ndFormulaException.getMessage());
                        if (NdVerifierLog.isTraceEnabled(NAME)) {
                            ndFormulaException.printStackTrace();
                        }
                        NdBaseObject.advAssert((boolean)false);
                    }
                    if (ndOverlap == NdOverlap.COMPLETE) {
                        if (NdVerifierLog.isTraceEnabled(NAME)) {
                            NdVerifierLog.trace(NAME, "is covered");
                        }
                        if (ndComboShape.polyhedron != null) {
                            // empty if block
                        }
                        ++n4;
                        break;
                    }
                    if (NdVerifierLog.isTraceEnabled(NAME)) {
                        NdVerifierLog.trace(NAME, "is not covered");
                    }
                    if (!object.isEmpty()) {
                        NdConvexShape ndConvexShape;
                        int n6;
                        if (NdVerifierLog.isTraceEnabled(NAME)) {
                            NdVerifierLog.trace(NAME, "[analyzeDisjuncts: convex splitted to]");
                            NdVerifierLog.trace(NAME, "splitted to " + object.size() + " chunks");
                            n6 = object.size();
                            for (int j = 0; j < n6; ++j) {
                                ndConvexShape = (NdConvexShape)object.get(j);
                                NdVerifierLog.trace(NAME, "\t" + ndConvexShape.toAnalyticalString());
                            }
                            NdVerifierLog.trace(NAME, "------------------------------------------------------------------------");
                        }
                        n6 = object.size();
                        for (int j = 0; j < n6; ++j) {
                            ndConvexShape = (NdConvexShape)object.get(j);
                            if (!this.WjIwKAH.contains(ndConvexShape)) {
                                this.WjIwKAH.add(ndConvexShape);
                                this.WjIwKAI.add(ndConvexShape);
                                ++n;
                                continue;
                            }
                            ++n2;
                        }
                        if (ndComboShape.polyhedron != null) {
                            // empty if block
                        }
                        ndOverlap = NdOverlap.COMPLETE;
                        if (object.size() <= 0 || ndComboShape.polyhedron != null) {
                            // empty if block
                        }
                        ++n4;
                        break;
                    }
                    if (!NdVerifierLog.isTraceEnabled(NAME)) continue;
                    NdVerifierLog.trace(NAME, "no chunks");
                }
                if (ndOverlap == NdOverlap.NO_OVERLAP) {
                    hashSet.add(ndComboShape);
                    ++n5;
                }
                ++l;
            }
            arrayList3.addAll(hashSet);
            if (arrayList3.size() <= 0) continue;
            arrayList.addAll(arrayList3);
        }
        if (NdVerifierLog.isTraceEnabled(NAME)) {
            NdVerifierLog.trace(NAME, "[analyzeDisjuncts Finished]");
        }
        return arrayList;
    }

    public long getMaxDisjunctsPerFormula() {
        return this.WjIwKAD;
    }

    public void setMaxDisjunctsPerFormula(long l) {
        this.WjIwKAD = l;
    }

    public int getMaxVariablesNumber() {
        return this.WjIwKAC;
    }

    public void setMaxVariablesNumber(int n) {
        this.WjIwKAC = n;
    }

    public int getDefaultLinearPrecision() {
        return 1000;
    }

    public NdControlFlowAnomaly makeOverlapAnomaly(NdTopLevelPredicate ndTopLevelPredicate, NdTopLevelPredicate ndTopLevelPredicate2, NdFormula ndFormula) {
        return new NdPlainPredicateSetOverlapAnomaly(ndTopLevelPredicate, ndTopLevelPredicate2, ndFormula);
    }

    public NdControlFlowAnomaly makeIncompletenessAnomaly(NdFormula ndFormula) {
        return new NdPlainPredicateSetIncompletenessAnomaly(ndFormula);
    }

    public NdControlFlowAnomaly makeContradictionAnomaly(NdTopLevelPredicate ndTopLevelPredicate) {
        return new NdPlainPredicateSetContradictionAnomaly(ndTopLevelPredicate);
    }

    public List testBranchConditions(NdBranchPreprocessor ndBranchPreprocessor, NdBranchAnnotation[] ndBranchAnnotationArray, boolean bl, boolean bl2, List list, List list2, int n, NdVerifierCallback ndVerifierCallback) {
        NdSpatialEngineImpl ndSpatialEngineImpl = new NdSpatialEngineImpl(this.WjIwKAJ);
        NdDisjointBasesDomain ndDisjointBasesDomain = ndSpatialEngineImpl.createDisjointBaseDomain(ndBranchPreprocessor, ndBranchAnnotationArray, n, this.WjIwKAG);
        int n2 = ndDisjointBasesDomain.getMaxDimension();
        List list3 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        if (n2 > this.WjIwKAC) {
            this.WjIwKAG.add(new NdMaxCoverageVariablesException(this.WjIwKAC, n2));
        } else {
            list3 = this.WjIwKAM(ndDisjointBasesDomain, arrayList, bl2, ndVerifierCallback);
            if (bl) {
                NdBaseObject.advAssertNonNull((Object)list);
                WjIwOxJ wjIwOxJ = new WjIwOxJ(ndVerifierCallback, list, this.WjIwKAG);
                this.WjIwKAK.searchOverlaps(ndDisjointBasesDomain, (NdOverlapDetector.Callback)wjIwOxJ);
            }
        }
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            NdTopLevelPredicate ndTopLevelPredicate = (NdTopLevelPredicate)arrayList.get(i);
            list2.add(this.makeContradictionAnomaly(ndTopLevelPredicate));
        }
        ArrayList<NdControlFlowAnomaly> arrayList2 = new ArrayList<NdControlFlowAnomaly>();
        int n4 = list3.size();
        for (n3 = 0; n3 < n4; ++n3) {
            NdControlFlowAnomaly ndControlFlowAnomaly;
            NdConvexShape ndConvexShape = (NdConvexShape)list3.get(n3);
            NdFormula ndFormula = this.WjIwKAF.generate(ndConvexShape, true);
            if (ndFormula != null && (ndControlFlowAnomaly = this.makeIncompletenessAnomaly(ndFormula)) != null) {
                arrayList2.add(ndControlFlowAnomaly);
            }
            this.WjIwKAN(ndConvexShape);
        }
        return arrayList2;
    }

    public List searchSelfContradictions(NdBranchPreprocessor ndBranchPreprocessor, NdBranchAnnotation[] ndBranchAnnotationArray, NdVerifierCallback ndVerifierCallback) {
        NdBaseObject.advAssertNonNull((Object)ndBranchAnnotationArray);
        ArrayList arrayList = new ArrayList();
        this.testBranchConditions(ndBranchPreprocessor, ndBranchAnnotationArray, false, true, null, arrayList, this.getDefaultLinearPrecision(), ndVerifierCallback);
        return arrayList;
    }

    public List getExceptions() {
        return this.WjIwKAG;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WjIwOxJ
    implements NdOverlapDetector.Callback {
        private NdVerifierCallback WjIwOuG;
        private List WjIwOvH;
        private List WjIwOwI;

        WjIwOxJ(NdVerifierCallback ndVerifierCallback, List list, List list2) {
            this.WjIwOuG = ndVerifierCallback;
            this.WjIwOvH = list;
            this.WjIwOwI = list2;
        }

        public boolean isMuted() {
            return this.WjIwOuG.isMuted();
        }

        public void setMuted(boolean bl) {
            this.WjIwOuG.setMuted(bl);
        }

        public void fireAnomaly(NdVerificationMessage ndVerificationMessage) {
            this.WjIwOuG.fireAnomaly(ndVerificationMessage);
        }

        public void fireAnomalyBlock(NdVerificationMessage[] ndVerificationMessageArray) {
            this.WjIwOuG.fireAnomalyBlock(ndVerificationMessageArray);
        }

        public boolean fireStatusUpdate(NdVerificationStatusMessage ndVerificationStatusMessage) {
            return this.WjIwOuG.fireStatusUpdate(ndVerificationStatusMessage);
        }

        public String getContainerName() {
            return this.WjIwOuG.getContainerName();
        }

        public int getProgressMax() {
            return this.WjIwOuG.getProgressMax();
        }

        public int getProgressMin() {
            return this.WjIwOuG.getProgressMin();
        }

        public boolean isInterrupted() {
            return this.WjIwOuG.isInterrupted();
        }

        public NdExternalAstNode getContainer() {
            return this.WjIwOuG.getContainer();
        }

        public void setContainer(NdExternalAstNode ndExternalAstNode, String string) {
            this.WjIwOuG.setContainer(ndExternalAstNode, string);
        }

        public void setInterrupted() {
            this.WjIwOuG.setInterrupted();
        }

        public int setProgressMax(int n) {
            return this.WjIwOuG.setProgressMax(n);
        }

        public void exceptionDetected(NdFormulaException ndFormulaException) {
            this.WjIwOwI.add(ndFormulaException);
        }

        public void notSupportedFormulaDetected(NdFormulaException ndFormulaException) {
        }

        public void overlappingDetected(NdTopLevelPredicate ndTopLevelPredicate, NdTopLevelPredicate ndTopLevelPredicate2, NdFormula ndFormula) {
            this.WjIwOvH.add(NdIntervalAnalyzer.this.makeOverlapAnomaly(ndTopLevelPredicate, ndTopLevelPredicate2, ndFormula));
        }

        public boolean WjISnTN() {
            return false;
        }

        public void WjISnTO(boolean bl) {
        }
    }
}

