/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationException;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdShapePrinter;
import com.blazesoft.verifier.cfa.spatial.NdShapePrinterTraverser;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableEnumeratedTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedralConstraint;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.predicate.NdConstantDate;
import com.blazesoft.verifier.predicate.NdConstantInteger;
import com.blazesoft.verifier.predicate.NdConstantMoney;
import com.blazesoft.verifier.predicate.NdConstantReal;
import com.blazesoft.verifier.predicate.NdConstantTerm;
import com.blazesoft.verifier.predicate.NdConstantTime;
import com.blazesoft.verifier.predicate.NdNormalizedConstantDate;
import com.blazesoft.verifier.predicate.NdNormalizedConstantTime;
import com.blazesoft.verifier.predicate.NdOperator;
import com.blazesoft.verifier.predicate.NdTimeConstraintVariable;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.type.NdModelEnumeratedItemType;
import com.blazesoft.verifier.type.NdModelType;

public class NdShapePrinterSrlAnalytic
extends NdShapePrinterTraverser
implements NdShapePrinter {
    public Object visit(NdComboShape ndComboShape, Object object) {
        StringBuffer[] stringBufferArray = (StringBuffer[])object;
        NdBaseObject.advAssert((stringBufferArray.length > 0 ? 1 : 0) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringBufferArray[0]);
        if (stringBufferArray.length > 1) {
            if (stringBufferArray[1].length() > 0) {
                stringBuffer.append(" and ").append(stringBufferArray[1]);
            } else {
                stringBuffer.setLength(0);
            }
        }
        return stringBuffer;
    }

    public Object visit(NdPolyhedron ndPolyhedron, Object object) {
        StringBuffer[] stringBufferArray = (StringBuffer[])object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringBufferArray.length; ++i) {
            if (stringBufferArray[i].length() == 0) {
                stringBuffer.setLength(0);
                break;
            }
            stringBuffer.append('(').append(stringBufferArray[i]).append(')');
            if (i >= stringBufferArray.length - 1) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer;
    }

    private NdConstantTerm WjIwMUZ(NdVerificationContext ndVerificationContext, NdModelType ndModelType, double d) {
        NdConstantTerm ndConstantTerm;
        if (ndModelType == NdConstantReal.WjIDgkX) {
            ndConstantTerm = new NdConstantReal(d);
        } else if (ndModelType == NdConstantInteger.WjICYZG) {
            ndConstantTerm = (double)((long)d) == d ? new NdConstantInteger((long)d) : new NdConstantReal(d);
        } else if (ndModelType == NdConstantMoney.WjIDgFP) {
            ndConstantTerm = new NdConstantMoney(ndVerificationContext.getCurrencyManager().getDefaultMappingCurrency().amount(d));
        } else {
            NdBaseObject.advAssert((boolean)false);
            ndConstantTerm = null;
        }
        return ndConstantTerm;
    }

    private StringBuffer WjIwMVA(boolean bl, NdOperator ndOperator, NdTimeConstraintVariable ndTimeConstraintVariable, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("effective ");
            if (ndTimeConstraintVariable == NdTimeConstraintVariable.WjIDfHT) {
                stringBuffer.append("everyday ");
            }
        }
        if (ndOperator == NdOperator.WjICYSF) {
            stringBuffer.append("from ");
        } else if (ndOperator == NdOperator.WjICYSG) {
            stringBuffer.append("to ");
        } else if (ndOperator == NdOperator.WjICYSE) {
            stringBuffer.append("from ");
            ++l;
        } else if (ndOperator == NdOperator.WjICYSD) {
            stringBuffer.append("to ");
            --l;
        } else if (ndOperator == NdOperator.WjICYSH) {
            stringBuffer.append("equal to ");
        } else {
            NdBaseObject.advAssert((boolean)false);
        }
        if (ndTimeConstraintVariable == NdTimeConstraintVariable.WjIDfHT) {
            if (l > NdNormalizedConstantTime.WjICYrY || l < NdNormalizedConstantTime.WjICYrZ) {
                stringBuffer.setLength(0);
            } else if (l == NdNormalizedConstantTime.WjICYrY && ndOperator == NdOperator.WjICYSE) {
                stringBuffer.setLength(0);
            } else if (l == NdNormalizedConstantTime.WjICYrZ && ndOperator == NdOperator.WjICYSD) {
                stringBuffer.setLength(0);
            }
        }
        if (stringBuffer.length() > 0) {
            if (ndTimeConstraintVariable == NdTimeConstraintVariable.WjIDfHT) {
                stringBuffer.append(new NdNormalizedConstantTime(l).toString());
            } else {
                stringBuffer.append(new NdNormalizedConstantDate(l).toString());
            }
        }
        return stringBuffer;
    }

    private StringBuffer WjIwMWB(NdTimeConstraintVariable ndTimeConstraintVariable, NdIntegerInterval ndIntegerInterval) {
        StringBuffer stringBuffer;
        long l = ndIntegerInterval.getLeftBound();
        boolean bl = ndIntegerInterval.isLeftOpen();
        long l2 = ndIntegerInterval.getRightBound();
        boolean bl2 = ndIntegerInterval.isRightOpen();
        if (l == Long.MIN_VALUE) {
            stringBuffer = this.WjIwMVA(false, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, ndTimeConstraintVariable, l2);
        } else if (l2 == Long.MAX_VALUE) {
            stringBuffer = this.WjIwMVA(false, bl2 ? NdOperator.WjICYSE : NdOperator.WjICYSF, ndTimeConstraintVariable, l);
        } else if (l == l2 && !bl && !bl2) {
            stringBuffer = this.WjIwMVA(false, NdOperator.WjICYSH, ndTimeConstraintVariable, l);
        } else {
            stringBuffer = this.WjIwMVA(false, bl2 ? NdOperator.WjICYSE : NdOperator.WjICYSF, ndTimeConstraintVariable, l);
            stringBuffer.append(' ');
            stringBuffer.append(this.WjIwMVA(true, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, ndTimeConstraintVariable, l2));
        }
        return stringBuffer;
    }

    private NdModelType WjIwMXC(WjIDdTC[] wjIDdTCArray) {
        NdModelType ndModelType = wjIDdTCArray[0].WjICXCU();
        if (wjIDdTCArray[0] == NdTimeConstraintVariable.WjIDfGS) {
            ndModelType = NdConstantDate.WjIDiPY;
        } else if (wjIDdTCArray[0] == NdTimeConstraintVariable.WjIDfHT) {
            ndModelType = NdConstantTime.WjIDihH;
        }
        try {
            for (int i = 1; i < wjIDdTCArray.length; ++i) {
                if (wjIDdTCArray[i] == null) continue;
                NdModelType ndModelType2 = wjIDdTCArray[i].WjICXCU();
                if (wjIDdTCArray[i] == NdTimeConstraintVariable.WjIDfGS) {
                    ndModelType2 = NdConstantDate.WjIDiPY;
                } else if (wjIDdTCArray[i] == NdTimeConstraintVariable.WjIDfHT) {
                    ndModelType2 = NdConstantTime.WjIDihH;
                }
                ndModelType = this._context.deriveBinaryExpressionType(NdOperator.WjICYSH, ndModelType, ndModelType2);
            }
        }
        catch (NdVerificationException ndVerificationException) {
            NdBaseObject.advAssert((boolean)false);
        }
        return ndModelType;
    }

    public Object visit(NdPolyhedralConstraint ndPolyhedralConstraint, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = ndPolyhedralConstraint.getCoefficients();
        WjIDdTC[] wjIDdTCArray = ndPolyhedralConstraint.getVariables();
        NdOperator ndOperator = ndPolyhedralConstraint.getOperator();
        boolean bl = true;
        NdModelType ndModelType = this.WjIwMXC(wjIDdTCArray);
        if (wjIDdTCArray[0].WjIDbmX()) {
            stringBuffer = this.WjIwMVA(false, ndOperator, (NdTimeConstraintVariable)wjIDdTCArray[0], (long)dArray[1]);
        } else {
            int n;
            for (n = 0; n < dArray.length - 1; ++n) {
                if (bl) {
                    bl = false;
                    if (dArray[n] < 0.0) {
                        stringBuffer.append('-');
                    }
                } else {
                    stringBuffer.append(dArray[n] > 0.0 ? " + " : " - ");
                }
                if (dArray[n] == 1.0 || dArray[n] == -1.0) {
                    stringBuffer.append(wjIDdTCArray[n]);
                    continue;
                }
                stringBuffer.append(this.WjIwMUZ(this._context, wjIDdTCArray[n].WjIDbjU, Math.abs(dArray[n]))).append("*").append(wjIDdTCArray[n]);
            }
            n = dArray.length - 1;
            stringBuffer.append(' ').append(ndOperator.toString()).append(' ');
            if (wjIDdTCArray[n] != null) {
                if (dArray[n] < 0.0) {
                    stringBuffer.append("-");
                }
                if (dArray[n] == 1.0 || dArray[n] == -1.0) {
                    stringBuffer.append(wjIDdTCArray[n]);
                } else {
                    stringBuffer.append(this.WjIwMUZ(this._context, wjIDdTCArray[n].WjIDbjU, Math.abs(dArray[n])));
                    stringBuffer.append("*").append(wjIDdTCArray[n]);
                }
            } else {
                stringBuffer.append(this.WjIwMUZ(this._context, ndModelType, dArray[n]));
            }
        }
        return stringBuffer;
    }

    public Object visit(NdHyperCube ndHyperCube, Object object) {
        StringBuffer[] stringBufferArray = (StringBuffer[])object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringBufferArray.length; ++i) {
            stringBuffer.append(stringBufferArray[i]);
            if (i >= stringBufferArray.length - 1) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer;
    }

    public Object visit(NdVariableBooleanInterval ndVariableBooleanInterval, Object object) {
        String string = ndVariableBooleanInterval.getVariableName();
        boolean bl = ndVariableBooleanInterval.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(string).append(bl ? " = true" : " = false").append(')');
        return stringBuffer;
    }

    public Object visit(NdVariableEnumeratedTypeInterval ndVariableEnumeratedTypeInterval, Object object) {
        String string = ndVariableEnumeratedTypeInterval.getVariableName();
        NdModelEnumeratedItemType[] ndModelEnumeratedItemTypeArray = ndVariableEnumeratedTypeInterval.getIntervalValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < ndModelEnumeratedItemTypeArray.length; ++i) {
            stringBuffer.append(string).append(" = ").append(ndModelEnumeratedItemTypeArray[i].getName());
            if (i >= ndModelEnumeratedItemTypeArray.length - 1) continue;
            stringBuffer.append(" or ");
        }
        stringBuffer.append(')');
        return stringBuffer;
    }

    public Object visit(NdVariableReferenceTypeInterval ndVariableReferenceTypeInterval, Object object) {
        String string = ndVariableReferenceTypeInterval.getVariableName();
        boolean bl = ndVariableReferenceTypeInterval.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(string).append(bl ? " = null" : " = not null").append(')');
        return stringBuffer;
    }

    public Object visit(NdVariableStringInterval ndVariableStringInterval, Object object) {
        String string = ndVariableStringInterval.getVariableName();
        return ndVariableStringInterval.getInterval().toAnalyticalString(string);
    }

    public Object visit(NdVariableIntegerInterval ndVariableIntegerInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        WjIDdTC wjIDdTC = ndVariableIntegerInterval.getVariable();
        if (wjIDdTC.WjIDbmX()) {
            stringBuffer = this.WjIwMWB((NdTimeConstraintVariable)wjIDdTC, (NdIntegerInterval)ndVariableIntegerInterval.getInterval());
        } else {
            stringBuffer.append(ndVariableIntegerInterval.getInterval().toAnalyticalString(ndVariableIntegerInterval.getVariableName()));
        }
        return stringBuffer;
    }

    public Object visit(NdVariableRealInterval ndVariableRealInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ndVariableRealInterval.getInterval().toAnalyticalString(ndVariableRealInterval.getVariableName()));
        return stringBuffer;
    }

    public Object visit(NdVariableMoneyInterval ndVariableMoneyInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ndVariableMoneyInterval.getInterval().toAnalyticalString(ndVariableMoneyInterval.getVariableName()));
        return stringBuffer;
    }

    public Object visit(NdVariableTimeInterval ndVariableTimeInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ndVariableTimeInterval.getInterval().toAnalyticalString(ndVariableTimeInterval.getVariableName()));
        return stringBuffer;
    }

    public Object visit(NdVariableDateInterval ndVariableDateInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ndVariableDateInterval.getInterval().toAnalyticalString(ndVariableDateInterval.getVariableName()));
        return stringBuffer;
    }

    public Object visit(NdVariableTimeStampInterval ndVariableTimeStampInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ndVariableTimeStampInterval.getInterval().toAnalyticalString(ndVariableTimeStampInterval.getVariableName()));
        return stringBuffer;
    }

    public Object visit(NdVariableDurationInterval ndVariableDurationInterval, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ndVariableDurationInterval.getInterval().toAnalyticalString(ndVariableDurationInterval.getVariableName()));
        return stringBuffer;
    }
}

