/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.algorithm;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerifierCallback;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConstraintNotSupportedException;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdDisjointBasesDomain;
import com.blazesoft.verifier.cfa.spatial.NdDisjointShape;
import com.blazesoft.verifier.cfa.spatial.NdDisjunct;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdSpatialEngine;
import com.blazesoft.verifier.cfa.spatial.NdSpatialEngineImpl;
import com.blazesoft.verifier.cfa.spatial.formula.NdFormulaGenerator;
import com.blazesoft.verifier.predicate.NdFormula;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdTopLevelPredicate;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.util.NdVerifierLog;
import com.blazesoft.verifier.util.NdnCk;
import java.util.Iterator;
import java.util.List;

public class NdOverlapDetector {
    public static final String NAME = (class$com$blazesoft$verifier$cfa$spatial$algorithm$NdOverlapDetector == null ? (class$com$blazesoft$verifier$cfa$spatial$algorithm$NdOverlapDetector = NdOverlapDetector.class$("com.blazesoft.verifier.cfa.spatial.algorithm.NdOverlapDetector")) : class$com$blazesoft$verifier$cfa$spatial$algorithm$NdOverlapDetector).getName();
    private NdVerificationContext WjIwNbH;
    private NdSpatialEngine WjIwNcI;
    private NdFormulaGenerator WjIwNdJ;
    static /* synthetic */ Class class$com$blazesoft$verifier$cfa$spatial$algorithm$NdOverlapDetector;

    public NdOverlapDetector(NdVerificationContext ndVerificationContext) {
        NdBaseObject.advAssertNonNull((Object)ndVerificationContext);
        this.WjIwNbH = ndVerificationContext;
        this.WjIwNcI = new NdSpatialEngineImpl(this.WjIwNbH);
        this.WjIwNdJ = new NdFormulaGenerator(this.WjIwNbH);
    }

    private void WjIwNeK(NdBasis ndBasis, NdDisjointBasesDomain ndDisjointBasesDomain, Callback callback) {
        List list = ndDisjointBasesDomain.getDisjuncts(ndBasis);
        if (list.size() > 1) {
            NdDisjunct ndDisjunct;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ndDisjunct = (NdDisjunct)list.get(i);
                try {
                    ndDisjunct.setConvex(this.WjIwNcI.createConvexShape(ndBasis, ndDisjunct.disjunct));
                    continue;
                }
                catch (NdConstraintNotSupportedException ndConstraintNotSupportedException) {
                    callback.notSupportedFormulaDetected(ndConstraintNotSupportedException);
                    if (!NdVerifierLog.isTraceEnabled(NAME) || !NdVerifierLog.isTraceEnabled(NAME)) continue;
                    NdVerifierLog.trace(NAME, "Non supported constraint on overlap check: " + ndConstraintNotSupportedException.WjICXSM());
                    ndConstraintNotSupportedException.printStackTrace();
                    continue;
                }
                catch (NdFormulaException ndFormulaException) {
                    callback.exceptionDetected(ndFormulaException);
                }
            }
            Iterator iterator = NdnCk.iterator(list.size(), 2);
            while (iterator.hasNext()) {
                int[] nArray = (int[])iterator.next();
                ndDisjunct = (NdDisjunct)list.get(nArray[0]);
                NdDisjunct ndDisjunct2 = (NdDisjunct)list.get(nArray[1]);
                if (ndDisjunct.testCondition == ndDisjunct2.testCondition) continue;
                try {
                    NdFormula ndFormula;
                    if (ndDisjunct.convex == null || ndDisjunct2.convex == null) continue;
                    NdDisjunct ndDisjunct3 = this.WjIwNcI.intersection(ndBasis, ndDisjunct, ndDisjunct2);
                    if (ndDisjunct3.convex.isEmptySet() || (ndFormula = this.WjIwNdJ.generate(ndDisjunct3.convex, true)) == null) continue;
                    callback.overlappingDetected(ndDisjunct.testCondition, ndDisjunct2.testCondition, ndFormula);
                }
                catch (NdFormulaException ndFormulaException) {
                    callback.exceptionDetected(ndFormulaException);
                }
            }
        }
    }

    public void searchOverlaps(NdDisjointBasesDomain ndDisjointBasesDomain, Callback callback) {
        Iterator iterator = ndDisjointBasesDomain.basisIterator();
        while (iterator.hasNext()) {
            NdBasisImpl ndBasisImpl = (NdBasisImpl)iterator.next();
            this.WjIwNeK(ndBasisImpl, ndDisjointBasesDomain, callback);
        }
    }

    public void searchOverlaps(NdDisjointShape ndDisjointShape, Callback callback) {
        List list;
        if (!ndDisjointShape.isUniverse() && !ndDisjointShape.isEmpty() && (list = ndDisjointShape.getDisjoints()).size() > 1) {
            Iterator iterator = NdnCk.iterator(list.size(), 2);
            while (iterator.hasNext()) {
                int[] nArray = (int[])iterator.next();
                NdConvexShape ndConvexShape = (NdConvexShape)list.get(nArray[0]);
                NdConvexShape ndConvexShape2 = (NdConvexShape)list.get(nArray[1]);
                try {
                    NdFormula ndFormula;
                    NdConvexShape ndConvexShape3 = ndConvexShape.intersect(ndConvexShape2);
                    if (ndConvexShape3.isEmptySet() || (ndFormula = this.WjIwNdJ.generate(ndConvexShape3, true)) == null) continue;
                    callback.overlappingDetected(((NdComboShape)ndConvexShape).getTestCondition(), ((NdComboShape)ndConvexShape2).getTestCondition(), ndFormula);
                }
                catch (NdShapeException ndShapeException) {
                    NdBaseObject.advAssert((boolean)false);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Callback
    extends NdVerifierCallback {
        public void overlappingDetected(NdTopLevelPredicate var1, NdTopLevelPredicate var2, NdFormula var3);

        public void exceptionDetected(NdFormulaException var1);

        public void notSupportedFormulaDetected(NdFormulaException var1);
    }
}

