/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.formula;

import com.blazesoft.verifier.cfa.spatial.NdConstraintNotSupportedException;
import com.blazesoft.verifier.predicate.NdConstantEnumeratedItem;
import com.blazesoft.verifier.predicate.NdConstantLogical;
import com.blazesoft.verifier.predicate.NdConstantMoney;
import com.blazesoft.verifier.predicate.NdConstantNull;
import com.blazesoft.verifier.predicate.NdConstantReal;
import com.blazesoft.verifier.predicate.NdConstantString;
import com.blazesoft.verifier.predicate.NdConstantTerm;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdIntegerTerm;
import com.blazesoft.verifier.type.NdModelEnumeratedItemType;
import com.blazesoft.verifier.type.NdModelType;

public class NdFormulaHelper {
    public static long getLongConstant(NdConstantTerm ndConstantTerm) throws NdFormulaException {
        long l;
        NdModelType ndModelType = ndConstantTerm.WjICXCU();
        Object object = ndConstantTerm.WjICZcB();
        if (ndConstantTerm instanceof NdIntegerTerm) {
            l = ((NdIntegerTerm)((Object)ndConstantTerm)).WjIDaaB();
        } else if (ndModelType == NdConstantReal.WjIDgkX) {
            l = ((Double)object).longValue();
        } else {
            throw new NdFormulaException(ndConstantTerm, "Integer - compatible type expected, got " + ndModelType.getTypeName());
        }
        return l;
    }

    public static double getDoubleConstant(NdConstantTerm ndConstantTerm) throws NdFormulaException {
        double d;
        NdModelType ndModelType = ndConstantTerm.WjICXCU();
        if (ndConstantTerm instanceof NdIntegerTerm) {
            d = ((NdIntegerTerm)((Object)ndConstantTerm)).WjIDaaB();
        } else if (ndModelType == NdConstantReal.WjIDgkX) {
            d = ((NdConstantReal)ndConstantTerm).WjIDgnA();
        } else if (ndModelType == NdConstantMoney.WjIDgFP) {
            d = ((NdConstantMoney)ndConstantTerm).WjIDgFT();
        } else {
            throw new NdFormulaException(ndConstantTerm, "Double - compatible type expected, got " + ndModelType.getTypeName());
        }
        return d;
    }

    public static boolean getBooleanConstant(NdConstantTerm ndConstantTerm) throws NdFormulaException {
        NdModelType ndModelType = ndConstantTerm.WjICXCU();
        if (ndModelType != NdConstantLogical.WjIDcxG) {
            throw new NdFormulaException(ndConstantTerm, "Logical type expected, got " + ndModelType.getTypeName());
        }
        boolean bl = (NdConstantLogical)ndConstantTerm == NdConstantLogical.WjIDcyH;
        return bl;
    }

    public static String getStringConstant(NdConstantTerm ndConstantTerm) throws NdFormulaException {
        NdModelType ndModelType = ndConstantTerm.WjICXCU();
        if (ndModelType != NdConstantString.WjIDhSC) {
            throw new NdConstraintNotSupportedException(null, ndConstantTerm);
        }
        return (String)((NdConstantString)ndConstantTerm).WjICZcB();
    }

    public static NdModelEnumeratedItemType getEnumeratedItem(NdConstantTerm ndConstantTerm) throws NdFormulaException {
        NdModelType ndModelType = ndConstantTerm.WjICXCU();
        if (!ndModelType.isEnumerated()) {
            throw new NdFormulaException(ndConstantTerm, "Enumerated type expected, got " + ndModelType.getTypeName());
        }
        return (NdModelEnumeratedItemType)((NdConstantEnumeratedItem)ndConstantTerm).WjICZcB();
    }

    public static boolean isNullConstant(NdConstantTerm ndConstantTerm) throws NdFormulaException {
        return ndConstantTerm == NdConstantNull.WjIDeLB;
    }
}

